/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.zxpspritecorrector.SpriteCorrectorMainFrame;
import com.igormaznitsa.zxpspritecorrector.components.CpuRegProperties;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.Z80ExportDialog;
import com.igormaznitsa.zxpspritecorrector.files.ZXEMLSnapshotFormat;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public final class Z80InZXPOutPlugin
extends AbstractFilePlugin {
    public static final int PAGE_SIZE = 16384;
    public static final int VERSION_1 = 0;
    public static final int VERSION_2 = 1;
    public static final int VERSION_3A = 2;
    public static final int VERSION_3B = 3;
    public static final JBBPParser Z80_MAINPART = JBBPParser.prepare("byte reg_a; byte reg_f; <short reg_bc; <short reg_hl; <short reg_pc; <short reg_sp; byte reg_ir; byte reg_r; flags{ bit:1 reg_r_bit7; bit:3 bordercolor; bit:1 basic_samrom; bit:1 compressed; bit:2 nomeaning;}<short reg_de; <short reg_bc_alt; <short reg_de_alt; <short reg_hl_alt; byte reg_a_alt; byte reg_f_alt; <short reg_iy; <short reg_ix; byte iff; byte iff2;emulFlags{bit:2 interruptmode; bit:1 issue2emulation; bit:1 doubleintfreq; bit:2 videosync; bit:2 inputdevice;}");
    public static final JBBPParser Z80_VERSION1 = JBBPParser.prepare("byte reg_a; byte reg_f; <short reg_bc; <short reg_hl; <short reg_pc; <short reg_sp; byte reg_ir; byte reg_r; flags{ bit:1 reg_r_bit7; bit:3 bordercolor; bit:1 basic_samrom; bit:1 compressed; bit:2 nomeaning;}<short reg_de; <short reg_bc_alt; <short reg_de_alt; <short reg_hl_alt; byte reg_a_alt; byte reg_f_alt; <short reg_iy; <short reg_ix; byte iff; byte iff2;emulFlags{bit:2 interruptmode; bit:1 issue2emulation; bit:1 doubleintfreq; bit:2 videosync; bit:2 inputdevice;}byte [_] data;");
    public static final JBBPParser Z80_VERSION2 = JBBPParser.prepare("byte reg_a; byte reg_f; <short reg_bc; <short reg_hl; <short reg_pc; <short reg_sp; byte reg_ir; byte reg_r; flags{ bit:1 reg_r_bit7; bit:3 bordercolor; bit:1 basic_samrom; bit:1 compressed; bit:2 nomeaning;}<short reg_de; <short reg_bc_alt; <short reg_de_alt; <short reg_hl_alt; byte reg_a_alt; byte reg_f_alt; <short reg_iy; <short reg_ix; byte iff; byte iff2;emulFlags{bit:2 interruptmode; bit:1 issue2emulation; bit:1 doubleintfreq; bit:2 videosync; bit:2 inputdevice;}<ushort extrahdrlen;<ushort reg_pc2;ubyte mode;ubyte port7FFD;ubyte portFF;byte [18] extra;byte [_] data;");
    public static final JBBPParser Z80_VERSION3A = JBBPParser.prepare("byte reg_a; byte reg_f; <short reg_bc; <short reg_hl; <short reg_pc; <short reg_sp; byte reg_ir; byte reg_r; flags{ bit:1 reg_r_bit7; bit:3 bordercolor; bit:1 basic_samrom; bit:1 compressed; bit:2 nomeaning;}<short reg_de; <short reg_bc_alt; <short reg_de_alt; <short reg_hl_alt; byte reg_a_alt; byte reg_f_alt; <short reg_iy; <short reg_ix; byte iff; byte iff2;emulFlags{bit:2 interruptmode; bit:1 issue2emulation; bit:1 doubleintfreq; bit:2 videosync; bit:2 inputdevice;}<ushort extrahdrlen;<ushort reg_pc2;ubyte mode;ubyte port7FFD;ubyte portFF;byte [49] extra;byte [_] data;");
    public static final JBBPParser Z80_VERSION3B = JBBPParser.prepare("byte reg_a; byte reg_f; <short reg_bc; <short reg_hl; <short reg_pc; <short reg_sp; byte reg_ir; byte reg_r; flags{ bit:1 reg_r_bit7; bit:3 bordercolor; bit:1 basic_samrom; bit:1 compressed; bit:2 nomeaning;}<short reg_de; <short reg_bc_alt; <short reg_de_alt; <short reg_hl_alt; byte reg_a_alt; byte reg_f_alt; <short reg_iy; <short reg_ix; byte iff; byte iff2;emulFlags{bit:2 interruptmode; bit:1 issue2emulation; bit:1 doubleintfreq; bit:2 videosync; bit:2 inputdevice;}<ushort extrahdrlen;<ushort reg_pc2;ubyte mode;ubyte port7FFD;ubyte portFF;byte [50] extra;byte [_] data;");
    private static final String DESCRIPTION_IN = "Z80 snapshot";
    private static final String DESCRIPTION_OUT = "ZX-Poly snapshot";

    public static boolean is48k(int version, Z80Snapshot snapshot) {
        switch (version) {
            case 0: {
                return true;
            }
            case 1: {
                return snapshot.mode == 0 || snapshot.mode == 1;
            }
            case 2: 
            case 3: {
                return snapshot.mode == 0 || snapshot.mode == 1 || snapshot.mode == 3;
            }
        }
        return false;
    }

    public static boolean is48k(int version, byte[] header) {
        switch (version) {
            case 0: {
                return true;
            }
            case 1: {
                return header[34] == 0 || header[34] == 1;
            }
            case 2: 
            case 3: {
                return header[34] == 0 || header[34] == 1 || header[34] == 3;
            }
        }
        return false;
    }

    public static int getVersion(byte[] data) {
        int version;
        if ((data[6] | data[7]) == 0) {
            switch ((data[31] & 0xFF) << 8 | data[30] & 0xFF) {
                case 23: {
                    version = 1;
                    break;
                }
                case 54: {
                    version = 2;
                    break;
                }
                case 55: {
                    version = 3;
                    break;
                }
                default: {
                    version = -1;
                    break;
                }
            }
        } else {
            version = 0;
        }
        return version;
    }

    public static int makePair(byte a, byte b) {
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public static byte[] convertZ80BankIndexesToPages(byte[] bankIndexes, boolean mode48, int version) {
        byte[] result;
        if (version == 0) {
            result = new byte[]{5, 2, 0};
        } else if (mode48) {
            result = new byte[bankIndexes.length];
            for (int i = 0; i < bankIndexes.length; ++i) {
                int pageIndex;
                switch (bankIndexes[i] & 0xFF) {
                    case 8: {
                        pageIndex = 0;
                        break;
                    }
                    case 4: {
                        pageIndex = 5;
                        break;
                    }
                    case 5: {
                        pageIndex = 2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected bank index for Z80 48K mode: " + bankIndexes[i]);
                    }
                }
                result[i] = (byte)pageIndex;
            }
        } else {
            result = new byte[bankIndexes.length];
            for (int i = 0; i < bankIndexes.length; ++i) {
                int page = (bankIndexes[i] & 0xFF) - 3;
                if (page < 0 || page >= 8) continue;
                result[i] = (byte)page;
            }
        }
        return result;
    }

    public static ZXEMLSnapshotFormat.Page makePage(int cpu, int page, ZXPolyData data, int offset) {
        byte[] bankData = new byte[16384];
        System.arraycopy(data.getDataForCPU(cpu), offset, bankData, 0, 16384);
        return new ZXEMLSnapshotFormat.Page(page, bankData);
    }

    public static int getPcReg(Z80MainHeader mainHeader, byte[] header) {
        int version = Z80InZXPOutPlugin.getVersion(header);
        return version == 0 ? mainHeader.reg_pc : (header[33] & 0xFF) << 8 | header[32] & 0xFF;
    }

    public static byte[] extractHeader(byte[] extra) {
        int banksInExtra = extra[0] == 0 ? 0 : extra[0] & 0xFF;
        byte[] z80SnapshotHeader = new byte[extra.length - (banksInExtra + 1)];
        System.arraycopy(extra, banksInExtra + 1, z80SnapshotHeader, 0, z80SnapshotHeader.length);
        return z80SnapshotHeader;
    }

    public static Z80MainHeader extractZ80SnapshotHeader(byte[] snapshotHeader) throws IOException {
        return Z80_MAINPART.parse(snapshotHeader).mapTo(new Z80MainHeader(), new Function[0]);
    }

    public static int getPort7ffd(int version, byte[] snapshotHeader) {
        int port7ffd;
        if (version == 0) {
            port7ffd = 48;
        } else {
            byte hwMode = snapshotHeader[34];
            switch (version) {
                case 1: {
                    if (hwMode == 3 || hwMode == 4) {
                        port7ffd = snapshotHeader[35] & 0xFF;
                        break;
                    }
                    port7ffd = 48;
                    break;
                }
                case 2: 
                case 3: {
                    if (hwMode == 4 || hwMode == 5 || hwMode == 6) {
                        port7ffd = snapshotHeader[35] & 0xFF;
                        break;
                    }
                    port7ffd = 48;
                    break;
                }
                default: {
                    port7ffd = 48;
                }
            }
        }
        return port7ffd;
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return forExport ? DESCRIPTION_OUT : DESCRIPTION_IN;
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".z80"));
    }

    @Override
    public String getDescription() {
        return "Z80 snapshot (*.Z80)";
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    @Override
    public String getPluginUID() {
        return "Z80S";
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return null;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return forExport ? DESCRIPTION_OUT : DESCRIPTION_IN;
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".zxp"));
            }

            @Override
            public String getDescription() {
                return "ZX-Poly snapshot (*.ZXP)";
            }
        };
    }

    @Override
    public String getExtension(boolean forExport) {
        return forExport ? "zxp" : "z80";
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] array, int index) throws IOException {
        int startAddress;
        byte[] data;
        int headerLength;
        JBBPParser parser;
        if (array.length < 30) {
            throw new IOException("File is too short to be Z80 snapshot");
        }
        int version = Z80InZXPOutPlugin.getVersion(array);
        switch (version) {
            case 0: {
                parser = Z80_VERSION1;
                break;
            }
            case 1: {
                parser = Z80_VERSION2;
                break;
            }
            case 2: {
                parser = Z80_VERSION3A;
                break;
            }
            case 3: {
                parser = Z80_VERSION3B;
                break;
            }
            default: {
                throw new IOException("Detected unsupported version of Z80 snapshot");
            }
        }
        Z80Snapshot current = parser.parse(array).mapTo(new Z80Snapshot(), (JBBPMapperCustomFieldProcessor)new DataProcessor(version), 1, new Function[0]);
        block6 : switch (version) {
            case 0: {
                break;
            }
            case 1: {
                switch (current.mode) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        break block6;
                    }
                }
                throw new IOException("Unsupported Z80 hardware mode [" + current.mode + "]");
            }
            case 2: 
            case 3: {
                switch (current.mode) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break block6;
                    }
                }
                throw new IOException("Unsupported Z80 hardware mode [" + current.mode + "]");
            }
        }
        boolean mode48 = Z80InZXPOutPlugin.is48k(version, current);
        if (version == 0) {
            headerLength = 30;
            data = current.data;
            startAddress = current.reg_pc & 0xFFFF;
        } else {
            int offset;
            headerLength = 30 + current.extrahdrlen;
            startAddress = current.reg_pc2;
            if (mode48) {
                data = new byte[49152];
                for (Bank b : current.banks) {
                    offset = -1;
                    switch (b.page) {
                        case 4: {
                            offset = 16384;
                            break;
                        }
                        case 5: {
                            offset = 32768;
                            break;
                        }
                        case 8: {
                            offset = 0;
                        }
                    }
                    if (offset < 0) continue;
                    System.arraycopy(b.data, 0, data, offset, 16384);
                }
            } else {
                data = new byte[131072];
                for (Bank b : current.banks) {
                    if (b.page < 3) {
                        offset = b.page * 16384;
                        System.arraycopy(b.data, 0, data, offset, 16384);
                        continue;
                    }
                    if (b.page > 10) continue;
                    offset = (b.page - 3) * 16384;
                    System.arraycopy(b.data, 0, data, offset, 16384);
                }
            }
        }
        byte[] extra = new byte[(version == 0 ? 1 : 1 + current.banks.length) + headerLength];
        extra[0] = current.banks == null ? (byte)0 : (byte)current.banks.length;
        int bankIndex = 1;
        if (version != 0) {
            for (Bank b : current.banks) {
                extra[bankIndex++] = (byte)b.page;
            }
        }
        System.arraycopy(array, 0, extra, bankIndex, headerLength);
        return new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(name, 'C', startAddress, data.length, 16384, true, extra), this, data), null);
    }

    private CpuRegProperties findCpu(SessionData sessionData) {
        String data = sessionData.getExtraProperty("z80.override.cpu.properties");
        if (data == null) {
            return new CpuRegProperties();
        }
        return new CpuRegProperties(SpriteCorrectorMainFrame.deserializeProperties(data));
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraData) throws IOException {
        byte[] bankIndexes;
        if (!(data.getPlugin() instanceof Z80InZXPOutPlugin)) {
            throw new IOException("Only imported Z80 snapshot can be exported");
        }
        CpuRegProperties cpuRegProperties = this.findCpu(sessionData);
        Z80ExportDialog dialog = new Z80ExportDialog(this.spriteCorrectorMainFrame);
        dialog.setVisible(true);
        if (!dialog.isAccepted()) {
            return;
        }
        int videoMode = dialog.getVideoMode();
        byte[] extra = data.getInfo().getExtra();
        if (extra[0] == 0) {
            bankIndexes = new byte[]{8, 4, 5};
        } else {
            bankIndexes = new byte[extra[0] & 0xFF];
            System.arraycopy(extra, 1, bankIndexes, 0, bankIndexes.length);
        }
        byte[] snapshotHeader = Z80InZXPOutPlugin.extractHeader(extra);
        int version = Z80InZXPOutPlugin.getVersion(snapshotHeader);
        Z80MainHeader mainSnapshotHeader = Z80InZXPOutPlugin.extractZ80SnapshotHeader(snapshotHeader);
        ZXEMLSnapshotFormat block = new ZXEMLSnapshotFormat();
        int reg_a = cpuRegProperties.extractInt("A", mainSnapshotHeader.reg_a);
        int reg_f = cpuRegProperties.extractInt("F", mainSnapshotHeader.reg_f);
        int reg_bc = cpuRegProperties.extractInt("BC", mainSnapshotHeader.reg_bc);
        int reg_de = cpuRegProperties.extractInt("DE", mainSnapshotHeader.reg_de);
        int reg_hl = cpuRegProperties.extractInt("HL", mainSnapshotHeader.reg_hl);
        int reg_a_alt = cpuRegProperties.extractInt("ALT_A", mainSnapshotHeader.reg_a_alt);
        int reg_f_alt = cpuRegProperties.extractInt("ALT_F", mainSnapshotHeader.reg_f_alt);
        int reg_bc_alt = cpuRegProperties.extractInt("ALT_BC", mainSnapshotHeader.reg_bc_alt);
        int reg_de_alt = cpuRegProperties.extractInt("ALT_DE", mainSnapshotHeader.reg_de_alt);
        int reg_hl_alt = cpuRegProperties.extractInt("ALT_HL", mainSnapshotHeader.reg_hl_alt);
        int reg_ix = cpuRegProperties.extractInt("IX", mainSnapshotHeader.reg_ix);
        int reg_iy = cpuRegProperties.extractInt("IY", mainSnapshotHeader.reg_iy);
        int reg_im = cpuRegProperties.extractInt("IM", mainSnapshotHeader.emulFlags.interruptmode);
        int reg_ir = cpuRegProperties.extractInt("IR", Z80InZXPOutPlugin.makePair(mainSnapshotHeader.reg_ir, mainSnapshotHeader.reg_r));
        int reg_sp = cpuRegProperties.extractInt("SP", mainSnapshotHeader.reg_sp);
        int reg_pc = cpuRegProperties.extractInt("PC", Z80InZXPOutPlugin.getPcReg(mainSnapshotHeader, snapshotHeader));
        boolean reg_iff = cpuRegProperties.extractBoolean("IFF1", mainSnapshotHeader.iff != 0);
        boolean reg_iff2 = cpuRegProperties.extractBoolean("IFF2", mainSnapshotHeader.iff2 != 0);
        int port_7FFD = cpuRegProperties.extractInt("7FFD", Z80InZXPOutPlugin.getPort7ffd(version, snapshotHeader));
        for (int cpuIndex = 0; cpuIndex < 4; ++cpuIndex) {
            block.setAF(cpuIndex, Z80InZXPOutPlugin.makePair((byte)reg_a, (byte)reg_f), false);
            block.setAF(cpuIndex, Z80InZXPOutPlugin.makePair((byte)reg_a_alt, (byte)reg_f_alt), true);
            block.setBC(cpuIndex, reg_bc, false);
            block.setBC(cpuIndex, reg_bc_alt, true);
            block.setDE(cpuIndex, reg_de, false);
            block.setDE(cpuIndex, reg_de_alt, true);
            block.setHL(cpuIndex, reg_hl, false);
            block.setHL(cpuIndex, reg_hl_alt, true);
            block.setRegIX(cpuIndex, reg_ix);
            block.setRegIY(cpuIndex, reg_iy);
            block.setRegIR(cpuIndex, reg_ir);
            block.setRegIM(cpuIndex, reg_im);
            block.setRegPC(cpuIndex, reg_pc);
            block.setRegSP(cpuIndex, reg_sp);
            block.setIFF(cpuIndex, reg_iff);
            block.setIFF2(cpuIndex, reg_iff2);
        }
        block.setPort3D00(videoMode << 2 | 0x80 | 1);
        block.setModulePorts(0, port_7FFD, 0, 0, 0, 0);
        block.setModulePorts(1, port_7FFD, 18, 0, 0, 0);
        block.setModulePorts(2, port_7FFD, 20, 0, 0, 0);
        block.setModulePorts(3, port_7FFD, 22, 0, 0, 0);
        block.setPortFE(mainSnapshotHeader.flags.bordercolor & 7);
        byte[] pageIndexes = Z80InZXPOutPlugin.convertZ80BankIndexesToPages(bankIndexes, Z80InZXPOutPlugin.is48k(version, snapshotHeader), version);
        for (int cpu = 0; cpu < 4; ++cpu) {
            ArrayList<ZXEMLSnapshotFormat.Page> pages = new ArrayList<ZXEMLSnapshotFormat.Page>();
            int offsetIndex = 0;
            for (byte page : pageIndexes) {
                pages.add(Z80InZXPOutPlugin.makePage(cpu, page & 0xFF, data, offsetIndex * 16384));
                ++offsetIndex;
            }
            block.setPages(cpu, new ZXEMLSnapshotFormat.Pages(pages.toArray(new ZXEMLSnapshotFormat.Page[0])));
        }
        this.saveDataToFile(file, block.save());
    }

    public static class Z80Snapshot {
        @Bin(order=1)
        public byte reg_a;
        @Bin(order=2)
        public byte reg_f;
        @Bin(order=3)
        public short reg_bc;
        @Bin(order=4)
        public short reg_hl;
        @Bin(order=5)
        public short reg_pc;
        @Bin(order=6)
        public short reg_sp;
        @Bin(order=7)
        public byte reg_ir;
        @Bin(order=8)
        public byte reg_r;
        @Bin(order=10)
        public short reg_de;
        @Bin(order=11)
        public short reg_bc_alt;
        @Bin(order=12)
        public short reg_de_alt;
        @Bin(order=13)
        public short reg_hl_alt;
        @Bin(order=14)
        public byte reg_a_alt;
        @Bin(order=15)
        public byte reg_f_alt;
        @Bin(order=16)
        public short reg_iy;
        @Bin(order=17)
        public short reg_ix;
        @Bin(order=18)
        public byte iff;
        @Bin(order=19)
        public byte iff2;
        @Bin(order=20)
        public EmulFlags emulFlags;
        @Bin(order=21, custom=true)
        public byte[] data;
        @Bin(type=BinType.USHORT)
        public int extrahdrlen;
        @Bin(type=BinType.USHORT)
        public int reg_pc2;
        @Bin(type=BinType.UBYTE)
        public int mode;
        @Bin(type=BinType.UBYTE)
        public int port7FFD;
        @Bin(type=BinType.UBYTE)
        public int portFF;
        @Bin(type=BinType.BYTE_ARRAY)
        public byte[] extra;
        @Bin(custom=true)
        public Bank[] banks;
        @Bin(order=9)
        Flags flags;

        public Object newInstance(Class<?> klazz) {
            if (klazz == Flags.class) {
                return new Flags();
            }
            if (klazz == EmulFlags.class) {
                return new EmulFlags();
            }
            return null;
        }
    }

    public static class Z80MainHeader {
        @Bin(order=1)
        public byte reg_a;
        @Bin(order=2)
        public byte reg_f;
        @Bin(order=3)
        public short reg_bc;
        @Bin(order=4)
        public short reg_hl;
        @Bin(order=5)
        public short reg_pc;
        @Bin(order=6)
        public short reg_sp;
        @Bin(order=7)
        public byte reg_ir;
        @Bin(order=8)
        public byte reg_r;
        @Bin(order=9)
        public Flags flags;
        @Bin(order=10)
        public short reg_de;
        @Bin(order=11)
        public short reg_bc_alt;
        @Bin(order=12)
        public short reg_de_alt;
        @Bin(order=13)
        public short reg_hl_alt;
        @Bin(order=14)
        public byte reg_a_alt;
        @Bin(order=15)
        public byte reg_f_alt;
        @Bin(order=16)
        public short reg_iy;
        @Bin(order=17)
        public short reg_ix;
        @Bin(order=18)
        public byte iff;
        @Bin(order=19)
        public byte iff2;
        @Bin(order=20)
        public EmulFlags emulFlags;

        public static Object newInstance(Class<?> klazz) {
            if (klazz == EmulFlags.class) {
                return new EmulFlags();
            }
            return null;
        }
    }

    private static class DataProcessor
    implements JBBPMapperCustomFieldProcessor {
        private final int version;

        private DataProcessor(int version) {
            this.version = version;
        }

        static byte[] decodeRLE(byte[] source, int offset, int length) {
            ByteArrayOutputStream result = new ByteArrayOutputStream(16384);
            while (length > 0) {
                if (length >= 4) {
                    if (source[offset] == 0 && source[offset + 1] == -19 && source[offset + 2] == -19 && source[offset + 3] == 0) break;
                    if (source[offset] == -19 && source[offset + 1] == -19) {
                        offset += 2;
                        int repeat = source[offset++] & 0xFF;
                        int value = source[offset++] & 0xFF;
                        length -= 4;
                        while (repeat > 0) {
                            result.write(value);
                            --repeat;
                        }
                        continue;
                    }
                    result.write(source[offset++]);
                    --length;
                    continue;
                }
                result.write(source[offset++]);
                --length;
            }
            return result.toByteArray();
        }

        static byte[] unpackBank(byte[] src, int offset, int length) {
            byte[] result;
            if (length == 65535) {
                result = new byte[16384];
                System.arraycopy(src, offset, result, 0, 16384);
            } else {
                result = DataProcessor.decodeRLE(src, offset, length);
            }
            return result;
        }

        @Override
        public Object prepareObjectForMapping(JBBPFieldStruct parsedBlock, Bin annotation, Field field) {
            if (this.version == 0) {
                if (field.getName().equals("data")) {
                    byte[] data = parsedBlock.findFieldForNameAndType("data", JBBPFieldArrayByte.class).getArray();
                    if (parsedBlock.findFieldForPathAndType("flags.compressed", JBBPFieldBit.class).getAsBool()) {
                        return DataProcessor.decodeRLE(data, 0, data.length);
                    }
                    return data;
                }
                return null;
            }
            if (field.getName().equalsIgnoreCase("data")) {
                return parsedBlock.findFieldForNameAndType("data", JBBPFieldArrayByte.class).getArray();
            }
            if (field.getName().equalsIgnoreCase("banks")) {
                byte[] rawdata = parsedBlock.findFieldForNameAndType("data", JBBPFieldArrayByte.class).getArray();
                int pos = 0;
                int len = rawdata.length;
                ArrayList<Bank> banks = new ArrayList<Bank>();
                while (len > 0) {
                    int blocklength = rawdata[pos++] & 0xFF | (rawdata[pos++] & 0xFF) << 8;
                    int page = rawdata[pos++] & 0xFF;
                    len -= 3 + (blocklength == 65535 ? 16384 : blocklength);
                    byte[] uncompressed = DataProcessor.unpackBank(rawdata, pos, blocklength);
                    pos += blocklength == 65535 ? 16384 : blocklength;
                    banks.add(new Bank(page, uncompressed));
                }
                return banks.toArray(new Bank[0]);
            }
            return null;
        }
    }

    static class Bank {
        final int page;
        final byte[] data;

        Bank(int page, byte[] data) {
            this.page = page;
            this.data = data;
        }
    }

    public static class EmulFlags {
        @Bin(order=1, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_2)
        public byte interruptmode;
        @Bin(order=2, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_1)
        public byte issue2emulation;
        @Bin(order=3, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_1)
        public byte doubleintfreq;
        @Bin(order=4, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_2)
        public byte videosync;
        @Bin(order=5, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_2)
        public byte inputdevice;
    }

    public static class Flags {
        @Bin(order=1, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_1)
        public byte reg_r_bit7;
        @Bin(order=2, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_3)
        public byte bordercolor;
        @Bin(order=3, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_1)
        public byte basic_samrom;
        @Bin(order=4, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_1)
        public byte compressed;
        @Bin(order=5, type=BinType.BIT, bitNumber=JBBPBitNumber.BITS_2)
        public byte nomeaning;
    }
}

