/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.tools;

import com.igormaznitsa.zxpspritecorrector.components.EditorComponent;
import com.igormaznitsa.zxpspritecorrector.components.ZXColorSelector;
import com.igormaznitsa.zxpspritecorrector.tools.AbstractTool;
import java.awt.Rectangle;
import org.picocontainer.annotations.Inject;

public class ToolPencil
extends AbstractTool {
    private static final long serialVersionUID = 1486692252806983383L;
    @Inject
    private ZXColorSelector colorSelector;

    public ToolPencil() {
        super("pencil.png", "Pencil allows to set pixels of defined color");
    }

    @Override
    public void process(EditorComponent editComponent, Rectangle area, int buttons) {
        int index;
        EditorComponent.ZXGraphics gfx = editComponent.getZXGraphics();
        boolean mode512 = editComponent.isMode512();
        if ((buttons & 1) != 0) {
            index = mode512 ? 1 : this.colorSelector.getSelectedInk();
        } else if ((buttons & 4) != 0) {
            index = mode512 ? 0 : this.colorSelector.getSelectedPaint();
        } else {
            return;
        }
        for (int x = 0; x < area.width; ++x) {
            for (int y = 0; y < area.height; ++y) {
                int dx = x + area.x;
                int dy = y + area.y;
                if (!ToolPencil.isCoordValid(dx, dy, mode512)) continue;
                gfx.setPoint(dx, dy, index);
            }
        }
        gfx.flush();
    }
}

