#include "GCNInstructionDefs.h"

// !!! Important Note !!!
// 
// Most of these instruction classes are auto generated using
// GenerateInstructionClass.py script with some heuristic strategies,
// so the classes are not guaranteed to be 100% correct.
// If we find a class doesn't match its instruction,
// we still need to fix it manually.
// see comments of InstructionClass for more information.


std::unordered_map<SISOP1Instruction::OP, GCNInstructionFormat> g_instructionFormatMapSOP1 = {
	{ SISOP1Instruction::S_MOV_B32, { Instruction::ScalarMov, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_MOV_B64, { Instruction::ScalarMov, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_CMOV_B32, { Instruction::ScalarMov, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_CMOV_B64, { Instruction::ScalarMov, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_NOT_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_NOT_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_WQM_B32, { Instruction::ScalarQuadMask, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_WQM_B64, { Instruction::ScalarQuadMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_BREV_B32, { Instruction::ScalarBitManip, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_BREV_B64, { Instruction::ScalarBitManip, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_BCNT0_I32_B32, { Instruction::ScalarBitManip, Instruction::TypeI32B32 } },
	{ SISOP1Instruction::S_BCNT0_I32_B64, { Instruction::ScalarBitManip, Instruction::TypeI32B64 } },
	{ SISOP1Instruction::S_BCNT1_I32_B32, { Instruction::ScalarBitManip, Instruction::TypeI32B32 } },
	{ SISOP1Instruction::S_BCNT1_I32_B64, { Instruction::ScalarBitManip, Instruction::TypeI32B64 } },
	{ SISOP1Instruction::S_FF0_I32_B32, { Instruction::ScalarBitManip, Instruction::TypeI32B32 } },
	{ SISOP1Instruction::S_FF0_I32_B64, { Instruction::ScalarBitManip, Instruction::TypeI32B64 } },
	{ SISOP1Instruction::S_FF1_I32_B32, { Instruction::ScalarBitManip, Instruction::TypeI32B32 } },
	{ SISOP1Instruction::S_FF1_I32_B64, { Instruction::ScalarBitManip, Instruction::TypeI32B64 } },
	{ SISOP1Instruction::S_FLBIT_I32_B32, { Instruction::ScalarBitManip, Instruction::TypeI32B32 } },
	{ SISOP1Instruction::S_FLBIT_I32_B64, { Instruction::ScalarBitManip, Instruction::TypeI32B64 } },
	{ SISOP1Instruction::S_FLBIT_I32, { Instruction::ScalarBitManip, Instruction::TypeI32 } },
	{ SISOP1Instruction::S_FLBIT_I32_I64, { Instruction::ScalarBitManip, Instruction::TypeI32I64 } },
	{ SISOP1Instruction::S_SEXT_I32_I8, { Instruction::ScalarConv, Instruction::TypeI32I8 } },
	{ SISOP1Instruction::S_SEXT_I32_I16, { Instruction::ScalarConv, Instruction::TypeI32I16 } },
	{ SISOP1Instruction::S_BITSET0_B32, { Instruction::ScalarBitManip, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_BITSET0_B64, { Instruction::ScalarBitManip, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_BITSET1_B32, { Instruction::ScalarBitManip, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_BITSET1_B64, { Instruction::ScalarBitManip, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_GETPC_B64, { Instruction::ScalarProgFlow, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_SETPC_B64, { Instruction::ScalarProgFlow, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_SWAPPC_B64, { Instruction::ScalarProgFlow, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_RFE_B64, { Instruction::Undefined, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_AND_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_OR_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_XOR_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_ANDN2_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_ORN2_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_NAND_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_NOR_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_XNOR_SAVEEXEC_B64, { Instruction::ScalarExecMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_QUADMASK_B32, { Instruction::ScalarQuadMask, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_QUADMASK_B64, { Instruction::ScalarQuadMask, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_MOVRELS_B32, { Instruction::ScalarMov, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_MOVRELS_B64, { Instruction::ScalarMov, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_MOVRELD_B32, { Instruction::ScalarMov, Instruction::TypeB32 } },
	{ SISOP1Instruction::S_MOVRELD_B64, { Instruction::ScalarMov, Instruction::TypeB64 } },
	{ SISOP1Instruction::S_CBRANCH_JOIN, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOP1Instruction::S_ABS_I32, { Instruction::ScalarAbs, Instruction::TypeI32 } },
	{ SISOP1Instruction::S_MOV_FED_B32, { Instruction::Undefined, Instruction::TypeB32 } }
};

std::unordered_map<SISOP2Instruction::OP, GCNInstructionFormat> g_instructionFormatMapSOP2 = {
	{ SISOP2Instruction::S_ADD_U32, { Instruction::ScalarArith, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_SUB_U32, { Instruction::ScalarArith, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_ADD_I32, { Instruction::ScalarArith, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_SUB_I32, { Instruction::ScalarArith, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_ADDC_U32, { Instruction::ScalarArith, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_SUBB_U32, { Instruction::ScalarArith, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_MIN_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_MIN_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_MAX_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_MAX_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_CSELECT_B32, { Instruction::ScalarSelect, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_CSELECT_B64, { Instruction::ScalarSelect, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_AND_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_AND_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_OR_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_OR_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_XOR_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_XOR_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_ANDN2_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_ANDN2_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_ORN2_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_ORN2_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_NAND_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_NAND_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_NOR_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_NOR_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_XNOR_B32, { Instruction::ScalarBitLogic, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_XNOR_B64, { Instruction::ScalarBitLogic, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_LSHL_B32, { Instruction::ScalarBitManip, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_LSHL_B64, { Instruction::ScalarBitManip, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_LSHR_B32, { Instruction::ScalarBitManip, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_LSHR_B64, { Instruction::ScalarBitManip, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_ASHR_I32, { Instruction::ScalarBitManip, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_ASHR_I64, { Instruction::ScalarBitManip, Instruction::TypeI64 } },
	{ SISOP2Instruction::S_BFM_B32, { Instruction::ScalarBitField, Instruction::TypeB32 } },
	{ SISOP2Instruction::S_BFM_B64, { Instruction::ScalarBitField, Instruction::TypeB64 } },
	{ SISOP2Instruction::S_MUL_I32, { Instruction::ScalarArith, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_BFE_U32, { Instruction::ScalarBitField, Instruction::TypeU32 } },
	{ SISOP2Instruction::S_BFE_I32, { Instruction::ScalarBitField, Instruction::TypeI32 } },
	{ SISOP2Instruction::S_BFE_U64, { Instruction::ScalarBitField, Instruction::TypeU64 } },
	{ SISOP2Instruction::S_BFE_I64, { Instruction::ScalarBitField, Instruction::TypeI64 } },
	{ SISOP2Instruction::S_CBRANCH_G_FORK, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOP2Instruction::S_ABSDIFF_I32, { Instruction::ScalarAbs, Instruction::TypeI32 } },
};

std::unordered_map<SISOPCInstruction::OP, GCNInstructionFormat> g_instructionFormatMapSOPC = {
	{ SISOPCInstruction::S_CMP_EQ_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_LG_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_GT_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_GE_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_LT_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_LE_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPCInstruction::S_CMP_EQ_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_CMP_LG_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_CMP_GT_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_CMP_GE_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_CMP_LT_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_CMP_LE_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPCInstruction::S_BITCMP0_B32, { Instruction::ScalarCmp, Instruction::TypeB32 } },
	{ SISOPCInstruction::S_BITCMP1_B32, { Instruction::ScalarCmp, Instruction::TypeB32 } },
	{ SISOPCInstruction::S_BITCMP0_B64, { Instruction::ScalarCmp, Instruction::TypeB64 } },
	{ SISOPCInstruction::S_BITCMP1_B64, { Instruction::ScalarCmp, Instruction::TypeB64 } },
	{ SISOPCInstruction::S_SETVSKIP, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
};

std::unordered_map<SISOPKInstruction::OP, GCNInstructionFormat> g_instructionFormatMapSOPK = {
	{ SISOPKInstruction::S_MOVK_I32, { Instruction::ScalarMov, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMOVK_I32, { Instruction::ScalarMov, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_EQ_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_LG_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_GT_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_GE_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_LT_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_LE_I32, { Instruction::ScalarCmp, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CMPK_EQ_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_CMPK_LG_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_CMPK_GT_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_CMPK_GE_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_CMPK_LT_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_CMPK_LE_U32, { Instruction::ScalarCmp, Instruction::TypeU32 } },
	{ SISOPKInstruction::S_ADDK_I32, { Instruction::ScalarArith, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_MULK_I32, { Instruction::ScalarArith, Instruction::TypeI32 } },
	{ SISOPKInstruction::S_CBRANCH_I_FORK, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPKInstruction::S_GETREG_B32, { Instruction::ScalarProgFlow, Instruction::TypeB32 } },
	{ SISOPKInstruction::S_SETREG_B32, { Instruction::ScalarRegAccess, Instruction::TypeB32 } },
	{ SISOPKInstruction::S_SETREG_IMM32_B32, { Instruction::ScalarRegAccess, Instruction::TypeB32 } },
};

std::unordered_map<SISOPPInstruction::OP, GCNInstructionFormat> g_instructionFormatMapSOPP = {
	{ SISOPPInstruction::S_NOP, { Instruction::ScalarWait, Instruction::TypeNone } },
	{ SISOPPInstruction::S_ENDPGM, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_BRANCH, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_SCC0, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_SCC1, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_VCCZ, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_VCCNZ, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_EXECZ, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_EXECNZ, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_BARRIER, { Instruction::ScalarSync, Instruction::TypeNone } },
	{ SISOPPInstruction::S_WAITCNT, { Instruction::ScalarSync, Instruction::TypeNone } },
	{ SISOPPInstruction::S_SETHALT, { Instruction::Undefined, Instruction::TypeNone } },
	{ SISOPPInstruction::S_SLEEP, { Instruction::ScalarSync, Instruction::TypeNone } },
	{ SISOPPInstruction::S_SETPRIO, { Instruction::ScalarSync, Instruction::TypeNone } },
	{ SISOPPInstruction::S_SENDMSG, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_SENDMSGHALT, { Instruction::ScalarProgFlow, Instruction::TypeNone } },
	{ SISOPPInstruction::S_TRAP, { Instruction::Undefined, Instruction::TypeNone } },
	{ SISOPPInstruction::S_ICACHE_INV, { Instruction::ScalarCache, Instruction::TypeNone } },
	{ SISOPPInstruction::S_INCPERFLEVEL, { Instruction::DbgProf, Instruction::TypeNone } },
	{ SISOPPInstruction::S_DECPERFLEVEL, { Instruction::DbgProf, Instruction::TypeNone } },
	{ SISOPPInstruction::S_TTRACEDATA, { Instruction::DbgProf, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_CDBGSYS, { Instruction::Undefined, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_CDBGUSER, { Instruction::Undefined, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_CDBGSYS_OR_USER, { Instruction::Undefined, Instruction::TypeNone } },
	{ SISOPPInstruction::S_CBRANCH_CDBGSYS_AND_USER, { Instruction::Undefined, Instruction::TypeNone } },
};

std::unordered_map<SIVOP1Instruction::VOP1_OP, GCNInstructionFormat> g_instructionFormatMapVOP1 = {
	{ SIVOP1Instruction::V_NOP, { Instruction::VectorMisc, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_MOV_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_READFIRSTLANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_CVT_I32_F64, { Instruction::VectorConv, Instruction::TypeI32F64 } },
	{ SIVOP1Instruction::V_CVT_F64_I32, { Instruction::VectorConv, Instruction::TypeF64I32 } },
	{ SIVOP1Instruction::V_CVT_F32_I32, { Instruction::VectorConv, Instruction::TypeF32I32 } },
	{ SIVOP1Instruction::V_CVT_F32_U32, { Instruction::VectorConv, Instruction::TypeF32U32 } },
	{ SIVOP1Instruction::V_CVT_U32_F32, { Instruction::VectorConv, Instruction::TypeU32F32 } },
	{ SIVOP1Instruction::V_CVT_I32_F32, { Instruction::VectorConv, Instruction::TypeI32F32 } },
	{ SIVOP1Instruction::V_MOV_FED_B32, { Instruction::Undefined, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_CVT_F16_F32, { Instruction::VectorConv, Instruction::TypeF16F32 } },
	{ SIVOP1Instruction::V_CVT_F32_F16, { Instruction::VectorConv, Instruction::TypeF32F16 } },
	{ SIVOP1Instruction::V_CVT_RPI_I32_F32, { Instruction::VectorConv, Instruction::TypeI32F32 } },
	{ SIVOP1Instruction::V_CVT_FLR_I32_F32, { Instruction::VectorConv, Instruction::TypeI32F32 } },
	{ SIVOP1Instruction::V_CVT_OFF_F32_I4, { Instruction::VectorConv, Instruction::TypeF32I4 } },
	{ SIVOP1Instruction::V_CVT_F32_F64, { Instruction::VectorConv, Instruction::TypeF32F64 } },
	{ SIVOP1Instruction::V_CVT_F64_F32, { Instruction::VectorConv, Instruction::TypeF64F32 } },
	{ SIVOP1Instruction::V_CVT_F32_UBYTE0, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_CVT_F32_UBYTE1, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_CVT_F32_UBYTE2, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_CVT_F32_UBYTE3, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_CVT_U32_F64, { Instruction::VectorConv, Instruction::TypeU32F64 } },
	{ SIVOP1Instruction::V_CVT_F64_U32, { Instruction::VectorConv, Instruction::TypeF64U32 } },
	{ SIVOP1Instruction::V_FRACT_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_TRUNC_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_CEIL_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RNDNE_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_FLOOR_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_EXP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_LOG_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_LOG_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RCP_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RCP_LEGACY_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RCP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RCP_IFLAG_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RSQ_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RSQ_LEGACY_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RSQ_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_RCP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_RCP_CLAMP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_RSQ_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_RSQ_CLAMP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_SQRT_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_SQRT_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_SIN_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_COS_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_NOT_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_BFREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_FFBH_U32, { Instruction::VectorBitField32, Instruction::TypeU32 } },
	{ SIVOP1Instruction::V_FFBL_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_FFBH_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP1Instruction::V_FREXP_EXP_I32_F64, { Instruction::VectorFpField64, Instruction::TypeI32F64 } },
	{ SIVOP1Instruction::V_FREXP_MANT_F64, { Instruction::VectorFpField64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_FRACT_F64, { Instruction::VectorFpRound64, Instruction::TypeF64 } },
	{ SIVOP1Instruction::V_FREXP_EXP_I32_F32, { Instruction::VectorFpField32, Instruction::TypeI32F32 } },
	{ SIVOP1Instruction::V_FREXP_MANT_F32, { Instruction::VectorFpField32, Instruction::TypeF32 } },
	{ SIVOP1Instruction::V_CLREXCP, { Instruction::Undefined, Instruction::TypeNone } },
	{ SIVOP1Instruction::V_MOVRELD_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_MOVRELS_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP1Instruction::V_MOVRELSD_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP1Instruction::VOP1_UNDEFINE, { Instruction::Undefined, Instruction::TypeNone } },
};

std::unordered_map<SIVOP2Instruction::VOP2_OP, GCNInstructionFormat> g_instructionFormatMapVOP2 = {
	{ SIVOP2Instruction::V_CNDMASK_B32, { Instruction::VectorThreadMask, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_READLANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_WRITELANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_ADD_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_SUB_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_SUBREV_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MAC_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MUL_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MUL_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MUL_I32_I24, { Instruction::VectorIntArith32, Instruction::TypeI32I24 } },
	{ SIVOP2Instruction::V_MUL_HI_I32_I24, { Instruction::VectorIntArith32, Instruction::TypeI32I24 } },
	{ SIVOP2Instruction::V_MUL_U32_U24, { Instruction::VectorIntArith32, Instruction::TypeU32U24 } },
	{ SIVOP2Instruction::V_MUL_HI_U32_U24, { Instruction::VectorIntArith32, Instruction::TypeU32U24 } },
	{ SIVOP2Instruction::V_MIN_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MAX_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MIN_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MAX_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MIN_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_MAX_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_MIN_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP2Instruction::V_MAX_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP2Instruction::V_LSHR_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_LSHRREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_ASHR_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_ASHRREV_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_LSHL_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_LSHLREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_AND_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_OR_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_XOR_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_BFM_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP2Instruction::V_MAC_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MADMK_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_MADAK_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_BCNT_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP2Instruction::V_MBCNT_LO_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP2Instruction::V_MBCNT_HI_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP2Instruction::V_ADD_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_SUB_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_SUBREV_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP2Instruction::V_ADDC_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP2Instruction::V_SUBB_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP2Instruction::V_SUBBREV_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP2Instruction::V_LDEXP_F32, { Instruction::VectorFpField32, Instruction::TypeF32 } },
	{ SIVOP2Instruction::V_CVT_PKACCUM_U8_F32, { Instruction::VectorConv, Instruction::TypeU8F32 } },
	{ SIVOP2Instruction::V_CVT_PKNORM_I16_F32, { Instruction::VectorConv, Instruction::TypeI16F32 } },
	{ SIVOP2Instruction::V_CVT_PKNORM_U16_F32, { Instruction::VectorConv, Instruction::TypeU16F32 } },
	{ SIVOP2Instruction::V_CVT_PKRTZ_F16_F32, { Instruction::VectorConv, Instruction::TypeF16F32 } },
	{ SIVOP2Instruction::V_CVT_PK_U16_U32, { Instruction::VectorConv, Instruction::TypeU16U32 } },
	{ SIVOP2Instruction::V_CVT_PK_I16_I32, { Instruction::VectorConv, Instruction::TypeI16I32 } },
	{ SIVOP2Instruction::VOP2_UNDEFINE, { Instruction::Undefined, Instruction::TypeNone } },
};

std::unordered_map<SIVOP3Instruction::VOP3_OP, GCNInstructionFormat> g_instructionFormatMapVOP3 = {
	{ SIVOP3Instruction::V3_CMP_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPSX_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPS_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPS_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPSX_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_F_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_LT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_EQ_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_LE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_GT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_NE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_GE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_T_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMP_CLASS_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMP_LT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_EQ_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_LE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_GT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_NE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_GE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMP_CLASS_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_F_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_LT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_LE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_GT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_NE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_GE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_T_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_CMPX_CLASS_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CMPX_LT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_LE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_GT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_NE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_GE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOP3Instruction::V3_CMPX_CLASS_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_F_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_LT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_EQ_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_LE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_GT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_NE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_GE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_T_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMP_CLASS_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMP_LT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_EQ_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_LE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_GT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_NE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_GE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_F_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_LT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_LE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_GT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_NE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_GE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_T_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_CMPX_CLASS_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_CMPX_LT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_LE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_GT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_NE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMPX_GE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_CMP_F_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_LT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_EQ_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_LE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_GT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_NE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_GE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_T_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMP_F_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_LT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_EQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_LE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_GT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_LG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_GE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_O_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_F_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_LT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_LE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_GT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_NE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_GE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_T_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CMPX_F_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_LT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_LE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_GT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_LG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_GE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_O_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_F_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_LT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_EQ_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_LE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_GT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_NE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_GE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_T_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMP_U_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NGE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NLG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NGT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NLE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NEQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_NLT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMP_TRU_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOP3Instruction::V3_CMPX_F_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_LT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_EQ_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_LE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_GT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_NE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_GE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CMPX_T_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOP3Instruction::V3_CNDMASK_B32, { Instruction::VectorThreadMask, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_READLANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_WRITELANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_ADD_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_SUB_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_SUBREV_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAC_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MUL_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MUL_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MUL_I32_I24, { Instruction::VectorIntArith32, Instruction::TypeI32I24 } },
	{ SIVOP3Instruction::V3_MUL_HI_I32_I24, { Instruction::VectorIntArith32, Instruction::TypeI32I24 } },
	{ SIVOP3Instruction::V3_MUL_U32_U24, { Instruction::VectorIntArith32, Instruction::TypeU32U24 } },
	{ SIVOP3Instruction::V3_MUL_HI_U32_U24, { Instruction::VectorIntArith32, Instruction::TypeU32U24 } },
	{ SIVOP3Instruction::V3_MIN_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAX_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MIN_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAX_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MIN_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MAX_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MIN_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_MAX_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_LSHR_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_LSHRREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_ASHR_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_ASHRREV_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_LSHL_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_LSHLREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_AND_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_OR_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_XOR_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_BFM_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_MAC_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MADMK_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MADAK_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_BCNT_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP3Instruction::V3_MBCNT_LO_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP3Instruction::V3_MBCNT_HI_U32_B32, { Instruction::VectorThreadMask, Instruction::TypeU32B32 } },
	{ SIVOP3Instruction::V3_ADD_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_SUB_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_SUBREV_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_ADDC_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_SUBB_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_SUBBREV_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_LDEXP_F32, { Instruction::VectorFpField32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CVT_PKACCUM_U8_F32, { Instruction::VectorConv, Instruction::TypeU8F32 } },
	{ SIVOP3Instruction::V3_CVT_PKNORM_I16_F32, { Instruction::VectorConv, Instruction::TypeI16F32 } },
	{ SIVOP3Instruction::V3_CVT_PKNORM_U16_F32, { Instruction::VectorConv, Instruction::TypeU16F32 } },
	{ SIVOP3Instruction::V3_CVT_PKRTZ_F16_F32, { Instruction::VectorConv, Instruction::TypeF16F32 } },
	{ SIVOP3Instruction::V3_CVT_PK_U16_U32, { Instruction::VectorConv, Instruction::TypeU16U32 } },
	{ SIVOP3Instruction::V3_CVT_PK_I16_I32, { Instruction::VectorConv, Instruction::TypeI16I32 } },
	{ SIVOP3Instruction::V3_MAD_LEGACY_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAD_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAD_I32_I24, { Instruction::VectorIntArith32, Instruction::TypeI32I24 } },
	{ SIVOP3Instruction::V3_MAD_U32_U24, { Instruction::VectorIntArith32, Instruction::TypeU32U24 } },
	{ SIVOP3Instruction::V3_CUBEID_F32, { Instruction::VectorFpGraph32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CUBESC_F32, { Instruction::VectorFpGraph32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CUBETC_F32, { Instruction::VectorFpGraph32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CUBEMA_F32, { Instruction::VectorFpGraph32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_BFE_U32, { Instruction::VectorBitField32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_BFE_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_BFI_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_FMA_F32, { Instruction::VectorFpArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_FMA_F64, { Instruction::VectorFpArith64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_LERP_U8, { Instruction::VectorIntGraph, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_ALIGNBIT_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_ALIGNBYTE_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_MULLIT_F32, { Instruction::VectorFpGraph32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MIN3_F32, { Instruction::VectorIntArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MIN3_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MIN3_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_MAX3_F32, { Instruction::VectorIntArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MAX3_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MAX3_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_MED3_F32, { Instruction::VectorIntArith32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_MED3_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MED3_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_SAD_U8, { Instruction::VectorIntGraph, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_SAD_HI_U8, { Instruction::VectorIntGraph, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_SAD_U16, { Instruction::VectorIntGraph, Instruction::TypeU16 } },
	{ SIVOP3Instruction::V3_SAD_U32, { Instruction::VectorIntGraph, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_CVT_PK_U8_F32, { Instruction::VectorConv, Instruction::TypeU8F32 } },
	{ SIVOP3Instruction::V3_DIV_FIXUP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_DIV_FIXUP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_LSHL_B64, { Instruction::VectorBitField64, Instruction::TypeB64 } },
	{ SIVOP3Instruction::V3_LSHR_B64, { Instruction::VectorBitField64, Instruction::TypeB64 } },
	{ SIVOP3Instruction::V3_ASHR_I64, { Instruction::VectorBitField64, Instruction::TypeI64 } },
	{ SIVOP3Instruction::V3_ADD_F64, { Instruction::VectorFpArith64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_MUL_F64, { Instruction::VectorFpArith64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_MIN_F64, { Instruction::VectorFpArith64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_MAX_F64, { Instruction::VectorFpArith64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_LDEXP_F64, { Instruction::VectorFpField64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_MUL_LO_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_MUL_HI_U32, { Instruction::VectorIntArith32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_MUL_LO_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_MUL_HI_I32, { Instruction::VectorIntArith32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_DIV_SCALE_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_DIV_SCALE_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_DIV_FMAS_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_DIV_FMAS_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_MSAD_U8, { Instruction::VectorIntGraph, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_QSAD_U8, { Instruction::Undefined, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_MQSAD_U8, { Instruction::Undefined, Instruction::TypeU8 } },
	{ SIVOP3Instruction::V3_TRIG_PREOP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_NOP, { Instruction::VectorMisc, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_MOV_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_READFIRSTLANE_B32, { Instruction::VectorLane, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_CVT_I32_F64, { Instruction::VectorConv, Instruction::TypeI32F64 } },
	{ SIVOP3Instruction::V3_CVT_F64_I32, { Instruction::VectorConv, Instruction::TypeF64I32 } },
	{ SIVOP3Instruction::V3_CVT_F32_I32, { Instruction::VectorFpTran32, Instruction::TypeF32I32 } },
	{ SIVOP3Instruction::V3_CVT_F32_U32, { Instruction::VectorFpTran32, Instruction::TypeF32U32 } },
	{ SIVOP3Instruction::V3_CVT_U32_F32, { Instruction::VectorFpTran32, Instruction::TypeU32F32 } },
	{ SIVOP3Instruction::V3_CVT_I32_F32, { Instruction::VectorFpTran32, Instruction::TypeI32F32 } },
	{ SIVOP3Instruction::V3_MOV_FED_B32, { Instruction::Undefined, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_CVT_F16_F32, { Instruction::VectorConv, Instruction::TypeF16F32 } },
	{ SIVOP3Instruction::V3_CVT_F32_F16, { Instruction::VectorConv, Instruction::TypeF32F16 } },
	{ SIVOP3Instruction::V3_CVT_RPI_I32_F32, { Instruction::VectorConv, Instruction::TypeI32F32 } },
	{ SIVOP3Instruction::V3_CVT_FLR_I32_F32, { Instruction::VectorConv, Instruction::TypeI32F32 } },
	{ SIVOP3Instruction::V3_CVT_OFF_F32_I4, { Instruction::VectorConv, Instruction::TypeF32I4 } },
	{ SIVOP3Instruction::V3_CVT_F32_F64, { Instruction::VectorConv, Instruction::TypeF32F64 } },
	{ SIVOP3Instruction::V3_CVT_F64_F32, { Instruction::VectorConv, Instruction::TypeF64F32 } },
	{ SIVOP3Instruction::V3_CVT_F32_UBYTE0, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_CVT_F32_UBYTE1, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_CVT_F32_UBYTE2, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_CVT_F32_UBYTE3, { Instruction::VectorConv, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_CVT_U32_F64, { Instruction::VectorConv, Instruction::TypeU32F64 } },
	{ SIVOP3Instruction::V3_CVT_F64_U32, { Instruction::VectorConv, Instruction::TypeF64U32 } },
	{ SIVOP3Instruction::V3_FRACT_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_TRUNC_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CEIL_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RNDNE_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_FLOOR_F32, { Instruction::VectorFpRound32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_EXP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_LOG_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_LOG_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RCP_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RCP_LEGACY_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RCP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RCP_IFLAG_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RSQ_CLAMP_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RSQ_LEGACY_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RSQ_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_RCP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_RCP_CLAMP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_RSQ_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_RSQ_CLAMP_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_SQRT_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_SQRT_F64, { Instruction::VectorFpTran64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_SIN_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_COS_F32, { Instruction::VectorFpTran32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_NOT_B32, { Instruction::VectorBitLogic, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_BFREV_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_FFBH_U32, { Instruction::VectorBitField32, Instruction::TypeU32 } },
	{ SIVOP3Instruction::V3_FFBL_B32, { Instruction::VectorBitField32, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_FFBH_I32, { Instruction::VectorBitField32, Instruction::TypeI32 } },
	{ SIVOP3Instruction::V3_FREXP_EXP_I32_F64, { Instruction::VectorFpField64, Instruction::TypeI32F64 } },
	{ SIVOP3Instruction::V3_FREXP_MANT_F64, { Instruction::VectorFpField64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_FRACT_F64, { Instruction::VectorFpRound64, Instruction::TypeF64 } },
	{ SIVOP3Instruction::V3_FREXP_EXP_I32_F32, { Instruction::VectorFpField32, Instruction::TypeI32F32 } },
	{ SIVOP3Instruction::V3_FREXP_MANT_F32, { Instruction::VectorFpField32, Instruction::TypeF32 } },
	{ SIVOP3Instruction::V3_CLREXCP, { Instruction::Undefined, Instruction::TypeNone } },
	{ SIVOP3Instruction::V3_MOVRELD_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_MOVRELS_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP3Instruction::V3_MOVRELSD_B32, { Instruction::VectorRegMov, Instruction::TypeB32 } },
	{ SIVOP3Instruction::VOP3_UNDEFINE, { Instruction::Undefined, Instruction::TypeNone } },
};

std::unordered_map<SIVOPCInstruction::VOPC_OP, GCNInstructionFormat> g_instructionFormatMapVOPC = {
	{ SIVOPCInstruction::V_CMP_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_F_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_LT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_EQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_LE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_GT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_LG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_GE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_O_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_U_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NGE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NLG_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NGT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NLE_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NEQ_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_NLT_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPSX_TRU_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPS_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPS_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_F_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_LT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_EQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_LE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_GT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_LG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_GE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_O_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_U_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NGE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NLG_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NGT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NLE_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NEQ_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_NLT_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPSX_TRU_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_F_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_LT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_EQ_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_LE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_GT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_NE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_GE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_T_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMP_CLASS_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMP_LT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_EQ_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_LE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_GT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_NE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_GE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMP_CLASS_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_F_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_LT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_EQ_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_LE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_GT_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_NE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_GE_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_T_I32, { Instruction::VectorIntCmp32, Instruction::TypeI32 } },
	{ SIVOPCInstruction::V_CMPX_CLASS_F32, { Instruction::VectorFpCmp32, Instruction::TypeF32 } },
	{ SIVOPCInstruction::V_CMPX_LT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_EQ_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_LE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_GT_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_NE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_GE_I16, { Instruction::Undefined, Instruction::TypeI16 } },
	{ SIVOPCInstruction::V_CMPX_CLASS_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_F_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_LT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_EQ_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_LE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_GT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_NE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_GE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_T_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMP_CLASS_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMP_LT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_EQ_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_LE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_GT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_NE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_GE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_F_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_LT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_EQ_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_LE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_GT_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_NE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_GE_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_T_I64, { Instruction::VectorIntCmp64, Instruction::TypeI64 } },
	{ SIVOPCInstruction::V_CMPX_CLASS_F64, { Instruction::VectorFpCmp64, Instruction::TypeF64 } },
	{ SIVOPCInstruction::V_CMPX_LT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_EQ_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_LE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_GT_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_NE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMPX_GE_U16, { Instruction::Undefined, Instruction::TypeU16 } },
	{ SIVOPCInstruction::V_CMP_F_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_LT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_EQ_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_LE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_GT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_NE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_GE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_T_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMP_F_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_LT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_EQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_LE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_GT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_LG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_GE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_O_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_F_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_LT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_EQ_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_LE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_GT_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_NE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_GE_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_T_U32, { Instruction::VectorIntCmp32, Instruction::TypeU32 } },
	{ SIVOPCInstruction::V_CMPX_F_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_LT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_EQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_LE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_GT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_LG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_GE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_O_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_F_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_LT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_EQ_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_LE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_GT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_NE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_GE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_T_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMP_U_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NGE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NLG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NGT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NLE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NEQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_NLT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMP_TRU_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_F_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_LT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_EQ_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_LE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_GT_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_NE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_GE_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_T_U64, { Instruction::VectorIntCmp64, Instruction::TypeU64 } },
	{ SIVOPCInstruction::V_CMPX_U_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NGE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NLG_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NGT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NLE_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NEQ_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_NLT_F16, { Instruction::Undefined, Instruction::TypeF16 } },
	{ SIVOPCInstruction::V_CMPX_TRU_F16, { Instruction::Undefined, Instruction::TypeF16 } },
};

std::unordered_map<SIMUBUFInstruction::OP, GCNInstructionFormat> g_instructionFormatMapMUBUF = {
	{ SIMUBUFInstruction::BUFFER_LOAD_FORMAT_X, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_FORMAT_XY, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_FORMAT_XYZ, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_FORMAT_XYZW, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_FORMAT_X, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_FORMAT_XY, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_FORMAT_XYZ, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_FORMAT_XYZW, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_UBYTE, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_SBYTE, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_USHORT, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_SSHORT, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_DWORD, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_DWORDX2, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_DWORDX4, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_LOAD_DWORDX3, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_BYTE, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_SHORT, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_DWORD, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_DWORDX2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_DWORDX4, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_STORE_DWORDX3, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SWAP, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_CMPSWAP, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_ADD, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SUB, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_RSUB, { Instruction::Undefined, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SMIN, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_UMIN, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SMAX, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_UMAX, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_AND, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_OR, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_XOR, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_INC, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_DEC, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FCMPSWAP, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FMIN, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FMAX, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SWAP_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_CMPSWAP_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_ADD_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SUB_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_RSUB_X2, { Instruction::Undefined, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SMIN_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_UMIN_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_SMAX_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_UMAX_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_AND_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_OR_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_XOR_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_INC_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_DEC_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FCMPSWAP_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FMIN_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_ATOMIC_FMAX_X2, { Instruction::VectorMemBufNoFmt, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_WBINVL1_SC, { Instruction::VectorMemL1Cache, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_WBINVL1_VOL, { Instruction::VectorMemL1Cache, Instruction::TypeNone } },
	{ SIMUBUFInstruction::BUFFER_WBINVL1, { Instruction::VectorMemL1Cache, Instruction::TypeNone } },
};

std::unordered_map<SIMTBUFInstruction::OP, GCNInstructionFormat> g_instructionFormatMapMTBUF = {
	{ SIMTBUFInstruction::TBUFFER_LOAD_FORMAT_X, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_LOAD_FORMAT_XY, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_LOAD_FORMAT_XYZ, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_LOAD_FORMAT_XYZW, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_STORE_FORMAT_X, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_STORE_FORMAT_XY, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_STORE_FORMAT_XYZ, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
	{ SIMTBUFInstruction::TBUFFER_STORE_FORMAT_XYZW, { Instruction::VectorMemBufFmt, Instruction::TypeNone } },
};

std::unordered_map<SIMIMGInstruction::OP, GCNInstructionFormat> g_instructionFormatMapMIMG = {
	{ SIMIMGInstruction::IMAGE_LOAD, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_LOAD_MIP, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_LOAD_PCK, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_LOAD_PCK_SGN, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_LOAD_MIP_PCK, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_LOAD_MIP_PCK_SGN, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_STORE, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_STORE_MIP, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_STORE_PCK, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_STORE_MIP_PCK, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GET_RESINFO, { Instruction::VectorMemImgUt, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_SWAP, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_CMPSWAP, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_ADD, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_SUB, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_RSUB, { Instruction::Undefined, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_SMIN, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_UMIN, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_SMAX, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_UMAX, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_AND, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_OR, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_XOR, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_INC, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_DEC, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_FCMPSWAP, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_FMIN, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_ATOMIC_FMAX, { Instruction::VectorMemImgNoSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_D, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_D_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_L, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_B, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_B_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_LZ, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_D, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_D_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_L, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_B, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_B_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_LZ, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_D_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_D_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_L_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_B_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_B_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_LZ_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_D_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_D_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_L_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_B_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_B_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_LZ_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_L, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_B, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_B_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_LZ, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_L, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_B, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_B_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_LZ, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_L_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_B_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_B_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_LZ_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_L_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_B_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_B_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GATHER4_C_LZ_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_GET_LOD, { Instruction::VectorMemImgUt, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CD, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CD_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CD, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CD_CL, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CD_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_CD_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CD_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
	{ SIMIMGInstruction::IMAGE_SAMPLE_C_CD_CL_O, { Instruction::VectorMemImgSmp, Instruction::TypeNone } },
};

std::unordered_map<SIDSInstruction::OP, GCNInstructionFormat> g_instructionFormatMapDS = {
	{ SIDSInstruction::DS_ADD_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_SUB_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_RSUB_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_INC_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_DEC_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MIN_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MAX_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MIN_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MAX_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_AND_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_OR_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_XOR_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_MSKOR_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRITE_B32, { Instruction::DsIdxWr, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRITE2_B32, { Instruction::DsIdxWr, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRITE2ST64_B32, { Instruction::DsIdxWr, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_CMPST_B32, { Instruction::DsAtomicCmpSt32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_CMPST_F32, { Instruction::DsAtomicCmpSt32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_MIN_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_MAX_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_NOP, { Instruction::DsDataShareMisc, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_SEMA_RELEASE_ALL, { Instruction::GdsSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_INIT, { Instruction::GdsSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_SEMA_V, { Instruction::GdsSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_SEMA_BR, { Instruction::GdsSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_SEMA_P, { Instruction::GdsSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_GWS_BARRIER, { Instruction::ScalarSync, Instruction::TypeNone } },
	{ SIDSInstruction::DS_WRITE_B8, { Instruction::DsIdxWr, Instruction::TypeB8 } },
	{ SIDSInstruction::DS_WRITE_B16, { Instruction::DsIdxWr, Instruction::TypeB16 } },
	{ SIDSInstruction::DS_ADD_RTN_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_SUB_RTN_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_RSUB_RTN_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_INC_RTN_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_DEC_RTN_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MIN_RTN_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MAX_RTN_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MIN_RTN_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MAX_RTN_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_AND_RTN_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_OR_RTN_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_XOR_RTN_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_MSKOR_RTN_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRXCHG_RTN_B32, { Instruction::DsIdxWrXchg, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRXCHG2_RTN_B32, { Instruction::DsIdxWrXchg, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRXCHG2ST64_RTN_B32, { Instruction::DsIdxWrXchg, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_CMPST_RTN_B32, { Instruction::DsAtomicCmpSt32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_CMPST_RTN_F32, { Instruction::DsAtomicCmpSt32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_MIN_RTN_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_MAX_RTN_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_WRAP_RTN_B32, { Instruction::DsIdxWrap, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_SWIZZLE_B32, { Instruction::DsDataShareUt, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_READ_B32, { Instruction::DsIdxRd, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_READ2_B32, { Instruction::DsIdxRd, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_READ2ST64_B32, { Instruction::DsIdxRd, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_READ_I8, { Instruction::DsIdxRd, Instruction::TypeI8 } },
	{ SIDSInstruction::DS_READ_U8, { Instruction::DsIdxRd, Instruction::TypeU8 } },
	{ SIDSInstruction::DS_READ_I16, { Instruction::DsIdxRd, Instruction::TypeI16 } },
	{ SIDSInstruction::DS_READ_U16, { Instruction::DsIdxRd, Instruction::TypeU16 } },
	{ SIDSInstruction::DS_CONSUME, { Instruction::DsAppendCon, Instruction::TypeNone } },
	{ SIDSInstruction::DS_APPEND, { Instruction::DsAppendCon, Instruction::TypeNone } },
	{ SIDSInstruction::DS_ORDERED_COUNT, { Instruction::GdsOrdCnt, Instruction::TypeNone } },
	{ SIDSInstruction::DS_ADD_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_SUB_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_RSUB_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_INC_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_DEC_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MIN_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MAX_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MIN_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MAX_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_AND_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_OR_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_XOR_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_MSKOR_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRITE_B64, { Instruction::DsIdxWr, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRITE2_B64, { Instruction::DsIdxWr, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRITE2ST64_B64, { Instruction::DsIdxWr, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_CMPST_B64, { Instruction::DsAtomicCmpSt64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_CMPST_F64, { Instruction::DsAtomicCmpSt64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_MIN_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_MAX_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_ADD_RTN_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_SUB_RTN_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_RSUB_RTN_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_INC_RTN_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_DEC_RTN_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MIN_RTN_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MAX_RTN_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MIN_RTN_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MAX_RTN_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_AND_RTN_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_OR_RTN_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_XOR_RTN_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_MSKOR_RTN_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRXCHG_RTN_B64, { Instruction::DsIdxWrXchg, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRXCHG2_RTN_B64, { Instruction::DsIdxWrXchg, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRXCHG2ST64_RTN_B64, { Instruction::DsIdxWrXchg, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_CMPST_RTN_B64, { Instruction::DsAtomicCmpSt64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_CMPST_RTN_F64, { Instruction::DsAtomicCmpSt64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_MIN_RTN_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_MAX_RTN_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_READ_B64, { Instruction::DsIdxRd, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_READ2_B64, { Instruction::DsIdxRd, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_READ2ST64_B64, { Instruction::DsIdxRd, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_CONDXCHG32_RTN_B64, { Instruction::DsIdxCondXchg, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_ADD_SRC2_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_SUB_SRC2_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_RSUB_SRC2_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_INC_SRC2_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_DEC_SRC2_U32, { Instruction::DsAtomicArith32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MIN_SRC2_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MAX_SRC2_I32, { Instruction::DsAtomicMinMax32, Instruction::TypeI32 } },
	{ SIDSInstruction::DS_MIN_SRC2_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_MAX_SRC2_U32, { Instruction::DsAtomicMinMax32, Instruction::TypeU32 } },
	{ SIDSInstruction::DS_AND_SRC2_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_OR_SRC2_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_XOR_SRC2_B32, { Instruction::DsAtomicLogic32, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_WRITE_SRC2_B32, { Instruction::DsIdxWr, Instruction::TypeB32 } },
	{ SIDSInstruction::DS_MIN_SRC2_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_MAX_SRC2_F32, { Instruction::DsAtomicMinMax32, Instruction::TypeF32 } },
	{ SIDSInstruction::DS_ADD_SRC2_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_SUB_SRC2_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_RSUB_SRC2_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_INC_SRC2_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_DEC_SRC2_U64, { Instruction::DsAtomicArith64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MIN_SRC2_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MAX_SRC2_I64, { Instruction::DsAtomicMinMax64, Instruction::TypeI64 } },
	{ SIDSInstruction::DS_MIN_SRC2_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_MAX_SRC2_U64, { Instruction::DsAtomicMinMax64, Instruction::TypeU64 } },
	{ SIDSInstruction::DS_AND_SRC2_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_OR_SRC2_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_XOR_SRC2_B64, { Instruction::DsAtomicLogic64, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_WRITE_SRC2_B64, { Instruction::DsIdxWr, Instruction::TypeB64 } },
	{ SIDSInstruction::DS_MIN_SRC2_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_MAX_SRC2_F64, { Instruction::DsAtomicMinMax64, Instruction::TypeF64 } },
	{ SIDSInstruction::DS_WRITE_B96, { Instruction::Undefined, Instruction::TypeB96 } },
	{ SIDSInstruction::DS_WRITE_B128, { Instruction::Undefined, Instruction::TypeB128 } },
	{ SIDSInstruction::DS_CONDXCHG32_RTN_B128, { Instruction::Undefined, Instruction::TypeB128 } },
	{ SIDSInstruction::DS_READ_B96, { Instruction::Undefined, Instruction::TypeB96 } },
	{ SIDSInstruction::DS_READ_B128, { Instruction::Undefined, Instruction::TypeB128 } },
};

std::unordered_map<SISMRDInstruction::OP, GCNInstructionFormat> g_instructionFormatMapSMRD = {
	{ SISMRDInstruction::S_LOAD_DWORD, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_LOAD_DWORDX2, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_LOAD_DWORDX4, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_LOAD_DWORDX8, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_LOAD_DWORDX16, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_BUFFER_LOAD_DWORD, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_BUFFER_LOAD_DWORDX2, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_BUFFER_LOAD_DWORDX4, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_BUFFER_LOAD_DWORDX8, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_BUFFER_LOAD_DWORDX16, { Instruction::ScalarMemRd, Instruction::TypeNone } },
	{ SISMRDInstruction::S_DCACHE_INV_VOL, { Instruction::ScalarMemUt, Instruction::TypeNone } },
	{ SISMRDInstruction::S_MEMTIME, { Instruction::ScalarMemUt, Instruction::TypeNone } },
	{ SISMRDInstruction::S_DCACHE_INV, { Instruction::ScalarMemUt, Instruction::TypeNone } },
};

std::unordered_map<SIVINTRPInstruction::OP, GCNInstructionFormat> g_instructionFormatMapVINTRP = {
	{ SIVINTRPInstruction::V_INTERP_P1_F32, { Instruction::VectorInterpFpCache, Instruction::TypeF32 } },
	{ SIVINTRPInstruction::V_INTERP_P2_F32, { Instruction::VectorInterpFpCache, Instruction::TypeF32 } },
	{ SIVINTRPInstruction::V_INTERP_MOV_F32, { Instruction::VectorInterpFpCache, Instruction::TypeF32 } },
};