#pragma once

#include "GcnCommon.h"

namespace sce::gcn
{

	enum class GcnOpcodeSOP2 : uint32_t
	{
		S_ADD_U32        = 0,
		S_SUB_U32        = 1,
		S_ADD_I32        = 2,
		S_SUB_I32        = 3,
		S_ADDC_U32       = 4,
		S_SUBB_U32       = 5,
		S_MIN_I32        = 6,
		S_MIN_U32        = 7,
		S_MAX_I32        = 8,
		S_MAX_U32        = 9,
		S_CSELECT_B32    = 10,
		S_CSELECT_B64    = 11,
		S_AND_B32        = 14,
		S_AND_B64        = 15,
		S_OR_B32         = 16,
		S_OR_B64         = 17,
		S_XOR_B32        = 18,
		S_XOR_B64        = 19,
		S_ANDN2_B32      = 20,
		S_ANDN2_B64      = 21,
		S_ORN2_B32       = 22,
		S_ORN2_B64       = 23,
		S_NAND_B32       = 24,
		S_NAND_B64       = 25,
		S_NOR_B32        = 26,
		S_NOR_B64        = 27,
		S_XNOR_B32       = 28,
		S_XNOR_B64       = 29,
		S_LSHL_B32       = 30,
		S_LSHL_B64       = 31,
		S_LSHR_B32       = 32,
		S_LSHR_B64       = 33,
		S_ASHR_I32       = 34,
		S_ASHR_I64       = 35,
		S_BFM_B32        = 36,
		S_BFM_B64        = 37,
		S_MUL_I32        = 38,
		S_BFE_U32        = 39,
		S_BFE_I32        = 40,
		S_BFE_U64        = 41,
		S_BFE_I64        = 42,
		S_CBRANCH_G_FORK = 43,
		S_ABSDIFF_I32    = 44,

		OP_RANGE_SOP2 = S_ABSDIFF_I32 + 1,
	};

	enum class GcnOpcodeSOPK : uint32_t
	{
		S_MOVK_I32         = 0,
		S_CMOVK_I32        = 2,
		S_CMPK_EQ_I32      = 3,
		S_CMPK_LG_I32      = 4,
		S_CMPK_GT_I32      = 5,
		S_CMPK_GE_I32      = 6,
		S_CMPK_LT_I32      = 7,
		S_CMPK_LE_I32      = 8,
		S_CMPK_EQ_U32      = 9,
		S_CMPK_LG_U32      = 10,
		S_CMPK_GT_U32      = 11,
		S_CMPK_GE_U32      = 12,
		S_CMPK_LT_U32      = 13,
		S_CMPK_LE_U32      = 14,
		S_ADDK_I32         = 15,
		S_MULK_I32         = 16,
		S_CBRANCH_I_FORK   = 17,
		S_GETREG_B32       = 18,
		S_SETREG_B32       = 19,
		S_GETREG_REGRD_B32 = 20,
		S_SETREG_IMM32_B32 = 21,

		OP_RANGE_SOPK = S_SETREG_IMM32_B32 + 1,
	};

	enum class GcnOpcodeSOP1 : uint32_t
	{
		S_MOV_B32            = 3,
		S_MOV_B64            = 4,
		S_CMOV_B32           = 5,
		S_CMOV_B64           = 6,
		S_NOT_B32            = 7,
		S_NOT_B64            = 8,
		S_WQM_B32            = 9,
		S_WQM_B64            = 10,
		S_BREV_B32           = 11,
		S_BREV_B64           = 12,
		S_BCNT0_I32_B32      = 13,
		S_BCNT0_I32_B64      = 14,
		S_BCNT1_I32_B32      = 15,
		S_BCNT1_I32_B64      = 16,
		S_FF0_I32_B32        = 17,
		S_FF0_I32_B64        = 18,
		S_FF1_I32_B32        = 19,
		S_FF1_I32_B64        = 20,
		S_FLBIT_I32_B32      = 21,
		S_FLBIT_I32_B64      = 22,
		S_FLBIT_I32          = 23,
		S_FLBIT_I32_I64      = 24,
		S_SEXT_I32_I8        = 25,
		S_SEXT_I32_I16       = 26,
		S_BITSET0_B32        = 27,
		S_BITSET0_B64        = 28,
		S_BITSET1_B32        = 29,
		S_BITSET1_B64        = 30,
		S_GETPC_B64          = 31,
		S_SETPC_B64          = 32,
		S_SWAPPC_B64         = 33,
		S_RFE_B64            = 34,
		S_AND_SAVEEXEC_B64   = 36,
		S_OR_SAVEEXEC_B64    = 37,
		S_XOR_SAVEEXEC_B64   = 38,
		S_ANDN2_SAVEEXEC_B64 = 39,
		S_ORN2_SAVEEXEC_B64  = 40,
		S_NAND_SAVEEXEC_B64  = 41,
		S_NOR_SAVEEXEC_B64   = 42,
		S_XNOR_SAVEEXEC_B64  = 43,
		S_QUADMASK_B32       = 44,
		S_QUADMASK_B64       = 45,
		S_MOVRELS_B32        = 46,
		S_MOVRELS_B64        = 47,
		S_MOVRELD_B32        = 48,
		S_MOVRELD_B64        = 49,
		S_CBRANCH_JOIN       = 50,
		S_MOV_REGRD_B32      = 51,
		S_ABS_I32            = 52,
		S_MOV_FED_B32        = 53,

		OP_RANGE_SOP1 = S_MOV_FED_B32 + 1,
	};

	enum class GcnOpcodeSOPC : uint32_t
	{
		S_CMP_EQ_I32  = 0,
		S_CMP_LG_I32  = 1,
		S_CMP_GT_I32  = 2,
		S_CMP_GE_I32  = 3,
		S_CMP_LT_I32  = 4,
		S_CMP_LE_I32  = 5,
		S_CMP_EQ_U32  = 6,
		S_CMP_LG_U32  = 7,
		S_CMP_GT_U32  = 8,
		S_CMP_GE_U32  = 9,
		S_CMP_LT_U32  = 10,
		S_CMP_LE_U32  = 11,
		S_BITCMP0_B32 = 12,
		S_BITCMP1_B32 = 13,
		S_BITCMP0_B64 = 14,
		S_BITCMP1_B64 = 15,
		S_SETVSKIP    = 16,

		OP_RANGE_SOPC = S_SETVSKIP + 1,
	};

	enum class GcnOpcodeSOPP : uint32_t
	{
		S_NOP                      = 0,
		S_ENDPGM                   = 1,
		S_BRANCH                   = 2,
		S_CBRANCH_SCC0             = 4,
		S_CBRANCH_SCC1             = 5,
		S_CBRANCH_VCCZ             = 6,
		S_CBRANCH_VCCNZ            = 7,
		S_CBRANCH_EXECZ            = 8,
		S_CBRANCH_EXECNZ           = 9,
		S_BARRIER                  = 10,
		S_SETKILL                  = 11,
		S_WAITCNT                  = 12,
		S_SETHALT                  = 13,
		S_SLEEP                    = 14,
		S_SETPRIO                  = 15,
		S_SENDMSG                  = 16,
		S_SENDMSGHALT              = 17,
		S_TRAP                     = 18,
		S_ICACHE_INV               = 19,
		S_INCPERFLEVEL             = 20,
		S_DECPERFLEVEL             = 21,
		S_TTRACEDATA               = 22,
		S_CBRANCH_CDBGSYS          = 23,
		S_CBRANCH_CDBGUSER         = 24,
		S_CBRANCH_CDBGSYS_OR_USER  = 25,
		S_CBRANCH_CDBGSYS_AND_USER = 26,

		OP_RANGE_SOPP = S_CBRANCH_CDBGSYS_AND_USER + 1,
	};

	enum class GcnOpcodeSMRD : uint32_t
	{
		S_LOAD_DWORD           = 0,
		S_LOAD_DWORDX2         = 1,
		S_LOAD_DWORDX4         = 2,
		S_LOAD_DWORDX8         = 3,
		S_LOAD_DWORDX16        = 4,
		S_BUFFER_LOAD_DWORD    = 8,
		S_BUFFER_LOAD_DWORDX2  = 9,
		S_BUFFER_LOAD_DWORDX4  = 10,
		S_BUFFER_LOAD_DWORDX8  = 11,
		S_BUFFER_LOAD_DWORDX16 = 12,
		S_DCACHE_INV_VOL       = 29,
		S_MEMTIME              = 30,
		S_DCACHE_INV           = 31,

		OP_RANGE_SMRD = S_DCACHE_INV + 1,
	};

	enum class GcnOpcodeVOP2 : uint32_t
	{
		V_CNDMASK_B32        = 0,
		V_READLANE_B32       = 1,
		V_WRITELANE_B32      = 2,
		V_ADD_F32            = 3,
		V_SUB_F32            = 4,
		V_SUBREV_F32         = 5,
		V_MAC_LEGACY_F32     = 6,
		V_MUL_LEGACY_F32     = 7,
		V_MUL_F32            = 8,
		V_MUL_I32_I24        = 9,
		V_MUL_HI_I32_I24     = 10,
		V_MUL_U32_U24        = 11,
		V_MUL_HI_U32_U24     = 12,
		V_MIN_LEGACY_F32     = 13,
		V_MAX_LEGACY_F32     = 14,
		V_MIN_F32            = 15,
		V_MAX_F32            = 16,
		V_MIN_I32            = 17,
		V_MAX_I32            = 18,
		V_MIN_U32            = 19,
		V_MAX_U32            = 20,
		V_LSHR_B32           = 21,
		V_LSHRREV_B32        = 22,
		V_ASHR_I32           = 23,
		V_ASHRREV_I32        = 24,
		V_LSHL_B32           = 25,
		V_LSHLREV_B32        = 26,
		V_AND_B32            = 27,
		V_OR_B32             = 28,
		V_XOR_B32            = 29,
		V_BFM_B32            = 30,
		V_MAC_F32            = 31,
		V_MADMK_F32          = 32,
		V_MADAK_F32          = 33,
		V_BCNT_U32_B32       = 34,
		V_MBCNT_LO_U32_B32   = 35,
		V_MBCNT_HI_U32_B32   = 36,
		V_ADD_I32            = 37,
		V_SUB_I32            = 38,
		V_SUBREV_I32         = 39,
		V_ADDC_U32           = 40,
		V_SUBB_U32           = 41,
		V_SUBBREV_U32        = 42,
		V_LDEXP_F32          = 43,
		V_CVT_PKACCUM_U8_F32 = 44,
		V_CVT_PKNORM_I16_F32 = 45,
		V_CVT_PKNORM_U16_F32 = 46,
		V_CVT_PKRTZ_F16_F32  = 47,
		V_CVT_PK_U16_U32     = 48,
		V_CVT_PK_I16_I32     = 49,

		OP_RANGE_VOP2 = V_CVT_PK_I16_I32 + 1,
	};

	enum class GcnOpcodeVOP3 : uint32_t
	{
		V_CMP_F_F32          = 0,
		V_CMP_LT_F32         = 1,
		V_CMP_EQ_F32         = 2,
		V_CMP_LE_F32         = 3,
		V_CMP_GT_F32         = 4,
		V_CMP_LG_F32         = 5,
		V_CMP_GE_F32         = 6,
		V_CMP_O_F32          = 7,
		V_CMP_U_F32          = 8,
		V_CMP_NGE_F32        = 9,
		V_CMP_NLG_F32        = 10,
		V_CMP_NGT_F32        = 11,
		V_CMP_NLE_F32        = 12,
		V_CMP_NEQ_F32        = 13,
		V_CMP_NLT_F32        = 14,
		V_CMP_TRU_F32        = 15,
		V_CMP_T_F32          = 15,
		V_CMPX_F_F32         = 16,
		V_CMPX_LT_F32        = 17,
		V_CMPX_EQ_F32        = 18,
		V_CMPX_LE_F32        = 19,
		V_CMPX_GT_F32        = 20,
		V_CMPX_LG_F32        = 21,
		V_CMPX_GE_F32        = 22,
		V_CMPX_O_F32         = 23,
		V_CMPX_U_F32         = 24,
		V_CMPX_NGE_F32       = 25,
		V_CMPX_NLG_F32       = 26,
		V_CMPX_NGT_F32       = 27,
		V_CMPX_NLE_F32       = 28,
		V_CMPX_NEQ_F32       = 29,
		V_CMPX_NLT_F32       = 30,
		V_CMPX_TRU_F32       = 31,
		V_CMPX_T_F32         = 31,
		V_CMP_F_F64          = 32,
		V_CMP_LT_F64         = 33,
		V_CMP_EQ_F64         = 34,
		V_CMP_LE_F64         = 35,
		V_CMP_GT_F64         = 36,
		V_CMP_LG_F64         = 37,
		V_CMP_GE_F64         = 38,
		V_CMP_O_F64          = 39,
		V_CMP_U_F64          = 40,
		V_CMP_NGE_F64        = 41,
		V_CMP_NLG_F64        = 42,
		V_CMP_NGT_F64        = 43,
		V_CMP_NLE_F64        = 44,
		V_CMP_NEQ_F64        = 45,
		V_CMP_NLT_F64        = 46,
		V_CMP_TRU_F64        = 47,
		V_CMP_T_F64          = 47,
		V_CMPX_F_F64         = 48,
		V_CMPX_LT_F64        = 49,
		V_CMPX_EQ_F64        = 50,
		V_CMPX_LE_F64        = 51,
		V_CMPX_GT_F64        = 52,
		V_CMPX_LG_F64        = 53,
		V_CMPX_GE_F64        = 54,
		V_CMPX_O_F64         = 55,
		V_CMPX_U_F64         = 56,
		V_CMPX_NGE_F64       = 57,
		V_CMPX_NLG_F64       = 58,
		V_CMPX_NGT_F64       = 59,
		V_CMPX_NLE_F64       = 60,
		V_CMPX_NEQ_F64       = 61,
		V_CMPX_NLT_F64       = 62,
		V_CMPX_TRU_F64       = 63,
		V_CMPX_T_F64         = 63,
		V_CMPS_F_F32         = 64,
		V_CMPS_LT_F32        = 65,
		V_CMPS_EQ_F32        = 66,
		V_CMPS_LE_F32        = 67,
		V_CMPS_GT_F32        = 68,
		V_CMPS_LG_F32        = 69,
		V_CMPS_GE_F32        = 70,
		V_CMPS_O_F32         = 71,
		V_CMPS_U_F32         = 72,
		V_CMPS_NGE_F32       = 73,
		V_CMPS_NLG_F32       = 74,
		V_CMPS_NGT_F32       = 75,
		V_CMPS_NLE_F32       = 76,
		V_CMPS_NEQ_F32       = 77,
		V_CMPS_NLT_F32       = 78,
		V_CMPS_TRU_F32       = 79,
		V_CMPS_T_F32         = 79,
		V_CMPSX_F_F32        = 80,
		V_CMPSX_LT_F32       = 81,
		V_CMPSX_EQ_F32       = 82,
		V_CMPSX_LE_F32       = 83,
		V_CMPSX_GT_F32       = 84,
		V_CMPSX_LG_F32       = 85,
		V_CMPSX_GE_F32       = 86,
		V_CMPSX_O_F32        = 87,
		V_CMPSX_U_F32        = 88,
		V_CMPSX_NGE_F32      = 89,
		V_CMPSX_NLG_F32      = 90,
		V_CMPSX_NGT_F32      = 91,
		V_CMPSX_NLE_F32      = 92,
		V_CMPSX_NEQ_F32      = 93,
		V_CMPSX_NLT_F32      = 94,
		V_CMPSX_TRU_F32      = 95,
		V_CMPSX_T_F32        = 95,
		V_CMPS_F_F64         = 96,
		V_CMPS_LT_F64        = 97,
		V_CMPS_EQ_F64        = 98,
		V_CMPS_LE_F64        = 99,
		V_CMPS_GT_F64        = 100,
		V_CMPS_LG_F64        = 101,
		V_CMPS_GE_F64        = 102,
		V_CMPS_O_F64         = 103,
		V_CMPS_U_F64         = 104,
		V_CMPS_NGE_F64       = 105,
		V_CMPS_NLG_F64       = 106,
		V_CMPS_NGT_F64       = 107,
		V_CMPS_NLE_F64       = 108,
		V_CMPS_NEQ_F64       = 109,
		V_CMPS_NLT_F64       = 110,
		V_CMPS_TRU_F64       = 111,
		V_CMPS_T_F64         = 111,
		V_CMPSX_F_F64        = 112,
		V_CMPSX_LT_F64       = 113,
		V_CMPSX_EQ_F64       = 114,
		V_CMPSX_LE_F64       = 115,
		V_CMPSX_GT_F64       = 116,
		V_CMPSX_LG_F64       = 117,
		V_CMPSX_GE_F64       = 118,
		V_CMPSX_O_F64        = 119,
		V_CMPSX_U_F64        = 120,
		V_CMPSX_NGE_F64      = 121,
		V_CMPSX_NLG_F64      = 122,
		V_CMPSX_NGT_F64      = 123,
		V_CMPSX_NLE_F64      = 124,
		V_CMPSX_NEQ_F64      = 125,
		V_CMPSX_NLT_F64      = 126,
		V_CMPSX_TRU_F64      = 127,
		V_CMPSX_T_F64        = 127,
		V_CMP_F_I32          = 128,
		V_CMP_LT_I32         = 129,
		V_CMP_EQ_I32         = 130,
		V_CMP_LE_I32         = 131,
		V_CMP_GT_I32         = 132,
		V_CMP_LG_I32         = 133,
		V_CMP_NE_I32         = 133,
		V_CMP_GE_I32         = 134,
		V_CMP_TRU_I32        = 135,
		V_CMP_T_I32          = 135,
		V_CMP_CLASS_F32      = 136,
		V_CMPX_F_I32         = 144,
		V_CMPX_LT_I32        = 145,
		V_CMPX_EQ_I32        = 146,
		V_CMPX_LE_I32        = 147,
		V_CMPX_GT_I32        = 148,
		V_CMPX_LG_I32        = 149,
		V_CMPX_NE_I32        = 149,
		V_CMPX_GE_I32        = 150,
		V_CMPX_TRU_I32       = 151,
		V_CMPX_T_I32         = 151,
		V_CMPX_CLASS_F32     = 152,
		V_CMP_F_I64          = 160,
		V_CMP_LT_I64         = 161,
		V_CMP_EQ_I64         = 162,
		V_CMP_LE_I64         = 163,
		V_CMP_GT_I64         = 164,
		V_CMP_LG_I64         = 165,
		V_CMP_NE_I64         = 165,
		V_CMP_GE_I64         = 166,
		V_CMP_TRU_I64        = 167,
		V_CMP_T_I64          = 167,
		V_CMP_CLASS_F64      = 168,
		V_CMPX_F_I64         = 176,
		V_CMPX_LT_I64        = 177,
		V_CMPX_EQ_I64        = 178,
		V_CMPX_LE_I64        = 179,
		V_CMPX_GT_I64        = 180,
		V_CMPX_LG_I64        = 181,
		V_CMPX_NE_I64        = 181,
		V_CMPX_GE_I64        = 182,
		V_CMPX_TRU_I64       = 183,
		V_CMPX_T_I64         = 183,
		V_CMPX_CLASS_F64     = 184,
		V_CMP_F_U32          = 192,
		V_CMP_LT_U32         = 193,
		V_CMP_EQ_U32         = 194,
		V_CMP_LE_U32         = 195,
		V_CMP_GT_U32         = 196,
		V_CMP_LG_U32         = 197,
		V_CMP_NE_U32         = 197,
		V_CMP_GE_U32         = 198,
		V_CMP_TRU_U32        = 199,
		V_CMP_T_U32          = 199,
		V_CMPX_F_U32         = 208,
		V_CMPX_LT_U32        = 209,
		V_CMPX_EQ_U32        = 210,
		V_CMPX_LE_U32        = 211,
		V_CMPX_GT_U32        = 212,
		V_CMPX_LG_U32        = 213,
		V_CMPX_NE_U32        = 213,
		V_CMPX_GE_U32        = 214,
		V_CMPX_TRU_U32       = 215,
		V_CMPX_T_U32         = 215,
		V_CMP_F_U64          = 224,
		V_CMP_LT_U64         = 225,
		V_CMP_EQ_U64         = 226,
		V_CMP_LE_U64         = 227,
		V_CMP_GT_U64         = 228,
		V_CMP_LG_U64         = 229,
		V_CMP_NE_U64         = 229,
		V_CMP_GE_U64         = 230,
		V_CMP_TRU_U64        = 231,
		V_CMP_T_U64          = 231,
		V_CMPX_F_U64         = 240,
		V_CMPX_LT_U64        = 241,
		V_CMPX_EQ_U64        = 242,
		V_CMPX_LE_U64        = 243,
		V_CMPX_GT_U64        = 244,
		V_CMPX_LG_U64        = 245,
		V_CMPX_NE_U64        = 245,
		V_CMPX_GE_U64        = 246,
		V_CMPX_TRU_U64       = 247,
		V_CMPX_T_U64         = 247,
		V_CNDMASK_B32        = 256,
		V_READLANE_B32       = 257,
		V_WRITELANE_B32      = 258,
		V_ADD_F32            = 259,
		V_SUB_F32            = 260,
		V_SUBREV_F32         = 261,
		V_MAC_LEGACY_F32     = 262,
		V_MUL_LEGACY_F32     = 263,
		V_MUL_F32            = 264,
		V_MUL_I32_I24        = 265,
		V_MUL_HI_I32_I24     = 266,
		V_MUL_U32_U24        = 267,
		V_MUL_HI_U32_U24     = 268,
		V_MIN_LEGACY_F32     = 269,
		V_MAX_LEGACY_F32     = 270,
		V_MIN_F32            = 271,
		V_MAX_F32            = 272,
		V_MIN_I32            = 273,
		V_MAX_I32            = 274,
		V_MIN_U32            = 275,
		V_MAX_U32            = 276,
		V_LSHR_B32           = 277,
		V_LSHRREV_B32        = 278,
		V_ASHR_I32           = 279,
		V_ASHRREV_I32        = 280,
		V_LSHL_B32           = 281,
		V_LSHLREV_B32        = 282,
		V_AND_B32            = 283,
		V_OR_B32             = 284,
		V_XOR_B32            = 285,
		V_BFM_B32            = 286,
		V_MAC_F32            = 287,
		V_MADMK_F32          = 288,
		V_MADAK_F32          = 289,
		V_BCNT_U32_B32       = 290,
		V_MBCNT_LO_U32_B32   = 291,
		V_MBCNT_HI_U32_B32   = 292,
		V_ADD_I32            = 293,
		V_SUB_I32            = 294,
		V_SUBREV_I32         = 295,
		V_ADDC_U32           = 296,
		V_SUBB_U32           = 297,
		V_SUBBREV_U32        = 298,
		V_LDEXP_F32          = 299,
		V_CVT_PKACCUM_U8_F32 = 300,
		V_CVT_PKNORM_I16_F32 = 301,
		V_CVT_PKNORM_U16_F32 = 302,
		V_CVT_PKRTZ_F16_F32  = 303,
		V_CVT_PK_U16_U32     = 304,
		V_CVT_PK_I16_I32     = 305,
		V_MAD_LEGACY_F32     = 320,
		V_MAD_F32            = 321,
		V_MAD_I32_I24        = 322,
		V_MAD_U32_U24        = 323,
		V_CUBEID_F32         = 324,
		V_CUBESC_F32         = 325,
		V_CUBETC_F32         = 326,
		V_CUBEMA_F32         = 327,
		V_BFE_U32            = 328,
		V_BFE_I32            = 329,
		V_BFI_B32            = 330,
		V_FMA_F32            = 331,
		V_FMA_F64            = 332,
		V_LERP_U8            = 333,
		V_ALIGNBIT_B32       = 334,
		V_ALIGNBYTE_B32      = 335,
		V_MULLIT_F32         = 336,
		V_MIN3_F32           = 337,
		V_MIN3_I32           = 338,
		V_MIN3_U32           = 339,
		V_MAX3_F32           = 340,
		V_MAX3_I32           = 341,
		V_MAX3_U32           = 342,
		V_MED3_F32           = 343,
		V_MED3_I32           = 344,
		V_MED3_U32           = 345,
		V_SAD_U8             = 346,
		V_SAD_HI_U8          = 347,
		V_SAD_U16            = 348,
		V_SAD_U32            = 349,
		V_CVT_PK_U8_F32      = 350,
		V_DIV_FIXUP_F32      = 351,
		V_DIV_FIXUP_F64      = 352,
		V_LSHL_B64           = 353,
		V_LSHR_B64           = 354,
		V_ASHR_I64           = 355,
		V_ADD_F64            = 356,
		V_MUL_F64            = 357,
		V_MIN_F64            = 358,
		V_MAX_F64            = 359,
		V_LDEXP_F64          = 360,
		V_MUL_LO_U32         = 361,
		V_MUL_HI_U32         = 362,
		V_MUL_LO_I32         = 363,
		V_MUL_HI_I32         = 364,
		V_DIV_SCALE_F32      = 365,
		V_DIV_SCALE_F64      = 366,
		V_DIV_FMAS_F32       = 367,
		V_DIV_FMAS_F64       = 368,
		V_MSAD_U8            = 369,
		V_QSAD_U8            = 370,
		V_QSAD_PK_U16_U8     = 370,
		V_MQSAD_U8           = 371,
		V_MQSAD_PK_U16_U8    = 371,
		V_TRIG_PREOP_F64     = 372,
		V_MQSAD_U32_U8       = 373,
		V_MAD_U64_U32        = 374,
		V_MAD_I64_I32        = 375,
		V_NOP                = 384,
		V_MOV_B32            = 385,
		V_READFIRSTLANE_B32  = 386,
		V_CVT_I32_F64        = 387,
		V_CVT_F64_I32        = 388,
		V_CVT_F32_I32        = 389,
		V_CVT_F32_U32        = 390,
		V_CVT_U32_F32        = 391,
		V_CVT_I32_F32        = 392,
		V_MOV_FED_B32        = 393,
		V_CVT_F16_F32        = 394,
		V_CVT_F32_F16        = 395,
		V_CVT_RPI_I32_F32    = 396,
		V_CVT_FLR_I32_F32    = 397,
		V_CVT_OFF_F32_I4     = 398,
		V_CVT_F32_F64        = 399,
		V_CVT_F64_F32        = 400,
		V_CVT_F32_UBYTE0     = 401,
		V_CVT_F32_UBYTE1     = 402,
		V_CVT_F32_UBYTE2     = 403,
		V_CVT_F32_UBYTE3     = 404,
		V_CVT_U32_F64        = 405,
		V_CVT_F64_U32        = 406,
		V_TRUNC_F64          = 407,
		V_CEIL_F64           = 408,
		V_RNDNE_F64          = 409,
		V_FLOOR_F64          = 410,
		V_FRACT_F32          = 416,
		V_TRUNC_F32          = 417,
		V_CEIL_F32           = 418,
		V_RNDNE_F32          = 419,
		V_FLOOR_F32          = 420,
		V_EXP_F32            = 421,
		V_LOG_CLAMP_F32      = 422,
		V_LOG_F32            = 423,
		V_RCP_CLAMP_F32      = 424,
		V_RCP_LEGACY_F32     = 425,
		V_RCP_F32            = 426,
		V_RCP_IFLAG_F32      = 427,
		V_RSQ_CLAMP_F32      = 428,
		V_RSQ_LEGACY_F32     = 429,
		V_RSQ_F32            = 430,
		V_RCP_F64            = 431,
		V_RCP_CLAMP_F64      = 432,
		V_RSQ_F64            = 433,
		V_RSQ_CLAMP_F64      = 434,
		V_SQRT_F32           = 435,
		V_SQRT_F64           = 436,
		V_SIN_F32            = 437,
		V_COS_F32            = 438,
		V_NOT_B32            = 439,
		V_BFREV_B32          = 440,
		V_FFBH_U32           = 441,
		V_FFBL_B32           = 442,
		V_FFBH_I32           = 443,
		V_FREXP_EXP_I32_F64  = 444,
		V_FREXP_MANT_F64     = 445,
		V_FRACT_F64          = 446,
		V_FREXP_EXP_I32_F32  = 447,
		V_FREXP_MANT_F32     = 448,
		V_CLREXCP            = 449,
		V_MOVRELD_B32        = 450,
		V_MOVRELS_B32        = 451,
		V_MOVRELSD_B32       = 452,
		V_LOG_LEGACY_F32     = 453,
		V_EXP_LEGACY_F32     = 454,

		OP_RANGE_VOP3 = V_EXP_LEGACY_F32 + 1,
	};

	enum class GcnOpcodeVOP1 : uint32_t
	{
		V_NOP               = 0,
		V_MOV_B32           = 1,
		V_READFIRSTLANE_B32 = 2,
		V_CVT_I32_F64       = 3,
		V_CVT_F64_I32       = 4,
		V_CVT_F32_I32       = 5,
		V_CVT_F32_U32       = 6,
		V_CVT_U32_F32       = 7,
		V_CVT_I32_F32       = 8,
		V_MOV_FED_B32       = 9,
		V_CVT_F16_F32       = 10,
		V_CVT_F32_F16       = 11,
		V_CVT_RPI_I32_F32   = 12,
		V_CVT_FLR_I32_F32   = 13,
		V_CVT_OFF_F32_I4    = 14,
		V_CVT_F32_F64       = 15,
		V_CVT_F64_F32       = 16,
		V_CVT_F32_UBYTE0    = 17,
		V_CVT_F32_UBYTE1    = 18,
		V_CVT_F32_UBYTE2    = 19,
		V_CVT_F32_UBYTE3    = 20,
		V_CVT_U32_F64       = 21,
		V_CVT_F64_U32       = 22,
		V_TRUNC_F64         = 23,
		V_CEIL_F64          = 24,
		V_RNDNE_F64         = 25,
		V_FLOOR_F64         = 26,
		V_FRACT_F32         = 32,
		V_TRUNC_F32         = 33,
		V_CEIL_F32          = 34,
		V_RNDNE_F32         = 35,
		V_FLOOR_F32         = 36,
		V_EXP_F32           = 37,
		V_LOG_CLAMP_F32     = 38,
		V_LOG_F32           = 39,
		V_RCP_CLAMP_F32     = 40,
		V_RCP_LEGACY_F32    = 41,
		V_RCP_F32           = 42,
		V_RCP_IFLAG_F32     = 43,
		V_RSQ_CLAMP_F32     = 44,
		V_RSQ_LEGACY_F32    = 45,
		V_RSQ_F32           = 46,
		V_RCP_F64           = 47,
		V_RCP_CLAMP_F64     = 48,
		V_RSQ_F64           = 49,
		V_RSQ_CLAMP_F64     = 50,
		V_SQRT_F32          = 51,
		V_SQRT_F64          = 52,
		V_SIN_F32           = 53,
		V_COS_F32           = 54,
		V_NOT_B32           = 55,
		V_BFREV_B32         = 56,
		V_FFBH_U32          = 57,
		V_FFBL_B32          = 58,
		V_FFBH_I32          = 59,
		V_FREXP_EXP_I32_F64 = 60,
		V_FREXP_MANT_F64    = 61,
		V_FRACT_F64         = 62,
		V_FREXP_EXP_I32_F32 = 63,
		V_FREXP_MANT_F32    = 64,
		V_CLREXCP           = 65,
		V_MOVRELD_B32       = 66,
		V_MOVRELS_B32       = 67,
		V_MOVRELSD_B32      = 68,
		V_LOG_LEGACY_F32    = 69,
		V_EXP_LEGACY_F32    = 70,

		OP_RANGE_VOP1 = V_EXP_LEGACY_F32 + 1,
	};

	enum class GcnOpcodeVOPC : uint32_t
	{
		V_CMP_F_F32      = 0,
		V_CMP_LT_F32     = 1,
		V_CMP_EQ_F32     = 2,
		V_CMP_LE_F32     = 3,
		V_CMP_GT_F32     = 4,
		V_CMP_LG_F32     = 5,
		V_CMP_GE_F32     = 6,
		V_CMP_O_F32      = 7,
		V_CMP_U_F32      = 8,
		V_CMP_NGE_F32    = 9,
		V_CMP_NLG_F32    = 10,
		V_CMP_NGT_F32    = 11,
		V_CMP_NLE_F32    = 12,
		V_CMP_NEQ_F32    = 13,
		V_CMP_NLT_F32    = 14,
		V_CMP_TRU_F32    = 15,
		V_CMP_T_F32      = 15,
		V_CMPX_F_F32     = 16,
		V_CMPX_LT_F32    = 17,
		V_CMPX_EQ_F32    = 18,
		V_CMPX_LE_F32    = 19,
		V_CMPX_GT_F32    = 20,
		V_CMPX_LG_F32    = 21,
		V_CMPX_GE_F32    = 22,
		V_CMPX_O_F32     = 23,
		V_CMPX_U_F32     = 24,
		V_CMPX_NGE_F32   = 25,
		V_CMPX_NLG_F32   = 26,
		V_CMPX_NGT_F32   = 27,
		V_CMPX_NLE_F32   = 28,
		V_CMPX_NEQ_F32   = 29,
		V_CMPX_NLT_F32   = 30,
		V_CMPX_TRU_F32   = 31,
		V_CMPX_T_F32     = 31,
		V_CMP_F_F64      = 32,
		V_CMP_LT_F64     = 33,
		V_CMP_EQ_F64     = 34,
		V_CMP_LE_F64     = 35,
		V_CMP_GT_F64     = 36,
		V_CMP_LG_F64     = 37,
		V_CMP_GE_F64     = 38,
		V_CMP_O_F64      = 39,
		V_CMP_U_F64      = 40,
		V_CMP_NGE_F64    = 41,
		V_CMP_NLG_F64    = 42,
		V_CMP_NGT_F64    = 43,
		V_CMP_NLE_F64    = 44,
		V_CMP_NEQ_F64    = 45,
		V_CMP_NLT_F64    = 46,
		V_CMP_TRU_F64    = 47,
		V_CMP_T_F64      = 47,
		V_CMPX_F_F64     = 48,
		V_CMPX_LT_F64    = 49,
		V_CMPX_EQ_F64    = 50,
		V_CMPX_LE_F64    = 51,
		V_CMPX_GT_F64    = 52,
		V_CMPX_LG_F64    = 53,
		V_CMPX_GE_F64    = 54,
		V_CMPX_O_F64     = 55,
		V_CMPX_U_F64     = 56,
		V_CMPX_NGE_F64   = 57,
		V_CMPX_NLG_F64   = 58,
		V_CMPX_NGT_F64   = 59,
		V_CMPX_NLE_F64   = 60,
		V_CMPX_NEQ_F64   = 61,
		V_CMPX_NLT_F64   = 62,
		V_CMPX_TRU_F64   = 63,
		V_CMPX_T_F64     = 63,
		V_CMPS_F_F32     = 64,
		V_CMPS_LT_F32    = 65,
		V_CMPS_EQ_F32    = 66,
		V_CMPS_LE_F32    = 67,
		V_CMPS_GT_F32    = 68,
		V_CMPS_LG_F32    = 69,
		V_CMPS_GE_F32    = 70,
		V_CMPS_O_F32     = 71,
		V_CMPS_U_F32     = 72,
		V_CMPS_NGE_F32   = 73,
		V_CMPS_NLG_F32   = 74,
		V_CMPS_NGT_F32   = 75,
		V_CMPS_NLE_F32   = 76,
		V_CMPS_NEQ_F32   = 77,
		V_CMPS_NLT_F32   = 78,
		V_CMPS_TRU_F32   = 79,
		V_CMPS_T_F32     = 79,
		V_CMPSX_F_F32    = 80,
		V_CMPSX_LT_F32   = 81,
		V_CMPSX_EQ_F32   = 82,
		V_CMPSX_LE_F32   = 83,
		V_CMPSX_GT_F32   = 84,
		V_CMPSX_LG_F32   = 85,
		V_CMPSX_GE_F32   = 86,
		V_CMPSX_O_F32    = 87,
		V_CMPSX_U_F32    = 88,
		V_CMPSX_NGE_F32  = 89,
		V_CMPSX_NLG_F32  = 90,
		V_CMPSX_NGT_F32  = 91,
		V_CMPSX_NLE_F32  = 92,
		V_CMPSX_NEQ_F32  = 93,
		V_CMPSX_NLT_F32  = 94,
		V_CMPSX_TRU_F32  = 95,
		V_CMPSX_T_F32    = 95,
		V_CMPS_F_F64     = 96,
		V_CMPS_LT_F64    = 97,
		V_CMPS_EQ_F64    = 98,
		V_CMPS_LE_F64    = 99,
		V_CMPS_GT_F64    = 100,
		V_CMPS_LG_F64    = 101,
		V_CMPS_GE_F64    = 102,
		V_CMPS_O_F64     = 103,
		V_CMPS_U_F64     = 104,
		V_CMPS_NGE_F64   = 105,
		V_CMPS_NLG_F64   = 106,
		V_CMPS_NGT_F64   = 107,
		V_CMPS_NLE_F64   = 108,
		V_CMPS_NEQ_F64   = 109,
		V_CMPS_NLT_F64   = 110,
		V_CMPS_TRU_F64   = 111,
		V_CMPS_T_F64     = 111,
		V_CMPSX_F_F64    = 112,
		V_CMPSX_LT_F64   = 113,
		V_CMPSX_EQ_F64   = 114,
		V_CMPSX_LE_F64   = 115,
		V_CMPSX_GT_F64   = 116,
		V_CMPSX_LG_F64   = 117,
		V_CMPSX_GE_F64   = 118,
		V_CMPSX_O_F64    = 119,
		V_CMPSX_U_F64    = 120,
		V_CMPSX_NGE_F64  = 121,
		V_CMPSX_NLG_F64  = 122,
		V_CMPSX_NGT_F64  = 123,
		V_CMPSX_NLE_F64  = 124,
		V_CMPSX_NEQ_F64  = 125,
		V_CMPSX_NLT_F64  = 126,
		V_CMPSX_TRU_F64  = 127,
		V_CMPSX_T_F64    = 127,
		V_CMP_F_I32      = 128,
		V_CMP_LT_I32     = 129,
		V_CMP_EQ_I32     = 130,
		V_CMP_LE_I32     = 131,
		V_CMP_GT_I32     = 132,
		V_CMP_LG_I32     = 133,
		V_CMP_NE_I32     = 133,
		V_CMP_GE_I32     = 134,
		V_CMP_TRU_I32    = 135,
		V_CMP_T_I32      = 135,
		V_CMP_CLASS_F32  = 136,
		V_CMPX_F_I32     = 144,
		V_CMPX_LT_I32    = 145,
		V_CMPX_EQ_I32    = 146,
		V_CMPX_LE_I32    = 147,
		V_CMPX_GT_I32    = 148,
		V_CMPX_LG_I32    = 149,
		V_CMPX_NE_I32    = 149,
		V_CMPX_GE_I32    = 150,
		V_CMPX_TRU_I32   = 151,
		V_CMPX_T_I32     = 151,
		V_CMPX_CLASS_F32 = 152,
		V_CMP_F_I64      = 160,
		V_CMP_LT_I64     = 161,
		V_CMP_EQ_I64     = 162,
		V_CMP_LE_I64     = 163,
		V_CMP_GT_I64     = 164,
		V_CMP_LG_I64     = 165,
		V_CMP_NE_I64     = 165,
		V_CMP_GE_I64     = 166,
		V_CMP_TRU_I64    = 167,
		V_CMP_T_I64      = 167,
		V_CMP_CLASS_F64  = 168,
		V_CMPX_F_I64     = 176,
		V_CMPX_LT_I64    = 177,
		V_CMPX_EQ_I64    = 178,
		V_CMPX_LE_I64    = 179,
		V_CMPX_GT_I64    = 180,
		V_CMPX_LG_I64    = 181,
		V_CMPX_NE_I64    = 181,
		V_CMPX_GE_I64    = 182,
		V_CMPX_TRU_I64   = 183,
		V_CMPX_T_I64     = 183,
		V_CMPX_CLASS_F64 = 184,
		V_CMP_F_U32      = 192,
		V_CMP_LT_U32     = 193,
		V_CMP_EQ_U32     = 194,
		V_CMP_LE_U32     = 195,
		V_CMP_GT_U32     = 196,
		V_CMP_LG_U32     = 197,
		V_CMP_NE_U32     = 197,
		V_CMP_GE_U32     = 198,
		V_CMP_TRU_U32    = 199,
		V_CMP_T_U32      = 199,
		V_CMPX_F_U32     = 208,
		V_CMPX_LT_U32    = 209,
		V_CMPX_EQ_U32    = 210,
		V_CMPX_LE_U32    = 211,
		V_CMPX_GT_U32    = 212,
		V_CMPX_LG_U32    = 213,
		V_CMPX_NE_U32    = 213,
		V_CMPX_GE_U32    = 214,
		V_CMPX_TRU_U32   = 215,
		V_CMPX_T_U32     = 215,
		V_CMP_F_U64      = 224,
		V_CMP_LT_U64     = 225,
		V_CMP_EQ_U64     = 226,
		V_CMP_LE_U64     = 227,
		V_CMP_GT_U64     = 228,
		V_CMP_LG_U64     = 229,
		V_CMP_NE_U64     = 229,
		V_CMP_GE_U64     = 230,
		V_CMP_TRU_U64    = 231,
		V_CMP_T_U64      = 231,
		V_CMPX_F_U64     = 240,
		V_CMPX_LT_U64    = 241,
		V_CMPX_EQ_U64    = 242,
		V_CMPX_LE_U64    = 243,
		V_CMPX_GT_U64    = 244,
		V_CMPX_LG_U64    = 245,
		V_CMPX_NE_U64    = 245,
		V_CMPX_GE_U64    = 246,
		V_CMPX_TRU_U64   = 247,
		V_CMPX_T_U64     = 247,

		OP_RANGE_VOPC = V_CMPX_T_U64 + 1,
	};

	enum class GcnOpcodeVINTRP : uint32_t
	{
		V_INTERP_P1_F32  = 0,
		V_INTERP_P2_F32  = 1,
		V_INTERP_MOV_F32 = 2,

		OP_RANGE_VINTRP = V_INTERP_MOV_F32 + 1,
	};

	enum class GcnOpcodeDS : uint32_t
	{
		DS_ADD_U32              = 0,
		DS_SUB_U32              = 1,
		DS_RSUB_U32             = 2,
		DS_INC_U32              = 3,
		DS_DEC_U32              = 4,
		DS_MIN_I32              = 5,
		DS_MAX_I32              = 6,
		DS_MIN_U32              = 7,
		DS_MAX_U32              = 8,
		DS_AND_B32              = 9,
		DS_OR_B32               = 10,
		DS_XOR_B32              = 11,
		DS_MSKOR_B32            = 12,
		DS_WRITE_B32            = 13,
		DS_WRITE2_B32           = 14,
		DS_WRITE2ST64_B32       = 15,
		DS_CMPST_B32            = 16,
		DS_CMPST_F32            = 17,
		DS_MIN_F32              = 18,
		DS_MAX_F32              = 19,
		DS_NOP                  = 20,
		DS_GWS_SEMA_RELEASE_ALL = 24,
		DS_GWS_INIT             = 25,
		DS_GWS_SEMA_V           = 26,
		DS_GWS_SEMA_BR          = 27,
		DS_GWS_SEMA_P           = 28,
		DS_GWS_BARRIER          = 29,
		DS_WRITE_B8             = 30,
		DS_WRITE_B16            = 31,
		DS_ADD_RTN_U32          = 32,
		DS_SUB_RTN_U32          = 33,
		DS_RSUB_RTN_U32         = 34,
		DS_INC_RTN_U32          = 35,
		DS_DEC_RTN_U32          = 36,
		DS_MIN_RTN_I32          = 37,
		DS_MAX_RTN_I32          = 38,
		DS_MIN_RTN_U32          = 39,
		DS_MAX_RTN_U32          = 40,
		DS_AND_RTN_B32          = 41,
		DS_OR_RTN_B32           = 42,
		DS_XOR_RTN_B32          = 43,
		DS_MSKOR_RTN_B32        = 44,
		DS_WRXCHG_RTN_B32       = 45,
		DS_WRXCHG2_RTN_B32      = 46,
		DS_WRXCHG2ST64_RTN_B32  = 47,
		DS_CMPST_RTN_B32        = 48,
		DS_CMPST_RTN_F32        = 49,
		DS_MIN_RTN_F32          = 50,
		DS_MAX_RTN_F32          = 51,
		DS_WRAP_RTN_B32         = 52,
		DS_SWIZZLE_B32          = 53,
		DS_READ_B32             = 54,
		DS_READ2_B32            = 55,
		DS_READ2ST64_B32        = 56,
		DS_READ_I8              = 57,
		DS_READ_U8              = 58,
		DS_READ_I16             = 59,
		DS_READ_U16             = 60,
		DS_CONSUME              = 61,
		DS_APPEND               = 62,
		DS_ORDERED_COUNT        = 63,
		DS_ADD_U64              = 64,
		DS_SUB_U64              = 65,
		DS_RSUB_U64             = 66,
		DS_INC_U64              = 67,
		DS_DEC_U64              = 68,
		DS_MIN_I64              = 69,
		DS_MAX_I64              = 70,
		DS_MIN_U64              = 71,
		DS_MAX_U64              = 72,
		DS_AND_B64              = 73,
		DS_OR_B64               = 74,
		DS_XOR_B64              = 75,
		DS_MSKOR_B64            = 76,
		DS_WRITE_B64            = 77,
		DS_WRITE2_B64           = 78,
		DS_WRITE2ST64_B64       = 79,
		DS_CMPST_B64            = 80,
		DS_CMPST_F64            = 81,
		DS_MIN_F64              = 82,
		DS_MAX_F64              = 83,
		DS_ADD_RTN_U64          = 96,
		DS_SUB_RTN_U64          = 97,
		DS_RSUB_RTN_U64         = 98,
		DS_INC_RTN_U64          = 99,
		DS_DEC_RTN_U64          = 100,
		DS_MIN_RTN_I64          = 101,
		DS_MAX_RTN_I64          = 102,
		DS_MIN_RTN_U64          = 103,
		DS_MAX_RTN_U64          = 104,
		DS_AND_RTN_B64          = 105,
		DS_OR_RTN_B64           = 106,
		DS_XOR_RTN_B64          = 107,
		DS_MSKOR_RTN_B64        = 108,
		DS_WRXCHG_RTN_B64       = 109,
		DS_WRXCHG2_RTN_B64      = 110,
		DS_WRXCHG2ST64_RTN_B64  = 111,
		DS_CMPST_RTN_B64        = 112,
		DS_CMPST_RTN_F64        = 113,
		DS_MIN_RTN_F64          = 114,
		DS_MAX_RTN_F64          = 115,
		DS_READ_B64             = 118,
		DS_READ2_B64            = 119,
		DS_READ2ST64_B64        = 120,
		DS_CONDXCHG32_RTN_B64   = 126,
		DS_ADD_SRC2_U32         = 128,
		DS_SUB_SRC2_U32         = 129,
		DS_RSUB_SRC2_U32        = 130,
		DS_INC_SRC2_U32         = 131,
		DS_DEC_SRC2_U32         = 132,
		DS_MIN_SRC2_I32         = 133,
		DS_MAX_SRC2_I32         = 134,
		DS_MIN_SRC2_U32         = 135,
		DS_MAX_SRC2_U32         = 136,
		DS_AND_SRC2_B32         = 137,
		DS_OR_SRC2_B32          = 138,
		DS_XOR_SRC2_B32         = 139,
		DS_WRITE_SRC2_B32       = 141,
		DS_MIN_SRC2_F32         = 146,
		DS_MAX_SRC2_F32         = 147,
		DS_ADD_SRC2_U64         = 192,
		DS_SUB_SRC2_U64         = 193,
		DS_RSUB_SRC2_U64        = 194,
		DS_INC_SRC2_U64         = 195,
		DS_DEC_SRC2_U64         = 196,
		DS_MIN_SRC2_I64         = 197,
		DS_MAX_SRC2_I64         = 198,
		DS_MIN_SRC2_U64         = 199,
		DS_MAX_SRC2_U64         = 200,
		DS_AND_SRC2_B64         = 201,
		DS_OR_SRC2_B64          = 202,
		DS_XOR_SRC2_B64         = 203,
		DS_WRITE_SRC2_B64       = 205,
		DS_MIN_SRC2_F64         = 210,
		DS_MAX_SRC2_F64         = 211,
		DS_WRITE_B96            = 222,
		DS_WRITE_B128           = 223,
		DS_CONDXCHG32_RTN_B128  = 253,
		DS_READ_B96             = 254,
		DS_READ_B128            = 255,

		OP_RANGE_DS = DS_READ_B128 + 1,
	};

	enum class GcnOpcodeMUBUF : uint32_t
	{
		BUFFER_LOAD_FORMAT_X      = 0,
		BUFFER_LOAD_FORMAT_XY     = 1,
		BUFFER_LOAD_FORMAT_XYZ    = 2,
		BUFFER_LOAD_FORMAT_XYZW   = 3,
		BUFFER_STORE_FORMAT_X     = 4,
		BUFFER_STORE_FORMAT_XY    = 5,
		BUFFER_STORE_FORMAT_XYZ   = 6,
		BUFFER_STORE_FORMAT_XYZW  = 7,
		BUFFER_LOAD_UBYTE         = 8,
		BUFFER_LOAD_SBYTE         = 9,
		BUFFER_LOAD_USHORT        = 10,
		BUFFER_LOAD_SSHORT        = 11,
		BUFFER_LOAD_DWORD         = 12,
		BUFFER_LOAD_DWORDX2       = 13,
		BUFFER_LOAD_DWORDX4       = 14,
		BUFFER_LOAD_DWORDX3       = 15,
		BUFFER_STORE_BYTE         = 24,
		BUFFER_STORE_SHORT        = 26,
		BUFFER_STORE_DWORD        = 28,
		BUFFER_STORE_DWORDX2      = 29,
		BUFFER_STORE_DWORDX4      = 30,
		BUFFER_STORE_DWORDX3      = 31,
		BUFFER_ATOMIC_SWAP        = 48,
		BUFFER_ATOMIC_CMPSWAP     = 49,
		BUFFER_ATOMIC_ADD         = 50,
		BUFFER_ATOMIC_SUB         = 51,
		BUFFER_ATOMIC_SMIN        = 53,
		BUFFER_ATOMIC_UMIN        = 54,
		BUFFER_ATOMIC_SMAX        = 55,
		BUFFER_ATOMIC_UMAX        = 56,
		BUFFER_ATOMIC_AND         = 57,
		BUFFER_ATOMIC_OR          = 58,
		BUFFER_ATOMIC_XOR         = 59,
		BUFFER_ATOMIC_INC         = 60,
		BUFFER_ATOMIC_DEC         = 61,
		BUFFER_ATOMIC_FCMPSWAP    = 62,
		BUFFER_ATOMIC_FMIN        = 63,
		BUFFER_ATOMIC_FMAX        = 64,
		BUFFER_ATOMIC_SWAP_X2     = 80,
		BUFFER_ATOMIC_CMPSWAP_X2  = 81,
		BUFFER_ATOMIC_ADD_X2      = 82,
		BUFFER_ATOMIC_SUB_X2      = 83,
		BUFFER_ATOMIC_SMIN_X2     = 85,
		BUFFER_ATOMIC_UMIN_X2     = 86,
		BUFFER_ATOMIC_SMAX_X2     = 87,
		BUFFER_ATOMIC_UMAX_X2     = 88,
		BUFFER_ATOMIC_AND_X2      = 89,
		BUFFER_ATOMIC_OR_X2       = 90,
		BUFFER_ATOMIC_XOR_X2      = 91,
		BUFFER_ATOMIC_INC_X2      = 92,
		BUFFER_ATOMIC_DEC_X2      = 93,
		BUFFER_ATOMIC_FCMPSWAP_X2 = 94,
		BUFFER_ATOMIC_FMIN_X2     = 95,
		BUFFER_ATOMIC_FMAX_X2     = 96,
		BUFFER_WBINVL1_SC         = 112,
		BUFFER_WBINVL1            = 113,

		OP_RANGE_MUBUF = BUFFER_WBINVL1 + 1,
	};

	enum class GcnOpcodeMTBUF : uint32_t
	{
		TBUFFER_LOAD_FORMAT_X     = 0,
		TBUFFER_LOAD_FORMAT_XY    = 1,
		TBUFFER_LOAD_FORMAT_XYZ   = 2,
		TBUFFER_LOAD_FORMAT_XYZW  = 3,
		TBUFFER_STORE_FORMAT_X    = 4,
		TBUFFER_STORE_FORMAT_XY   = 5,
		TBUFFER_STORE_FORMAT_XYZ  = 6,
		TBUFFER_STORE_FORMAT_XYZW = 7,

		OP_RANGE_MTBUF = TBUFFER_STORE_FORMAT_XYZW + 1,
	};

	enum class GcnOpcodeMIMG : uint32_t
	{
		IMAGE_LOAD             = 0,
		IMAGE_LOAD_MIP         = 1,
		IMAGE_LOAD_PCK         = 2,
		IMAGE_LOAD_PCK_SGN     = 3,
		IMAGE_LOAD_MIP_PCK     = 4,
		IMAGE_LOAD_MIP_PCK_SGN = 5,
		IMAGE_STORE            = 8,
		IMAGE_STORE_MIP        = 9,
		IMAGE_STORE_PCK        = 10,
		IMAGE_STORE_MIP_PCK    = 11,
		IMAGE_GET_RESINFO      = 14,
		IMAGE_ATOMIC_SWAP      = 15,
		IMAGE_ATOMIC_CMPSWAP   = 16,
		IMAGE_ATOMIC_ADD       = 17,
		IMAGE_ATOMIC_SUB       = 18,
		IMAGE_ATOMIC_SMIN      = 20,
		IMAGE_ATOMIC_UMIN      = 21,
		IMAGE_ATOMIC_SMAX      = 22,
		IMAGE_ATOMIC_UMAX      = 23,
		IMAGE_ATOMIC_AND       = 24,
		IMAGE_ATOMIC_OR        = 25,
		IMAGE_ATOMIC_XOR       = 26,
		IMAGE_ATOMIC_INC       = 27,
		IMAGE_ATOMIC_DEC       = 28,
		IMAGE_ATOMIC_FCMPSWAP  = 29,
		IMAGE_ATOMIC_FMIN      = 30,
		IMAGE_ATOMIC_FMAX      = 31,
		IMAGE_SAMPLE           = 32,
		IMAGE_SAMPLE_CL        = 33,
		IMAGE_SAMPLE_D         = 34,
		IMAGE_SAMPLE_D_CL      = 35,
		IMAGE_SAMPLE_L         = 36,
		IMAGE_SAMPLE_B         = 37,
		IMAGE_SAMPLE_B_CL      = 38,
		IMAGE_SAMPLE_LZ        = 39,
		IMAGE_SAMPLE_C         = 40,
		IMAGE_SAMPLE_C_CL      = 41,
		IMAGE_SAMPLE_C_D       = 42,
		IMAGE_SAMPLE_C_D_CL    = 43,
		IMAGE_SAMPLE_C_L       = 44,
		IMAGE_SAMPLE_C_B       = 45,
		IMAGE_SAMPLE_C_B_CL    = 46,
		IMAGE_SAMPLE_C_LZ      = 47,
		IMAGE_SAMPLE_O         = 48,
		IMAGE_SAMPLE_CL_O      = 49,
		IMAGE_SAMPLE_D_O       = 50,
		IMAGE_SAMPLE_D_CL_O    = 51,
		IMAGE_SAMPLE_L_O       = 52,
		IMAGE_SAMPLE_B_O       = 53,
		IMAGE_SAMPLE_B_CL_O    = 54,
		IMAGE_SAMPLE_LZ_O      = 55,
		IMAGE_SAMPLE_C_O       = 56,
		IMAGE_SAMPLE_C_CL_O    = 57,
		IMAGE_SAMPLE_C_D_O     = 58,
		IMAGE_SAMPLE_C_D_CL_O  = 59,
		IMAGE_SAMPLE_C_L_O     = 60,
		IMAGE_SAMPLE_C_B_O     = 61,
		IMAGE_SAMPLE_C_B_CL_O  = 62,
		IMAGE_SAMPLE_C_LZ_O    = 63,
		IMAGE_GATHER4          = 64,
		IMAGE_GATHER4_CL       = 65,
		IMAGE_GATHER4_L        = 68,
		IMAGE_GATHER4_B        = 69,
		IMAGE_GATHER4_B_CL     = 70,
		IMAGE_GATHER4_LZ       = 71,
		IMAGE_GATHER4_C        = 72,
		IMAGE_GATHER4_C_CL     = 73,
		IMAGE_GATHER4_C_L      = 76,
		IMAGE_GATHER4_C_B      = 77,
		IMAGE_GATHER4_C_B_CL   = 78,
		IMAGE_GATHER4_C_LZ     = 79,
		IMAGE_GATHER4_O        = 80,
		IMAGE_GATHER4_CL_O     = 81,
		IMAGE_GATHER4_L_O      = 84,
		IMAGE_GATHER4_B_O      = 85,
		IMAGE_GATHER4_B_CL_O   = 86,
		IMAGE_GATHER4_LZ_O     = 87,
		IMAGE_GATHER4_C_O      = 88,
		IMAGE_GATHER4_C_CL_O   = 89,
		IMAGE_GATHER4_C_L_O    = 92,
		IMAGE_GATHER4_C_B_O    = 93,
		IMAGE_GATHER4_C_B_CL_O = 94,
		IMAGE_GATHER4_C_LZ_O   = 95,
		IMAGE_GET_LOD          = 96,
		IMAGE_SAMPLE_CD        = 104,
		IMAGE_SAMPLE_CD_CL     = 105,
		IMAGE_SAMPLE_C_CD      = 106,
		IMAGE_SAMPLE_C_CD_CL   = 107,
		IMAGE_SAMPLE_CD_O      = 108,
		IMAGE_SAMPLE_CD_CL_O   = 109,
		IMAGE_SAMPLE_C_CD_O    = 110,
		IMAGE_SAMPLE_C_CD_CL_O = 111,

		OP_RANGE_MIMG = IMAGE_SAMPLE_C_CD_CL_O + 1,
	};

	enum class GcnOpcodeEXP : uint32_t
	{
		EXP = 0,

		OP_RANGE_EXP = EXP + 1,
	};

	// Use to map VOP3 opcodes into VOP1, VOP2, VOPC
	enum class GcnOpMapVOP3VOPX : uint32_t
	{
		VOP3_TO_VOPC = 0,
		VOP3_TO_VOP2 = 256,
		VOP3_TO_VOP1 = 384,
	};

	// Use to map all opcodes into a single enum
	enum class GcnOpcodeMap : uint32_t
	{
		OP_MAP_SOP2   = 0,
		OP_MAP_SOPK   = OP_MAP_SOP2 + (uint32_t)GcnOpcodeSOP2::OP_RANGE_SOP2,
		OP_MAP_SOP1   = OP_MAP_SOPK + (uint32_t)GcnOpcodeSOPK::OP_RANGE_SOPK,
		OP_MAP_SOPC   = OP_MAP_SOP1 + (uint32_t)GcnOpcodeSOP1::OP_RANGE_SOP1,
		OP_MAP_SOPP   = OP_MAP_SOPC + (uint32_t)GcnOpcodeSOPC::OP_RANGE_SOPC,
		OP_MAP_VOPC   = OP_MAP_SOPP + (uint32_t)GcnOpcodeSOPP::OP_RANGE_SOPP,
		OP_MAP_VOP2   = OP_MAP_VOPC + (uint32_t)GcnOpcodeVOPC::OP_RANGE_VOPC,
		OP_MAP_VOP1   = OP_MAP_VOP2 + (uint32_t)GcnOpcodeVOP2::OP_RANGE_VOP2,
		OP_MAP_VOP3   = OP_MAP_VOP1 + (uint32_t)GcnOpcodeVOP1::OP_RANGE_VOP1,
		OP_MAP_VINTRP = OP_MAP_VOP3 + (uint32_t)GcnOpcodeVOP3::OP_RANGE_VOP3,
		OP_MAP_SMRD   = OP_MAP_VINTRP + (uint32_t)GcnOpcodeVINTRP::OP_RANGE_VINTRP,
		OP_MAP_DS     = OP_MAP_SMRD + (uint32_t)GcnOpcodeSMRD::OP_RANGE_SMRD,
		OP_MAP_MUBUF  = OP_MAP_DS + (uint32_t)GcnOpcodeDS::OP_RANGE_DS,
		OP_MAP_MTBUF  = OP_MAP_MUBUF + (uint32_t)GcnOpcodeMUBUF::OP_RANGE_MUBUF,
		OP_MAP_MIMG   = OP_MAP_MTBUF + (uint32_t)GcnOpcodeMTBUF::OP_RANGE_MTBUF,
		OP_MAP_EXP    = OP_MAP_MIMG + (uint32_t)GcnOpcodeMIMG::OP_RANGE_MIMG,
	};

	enum class GcnOpcode : uint32_t
	{
		// SOP2
		S_ADD_U32        = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_SUB_U32        = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ADD_I32        = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_SUB_I32        = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ADDC_U32       = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_SUBB_U32       = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_MIN_I32        = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_MIN_U32        = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_MAX_I32        = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_MAX_U32        = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_CSELECT_B32    = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_CSELECT_B64    = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_AND_B32        = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_AND_B64        = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_OR_B32         = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_OR_B64         = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_XOR_B32        = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_XOR_B64        = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ANDN2_B32      = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ANDN2_B64      = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ORN2_B32       = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ORN2_B64       = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_NAND_B32       = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_NAND_B64       = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_NOR_B32        = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_NOR_B64        = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_XNOR_B32       = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_XNOR_B64       = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_LSHL_B32       = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_LSHL_B64       = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_LSHR_B32       = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_LSHR_B64       = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ASHR_I32       = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ASHR_I64       = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFM_B32        = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFM_B64        = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_MUL_I32        = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFE_U32        = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFE_I32        = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFE_U64        = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_BFE_I64        = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_CBRANCH_G_FORK = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		S_ABSDIFF_I32    = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP2,
		// SOPK
		S_MOVK_I32         = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMOVK_I32        = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_EQ_I32      = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LG_I32      = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_GT_I32      = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_GE_I32      = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LT_I32      = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LE_I32      = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_EQ_U32      = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LG_U32      = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_GT_U32      = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_GE_U32      = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LT_U32      = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CMPK_LE_U32      = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_ADDK_I32         = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_MULK_I32         = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_CBRANCH_I_FORK   = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_GETREG_B32       = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_SETREG_B32       = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_GETREG_REGRD_B32 = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		S_SETREG_IMM32_B32 = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPK,
		// SOP1
		S_MOV_B32            = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOV_B64            = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_CMOV_B32           = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_CMOV_B64           = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_NOT_B32            = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_NOT_B64            = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_WQM_B32            = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_WQM_B64            = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BREV_B32           = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BREV_B64           = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BCNT0_I32_B32      = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BCNT0_I32_B64      = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BCNT1_I32_B32      = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BCNT1_I32_B64      = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FF0_I32_B32        = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FF0_I32_B64        = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FF1_I32_B32        = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FF1_I32_B64        = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FLBIT_I32_B32      = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FLBIT_I32_B64      = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FLBIT_I32          = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_FLBIT_I32_I64      = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_SEXT_I32_I8        = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_SEXT_I32_I16       = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BITSET0_B32        = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BITSET0_B64        = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BITSET1_B32        = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_BITSET1_B64        = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_GETPC_B64          = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_SETPC_B64          = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_SWAPPC_B64         = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_RFE_B64            = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_AND_SAVEEXEC_B64   = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_OR_SAVEEXEC_B64    = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_XOR_SAVEEXEC_B64   = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_ANDN2_SAVEEXEC_B64 = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_ORN2_SAVEEXEC_B64  = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_NAND_SAVEEXEC_B64  = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_NOR_SAVEEXEC_B64   = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_XNOR_SAVEEXEC_B64  = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_QUADMASK_B32       = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_QUADMASK_B64       = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOVRELS_B32        = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOVRELS_B64        = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOVRELD_B32        = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOVRELD_B64        = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_CBRANCH_JOIN       = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOV_REGRD_B32      = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_ABS_I32            = 52 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		S_MOV_FED_B32        = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_SOP1,
		// SOPC
		S_CMP_EQ_I32  = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LG_I32  = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_GT_I32  = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_GE_I32  = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LT_I32  = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LE_I32  = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_EQ_U32  = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LG_U32  = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_GT_U32  = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_GE_U32  = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LT_U32  = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_CMP_LE_U32  = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_BITCMP0_B32 = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_BITCMP1_B32 = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_BITCMP0_B64 = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_BITCMP1_B64 = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		S_SETVSKIP    = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPC,
		// SOPP
		S_NOP                      = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_ENDPGM                   = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_BRANCH                   = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_SCC0             = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_SCC1             = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_VCCZ             = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_VCCNZ            = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_EXECZ            = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_EXECNZ           = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_BARRIER                  = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SETKILL                  = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_WAITCNT                  = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SETHALT                  = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SLEEP                    = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SETPRIO                  = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SENDMSG                  = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_SENDMSGHALT              = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_TRAP                     = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_ICACHE_INV               = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_INCPERFLEVEL             = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_DECPERFLEVEL             = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_TTRACEDATA               = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_CDBGSYS          = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_CDBGUSER         = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_CDBGSYS_OR_USER  = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		S_CBRANCH_CDBGSYS_AND_USER = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_SOPP,
		// VOPC
		V_CMP_F_F32      = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_F32     = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_F32     = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_F32     = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_F32     = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LG_F32     = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_F32     = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_O_F32      = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_U_F32      = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NGE_F32    = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLG_F32    = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NGT_F32    = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLE_F32    = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NEQ_F32    = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLT_F32    = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_F32    = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_F32      = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_F32     = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_F32    = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_F32    = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_F32    = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_F32    = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LG_F32    = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_F32    = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_O_F32     = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_U_F32     = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NGE_F32   = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLG_F32   = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NGT_F32   = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLE_F32   = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NEQ_F32   = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLT_F32   = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_F32   = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_F32     = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_F_F64      = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_F64     = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_F64     = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_F64     = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_F64     = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LG_F64     = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_F64     = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_O_F64      = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_U_F64      = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NGE_F64    = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLG_F64    = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NGT_F64    = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLE_F64    = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NEQ_F64    = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NLT_F64    = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_F64    = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_F64      = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_F64     = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_F64    = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_F64    = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_F64    = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_F64    = 52 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LG_F64    = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_F64    = 54 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_O_F64     = 55 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_U_F64     = 56 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NGE_F64   = 57 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLG_F64   = 58 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NGT_F64   = 59 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLE_F64   = 60 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NEQ_F64   = 61 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NLT_F64   = 62 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_F64   = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_F64     = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_F_F32     = 64 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LT_F32    = 65 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_EQ_F32    = 66 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LE_F32    = 67 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_GT_F32    = 68 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LG_F32    = 69 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_GE_F32    = 70 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_O_F32     = 71 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_U_F32     = 72 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NGE_F32   = 73 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLG_F32   = 74 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NGT_F32   = 75 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLE_F32   = 76 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NEQ_F32   = 77 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLT_F32   = 78 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_TRU_F32   = 79 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_T_F32     = 79 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_F_F32    = 80 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LT_F32   = 81 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_EQ_F32   = 82 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LE_F32   = 83 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_GT_F32   = 84 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LG_F32   = 85 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_GE_F32   = 86 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_O_F32    = 87 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_U_F32    = 88 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NGE_F32  = 89 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLG_F32  = 90 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NGT_F32  = 91 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLE_F32  = 92 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NEQ_F32  = 93 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLT_F32  = 94 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_TRU_F32  = 95 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_T_F32    = 95 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_F_F64     = 96 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LT_F64    = 97 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_EQ_F64    = 98 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LE_F64    = 99 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_GT_F64    = 100 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_LG_F64    = 101 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_GE_F64    = 102 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_O_F64     = 103 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_U_F64     = 104 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NGE_F64   = 105 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLG_F64   = 106 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NGT_F64   = 107 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLE_F64   = 108 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NEQ_F64   = 109 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_NLT_F64   = 110 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_TRU_F64   = 111 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPS_T_F64     = 111 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_F_F64    = 112 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LT_F64   = 113 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_EQ_F64   = 114 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LE_F64   = 115 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_GT_F64   = 116 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_LG_F64   = 117 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_GE_F64   = 118 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_O_F64    = 119 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_U_F64    = 120 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NGE_F64  = 121 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLG_F64  = 122 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NGT_F64  = 123 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLE_F64  = 124 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NEQ_F64  = 125 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_NLT_F64  = 126 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_TRU_F64  = 127 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPSX_T_F64    = 127 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_F_I32      = 128 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_I32     = 129 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_I32     = 130 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_I32     = 131 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_I32     = 132 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LG_I32     = 133 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NE_I32     = 133 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_I32     = 134 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_I32    = 135 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_I32      = 135 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_CLASS_F32  = 136 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_I32     = 144 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_I32    = 145 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_I32    = 146 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_I32    = 147 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_I32    = 148 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LG_I32    = 149 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NE_I32    = 149 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_I32    = 150 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_I32   = 151 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_I32     = 151 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_CLASS_F32 = 152 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_F_I64      = 160 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_I64     = 161 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_I64     = 162 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_I64     = 163 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_I64     = 164 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LG_I64     = 165 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NE_I64     = 165 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_I64     = 166 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_I64    = 167 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_I64      = 167 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_CLASS_F64  = 168 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_I64     = 176 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_I64    = 177 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_I64    = 178 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_I64    = 179 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_I64    = 180 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LG_I64    = 181 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NE_I64    = 181 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_I64    = 182 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_I64   = 183 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_I64     = 183 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_CLASS_F64 = 184 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_F_U32      = 192 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_U32     = 193 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_U32     = 194 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_U32     = 195 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_U32     = 196 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NE_U32     = 197 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_U32     = 198 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_U32    = 199 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_U32      = 199 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_U32     = 208 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_U32    = 209 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_U32    = 210 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_U32    = 211 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_U32    = 212 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NE_U32    = 213 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_U32    = 214 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_U32   = 215 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_U32     = 215 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_F_U64      = 224 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LT_U64     = 225 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_EQ_U64     = 226 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LE_U64     = 227 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GT_U64     = 228 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_LG_U64     = 229 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_NE_U64     = 229 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_GE_U64     = 230 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_TRU_U64    = 231 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMP_T_U64      = 231 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_F_U64     = 240 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LT_U64    = 241 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_EQ_U64    = 242 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LE_U64    = 243 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GT_U64    = 244 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_LG_U64    = 245 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_NE_U64    = 245 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_GE_U64    = 246 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_TRU_U64   = 247 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		V_CMPX_T_U64     = 247 + (uint32_t)GcnOpcodeMap::OP_MAP_VOPC,
		// VOP2
		V_CNDMASK_B32        = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_READLANE_B32       = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_WRITELANE_B32      = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_ADD_F32            = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUB_F32            = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUBREV_F32         = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAC_LEGACY_F32     = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_LEGACY_F32     = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_F32            = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_I32_I24        = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_HI_I32_I24     = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_U32_U24        = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MUL_HI_U32_U24     = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MIN_LEGACY_F32     = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAX_LEGACY_F32     = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MIN_F32            = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAX_F32            = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MIN_I32            = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAX_I32            = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MIN_U32            = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAX_U32            = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_LSHR_B32           = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_LSHRREV_B32        = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_ASHR_I32           = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_ASHRREV_I32        = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_LSHL_B32           = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_LSHLREV_B32        = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_AND_B32            = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_OR_B32             = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_XOR_B32            = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_BFM_B32            = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MAC_F32            = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MADMK_F32          = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MADAK_F32          = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_BCNT_U32_B32       = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MBCNT_LO_U32_B32   = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_MBCNT_HI_U32_B32   = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_ADD_I32            = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUB_I32            = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUBREV_I32         = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_ADDC_U32           = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUBB_U32           = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_SUBBREV_U32        = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_LDEXP_F32          = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PKACCUM_U8_F32 = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PKNORM_I16_F32 = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PKNORM_U16_F32 = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PKRTZ_F16_F32  = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PK_U16_U32     = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		V_CVT_PK_I16_I32     = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP2,
		// VOP1
		V_NOP               = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_MOV_B32           = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_READFIRSTLANE_B32 = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_I32_F64       = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F64_I32       = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_I32       = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_U32       = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_U32_F32       = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_I32_F32       = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_MOV_FED_B32       = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F16_F32       = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_F16       = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_RPI_I32_F32   = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_FLR_I32_F32   = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_OFF_F32_I4    = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_F64       = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F64_F32       = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_UBYTE0    = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_UBYTE1    = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_UBYTE2    = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F32_UBYTE3    = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_U32_F64       = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CVT_F64_U32       = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_TRUNC_F64         = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CEIL_F64          = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RNDNE_F64         = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FLOOR_F64         = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FRACT_F32         = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_TRUNC_F32         = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CEIL_F32          = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RNDNE_F32         = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FLOOR_F32         = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_EXP_F32           = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_LOG_CLAMP_F32     = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_LOG_F32           = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_CLAMP_F32     = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_LEGACY_F32    = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_F32           = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_IFLAG_F32     = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RSQ_CLAMP_F32     = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RSQ_LEGACY_F32    = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RSQ_F32           = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_F64           = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RCP_CLAMP_F64     = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RSQ_F64           = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_RSQ_CLAMP_F64     = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_SQRT_F32          = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_SQRT_F64          = 52 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_SIN_F32           = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_COS_F32           = 54 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_NOT_B32           = 55 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_BFREV_B32         = 56 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FFBH_U32          = 57 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FFBL_B32          = 58 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FFBH_I32          = 59 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FREXP_EXP_I32_F64 = 60 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FREXP_MANT_F64    = 61 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FRACT_F64         = 62 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FREXP_EXP_I32_F32 = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_FREXP_MANT_F32    = 64 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_CLREXCP           = 65 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_MOVRELD_B32       = 66 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_MOVRELS_B32       = 67 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_MOVRELSD_B32      = 68 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_LOG_LEGACY_F32    = 69 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		V_EXP_LEGACY_F32    = 70 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP1,
		// VOP3
		V_MAD_LEGACY_F32  = 320 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAD_F32         = 321 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAD_I32_I24     = 322 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAD_U32_U24     = 323 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_CUBEID_F32      = 324 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_CUBESC_F32      = 325 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_CUBETC_F32      = 326 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_CUBEMA_F32      = 327 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_BFE_U32         = 328 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_BFE_I32         = 329 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_BFI_B32         = 330 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_FMA_F32         = 331 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_FMA_F64         = 332 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_LERP_U8         = 333 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_ALIGNBIT_B32    = 334 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_ALIGNBYTE_B32   = 335 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MULLIT_F32      = 336 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MIN3_F32        = 337 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MIN3_I32        = 338 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MIN3_U32        = 339 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAX3_F32        = 340 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAX3_I32        = 341 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAX3_U32        = 342 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MED3_F32        = 343 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MED3_I32        = 344 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MED3_U32        = 345 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_SAD_U8          = 346 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_SAD_HI_U8       = 347 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_SAD_U16         = 348 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_SAD_U32         = 349 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_CVT_PK_U8_F32   = 350 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_FIXUP_F32   = 351 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_FIXUP_F64   = 352 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_LSHL_B64        = 353 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_LSHR_B64        = 354 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_ASHR_I64        = 355 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_ADD_F64         = 356 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MUL_F64         = 357 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MIN_F64         = 358 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAX_F64         = 359 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_LDEXP_F64       = 360 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MUL_LO_U32      = 361 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MUL_HI_U32      = 362 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MUL_LO_I32      = 363 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MUL_HI_I32      = 364 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_SCALE_F32   = 365 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_SCALE_F64   = 366 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_FMAS_F32    = 367 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_DIV_FMAS_F64    = 368 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MSAD_U8         = 369 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_QSAD_U8         = 370 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_QSAD_PK_U16_U8  = 370 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MQSAD_U8        = 371 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MQSAD_PK_U16_U8 = 371 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_TRIG_PREOP_F64  = 372 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MQSAD_U32_U8    = 373 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAD_U64_U32     = 374 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		V_MAD_I64_I32     = 375 + (uint32_t)GcnOpcodeMap::OP_MAP_VOP3,
		// VINTRP
		V_INTERP_P1_F32  = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_VINTRP,
		V_INTERP_P2_F32  = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_VINTRP,
		V_INTERP_MOV_F32 = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_VINTRP,
		// SMRD
		S_LOAD_DWORD           = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_LOAD_DWORDX2         = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_LOAD_DWORDX4         = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_LOAD_DWORDX8         = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_LOAD_DWORDX16        = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_BUFFER_LOAD_DWORD    = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_BUFFER_LOAD_DWORDX2  = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_BUFFER_LOAD_DWORDX4  = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_BUFFER_LOAD_DWORDX8  = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_BUFFER_LOAD_DWORDX16 = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_MEMTIME              = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		S_DCACHE_INV           = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_SMRD,
		// DS
		DS_ADD_U32              = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_U32              = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_U32             = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_U32              = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_U32              = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_I32              = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_I32              = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_U32              = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_U32              = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_B32              = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_B32               = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_B32              = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MSKOR_B32            = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B32            = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE2_B32           = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE2ST64_B32       = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_B32            = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_F32            = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_F32              = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_F32              = 19 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_NOP                  = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_SEMA_RELEASE_ALL = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_INIT             = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_SEMA_V           = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_SEMA_BR          = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_SEMA_P           = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_GWS_BARRIER          = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B8             = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B16            = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ADD_RTN_U32          = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_RTN_U32          = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_RTN_U32         = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_RTN_U32          = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_RTN_U32          = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_I32          = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_I32          = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_U32          = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_U32          = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_RTN_B32          = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_RTN_B32           = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_RTN_B32          = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MSKOR_RTN_B32        = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG_RTN_B32       = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG2_RTN_B32      = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG2ST64_RTN_B32  = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_RTN_B32        = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_RTN_F32        = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_F32          = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_F32          = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRAP_RTN_B32         = 52 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SWIZZLE_B32          = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_B32             = 54 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ2_B32            = 55 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ2ST64_B32        = 56 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_I8              = 57 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_U8              = 58 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_I16             = 59 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_U16             = 60 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CONSUME              = 61 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_APPEND               = 62 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ORDERED_COUNT        = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ADD_U64              = 64 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_U64              = 65 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_U64             = 66 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_U64              = 67 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_U64              = 68 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_I64              = 69 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_I64              = 70 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_U64              = 71 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_U64              = 72 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_B64              = 73 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_B64               = 74 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_B64              = 75 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MSKOR_B64            = 76 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B64            = 77 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE2_B64           = 78 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE2ST64_B64       = 79 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_B64            = 80 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_F64            = 81 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_F64              = 82 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_F64              = 83 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ADD_RTN_U64          = 96 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_RTN_U64          = 97 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_RTN_U64         = 98 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_RTN_U64          = 99 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_RTN_U64          = 100 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_I64          = 101 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_I64          = 102 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_U64          = 103 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_U64          = 104 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_RTN_B64          = 105 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_RTN_B64           = 106 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_RTN_B64          = 107 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MSKOR_RTN_B64        = 108 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG_RTN_B64       = 109 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG2_RTN_B64      = 110 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRXCHG2ST64_RTN_B64  = 111 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_RTN_B64        = 112 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CMPST_RTN_F64        = 113 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_RTN_F64          = 114 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_RTN_F64          = 115 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_B64             = 118 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ2_B64            = 119 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ2ST64_B64        = 120 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CONDXCHG32_RTN_B64   = 126 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ADD_SRC2_U32         = 128 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_SRC2_U32         = 129 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_SRC2_U32        = 130 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_SRC2_U32         = 131 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_SRC2_U32         = 132 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_I32         = 133 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_I32         = 134 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_U32         = 135 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_U32         = 136 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_SRC2_B32         = 137 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_SRC2_B32          = 138 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_SRC2_B32         = 139 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_SRC2_B32       = 141 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_F32         = 146 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_F32         = 147 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_ADD_SRC2_U64         = 192 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_SUB_SRC2_U64         = 193 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_RSUB_SRC2_U64        = 194 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_INC_SRC2_U64         = 195 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_DEC_SRC2_U64         = 196 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_I64         = 197 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_I64         = 198 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_U64         = 199 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_U64         = 200 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_AND_SRC2_B64         = 201 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_OR_SRC2_B64          = 202 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_XOR_SRC2_B64         = 203 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_SRC2_B64       = 205 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MIN_SRC2_F64         = 210 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_MAX_SRC2_F64         = 211 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B96            = 222 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_WRITE_B128           = 223 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_CONDXCHG32_RTN_B128  = 253 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_B96             = 254 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		DS_READ_B128            = 255 + (uint32_t)GcnOpcodeMap::OP_MAP_DS,
		// MUBUF
		BUFFER_LOAD_FORMAT_X      = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_FORMAT_XY     = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_FORMAT_XYZ    = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_FORMAT_XYZW   = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_FORMAT_X     = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_FORMAT_XY    = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_FORMAT_XYZ   = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_FORMAT_XYZW  = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_UBYTE         = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_SBYTE         = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_USHORT        = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_SSHORT        = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_DWORD         = 12 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_DWORDX2       = 13 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_DWORDX4       = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_LOAD_DWORDX3       = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_BYTE         = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_SHORT        = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_DWORD        = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_DWORDX2      = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_DWORDX4      = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_STORE_DWORDX3      = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SWAP        = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_CMPSWAP     = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_ADD         = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SUB         = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SMIN        = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_UMIN        = 54 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SMAX        = 55 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_UMAX        = 56 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_AND         = 57 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_OR          = 58 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_XOR         = 59 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_INC         = 60 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_DEC         = 61 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FCMPSWAP    = 62 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FMIN        = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FMAX        = 64 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SWAP_X2     = 80 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_CMPSWAP_X2  = 81 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_ADD_X2      = 82 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SUB_X2      = 83 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SMIN_X2     = 85 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_UMIN_X2     = 86 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_SMAX_X2     = 87 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_UMAX_X2     = 88 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_AND_X2      = 89 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_OR_X2       = 90 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_XOR_X2      = 91 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_INC_X2      = 92 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_DEC_X2      = 93 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FCMPSWAP_X2 = 94 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FMIN_X2     = 95 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_ATOMIC_FMAX_X2     = 96 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_WBINVL1_SC         = 112 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		BUFFER_WBINVL1            = 113 + (uint32_t)GcnOpcodeMap::OP_MAP_MUBUF,
		// MTBUF
		TBUFFER_LOAD_FORMAT_X     = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_LOAD_FORMAT_XY    = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_LOAD_FORMAT_XYZ   = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_LOAD_FORMAT_XYZW  = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_STORE_FORMAT_X    = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_STORE_FORMAT_XY   = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_STORE_FORMAT_XYZ  = 6 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		TBUFFER_STORE_FORMAT_XYZW = 7 + (uint32_t)GcnOpcodeMap::OP_MAP_MTBUF,
		// MIMG
		IMAGE_LOAD             = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_LOAD_MIP         = 1 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_LOAD_PCK         = 2 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_LOAD_PCK_SGN     = 3 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_LOAD_MIP_PCK     = 4 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_LOAD_MIP_PCK_SGN = 5 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_STORE            = 8 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_STORE_MIP        = 9 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_STORE_PCK        = 10 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_STORE_MIP_PCK    = 11 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GET_RESINFO      = 14 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_SWAP      = 15 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_CMPSWAP   = 16 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_ADD       = 17 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_SUB       = 18 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_SMIN      = 20 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_UMIN      = 21 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_SMAX      = 22 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_UMAX      = 23 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_AND       = 24 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_OR        = 25 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_XOR       = 26 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_INC       = 27 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_DEC       = 28 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_FCMPSWAP  = 29 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_FMIN      = 30 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_ATOMIC_FMAX      = 31 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE           = 32 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CL        = 33 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_D         = 34 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_D_CL      = 35 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_L         = 36 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_B         = 37 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_B_CL      = 38 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_LZ        = 39 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C         = 40 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CL      = 41 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_D       = 42 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_D_CL    = 43 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_L       = 44 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_B       = 45 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_B_CL    = 46 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_LZ      = 47 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_O         = 48 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CL_O      = 49 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_D_O       = 50 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_D_CL_O    = 51 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_L_O       = 52 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_B_O       = 53 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_B_CL_O    = 54 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_LZ_O      = 55 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_O       = 56 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CL_O    = 57 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_D_O     = 58 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_D_CL_O  = 59 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_L_O     = 60 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_B_O     = 61 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_B_CL_O  = 62 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_LZ_O    = 63 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4          = 64 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_CL       = 65 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_L        = 68 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_B        = 69 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_B_CL     = 70 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_LZ       = 71 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C        = 72 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_CL     = 73 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_L      = 76 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_B      = 77 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_B_CL   = 78 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_LZ     = 79 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_O        = 80 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_CL_O     = 81 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_L_O      = 84 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_B_O      = 85 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_B_CL_O   = 86 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_LZ_O     = 87 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_O      = 88 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_CL_O   = 89 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_L_O    = 92 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_B_O    = 93 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_B_CL_O = 94 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GATHER4_C_LZ_O   = 95 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_GET_LOD          = 96 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CD        = 104 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CD_CL     = 105 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CD      = 106 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CD_CL   = 107 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CD_O      = 108 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_CD_CL_O   = 109 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CD_O    = 110 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		IMAGE_SAMPLE_C_CD_CL_O = 111 + (uint32_t)GcnOpcodeMap::OP_MAP_MIMG,
		// EXP
		EXP = 0 + (uint32_t)GcnOpcodeMap::OP_MAP_EXP,
	};

	enum class GcnEncodingMask : uint32_t
	{
		MASK_9bit = 0x000001FFULL << 23,
		MASK_7bit = 0x0000007FULL << 25,
		MASK_6bit = 0x0000003FULL << 26,
		MASK_5bit = 0x0000001FULL << 27,
		MASK_4bit = 0x0000000FULL << 28,
		MASK_2bit = 0x00000003ULL << 30,
		MASK_1bit = 0x00000001ULL << 31
	};

	enum class GcnInstEncoding : uint32_t
	{
		/// InstructionEncodingMask_9bit
		/// bits [31:23] - (1 0 1 1 1 1 1 0 1)
		SOP1 = 0x0000017Du << 23,
		/// bits [31:23] - (1 0 1 1 1 1 1 1 1)
		SOPP = 0x0000017Fu << 23,
		/// bits [31:23] - (1 0 1 1 1 1 1 1 0)
		SOPC = 0x0000017Eu << 23,
		/// InstructionEncodingMask_7bit
		/// bits [31:25] - (0 1 1 1 1 1 1)
		VOP1 = 0x0000003Fu << 25,
		/// bits [31:25] - (0 1 1 1 1 1 0)
		VOPC = 0x0000003Eu << 25,
		/// InstructionEncodingMask_6bit
		/// bits [31:26] - (1 1 0 1 0 0)
		VOP3 = 0x00000034u << 26,
		/// bits [31:26] - (1 1 1 1 1 0)
		EXP = 0x0000003Eu << 26,
		/// bits [31:26] - (1 1 0 0 1 0)
		VINTRP = 0x00000032u << 26,
		/// bits [31:26] - (1 1 0 1 1 0)
		DS = 0x00000036u << 26,
		/// bits [31:26] - (1 1 1 0 0 0)
		MUBUF = 0x00000038u << 26,
		/// bits [31:26] - (1 1 1 0 1 0)
		MTBUF = 0x0000003Au << 26,
		/// bits [31:26] - (1 1 1 1 0 0)
		MIMG = 0x0000003Cu << 26,
		/// InstructionEncodingMask_5bit
		/// bits [31:27] - (1 1 0 0 0)
		SMRD = 0x00000018u << 27,
		/// InstructionEncodingMask_4bit
		/// bits [31:28] - (1 0 1 1)
		SOPK = 0x0000000Bu << 28,
		/// InstructionEncodingMask_2bit
		/// bits [31:30] - (1 0)
		SOP2 = 0x00000002u << 30,
		/// InstructionEncodingMask_1bit
		/// bits [31:31] - (0)
		VOP2 = 0x00000000u << 31,

		ILLEGAL
	};

	enum class GcnInstClass : uint32_t
	{
		Undefined,

		ScalarArith,
		ScalarAbs,
		ScalarMov,
		ScalarCmp,
		ScalarSelect,
		ScalarBitLogic,
		ScalarBitManip,
		ScalarBitField,
		ScalarConv,
		ScalarExecMask,
		ScalarQuadMask,

		VectorRegMov,
		VectorLane,
		VectorBitLogic,
		VectorBitField32,
		VectorThreadMask,
		VectorBitField64,
		VectorFpArith32,
		VectorFpRound32,
		VectorFpField32,
		VectorFpTran32,
		VectorFpCmp32,
		VectorFpArith64,
		VectorFpRound64,
		VectorFpField64,
		VectorFpTran64,
		VectorFpCmp64,
		VectorIntArith32,
		VectorIntArith64,
		VectorIntCmp32,
		VectorIntCmp64,
		VectorConv,
		VectorFpGraph32,
		VectorIntGraph,
		VectorMisc,

		ScalarProgFlow,
		ScalarSync,
		ScalarWait,
		ScalarCache,
		ScalarPrior,
		ScalarRegAccess,
		ScalarMsg,

		ScalarMemRd,
		ScalarMemUt,

		VectorMemBufNoFmt,
		VectorMemBufFmt,
		VectorMemImgNoSmp,
		VectorMemImgSmp,
		VectorMemImgUt,
		VectorMemL1Cache,

		DsIdxRd,
		DsIdxWr,
		DsIdxWrXchg,
		DsIdxCondXchg,
		DsIdxWrap,
		DsAtomicArith32,
		DsAtomicArith64,
		DsAtomicMinMax32,
		DsAtomicMinMax64,
		DsAtomicCmpSt32,
		DsAtomicCmpSt64,
		DsAtomicLogic32,
		DsAtomicLogic64,
		DsAppendCon,
		DsDataShareUt,
		DsDataShareMisc,
		GdsSync,
		GdsOrdCnt,

		VectorInterpFpCache,

		Exp,

		DbgProf
	};

	enum class GcnInstCategory : uint32_t
	{
		Undefined,
		/// Scalar ALU Operation
		ScalarALU,
		/// Scalar Instruction Memory
		ScalarMemory,
		/// Vector ALU Operation
		VectorALU,
		/// Vector Instruction Memory Read
		VectorMemory,
		/// Scalar Program Flow Control and Special Operations
		FlowControl,
		/// LDS and GDS
		DataShare,
		/// Vector Interpolation Operations
		VectorInterpolation,
		/// Export
		Export,
		/// Debug and Profiling Operations
		DebugProfile,
	};

	/**
	 * \brief Divergent Action
	 * 
	 * Instruction's action when 
	 * GPU thread is not active.
	 * 
	 */
	enum class GcnDivergentAction : uint32_t
	{
		// no operation, simply skip
		Nop,
		// zero the SGPR-pair destinations
		ZeroScalar,
		// execute as normal
		Execute
	};

	/**
	 * \brief Scalar value type
	 *
	 * Enumerates possible register component
	 * types. Scalar types are represented as
	 * a one-component vector type.
	 */
	enum class GcnScalarType : uint32_t
	{
		// If a instruction or it's operands scalar type
		// is undefined, it will hit the assert
		// in decoder, in such case,
		// please fill it with the correct value.
		Undefined,
		// Some instructions' operands do not need a scalar type
		// but 'Undefined' is used in assert to alert developer 
		// to fix the uncompleted table,
		// so we need a dummy value to pass the assert for 
		// those special instructions.
		Dummy,  

		Uint32,
		Uint64,
		Sint32,
		Sint64,
		Float16,
		Float32,
		Float64,
		Bool,
	};

	enum class GcnOperandField : uint32_t
	{
		ScalarGPR = 0,
		VccLo     = 106,
		VccHi,
		M0     = 124,
		ExecLo = 126,
		ExecHi,
		ConstZero,
		SignedConstIntPos = 129,
		SignedConstIntNeg = 193,
		ConstFloatPos_0_5 = 240,
		ConstFloatNeg_0_5,
		ConstFloatPos_1_0,
		ConstFloatNeg_1_0,
		ConstFloatPos_2_0,
		ConstFloatNeg_2_0,
		ConstFloatPos_4_0,
		ConstFloatNeg_4_0,
		VccZ = 251,
		ExecZ,
		Scc,
		LdsDirect,
		LiteralConst,
		VectorGPR,

		Undefined = 0xFFFFFFFF,
	};

	enum class GcnExportTarget : uint32_t
	{
		Mrt,
		MrtZ,
		Null,
		Pos,
		Param
	};

	enum class GcnSystemValue : uint32_t
	{
		None                        = 0,
		Position                    = 1,
		ClipDistance                = 2,
		CullDistance                = 3,
		RenderTargetId              = 4,
		ViewportId                  = 5,
		VertexId                    = 6,
		PrimitiveId                 = 7,
		InstanceId                  = 8,
		IsFrontFace                 = 9,
		SampleIndex                 = 10,
		FinalQuadUeq0EdgeTessFactor = 11,
		FinalQuadVeq0EdgeTessFactor = 12,
		FinalQuadUeq1EdgeTessFactor = 13,
		FinalQuadVeq1EdgeTessFactor = 14,
		FinalQuadUInsideTessFactor  = 15,
		FinalQuadVInsideTessFactor  = 16,
		FinalTriUeq0EdgeTessFactor  = 17,
		FinalTriVeq0EdgeTessFactor  = 18,
		FinalTriWeq0EdgeTessFactor  = 19,
		FinalTriInsideTessFactor    = 20,
		FinalLineDetailTessFactor   = 21,
		FinalLineDensityTessFactor  = 22,
		GlobalInvocationId          = 23,
		WorkgroupId                 = 24,
		LocalInvocationId           = 25,
		LocalInvocationIndex        = 26,
		Target                      = 64,
		Depth                       = 65,
		Coverage                    = 66,
		DepthGe                     = 67,
		DepthLe                     = 68,
		NumSubgroups                = 70,
		SubgroupID                  = 71,
		SubgroupSize                = 72,
		SubgroupInvocationID        = 73,
		SubgroupEqMask              = 74,
		SubgroupGeMask              = 75,
		SubgroupGtMask              = 76,
		SubgroupLeMask              = 77,
		SubgroupLtMask              = 78,
	};

	enum class GcnInterpolationMode : uint32_t
	{
		Undefined                   = 0,
		Constant                    = 1,
		Linear                      = 2,
		LinearCentroid              = 3,
		LinearNoPerspective         = 4,
		LinearNoPerspectiveCentroid = 5,
		LinearSample                = 6,
		LinearNoPerspectiveSample   = 7,
	};
}  // namespace sce::gcn
