
#include "shared.h"


void update_video(void)
{
    int y;

    /* Foreground pages */
    fg_page[0] = ((textram[0xE80] >> 4) & 0x0F) << 12;
    fg_page[1] = ((textram[0xE80] >> 0) & 0x0F) << 12;
    fg_page[2] = ((textram[0xE81] >> 4) & 0x0F) << 12;
    fg_page[3] = ((textram[0xE81] >> 0) & 0x0F) << 12;

    /* Background pages */
    bg_page[0] = ((textram[0xE82] >> 4) & 0x0F) << 12;
    bg_page[1] = ((textram[0xE82] >> 0) & 0x0F) << 12;
    bg_page[2] = ((textram[0xE83] >> 4) & 0x0F) << 12;
    bg_page[3] = ((textram[0xE83] >> 0) & 0x0F) << 12;

    /* Scroll values for both layers */
    fg_scrollx = 0x400-((textram[0xE98] | textram[0xE99] << 8) & 0x3FF);
    bg_scrollx = 0x400-((textram[0xE9A] | textram[0xE9B] << 8) & 0x3FF);
    fg_scrolly = (textram[0xE90] | textram[0xE91] << 8) & 0x1FF;
    bg_scrolly = (textram[0xE92] | textram[0xE93] << 8) & 0x1FF;

    /* Draw layers */
    if(layer_enable & 0x01) draw_xg(bg_scrollx, bg_scrolly, bg_page, 1);
    else                    clear (bmp);
    if(layer_enable & 0x02) draw_xg(fg_scrollx, fg_scrolly, fg_page, 0);
    if(layer_enable & 0x04) { for(y = 0; y < 224; y += 1) draw_sprites_line(y); }
    if(layer_enable & 0x08) draw_text();
}

void draw_sprites_line(int line)
{
    int count;

    for(count = 0x00; count <= 0x80; count += 0x01)
    {
        byte *p = &objram[(count << 3)];
        int start = p[0];
        int end = p[1];

        /* End marker */
        if(start == 0xFF && end == 0xFF) break;

        /* Check if sprite falls on current line */
        if( (line >= start) && (line < end) )
        {
            static int bank[16] = { 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 4, 0, 2, 0, 0 };
            int pal = (p[8] & 0x3F) << 4;
            int xpos = (p[3] << 8 | p[2]) - (160 + 24);
            int width = (p[4] & 0x7F) << 2;
            int height = (end - start);
            int sl = (line - start);
            int name;
            int x, c, sx;

            sl = (p[4] & 0x80) ? (height - sl) : (sl);
            name = (((p[7] << 8 | p[6]) << 2 | (bank[(p[9] & 0x0F)]) << 17) + (width * (1+sl))) & 0x003FFFFC;

            for(x = 0; x < width; x += 1)
            {
                sx = (p[5] & 1) ? ((width+4) - x) : (x);
                c = obj_cache[(name + sx) & 0xFFFFF];
                if(c) {
                    c = pixel[(c | 0x400) | (pal)];
                    putpixel(bmp, MARGIN+(xpos + x), line, c);
                }
            }
        }
    }
}



void draw_xg(int scrollx, int scrolly, word *page, int opaque)
{
    int xx, yy, c;
    int sx, sy, px, py, pg = 0;
    int attr;
    int name;
    int info;
    int pal;
    int ce = (scrollx & 7) ? 41 : 40;
    byte *src = NULL;
    word *dst = NULL;

    for(yy = 0; yy < 224; yy += 1)
    {
        sy = ((scrolly + yy) >> 3) & 0x3F;
        py = (sy & 0x1F);
        pg = (pg & 0x01) | ((sy >> 5) & 1) << 1;

        for(xx = 0; xx < ce; xx += 1)
        {
            sx  = (24 + (scrollx >> 3) + xx);
            px  = (sx) & 0x3f;
            pg  = (pg & 0x02) | ((sx >> 5) & 1);

            /* Get tile entry from tile RAM */
            attr = *(word *)&tileram[(page[pg]) | (py << 7) | (px << 1)];

            /* Isolate name bits and add tile bank select bits in */
            name = (attr & 0x0FFF) | (tile_bank[(attr >> 12) & 1] << 12);

            /* Isolate palette select field */
            pal  = ((attr >> 6) & 0x7F) << 3;

            /* Get tile info and modify based on opaque drawing flag */
            info = bg_tile_info[name];
            if(opaque) info = TILE_OPAQUE;

            /* Point to line in BG tile cache */
            src = (byte *)&bg_cache[name][((scrolly + yy) % 224) & 7][0];

            /* Point to current offset in display bitmap */
            dst = (word *)&bmp->line[(yy)][( (MARGIN - (scrollx & 7)) + (xx << 3) ) << 1];

            /* Draw tile line based on tile info */
            switch(info)
            {
                case TILE_TRANSPARENT:
                    break;

                case TILE_SEMITRANSPARENT:
                    c = *src++; if(c) dst[0] = pixel[c | pal];
                    c = *src++; if(c) dst[1] = pixel[c | pal];
                    c = *src++; if(c) dst[2] = pixel[c | pal];
                    c = *src++; if(c) dst[3] = pixel[c | pal];
                    c = *src++; if(c) dst[4] = pixel[c | pal];
                    c = *src++; if(c) dst[5] = pixel[c | pal];
                    c = *src++; if(c) dst[6] = pixel[c | pal];
                    c = *src++; if(c) dst[7] = pixel[c | pal];
                    break;

                case TILE_OPAQUE:
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    *dst++ = pixel[(*src++) | pal];
                    break;
            }
        }
    }
}


void draw_text(void)
{
    int xx, yy, x, y, name, c, cc;

    for(yy = 0; yy < 28; yy += 1)
    {
        for(xx = 0; xx < 40; xx += 1)
        {
            name = *(word *)&textram[((yy << 6) + (xx + 24)) << 1];
            cc = (name >> 6) & 0x38;
            name = (name & 0x1FF);

            if(bg_tile_info[name] != TILE_TRANSPARENT)
            {
                for(y = 0; y < 8; y += 1)
                {
                    byte *src = (byte *)&bg_cache[name][y][0];
                    word *dst = (word *)&bmp->line[(yy << 3) | (y)][(MARGIN + (xx << 3)) << 1];
                    for(x = 0; x < 8; x += 1) {
                        c = src[x];
                        if(c) dst[(x)] = pixel[(c | cc)];
                    }
                }
            }
        }
    }
}



