
#ifndef _STARINTF_H_
#define _STARINTF_H_

#include "starcpu.h"

#define MAX_REGION          (16+1)  /* Total number of data regions */      
#define MAX_68000           (3)     /* Number of 68000's we can emulate */

/* Ensures the local context structure is loaded with the data from the
   context we want to use. */
#define UPDATE_CONTEXT                          \
{                                               \
    if(context != num)                          \
    {                                           \
        /* Save current context */              \
        s68000GetContext(&cpu[context]);        \
                                                \
        /* Update current context number */     \
        context = num;                          \
                                                \
        /* Load context into local context */   \
        s68000SetContext(&cpu[context]);        \
    }                                           \
}

/* Holds all the information for a single 68000 CPU. */
typedef struct
{
    void *context;
    unsigned char index[5];
    struct STARSCREAM_PROGRAMREGION fetch[MAX_REGION];
    struct STARSCREAM_DATAREGION readbyte[MAX_REGION];
    struct STARSCREAM_DATAREGION readword[MAX_REGION];
    struct STARSCREAM_DATAREGION writebyte[MAX_REGION];
    struct STARSCREAM_DATAREGION writeword[MAX_REGION];
}t_cpu;

/* Global data */
extern int context;

/* Function prototypes */
int cpu_init(void);
int cpu_reset(int num);
int cpu_execute(int num, int cycles);
int cpu_cause_interrupt(int num, int level);
void cpu_flush_interrupts(int num);
int cpu_readpc(int num);
void cpu_stop(int num);

void cpu_add_fetch(int num, unsigned lowaddr, unsigned highaddr, unsigned offset);
void cpu_add_read_byte(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_read_word(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_write_byte(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_write_word(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_write(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_read(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_readwrite(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);
void cpu_add_readwrite(int num, int lowaddr, int highaddr, void *memorycall, void *userdata);

#endif /* _STARINTF_H_ */
