
#ifndef _MAIN_H_
#define _MAIN_H_

#define CENTER_X                ((SCREEN_W - 320) / 2)
#define CENTER_Y                ((SCREEN_H - 224) / 2)
#define MARGIN                  (0x10)
#define PALETTE_SIZE            (2048)
#define TILE_OPAQUE             (0x01)
#define TILE_TRANSPARENT        (0x02)
#define TILE_SEMITRANSPARENT    (0x04)

extern byte obj_cache[0x100000];       /* Unpacked 4-bpp object graphics (dynamic) */
extern byte bg_cache[0x2000][8][8];    /* 3-bpp tiles converted to 8-bpp tiles (dynamic) */
extern byte bg_tile_info[0x2000];      /* Transparency state of each tile (dynamic) */
extern word pixel[PALETTE_SIZE];       /* Palette -> 5:6:5 pixel lookup */
extern byte tile_bank[2];              /* Tile banks */
extern word fg_page[4];                /* Foreground page addresses */
extern word bg_page[4];                /* Background page addresses */
extern word fg_scrollx, fg_scrolly;    /* Foreground scroll regs. */
extern word bg_scrollx, bg_scrolly;    /* Background scroll regs. */
extern byte rom[0x40000];              /* 256k program ROM */
extern byte ram[0x4000];               /* 16k RAM */
extern byte tileram[0x10000];          /* 64k tile RAM */
extern byte textram[0x1000];           /* 4k text RAM */
extern byte objram[0x1000];            /* 4k object RAM */
extern byte palram[0x1000];            /* 4k color RAM */

/* Function prototypes */
void update_video(void);
void draw_xg(int scrollx, int scrolly, word *page, int opaque);
void draw_text(void);
void draw_sprites_line(int line);
void init_machine(void);
void trash_machine(void);
void load_file(char *filename, char *mem, int size);
void load_file_even(char *filename, char *mem, int size);
void load_file_odd(char *filename, char *mem, int size);
void save_file(char *filename, char *mem, int size);
void error(char *fmt, ...);
void cache_obj_tiles(void);
void cache_bg_tiles(void);
UBYTE z80_read_port(UWORD port);
void z80_write_port(UWORD port, UBYTE data);
void m68k_write_memory_8(int address, int data);
void init_system(void);
void m68k_write_memory_16(int address, int data);
int m68k_read_memory_8(int address);
int m68k_read_memory_16(int address);
void compress_palette(void);

#endif /* _MAIN_H_ */
