#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_MMC3.h"

namespace {
uint8_t reg;

void sync (void) {
	if (reg &0x0C)
		MMC3::syncPRG(0x0F, reg >>2 &0x30);
	else
		EMU->SetPRG_ROM32(0x8, reg >>4 &0x0C | reg &0x03);
	MMC3::syncCHR(0xFF, 0x00);
	if (reg &0x20) {
		if (reg &0x10)
			EMU->Mirror_S1();
		else
			EMU->Mirror_S0();
	} else
		MMC3::syncMirror();
}

void MAPINT writeReg (int, int, int val) {
	reg = val;
	sync();
}

BOOL MAPINT load (void) {
	MMC3::load(sync, MMC3Type::AX5202P, NULL, NULL, NULL, writeReg);
	return TRUE;
}

void MAPINT reset (RESET_TYPE) {
	reg = 0;
	MMC3::reset(RESET_HARD);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 345;
} // namespace

MapperInfo MapperInfo_345 = {
	&mapperNum,
	_T("L6IN1"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};