﻿#include "..\DLL\d_iNES.h"
#include "..\Hardware\h_EEPROM_93Cx6.h"

/*
static INPUT_PORTS_START( dancexpt )
	PORT_START("IO1")
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP ) PORT_PLAYER(1) PORT_16WAY // NOT A JOYSTICK!!
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT ) PORT_PLAYER(1) PORT_16WAY
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN ) PORT_PLAYER(1) PORT_16WAY
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT ) PORT_PLAYER(1) PORT_16WAY
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON1 ) PORT_PLAYER(1)
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 ) PORT_PLAYER(1)
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON3 ) PORT_PLAYER(1)
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_BUTTON4 ) PORT_PLAYER(1)
INPUT_PORTS_END

uint8_t nes_clone_dancexpt_state::in0_r()
{
	// polled frequently during game, music data? from some other device?
	return 0xfe; // bit 0x01 exits the song?
}

uint8_t nes_clone_dancexpt_state::in1_r()
{
	// read directly, not through shifter here
	return m_io1->read();
}

*/

namespace {
uint8_t reg4016;
uint8_t reg[4];

void sync (void) {
	EMU->SetPRG_ROM16(0x8, reg[0]);
	EMU->SetPRG_ROM16(0xC, 0xFF);
	EMU->SetCHR_ROM8(0x0, reg[1] &0x03 | reg4016 <<2);
	iNES_SetMirroring();
}

void MAPINT writeAPU (int bank, int addr, int val) {
	EMU->WriteAPU(bank, addr, val);
	if (addr == 0x016) {
		reg4016 = val;
		sync();
	}
}

void MAPINT writeReg (int bank, int addr, int val) {
	if (~addr &0x800) {
		reg[addr >>8 &3] = val;
		sync();
	}
}

void MAPINT reset (RESET_TYPE resetType) {
	reg4016 = 0;
	reg[0] = 0;
	reg[1] = 0;
	reg[2] = 0;
	reg[3] = 0;
	sync();
	EMU->SetCPUWriteHandler (0x4, writeAPU);
	EMU->SetCPUWriteHandler (0x5, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	for (auto& c: reg) SAVELOAD_BYTE(stateMode, offset, data, c);
	SAVELOAD_BYTE(stateMode, offset, data, reg4016);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 604;
} // namespace

MapperInfo MapperInfo_604 = {
	&mapperNum,
	_T("Dancing Expert"),
	COMPAT_FULL,
	NULL,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};