#include "..\DLL\d_iNES.h"

namespace {
uint8_t reg[256];

void sync () {
	switch(reg[0] &0x07) {
		case 0x00:
			if (reg[0x08] &0x80)
				EMU->SetPRG_RAM32(0x8, reg[0x08] <<8 | reg[0x18]);
			else
				EMU->SetPRG_ROM32(0x8, reg[0x08] <<8 | reg[0x18]);
			break;
		case 0x01:
			for (int bank = 0x8; bank <=0xF; bank += 0x4) {
				if (reg[0x00 | bank] &0x80) 
					EMU->SetPRG_ROM16(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
				else
					EMU->SetPRG_ROM16(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
			}
			break;
		case 0x02:
			if (reg[0x08] &0x80) 
				EMU->SetPRG_RAM16(0x8, reg[0x08] <<8 | reg[0x18]);
			else
				EMU->SetPRG_RAM16(0x8, reg[0x08] <<8 | reg[0x18]);

			if (reg[0x0C] &0x80) 
				EMU->SetPRG_RAM8(0xC, reg[0x0C] <<8 | reg[0x1C]);
			else
				EMU->SetPRG_ROM8(0xC, reg[0x0C] <<8 | reg[0x1C]);

			if (reg[0x0E] &0x80) 
				EMU->SetPRG_RAM8(0xC, reg[0x0E] <<8 | reg[0x1E]);
			else
				EMU->SetPRG_ROM8(0xC, reg[0x0E] <<8 | reg[0x1E]);
			break;
		case 0x03:
			for (int bank = 0x8; bank <=0xF; bank += 0x2) {
				if (reg[0x00 | bank] &0x80) 
					EMU->SetPRG_RAM8(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
				else
					EMU->SetPRG_ROM8(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
			}
			break;
		case 0x04: case 0x05: case 0x06: case 0x07:
			for (int bank = 0x8; bank <=0xF; bank++) {
				if (reg[0x00 | bank] &0x80) 
					EMU->SetPRG_RAM4(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
				else
					EMU->SetPRG_ROM4(bank, reg[0x00 | bank] <<8 | reg[0x10 | bank]);
			}
			break;
	}
	EMU->SetCHR_RAM8(0x0, 0);
	EMU->Mirror_V();
}

void MAPINT writeReg (int bank, int addr, int val) {
	EMU->WriteAPU(bank, addr, val);
	if (addr &0x100) {
		reg[addr &0xFF] = val;
		sync();
	}
}

BOOL MAPINT load (void) {
	iNES_SetSRAM();
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	for (auto& r: reg) r = 0;
	sync();
	EMU->SetCPUWriteHandler(0x4, writeReg);	
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	for (auto& r: reg) SAVELOAD_BYTE(stateMode, offset, data, r);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum =682;
} // namespace

MapperInfo MapperInfo_682 ={
	&mapperNum,
	_T("Rainbow Mapper"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};
