#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_VRC24.h"

namespace {
uint8_t reg;

void sync (void) {
	if (reg &0x04) {
		if (reg &0x08) {
			EMU->SetPRG_ROM16(0x8, VRC24::prg[0] >>1 &0x07 | reg <<3);
			EMU->SetPRG_ROM16(0xC, VRC24::prg[0] >>1 &0x07 | reg <<3);
		} else
			EMU->SetPRG_ROM32(0x8, VRC24::prg[0] >>2 & 0x03 | reg <<2);
	} else
		VRC24::syncPRG(0x0F, reg <<4);
	VRC24::syncCHR(0x7F, reg <<7);
	VRC24::syncMirror();
}

void MAPINT writeReg (int bank, int addr, int val) {
	if (~reg &0x01) {
		reg =addr &0xFF;
		sync();
	}
	EMU->WritePRG(bank, addr, val);
}

BOOL MAPINT load (void) {
	iNES_SetSRAM();
	VRC24::load(sync, true, 0x04, 0x08, NULL, true, 0);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	reg =0;
	VRC24::reset(resetType);
	for (int bank =0x6; bank <=0x7; bank++) EMU->SetCPUWriteHandler(bank, writeReg);
}

uint16_t MapperNum =599;
} // namespace

MapperInfo MapperInfo_599 = {
	&MapperNum,
	_T("GC007"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	VRC24::cpuCycle,
	NULL,
	VRC24::saveLoad,
	NULL,
	NULL
};