﻿#include "..\DLL\d_iNES.h"
/* tape

5100 D2 save 4016 D2
5300 D2 load 4016 D1
*/
namespace DongdaLarge {
uint8_t unshuffled[0x8000];
uint8_t reg;
uint8_t high;
uint8_t protectionIndex;
bool pa00;
bool pa09;
bool pa13;

void sync (void) {
	EMU->SetPRG_RAM8(0x6, 0);
	if (reg &0x10) {
		EMU->SetPRG_ROM32(0x8, high <<1 &0x10 | reg &0x07);
	} else {
		if (reg &0x40)
			EMU->SetPRG_ROM8(0x8, 0x20 | reg >>1 &0x10 | reg &0x0F);
		else {
			EMU->SetPRG_Ptr4(0x8, &unshuffled[0x0000], FALSE);
			EMU->SetPRG_Ptr4(0x9, &unshuffled[0x1000], FALSE);
		}
		EMU->SetPRG_Ptr4(0xA, &unshuffled[0x2000], FALSE);
		EMU->SetPRG_Ptr4(0xB, &unshuffled[0x3000], FALSE);
		EMU->SetPRG_Ptr4(0xC, &unshuffled[0x4000], FALSE);
		EMU->SetPRG_Ptr4(0xD, &unshuffled[0x5000], FALSE);
		EMU->SetPRG_Ptr4(0xE, &unshuffled[0x6000], FALSE);
		EMU->SetPRG_Ptr4(0xF, &unshuffled[0x7000], FALSE);
	}
	EMU->SetCHR_RAM8(0x0, 0);
	if (reg &0x40 && ~reg &0x20 && reg &0x10 && reg &0x08)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

void latchBits (int bank, int addr) { // During rising edge of PPU A13, PPU A9 is latched.
	bool pa13new =!!(bank &8);
	if (!pa13 && pa13new) {
		pa00 =!!(addr &0x001);
		pa09 =!!(addr &0x200);
	}
	pa13 =pa13new;
}

int MAPINT trapPPURead (int bank, int addr) {
	latchBits(bank, addr);
	if (reg &0x80 && !pa13)
		return EMU->ReadCHR(bank &3 | (pa09? 4: 0), addr &~8 | (pa00? 8: 0));
	else
		return EMU->ReadCHR(bank, addr);
}

void MAPINT trapPPUWrite (int bank, int addr, int val) {
	latchBits(bank, addr);
	EMU->WriteCHR(bank, addr, val);
}

int MAPINT readReg (int, int addr) {
	static const uint8_t protectionLUT[16] = { 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 };
	int result =*EMU->OpenBus;
	switch(addr >>8 &7) {
		case 3:
			result = result &~0x04 | EMU->tapeIn() *0x04;
			break;
		case 5:
			result = protectionLUT[protectionIndex >>4] | ROM->dipValue;
			break;
	}
	return result;
}

void MAPINT writeReg (int, int addr, int val) {
	switch(addr >>8 &7) {
		case 0:
			reg = val;
			sync();
			break;
		case 1:
			high = val;
			EMU->tapeOut(!!(val &0x04));
			break;
		case 4:
			protectionIndex = val;
			break;
	}
}

BOOL MAPINT load (void) {
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	if (resetType == RESET_HARD) {
		reg = 0;
		high = 0;
		protectionIndex = 0;
		for (int bank = 0; bank < 32; bank++)
			for (int offset = 0; offset < 1024; offset++)
				unshuffled[bank <<10 | offset] = ROM->PRGROMData[0x41C00 | bank <<13 | offset];
	}
	pa00 = pa09 = pa13 = false;
	sync();
	EMU->SetCPUReadHandler(0x5, readReg);
	EMU->SetCPUWriteHandler(0x5, writeReg);
	for (int bank = 0; bank < 12; bank++) {
		EMU->SetPPUReadHandler(bank, trapPPURead);
		EMU->SetPPUReadHandlerDebug(bank, EMU->ReadCHRDebug);
		EMU->SetPPUWriteHandler(bank, trapPPUWrite);
	}
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	SAVELOAD_BYTE(stateMode, offset, data, protectionIndex);
	SAVELOAD_BOOL(stateMode, offset, data, pa00);
	SAVELOAD_BOOL(stateMode, offset, data, pa09);
	SAVELOAD_BOOL(stateMode, offset, data, pa13);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 257;

MapperInfo MapperInfo_DongdaLarge ={
	&mapperNum,
	_T("东达 PEC-586 (Large)"),
	COMPAT_FULL,
	load,
	reset,
	::Unload,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};
} // namespace
