#include "..\DLL\d_iNES.h"
#include "..\Hardware\h_FlashROM.h"

namespace {
FlashROM *flash = NULL;
uint8_t reg;

void sync (void) {
	EMU->SetPRG_RAM8(0x6, 0);
	EMU->SetPRG_ROM16(0x8, reg &0x1F);
	EMU->SetPRG_ROM16(0xC, 0xFF);
	EMU->SetCHR_RAM8(0x0, 0);
	EMU->SetCHR_RAM8(0x8, 1);
}

int MAPINT readFlash (int bank, int addr) {
	return flash->read(bank, addr);
}

void MAPINT writeFlash (int bank, int addr, int val) {
	flash->write(bank, bank <<12 &0x3000 | reg <<14 &0x4000 | addr, val);
}

void MAPINT writeReg (int, int, int val) {
	reg = reg >>1 | val <<4 &0x10;
	sync();
}

BOOL MAPINT load () {
	ROM->ChipRAMData = ROM->PRGROMData;
	ROM->ChipRAMSize = ROM->PRGROMSize;
	flash = new FlashROM(0xBF, 0xB7, ROM->ChipRAMData, ROM->ChipRAMSize, 4096);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	reg = 0;
	sync();
	for (int bank = 0x8; bank <= 0xB; bank++) {
		EMU->SetCPUReadHandler(bank, readFlash);
		EMU->SetCPUReadHandlerDebug(bank, readFlash);
		EMU->SetCPUWriteHandler(bank, writeFlash);
	}
	for (int bank = 0xC; bank <= 0xF; bank++)
		EMU->SetCPUWriteHandler(bank, writeReg);
}

void MAPINT unload (void) {
	if (flash) {
		delete flash;
		flash = NULL;
	}
}

void MAPINT cpuCycle() {
	flash->cpuCycle();
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 595;
} // namespace

MapperInfo MapperInfo_595 = {
	&mapperNum,
	_T("4MROM-512"),
	COMPAT_FULL,
	load,
	reset,
	unload,
	cpuCycle,
	NULL,
	saveLoad,
	NULL,
	NULL
};
