#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_MMC3.h"

namespace {
uint8_t reg;

void sync (void) {
	if (reg &0x01)
		MMC3::syncPRG(0x0F, reg >>2 &~0x0F);
	else
		EMU->SetPRG_ROM32(0x8, reg >>4);
	MMC3::syncCHR_ROM(0x7F, reg <<1 &~0x7F);
	MMC3::syncMirror();
}

void MAPINT writeReg (int bank, int addr, int val) {
	reg =val;
	sync();
}

BOOL MAPINT load (void) {
	MMC3::load(sync);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	reg =0x00;
	MMC3::reset(RESET_HARD);
	MMC3::setWRAMCallback(NULL, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset =MMC3::saveLoad(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum =49;
} // namespace

MapperInfo MapperInfo_049 ={
	&mapperNum,
	_T("820401/T-217"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};
