#include	"..\..\DLL\d_iNES.h"
#include	"..\..\Hardware\h_MMC3.h"

namespace {
uint8_t		reg;

/*
$6000.A1 | $6000.A0 | PRG A18 | PRG A17 | CHR A18 | CHR A17
    0    |     0    |    0    |    0    |    0    |    M	Street Fighter
    1    |     0    |    0    |    1    |    1    |    1	Mitsume ga Tooru
    1    |     1    |    1    |    M    |    1    |    0	Captain Tsubasa II
*/
void	sync (void) {
	int prgAND =~reg &3? 0x0F: 0x1F;
	int chrAND = reg &3? 0x7F: 0xFF; // 256 KiB if reg ==0, otherwise 128 KiB
	int prgOR  = reg <<5 &0x20  | reg <<3 &0x10;
	int chrOR  = reg <<7 &0x100 |~reg <<7 &0x80;
	MMC3::syncPRG(prgAND, prgOR &~prgAND);
	MMC3::syncCHR(chrAND, chrOR &~chrAND);
	MMC3::syncMirror();
}

void	MAPINT	writeReg (int bank, int addr, int val) {
	reg =addr &3;
	sync();
}

BOOL	MAPINT	load (void) {
	MMC3::load(sync);
	return TRUE;
}

void	MAPINT	reset (RESET_TYPE resetType) {
	reg =0;
	MMC3::reset(RESET_HARD);
	MMC3::setWRAMCallback(NULL, writeReg);
}

int	MAPINT	saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum =736;
} // namespace

MapperInfo MapperInfo_736 = {
	&mapperNum,
	_T("GA-009"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};
