/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.admin;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.connectcontroller.ConnectController;
import org.emulinker.kaillera.model.KailleraServer;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.util.InetAddrPort;
import org.picocontainer.Startable;

public class KailleraAdminHttpServer
implements Startable {
    private static Log log = LogFactory.getLog(KailleraAdminHttpServer.class);
    protected Server appServer = new Server();

    public KailleraAdminHttpServer(Configuration config, ThreadPoolExecutor threadPool, ConnectController connectController, KailleraServer kailleraServer) throws Exception {
        int port = config.getInt("adminserver.httpport");
        String jspDir = config.getString("adminserver.jspdir");
        this.appServer = new Server();
        this.appServer.addListener(new InetAddrPort(port));
        ServletHttpContext context = (ServletHttpContext)this.appServer.getContext(jspDir);
        context.setAttribute("threadPool", (Object)threadPool);
        context.setAttribute("connectController", (Object)connectController);
        context.setAttribute("kailleraServer", (Object)kailleraServer);
        this.setupSecurity(context, config);
        context.addHandler((HttpHandler)new ServletHandler());
        context.addHandler((HttpHandler)new ResourceHandler());
        context.addHandler((HttpHandler)new NotFoundHandler());
        context.setResourceBase(jspDir);
        context.addServlet("JSP", "*.jsp", "org.apache.jasper.servlet.JspServlet");
    }

    private void setupSecurity(ServletHttpContext context, Configuration config) throws IOException {
        boolean isSecurity = config.getBoolean("adminserver.authenticate", false);
        if (isSecurity) {
            String userFile;
            log.info((Object)"Configuring admin server security.");
            String realmName = config.getString("adminserver.realmname");
            if (realmName == null || realmName.trim().length() == 0) {
                realmName = "Emulinker";
            }
            if ((userFile = config.getString("adminserver.userfile")) == null || userFile.trim().length() == 0) {
                userFile = "conf/user.properties";
            }
            log.info((Object)("Establishing realm " + realmName));
            log.info((Object)("Loading usernames and passwords from " + userFile));
            SecurityHandler sh = new SecurityHandler();
            sh.setAuthMethod("BASIC");
            sh.setName(realmName);
            context.addHandler((HttpHandler)sh);
            SecurityConstraint sc = new SecurityConstraint();
            sc.setAuthenticate(true);
            sc.setName("BASIC");
            sc.addRole("*");
            context.addSecurityConstraint("/*", sc);
            HashUserRealm hur = new HashUserRealm();
            hur.setName(realmName);
            hur.load(userFile);
            context.setRealm((UserRealm)hur);
        } else {
            log.info((Object)"Admin server security is disabled.");
        }
    }

    public void start() {
        log.info((Object)"Starting Web-based Admin Interface.");
        if (!this.appServer.isStarted()) {
            try {
                this.appServer.start();
            }
            catch (Exception e) {
                log.error((Object)("Failed to start admin server: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void stop() {
        log.info((Object)"Stoping!");
        if (this.appServer.isStarted()) {
            try {
                this.appServer.stop();
            }
            catch (Exception e) {
                log.error((Object)("Failed to stop admin server: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

