/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.connectcontroller;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.kaillera.controller.KailleraServerController;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage_HELLO;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage_HELLOD00D;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage_PING;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage_PONG;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage_TOO;
import org.emulinker.kaillera.controller.messaging.ByteBufferMessage;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.model.exception.NewConnectionException;
import org.emulinker.kaillera.model.exception.ServerFullException;
import org.emulinker.net.BindException;
import org.emulinker.net.UDPServer;
import org.emulinker.util.EmuUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectController
extends UDPServer {
    private static Log log = LogFactory.getLog(ConnectController.class);
    private ThreadPoolExecutor threadPool;
    private AccessManager accessManager;
    private Map<String, KailleraServerController> controllersMap;
    private int bufferSize = 0;
    private long startTime;
    private int requestCount = 0;
    private int messageFormatErrorCount = 0;
    private int protocolErrorCount = 0;
    private int deniedServerFullCount = 0;
    private int deniedOtherCount = 0;
    private String lastAddress = null;
    private int lastAddressCount = 0;
    private int failedToStartCount = 0;
    private int connectedCount = 0;
    private int pingCount = 0;

    public ConnectController(ThreadPoolExecutor threadPool, KailleraServerController[] controllersArray, AccessManager accessManager, Configuration config) throws NoSuchElementException, ConfigurationException, BindException {
        super(true);
        this.threadPool = threadPool;
        this.accessManager = accessManager;
        int port = config.getInt("controllers.connect.port");
        this.bufferSize = config.getInt("controllers.connect.bufferSize");
        if (this.bufferSize <= 0) {
            throw new ConfigurationException("controllers.connect.bufferSize must be > 0");
        }
        this.controllersMap = new HashMap<String, KailleraServerController>();
        KailleraServerController[] kailleraServerControllerArray = controllersArray;
        int n = controllersArray.length;
        int n2 = 0;
        while (n2 < n) {
            KailleraServerController controller = kailleraServerControllerArray[n2];
            String[] clientTypes = controller.getClientTypes();
            int j = 0;
            while (j < clientTypes.length) {
                log.debug((Object)("Mapping client type " + clientTypes[j] + " to " + controller));
                this.controllersMap.put(clientTypes[j], controller);
                ++j;
            }
            ++n2;
        }
        super.bind(port);
        System.out.println("Ready to accept connections on port " + port);
        log.info((Object)("Ready to accept connections on port " + port));
    }

    public KailleraServerController getController(String clientType) {
        return this.controllersMap.get(clientType);
    }

    public Collection<KailleraServerController> getControllers() {
        return this.controllersMap.values();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getMessageFormatErrorCount() {
        return this.messageFormatErrorCount;
    }

    public int getProtocolErrorCount() {
        return this.protocolErrorCount;
    }

    public int getDeniedServerFullCount() {
        return this.deniedServerFullCount;
    }

    public int getDeniedOtherCount() {
        return this.deniedOtherCount;
    }

    public int getFailedToStartCount() {
        return this.failedToStartCount;
    }

    public int getConnectCount() {
        return this.connectedCount;
    }

    public int getPingCount() {
        return this.pingCount;
    }

    @Override
    protected ByteBuffer getBuffer() {
        return ByteBufferMessage.getBuffer(this.bufferSize);
    }

    @Override
    protected void releaseBuffer(ByteBuffer buffer) {
        ByteBufferMessage.releaseBuffer(buffer);
    }

    public String toString() {
        if (this.getBindPort() > 0) {
            return "ConnectController(" + this.getBindPort() + ")";
        }
        return "ConnectController(unbound)";
    }

    @Override
    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
        log.debug((Object)(String.valueOf(this.toString()) + " Thread starting (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        this.threadPool.execute(this);
        Thread.yield();
        log.debug((Object)(String.valueOf(this.toString()) + " Thread started (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
    }

    @Override
    public synchronized void stop() {
        super.stop();
        for (KailleraServerController controller : this.controllersMap.values()) {
            controller.stop();
        }
    }

    @Override
    protected synchronized void handleReceived(ByteBuffer buffer, InetSocketAddress fromSocketAddress) {
        ++this.requestCount;
        ConnectMessage inMessage = null;
        try {
            inMessage = ConnectMessage.parse(buffer);
        }
        catch (MessageFormatException e) {
            ++this.messageFormatErrorCount;
            buffer.rewind();
            log.warn((Object)("Received invalid message from " + EmuUtil.formatSocketAddress(fromSocketAddress) + ": " + EmuUtil.dumpBuffer(buffer)));
            return;
        }
        if (inMessage instanceof ConnectMessage_PING) {
            ++this.pingCount;
            log.debug((Object)("Ping from: " + EmuUtil.formatSocketAddress(fromSocketAddress)));
            this.send(new ConnectMessage_PONG(), fromSocketAddress);
            return;
        }
        if (!(inMessage instanceof ConnectMessage_HELLO)) {
            ++this.messageFormatErrorCount;
            log.warn((Object)("Received unexpected message type from " + EmuUtil.formatSocketAddress(fromSocketAddress) + ": " + inMessage));
            return;
        }
        ConnectMessage_HELLO connectMessage = (ConnectMessage_HELLO)inMessage;
        KailleraServerController protocolController = this.getController(connectMessage.getProtocol());
        if (protocolController == null) {
            ++this.protocolErrorCount;
            log.error((Object)("Client requested an unhandled protocol " + EmuUtil.formatSocketAddress(fromSocketAddress) + ": " + connectMessage.getProtocol()));
            return;
        }
        if (!this.accessManager.isAddressAllowed(fromSocketAddress.getAddress())) {
            ++this.deniedOtherCount;
            log.warn((Object)("AccessManager denied connection from " + EmuUtil.formatSocketAddress(fromSocketAddress)));
            return;
        }
        int privatePort = -1;
        int access = this.accessManager.getAccess(fromSocketAddress.getAddress());
        try {
            if (access < 4 && this.connectedCount > 0) {
                if (this.lastAddress.equals(fromSocketAddress.getAddress().getHostAddress())) {
                    ++this.lastAddressCount;
                    if (this.lastAddressCount >= 4) {
                        this.lastAddressCount = 0;
                        ++this.failedToStartCount;
                        log.debug((Object)("SF MOD: HAMMER PROTECTION (2 Min Ban): " + EmuUtil.formatSocketAddress(fromSocketAddress)));
                        this.accessManager.addTempBan(fromSocketAddress.getAddress().getHostAddress(), 2);
                        return;
                    }
                } else {
                    this.lastAddress = fromSocketAddress.getAddress().getHostAddress();
                    this.lastAddressCount = 0;
                }
            } else {
                this.lastAddress = fromSocketAddress.getAddress().getHostAddress();
            }
            if ((privatePort = protocolController.newConnection(fromSocketAddress, connectMessage.getProtocol())) <= 0) {
                ++this.failedToStartCount;
                log.error((Object)(protocolController + " failed to start for " + EmuUtil.formatSocketAddress(fromSocketAddress)));
                return;
            }
            ++this.connectedCount;
            log.debug((Object)(protocolController + " allocated port " + privatePort + " to client from " + fromSocketAddress.getAddress().getHostAddress()));
            this.send(new ConnectMessage_HELLOD00D(privatePort), fromSocketAddress);
        }
        catch (ServerFullException e) {
            ++this.deniedServerFullCount;
            log.debug((Object)("Sending server full response to " + EmuUtil.formatSocketAddress(fromSocketAddress)));
            this.send(new ConnectMessage_TOO(), fromSocketAddress);
            return;
        }
        catch (NewConnectionException e) {
            ++this.deniedOtherCount;
            log.warn((Object)(protocolController + " denied connection from " + EmuUtil.formatSocketAddress(fromSocketAddress) + ": " + e.getMessage()));
            return;
        }
    }

    protected void send(ConnectMessage outMessage, InetSocketAddress toSocketAddress) {
        this.send(outMessage.toBuffer(), toSocketAddress);
        outMessage.releaseBuffer();
    }
}

