/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.master.client;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.connectcontroller.ConnectController;
import org.emulinker.kaillera.master.PublicServerInformation;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.master.client.EmuLinkerMasterUpdateTask;
import org.emulinker.kaillera.master.client.KailleraMasterUpdateTask;
import org.emulinker.kaillera.master.client.MasterListUpdater;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.release.ReleaseInfo;
import org.emulinker.util.Executable;
import org.picocontainer.Startable;

public class MasterListUpdaterImpl
implements MasterListUpdater,
Executable,
Startable {
    private static Log log = LogFactory.getLog(MasterListUpdaterImpl.class);
    private ThreadPoolExecutor threadPool;
    private ConnectController connectController;
    private KailleraServer kailleraServer;
    private StatsCollector statsCollector;
    private ReleaseInfo releaseInfo;
    private PublicServerInformation publicInfo;
    private boolean touchKaillera = false;
    private boolean touchEmulinker = false;
    private EmuLinkerMasterUpdateTask emulinkerMasterTask;
    private KailleraMasterUpdateTask kailleraMasterTask;
    private boolean stopFlag = false;
    private boolean isRunning = false;

    public MasterListUpdaterImpl(Configuration config, ThreadPoolExecutor threadPool, ConnectController connectController, KailleraServer kailleraServer, StatsCollector statsCollector, ReleaseInfo releaseInfo) throws Exception {
        this.threadPool = threadPool;
        this.connectController = connectController;
        this.kailleraServer = kailleraServer;
        this.statsCollector = statsCollector;
        this.releaseInfo = releaseInfo;
        this.touchKaillera = config.getBoolean("masterList.touchKaillera", false);
        this.touchEmulinker = config.getBoolean("masterList.touchEmulinker", false);
        if (this.touchKaillera || this.touchEmulinker) {
            this.publicInfo = new PublicServerInformation(config);
        }
        if (this.touchKaillera) {
            this.kailleraMasterTask = new KailleraMasterUpdateTask(this.publicInfo, connectController, kailleraServer, statsCollector, releaseInfo);
        }
        if (this.touchEmulinker) {
            this.emulinkerMasterTask = new EmuLinkerMasterUpdateTask(this.publicInfo, connectController, kailleraServer, releaseInfo);
        }
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized String toString() {
        return "MasterListUpdaterImpl[touchKaillera=" + this.touchKaillera + " touchEmulinker=" + this.touchEmulinker + "]";
    }

    public synchronized void start() {
        if (this.publicInfo != null) {
            log.debug((Object)"MasterListUpdater thread received start request!");
            log.debug((Object)("MasterListUpdater thread starting (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
            this.threadPool.execute(this);
            Thread.yield();
            log.debug((Object)("MasterListUpdater thread started (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        }
    }

    public synchronized void stop() {
        if (this.publicInfo != null) {
            log.debug((Object)"MasterListUpdater thread received stop request!");
            if (!this.isRunning()) {
                log.debug((Object)"MasterListUpdater thread stop request ignored: not running!");
                return;
            }
            this.stopFlag = true;
        }
    }

    public void run() {
        this.isRunning = true;
        log.debug((Object)"MasterListUpdater thread running...");
        try {
            while (!this.stopFlag) {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stopFlag) {
                    break;
                }
                log.info((Object)"MasterListUpdater touching masters...");
                List createdGamesList = this.statsCollector.getStartedGamesList();
                if (this.emulinkerMasterTask != null) {
                    this.emulinkerMasterTask.touchMaster();
                }
                if (this.kailleraMasterTask != null) {
                    this.kailleraMasterTask.touchMaster();
                }
                this.statsCollector.clearStartedGamesList();
            }
        }
        finally {
            this.isRunning = false;
            log.debug((Object)"MasterListUpdater thread exiting...");
        }
    }
}

