/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.access;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessException;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.util.WildcardStringPattern;
import org.picocontainer.Startable;

public class AccessManager2
implements AccessManager,
Startable,
Runnable {
    private static Log log;
    private ThreadPoolExecutor threadPool;
    private boolean isRunning = false;
    private boolean stopFlag = false;
    private File accessFile;
    private long lastLoadModifiedTime = -1L;
    private List<UserAccess> userList = new CopyOnWriteArrayList<UserAccess>();
    private List<GameAccess> gameList = new CopyOnWriteArrayList<GameAccess>();
    private List<EmulatorAccess> emulatorList = new CopyOnWriteArrayList<EmulatorAccess>();
    private List<AddressAccess> addressList = new CopyOnWriteArrayList<AddressAccess>();
    private List<TempBan> tempBanList = new CopyOnWriteArrayList<TempBan>();
    private List<TempAdmin> tempAdminList = new CopyOnWriteArrayList<TempAdmin>();
    private List<TempModerator> tempModeratorList = new CopyOnWriteArrayList<TempModerator>();
    private List<TempElevated> tempElevatedList = new CopyOnWriteArrayList<TempElevated>();
    private List<Silence> silenceList = new CopyOnWriteArrayList<Silence>();

    static {
        Security.setProperty("networkaddress.cache.ttl", "60");
        Security.setProperty("networkaddress.cache.negative.ttl", "60");
        log = LogFactory.getLog(AccessManager2.class);
    }

    public AccessManager2(ThreadPoolExecutor threadPool) throws NoSuchElementException, FileNotFoundException {
        this.threadPool = threadPool;
        URL url = AccessManager2.class.getResource("/access.cfg");
        if (url == null) {
            throw new FileNotFoundException("Resource not found: /access.conf");
        }
        try {
            this.accessFile = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        if (!this.accessFile.exists()) {
            throw new FileNotFoundException("Resource not found: /access.conf");
        }
        if (!this.accessFile.canRead()) {
            throw new FileNotFoundException("Can not read: /access.conf");
        }
        this.loadAccess();
        threadPool.execute(this);
    }

    public synchronized void start() {
        log.debug((Object)"AccessManager2 thread received start request!");
        log.debug((Object)("AccessManager2 thread starting (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        this.threadPool.execute(this);
        Thread.yield();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void stop() {
        log.debug((Object)"AccessManager2 thread received stop request!");
        if (!this.isRunning()) {
            log.debug((Object)"KailleraServer thread stop request ignored: not running!");
            return;
        }
        this.stopFlag = true;
        this.userList.clear();
        this.gameList.clear();
        this.emulatorList.clear();
        this.addressList.clear();
        this.tempBanList.clear();
        this.tempElevatedList.clear();
        this.tempAdminList.clear();
        this.silenceList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        log.debug((Object)"AccessManager2 thread running...");
        try {
            try {
                while (!this.stopFlag) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Sleep Interrupted!", (Throwable)e);
                    }
                    if (this.stopFlag) {
                        break;
                    }
                    AccessManager2 e = this;
                    synchronized (e) {
                        for (TempBan tempBan : this.tempBanList) {
                            if (!tempBan.isExpired()) continue;
                            this.tempBanList.remove(tempBan);
                        }
                        for (TempAdmin tempAdmin : this.tempAdminList) {
                            if (!tempAdmin.isExpired()) continue;
                            this.tempAdminList.remove(tempAdmin);
                        }
                        for (TempModerator tempModerator : this.tempModeratorList) {
                            if (!tempModerator.isExpired()) continue;
                            this.tempModeratorList.remove(tempModerator);
                        }
                        for (TempElevated tempElevated : this.tempElevatedList) {
                            if (!tempElevated.isExpired()) continue;
                            this.tempElevatedList.remove(tempElevated);
                        }
                        for (Silence silence : this.silenceList) {
                            if (!silence.isExpired()) continue;
                            this.silenceList.remove(silence);
                        }
                        for (UserAccess userAccess : this.userList) {
                            userAccess.refreshDNS();
                        }
                        for (AddressAccess addressAccess : this.addressList) {
                            addressAccess.refreshDNS();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!this.stopFlag) {
                    log.fatal((Object)("AccessManager2 thread caught unexpected exception: " + e), e);
                }
                this.isRunning = false;
                log.debug((Object)"AccessManager2 thread exiting...");
            }
        }
        finally {
            this.isRunning = false;
            log.debug((Object)"AccessManager2 thread exiting...");
        }
    }

    private synchronized void checkReload() {
        if (this.accessFile != null && this.accessFile.lastModified() > this.lastLoadModifiedTime) {
            this.loadAccess();
        }
    }

    private synchronized void loadAccess() {
        if (this.accessFile == null) {
            return;
        }
        log.info((Object)"Reloading permissions...");
        this.lastLoadModifiedTime = this.accessFile.lastModified();
        this.userList.clear();
        this.gameList.clear();
        this.emulatorList.clear();
        this.addressList.clear();
        try {
            FileInputStream file = new FileInputStream(this.accessFile);
            InputStreamReader temp = new InputStreamReader((InputStream)file, System.getProperty("emulinker.charset"));
            BufferedReader reader = new BufferedReader(temp);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                if (st.countTokens() < 3) {
                    log.error((Object)("Failed to load access line, too few tokens: " + line));
                    continue;
                }
                String type = st.nextToken();
                try {
                    if (type.equalsIgnoreCase("user")) {
                        this.userList.add(new UserAccess(st));
                        continue;
                    }
                    if (type.equalsIgnoreCase("game")) {
                        this.gameList.add(new GameAccess(st));
                        continue;
                    }
                    if (type.equalsIgnoreCase("emulator")) {
                        this.emulatorList.add(new EmulatorAccess(st));
                        continue;
                    }
                    if (type.equalsIgnoreCase("ipaddress")) {
                        this.addressList.add(new AddressAccess(st));
                        continue;
                    }
                    throw new Exception("Unrecognized access type: " + type);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to load access line: " + e.getMessage() + ": " + line));
                }
            }
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)("Failed to load access file: " + e.getMessage()), (Throwable)e);
        }
    }

    public void addTempBan(String addressPattern, int minutes) {
        this.tempBanList.add(new TempBan(addressPattern, minutes));
    }

    public void addTempAdmin(String addressPattern, int minutes) {
        this.tempAdminList.add(new TempAdmin(addressPattern, minutes));
    }

    public void addTempModerator(String addressPattern, int minutes) {
        this.tempModeratorList.add(new TempModerator(addressPattern, minutes));
    }

    public void addTempElevated(String addressPattern, int minutes) {
        this.tempElevatedList.add(new TempElevated(addressPattern, minutes));
    }

    public void addSilenced(String addressPattern, int minutes) {
        this.silenceList.add(new Silence(addressPattern, minutes));
    }

    public synchronized String getAnnouncement(InetAddress address) {
        this.checkReload();
        String userAddress = address.getHostAddress();
        for (UserAccess userAccess : this.userList) {
            if (!userAccess.matches(userAddress)) continue;
            return userAccess.getMessage();
        }
        return null;
    }

    public synchronized int getAccess(InetAddress address) {
        this.checkReload();
        String userAddress = address.getHostAddress();
        for (TempAdmin tempAdmin : this.tempAdminList) {
            if (!tempAdmin.matches(userAddress) || tempAdmin.isExpired()) continue;
            return 4;
        }
        for (TempModerator tempModerator : this.tempModeratorList) {
            if (!tempModerator.matches(userAddress) || tempModerator.isExpired()) continue;
            return 3;
        }
        for (TempElevated tempElevated : this.tempElevatedList) {
            if (!tempElevated.matches(userAddress) || tempElevated.isExpired()) continue;
            return 2;
        }
        for (UserAccess userAccess : this.userList) {
            if (!userAccess.matches(userAddress)) continue;
            return userAccess.getAccess();
        }
        return 1;
    }

    public synchronized boolean clearTemp(InetAddress address, boolean clearAll) {
        String userAddress = address.getHostAddress();
        boolean found = false;
        for (Silence silence : this.silenceList) {
            if (!silence.matches(userAddress)) continue;
            this.silenceList.remove(silence);
            found = true;
        }
        for (TempBan tempBan : this.tempBanList) {
            if (!tempBan.matches(userAddress) || tempBan.isExpired()) continue;
            this.tempBanList.remove(tempBan);
            found = true;
        }
        if (clearAll) {
            for (TempElevated tempElevated : this.tempElevatedList) {
                if (!tempElevated.matches(userAddress)) continue;
                this.tempElevatedList.remove(tempElevated);
                found = true;
            }
            for (TempModerator tempModerator : this.tempModeratorList) {
                if (!tempModerator.matches(userAddress)) continue;
                this.tempModeratorList.remove(tempModerator);
                found = true;
            }
            for (TempAdmin tempAdmin : this.tempAdminList) {
                if (!tempAdmin.matches(userAddress)) continue;
                this.tempAdminList.remove(tempAdmin);
                found = true;
            }
        }
        return found;
    }

    public synchronized boolean isSilenced(InetAddress address) {
        this.checkReload();
        String userAddress = address.getHostAddress();
        for (Silence silence : this.silenceList) {
            if (!silence.matches(userAddress) || silence.isExpired()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isAddressAllowed(InetAddress address) {
        this.checkReload();
        String userAddress = address.getHostAddress();
        for (TempBan tempBan : this.tempBanList) {
            if (!tempBan.matches(userAddress) || tempBan.isExpired()) continue;
            return false;
        }
        for (AddressAccess addressAccess : this.addressList) {
            if (!addressAccess.matches(userAddress)) continue;
            return addressAccess.getAccess();
        }
        return true;
    }

    public synchronized boolean isEmulatorAllowed(String emulator) {
        this.checkReload();
        for (EmulatorAccess emulatorAccess : this.emulatorList) {
            if (!emulatorAccess.matches(emulator)) continue;
            return emulatorAccess.getAccess();
        }
        return true;
    }

    public synchronized boolean isGameAllowed(String game) {
        this.checkReload();
        for (GameAccess gameAccess : this.gameList) {
            if (!gameAccess.matches(game)) continue;
            return gameAccess.getAccess();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AddressAccess {
        protected List<WildcardStringPattern> patterns;
        protected List<String> hostNames;
        protected List<String> resolvedAddresses;
        protected boolean access;

        protected AddressAccess(StringTokenizer st) throws Exception {
            if (st.countTokens() != 2) {
                throw new Exception("Wrong number of tokens: " + st.countTokens());
            }
            String accessStr = st.nextToken().toLowerCase();
            if (accessStr.equals("allow")) {
                this.access = true;
            } else if (accessStr.equals("deny")) {
                this.access = false;
            } else {
                throw new AccessException("Unrecognized access token: " + accessStr);
            }
            this.hostNames = new ArrayList<String>();
            this.resolvedAddresses = new ArrayList<String>();
            this.patterns = new ArrayList<WildcardStringPattern>();
            String s = st.nextToken().toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                String pat = pt.nextToken().toLowerCase();
                if (pat.startsWith("dns:")) {
                    if (pat.length() <= 5) {
                        throw new AccessException("Malformatted DNS entry: " + s);
                    }
                    String hostName = pat.substring(4);
                    try {
                        InetAddress a = InetAddress.getByName(hostName);
                        log.debug((Object)("Resolved " + hostName + " to " + a.getHostAddress()));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to resolve DNS entry to an address: " + hostName + ": " + e.getMessage()));
                    }
                    this.hostNames.add(pat.substring(4));
                    continue;
                }
                this.patterns.add(new WildcardStringPattern(pat));
            }
            this.refreshDNS();
        }

        protected synchronized void refreshDNS() {
            this.resolvedAddresses.clear();
            for (String hostName : this.hostNames) {
                try {
                    InetAddress address = InetAddress.getByName(hostName);
                    this.resolvedAddresses.add(address.getHostAddress());
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to resolve DNS entry to an address: " + hostName), (Throwable)e);
                }
            }
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected boolean getAccess() {
            return this.access;
        }

        protected synchronized boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            for (String resolvedAddress : this.resolvedAddresses) {
                if (!resolvedAddress.equals(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EmulatorAccess {
        protected List<WildcardStringPattern> patterns;
        protected boolean access;

        protected EmulatorAccess(StringTokenizer st) throws Exception {
            if (st.countTokens() != 2) {
                throw new Exception("Wrong number of tokens: " + st.countTokens());
            }
            String accessStr = st.nextToken().toLowerCase();
            if (accessStr.equals("allow")) {
                this.access = true;
            } else if (accessStr.equals("deny")) {
                this.access = false;
            } else {
                throw new AccessException("Unrecognized access token: " + accessStr);
            }
            this.patterns = new ArrayList<WildcardStringPattern>();
            String s = st.nextToken().toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected boolean getAccess() {
            return this.access;
        }

        protected boolean matches(String emulator) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(emulator.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GameAccess {
        protected List<WildcardStringPattern> patterns;
        protected boolean access;

        protected GameAccess(StringTokenizer st) throws Exception {
            if (st.countTokens() != 2) {
                throw new Exception("Wrong number of tokens: " + st.countTokens());
            }
            String accessStr = st.nextToken().toLowerCase();
            if (accessStr.equals("allow")) {
                this.access = true;
            } else if (accessStr.equals("deny")) {
                this.access = false;
            } else {
                throw new AccessException("Unrecognized access token: " + accessStr);
            }
            this.patterns = new ArrayList<WildcardStringPattern>();
            String s = st.nextToken().toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected boolean getAccess() {
            return this.access;
        }

        protected boolean matches(String game) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(game.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Silence {
        protected List<WildcardStringPattern> patterns = new ArrayList<WildcardStringPattern>();
        protected long startTime;
        protected int minutes;

        protected Silence(String accessStr, int minutes) {
            String s = accessStr.toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
            this.minutes = minutes;
            this.startTime = System.currentTimeMillis();
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected long getStartTime() {
            return this.startTime;
        }

        protected int getMinutes() {
            return this.minutes;
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + (long)(this.minutes * 60000);
        }

        protected boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TempAdmin {
        protected List<WildcardStringPattern> patterns = new ArrayList<WildcardStringPattern>();
        protected long startTime;
        protected int minutes;

        protected TempAdmin(String accessStr, int minutes) {
            String s = accessStr.toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
            this.minutes = minutes;
            this.startTime = System.currentTimeMillis();
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected long getStartTime() {
            return this.startTime;
        }

        protected int getMinutes() {
            return this.minutes;
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + (long)(this.minutes * 60000);
        }

        protected boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TempBan {
        protected List<WildcardStringPattern> patterns = new ArrayList<WildcardStringPattern>();
        protected long startTime;
        protected int minutes;

        protected TempBan(String accessStr, int minutes) {
            String s = accessStr.toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
            this.minutes = minutes;
            this.startTime = System.currentTimeMillis();
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected long getStartTime() {
            return this.startTime;
        }

        protected int getMinutes() {
            return this.minutes;
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + (long)(this.minutes * 60000);
        }

        protected boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TempElevated {
        protected List<WildcardStringPattern> patterns = new ArrayList<WildcardStringPattern>();
        protected long startTime;
        protected int minutes;

        protected TempElevated(String accessStr, int minutes) {
            String s = accessStr.toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
            this.minutes = minutes;
            this.startTime = System.currentTimeMillis();
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected long getStartTime() {
            return this.startTime;
        }

        protected int getMinutes() {
            return this.minutes;
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + (long)(this.minutes * 60000);
        }

        protected boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TempModerator {
        protected List<WildcardStringPattern> patterns = new ArrayList<WildcardStringPattern>();
        protected long startTime;
        protected int minutes;

        protected TempModerator(String accessStr, int minutes) {
            String s = accessStr.toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                this.patterns.add(new WildcardStringPattern(pt.nextToken().toLowerCase()));
            }
            this.minutes = minutes;
            this.startTime = System.currentTimeMillis();
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected long getStartTime() {
            return this.startTime;
        }

        protected int getMinutes() {
            return this.minutes;
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + (long)(this.minutes * 60000);
        }

        protected boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UserAccess {
        protected List<WildcardStringPattern> patterns;
        protected List<String> hostNames;
        protected List<String> resolvedAddresses;
        protected int access;
        protected String message;

        protected UserAccess(StringTokenizer st) throws Exception {
            if (st.countTokens() < 2 || st.countTokens() > 3) {
                throw new Exception("Wrong number of tokens: " + st.countTokens());
            }
            String accessStr = st.nextToken().toLowerCase();
            if (accessStr.equals("normal")) {
                this.access = 1;
            } else if (accessStr.equals("elevated")) {
                this.access = 2;
            } else if (accessStr.equals("moderator")) {
                this.access = 3;
            } else if (accessStr.equals("admin")) {
                this.access = 4;
            } else if (accessStr.equals("superadmin")) {
                this.access = 5;
            } else {
                throw new AccessException("Unrecognized access token: " + accessStr);
            }
            this.hostNames = new ArrayList<String>();
            this.resolvedAddresses = new ArrayList<String>();
            this.patterns = new ArrayList<WildcardStringPattern>();
            String s = st.nextToken().toLowerCase();
            StringTokenizer pt = new StringTokenizer(s, "|");
            while (pt.hasMoreTokens()) {
                String pat = pt.nextToken().toLowerCase();
                if (pat.startsWith("dns:")) {
                    if (pat.length() <= 5) {
                        throw new AccessException("Malformatted DNS entry: " + s);
                    }
                    String hostName = pat.substring(4);
                    try {
                        InetAddress a = InetAddress.getByName(hostName);
                        log.debug((Object)("Resolved " + hostName + " to " + a.getHostAddress()));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to resolve DNS entry to an address: " + hostName + ": " + e.getMessage()));
                    }
                    this.hostNames.add(pat.substring(4));
                    continue;
                }
                this.patterns.add(new WildcardStringPattern(pat));
            }
            this.refreshDNS();
            if (st.hasMoreTokens()) {
                this.message = st.nextToken();
            }
        }

        protected synchronized void refreshDNS() {
            this.resolvedAddresses.clear();
            for (String hostName : this.hostNames) {
                try {
                    InetAddress address = InetAddress.getByName(hostName);
                    this.resolvedAddresses.add(address.getHostAddress());
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to resolve DNS entry to an address: " + hostName), (Throwable)e);
                }
            }
        }

        protected List<WildcardStringPattern> getPatterns() {
            return this.patterns;
        }

        protected int getAccess() {
            return this.access;
        }

        protected String getMessage() {
            return this.message;
        }

        protected synchronized boolean matches(String address) {
            for (WildcardStringPattern pattern : this.patterns) {
                if (!pattern.match(address)) continue;
                return true;
            }
            for (String resolvedAddress : this.resolvedAddresses) {
                if (!resolvedAddress.equals(address)) continue;
                return true;
            }
            return false;
        }
    }
}

