/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.connectcontroller.protocol;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;

public class ConnectMessage_PONG
extends ConnectMessage {
    public static final String ID = "PONG";
    public static final String DESC = "Server Pong";
    private InetSocketAddress clientSocketAddress;

    public String getID() {
        return ID;
    }

    public String getDescription() {
        return DESC;
    }

    public void setClientSocketAddress(InetSocketAddress clientSocketAddress) {
        this.clientSocketAddress = clientSocketAddress;
    }

    public InetSocketAddress getClientSocketAddress() {
        return this.clientSocketAddress;
    }

    public String toString() {
        return DESC;
    }

    public int getLength() {
        return ID.length() + 1;
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.put(charset.encode(ID));
        buffer.put((byte)0);
    }

    public static ConnectMessage parse(String msg) throws MessageFormatException {
        if (msg.length() != 5) {
            throw new MessageFormatException("Invalid message length!");
        }
        if (!msg.startsWith(ID)) {
            throw new MessageFormatException("Invalid message identifier!");
        }
        if (msg.charAt(msg.length() - 1) != '\u0000') {
            throw new MessageFormatException("Invalid message stop byte!");
        }
        return new ConnectMessage_PONG();
    }
}

