/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.messaging;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ByteBufferMessage {
    protected static Log log = LogFactory.getLog(ByteBufferMessage.class);
    public static Charset charset = Charset.defaultCharset();
    private ByteBuffer buffer;

    static {
        String charsetName = System.getProperty("emulinker.charset");
        if (charsetName != null) {
            try {
                if (Charset.isSupported(charsetName)) {
                    charset = Charset.forName(charsetName);
                } else {
                    log.fatal((Object)("Charset " + charsetName + " is not supported!"));
                }
            }
            catch (Exception e) {
                log.fatal((Object)("Failed to load charset " + charsetName + ": " + e.getMessage()), (Throwable)e);
            }
        }
        log.info((Object)("Using character set: " + charset.displayName()));
    }

    public abstract int getLength();

    public abstract String getDescription();

    public abstract String toString();

    protected void initBuffer() {
        this.initBuffer(this.getLength());
    }

    private void initBuffer(int size) {
        this.buffer = ByteBufferMessage.getBuffer(size);
    }

    public void releaseBuffer() {
    }

    public ByteBuffer toBuffer() {
        this.initBuffer();
        this.writeTo(this.buffer);
        this.buffer.flip();
        return this.buffer;
    }

    public abstract void writeTo(ByteBuffer var1);

    public static ByteBuffer getBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    public static void releaseBuffer(ByteBuffer buffer) {
    }
}

