/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.CreateGame;
import org.emulinker.kaillera.controller.v086.protocol.CreateGame_Notification;
import org.emulinker.kaillera.controller.v086.protocol.CreateGame_Request;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.QuitGame_Notification;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.GameCreatedEvent;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.exception.CreateGameException;
import org.emulinker.kaillera.model.exception.FloodException;
import org.emulinker.util.EmuLang;

public class CreateGameAction
implements V086Action,
V086ServerEventHandler {
    private static Log log = LogFactory.getLog(CreateGameAction.class);
    private static final String desc = "CreateGameAction";
    private static CreateGameAction singleton = new CreateGameAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static CreateGameAction getInstance() {
        return singleton;
    }

    private CreateGameAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof CreateGame_Request)) {
            throw new FatalActionException("Received incorrect instance of CreateGame: " + message);
        }
        ++this.actionCount;
        CreateGame createGameMessage = (CreateGame)message;
        try {
            clientHandler.getUser().createGame(createGameMessage.getRomName());
        }
        catch (CreateGameException e) {
            log.info((Object)("Create Game Denied: " + clientHandler.getUser() + ": " + createGameMessage.getRomName()));
            try {
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("CreateGameAction.CreateGameDenied", e.getMessage())));
                clientHandler.send(new QuitGame_Notification(clientHandler.getNextMessageNumber(), clientHandler.getUser().getName(), clientHandler.getUser().getID()));
            }
            catch (MessageFormatException e2) {
                log.error((Object)("Failed to contruct message: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (FloodException e) {
            log.info((Object)("Create Game Denied: " + clientHandler.getUser() + ": " + createGameMessage.getRomName()));
            try {
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("CreateGameAction.CreateGameDeniedFloodControl")));
                clientHandler.send(new QuitGame_Notification(clientHandler.getNextMessageNumber(), clientHandler.getUser().getName(), clientHandler.getUser().getID()));
            }
            catch (MessageFormatException e2) {
                log.error((Object)("Failed to contruct message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameCreatedEvent gameCreatedEvent = (GameCreatedEvent)event;
        try {
            KailleraGame game = gameCreatedEvent.getGame();
            KailleraUser owner = game.getOwner();
            clientHandler.send(new CreateGame_Notification(clientHandler.getNextMessageNumber(), owner.getName(), game.getRomName(), owner.getClientType(), game.getID(), 0));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct CreateGame_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

