/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.GameKick;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.exception.GameKickException;

public class GameKickAction
implements V086Action {
    private static Log log = LogFactory.getLog(GameKickAction.class);
    private static final String desc = "GameKickAction";
    private static GameKickAction singleton = new GameKickAction();
    private int actionCount = 0;

    public static GameKickAction getInstance() {
        return singleton;
    }

    private GameKickAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        ++this.actionCount;
        GameKick kickRequest = (GameKick)message;
        try {
            clientHandler.getUser().gameKick(kickRequest.getUserID());
        }
        catch (GameKickException e) {
            log.debug((Object)("Failed to kick: " + e.getMessage()));
            try {
                clientHandler.send(new GameChat_Notification(clientHandler.getNextMessageNumber(), "Error", e.getMessage()));
            }
            catch (MessageFormatException ex) {
                log.error((Object)("Failed to contruct GameChat_Notification message: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

