/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.GameStatus;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.GameStatusChangedEvent;
import org.emulinker.kaillera.model.event.ServerEvent;

public class GameStatusAction
implements V086ServerEventHandler {
    private static Log log = LogFactory.getLog(GameStatusAction.class);
    private static final String desc = "GameStatusAction";
    private static GameStatusAction singleton = new GameStatusAction();
    private int handledCount = 0;

    public static GameStatusAction getInstance() {
        return singleton;
    }

    private GameStatusAction() {
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameStatusChangedEvent statusChangeEvent = (GameStatusChangedEvent)event;
        try {
            KailleraGame game = statusChangeEvent.getGame();
            int num = 0;
            for (KailleraUser kailleraUser : game.getPlayers()) {
                if (kailleraUser.getStealth()) continue;
                ++num;
            }
            clientHandler.send(new GameStatus(clientHandler.getNextMessageNumber(), game.getID(), 0, (byte)game.getStatus(), (byte)num, (byte)game.getMaxUsers()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct CreateGame_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

