/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.UnsignedUtil;

public class KeepAlive
extends V086Message {
    public static final byte ID = 9;
    public static final String DESC = "KeepAlive";
    private short val;

    public KeepAlive(int messageNumber) throws MessageFormatException {
        this(messageNumber, 0);
    }

    public KeepAlive(int messageNumber, short val) throws MessageFormatException {
        super(messageNumber);
        if (val < 0 || val > 255) {
            throw new MessageFormatException("Invalid " + this.getDescription() + " format: val out of acceptable range: " + val);
        }
        this.val = val;
    }

    public byte getID() {
        return 9;
    }

    public String getDescription() {
        return DESC;
    }

    public short getVal() {
        return this.val;
    }

    public String toString() {
        return String.valueOf(this.getInfoString()) + "[val=" + this.val + "]";
    }

    public int getBodyLength() {
        return 1;
    }

    public void writeBodyTo(ByteBuffer buffer) {
        UnsignedUtil.putUnsignedByte(buffer, this.val);
    }

    public static KeepAlive parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 1) {
            throw new ParseException("Failed byte count validation!");
        }
        return new KeepAlive(messageNumber, UnsignedUtil.getUnsignedByte(buffer));
    }
}

