/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.UnsignedUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStatus
extends V086Message {
    public static final byte ID = 4;
    public static final String DESC = "Server Status";
    private List<User> users;
    private List<Game> games;

    public ServerStatus(int messageNumber, List<User> users, List<Game> games) throws MessageFormatException {
        super(messageNumber);
        this.users = users;
        this.games = games;
    }

    @Override
    public byte getID() {
        return 4;
    }

    @Override
    public String getDescription() {
        return DESC;
    }

    public List getUsers() {
        return this.users;
    }

    public List getGames() {
        return this.games;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getInfoString()) + "[users=" + this.users.size() + " games=" + this.games.size() + "]");
        if (!this.users.isEmpty()) {
            sb.append(EmuUtil.LB);
        }
        for (User u : this.users) {
            sb.append("\t" + u);
            sb.append(EmuUtil.LB);
        }
        if (!this.games.isEmpty()) {
            sb.append(EmuUtil.LB);
        }
        for (Game g : this.games) {
            sb.append("\t" + g);
            sb.append(EmuUtil.LB);
        }
        return sb.toString();
    }

    @Override
    public int getBodyLength() {
        int len = 9;
        for (User u : this.users) {
            len += u.getLength();
        }
        for (Game g : this.games) {
            len += g.getLength();
        }
        return len;
    }

    @Override
    public void writeBodyTo(ByteBuffer buffer) {
        buffer.put((byte)0);
        buffer.putInt(this.users.size());
        buffer.putInt(this.games.size());
        for (User u : this.users) {
            u.writeTo(buffer);
        }
        for (Game g : this.games) {
            g.writeTo(buffer);
        }
    }

    public static ServerStatus parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 9) {
            throw new ParseException("Failed byte count validation!");
        }
        byte b = buffer.get();
        if (b != 0) {
            throw new MessageFormatException("Invalid Server Status format: byte 0 = " + EmuUtil.byteToHex(b));
        }
        int numUsers = buffer.getInt();
        int numGames = buffer.getInt();
        int minLen = numUsers * 10 + numGames * 13;
        if (buffer.remaining() < minLen) {
            throw new ParseException("Failed byte count validation!");
        }
        ArrayList<User> users = new ArrayList<User>(numUsers);
        int j = 0;
        while (j < numUsers) {
            if (buffer.remaining() < 9) {
                throw new ParseException("Failed byte count validation!");
            }
            String userName = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 8) {
                throw new ParseException("Failed byte count validation!");
            }
            long ping = UnsignedUtil.getUnsignedInt(buffer);
            byte status = buffer.get();
            int userID = UnsignedUtil.getUnsignedShort(buffer);
            byte connectionType = buffer.get();
            users.add(new User(userName, ping, status, userID, connectionType));
            ++j;
        }
        ArrayList<Game> games = new ArrayList<Game>(numGames);
        int j2 = 0;
        while (j2 < numGames) {
            if (buffer.remaining() < 13) {
                throw new ParseException("Failed byte count validation!");
            }
            String romName = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 10) {
                throw new ParseException("Failed byte count validation!");
            }
            int gameID = buffer.getInt();
            String clientType = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 5) {
                throw new ParseException("Failed byte count validation!");
            }
            String userName = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 3) {
                throw new ParseException("Failed byte count validation!");
            }
            String players = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 1) {
                throw new ParseException("Failed byte count validation!");
            }
            byte status = buffer.get();
            games.add(new Game(romName.toString(), gameID, clientType, userName, players, status));
            ++j2;
        }
        return new ServerStatus(messageNumber, users, games);
    }

    public static class Game {
        private String romName;
        private int gameID;
        private String clientType;
        private String userName;
        private String players;
        private byte status;

        public Game(String romName, int gameID, String clientType, String userName, String players, byte status) throws MessageFormatException {
            if (romName.length() == 0) {
                throw new MessageFormatException("Invalid Server Status format: romName.length == 0");
            }
            if (gameID < 0 || gameID > 65535) {
                throw new MessageFormatException("Invalid Server Status format: gameID out of acceptable range: " + gameID);
            }
            if (clientType.length() == 0) {
                throw new MessageFormatException("Invalid Server Status format: clientType.length == 0");
            }
            if (userName.length() == 0) {
                throw new MessageFormatException("Invalid Server Status format: userName.length == 0");
            }
            if (status < 0 || status > 2) {
                throw new MessageFormatException("Invalid Server Status format: gameStatus out of acceptable range: " + status);
            }
            this.romName = romName;
            this.gameID = gameID;
            this.clientType = clientType;
            this.userName = userName;
            this.players = players;
            this.status = status;
        }

        public String getRomName() {
            return this.romName;
        }

        public int getGameID() {
            return this.gameID;
        }

        public String getClientType() {
            return this.clientType;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPlayers() {
            return this.players;
        }

        public byte getStatus() {
            return this.status;
        }

        public String toString() {
            return "[romName=" + this.romName + " gameID=" + this.gameID + " clientType=" + this.clientType + " userName=" + this.userName + " players=" + this.players + " status=" + KailleraGame.STATUS_NAMES[this.status] + "]";
        }

        public int getLength() {
            return ServerStatus.getNumBytes(this.romName) + 1 + 4 + ServerStatus.getNumBytes(this.clientType) + 1 + ServerStatus.getNumBytes(this.userName) + 1 + ServerStatus.getNumBytes(this.players) + 1 + 1;
        }

        public void writeTo(ByteBuffer buffer) {
            EmuUtil.writeString(buffer, this.romName, 0, charset);
            buffer.putInt(this.gameID);
            EmuUtil.writeString(buffer, this.clientType, 0, charset);
            EmuUtil.writeString(buffer, this.userName, 0, charset);
            EmuUtil.writeString(buffer, this.players, 0, charset);
            buffer.put(this.status);
        }
    }

    public static class User {
        private String userName;
        private long ping;
        private byte status;
        private int userID;
        private byte connectionType;

        public User(String userName, long ping, byte status, int userID, byte connectionType) throws MessageFormatException {
            if (userName.length() == 0) {
                throw new MessageFormatException("Invalid Server Status format: userName.length == 0, (userID = " + userID + ")");
            }
            if (ping < 0L || ping > 2048L) {
                throw new MessageFormatException("Invalid Server Status format: ping out of acceptable range: " + ping);
            }
            if (status < 0 || status > 2) {
                throw new MessageFormatException("Invalid Server Status format: status out of acceptable range: " + status);
            }
            if (userID < 0 || userID > 65535) {
                throw new MessageFormatException("Invalid Server Status format: userID out of acceptable range: " + userID);
            }
            if (connectionType < 1 || connectionType > 6) {
                throw new MessageFormatException("Invalid Server Status format: connectionType out of acceptable range: " + connectionType);
            }
            this.userName = userName;
            this.ping = ping;
            this.status = status;
            this.userID = userID;
            this.connectionType = connectionType;
        }

        public String getUserName() {
            return this.userName;
        }

        public long getPing() {
            return this.ping;
        }

        public byte getStatus() {
            return this.status;
        }

        public int getUserID() {
            return this.userID;
        }

        public byte getConnectionType() {
            return this.connectionType;
        }

        public String toString() {
            return "[userName=" + this.userName + " ping=" + this.ping + " status=" + KailleraUser.STATUS_NAMES[this.status] + " userID=" + this.userID + " connectionType=" + KailleraUser.CONNECTION_TYPE_NAMES[this.connectionType] + "]";
        }

        public int getLength() {
            return ServerStatus.getNumBytes(this.userName) + 9;
        }

        public void writeTo(ByteBuffer buffer) {
            EmuUtil.writeString(buffer, this.userName, 0, charset);
            UnsignedUtil.putUnsignedInt(buffer, this.ping);
            buffer.put(this.status);
            UnsignedUtil.putUnsignedShort(buffer, this.userID);
            buffer.put(this.connectionType);
        }
    }
}

