/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.master.client;

import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.connectcontroller.ConnectController;
import org.emulinker.kaillera.master.PublicServerInformation;
import org.emulinker.kaillera.master.client.MasterListUpdateTask;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.release.ReleaseInfo;

public class EmuLinkerMasterUpdateTask
implements MasterListUpdateTask {
    private static Log log = LogFactory.getLog(EmuLinkerMasterUpdateTask.class);
    private static final String url = "http://kaillerareborn.2manygames.fr/touch_list.php";
    private PublicServerInformation publicInfo;
    private ConnectController connectController;
    private KailleraServer kailleraServer;
    private ReleaseInfo releaseInfo;
    private HttpClient httpClient;

    public EmuLinkerMasterUpdateTask(PublicServerInformation publicInfo, ConnectController connectController, KailleraServer kailleraServer, ReleaseInfo releaseInfo) {
        this.publicInfo = publicInfo;
        this.connectController = connectController;
        this.kailleraServer = kailleraServer;
        this.publicInfo = publicInfo;
        this.releaseInfo = releaseInfo;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectionTimeout(5000);
        this.httpClient.setTimeout(5000);
    }

    public void touchMaster() {
        String updateAvailable;
        Properties props;
        block19: {
            StringBuilder waitingGames = new StringBuilder();
            for (KailleraGame kailleraGame : this.kailleraServer.getGames()) {
                if (kailleraGame.getStatus() != 0) continue;
                waitingGames.append(kailleraGame.getRomName());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getOwner().getName());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getOwner().getClientType());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getNumPlayers());
                waitingGames.append("/");
                waitingGames.append(kailleraGame.getMaxUsers());
                waitingGames.append("|");
            }
            NameValuePair[] nameValuePairArray = new NameValuePair[]{new NameValuePair("serverName", this.publicInfo.getServerName()), new NameValuePair("ipAddress", this.publicInfo.getConnectAddress()), new NameValuePair("location", this.publicInfo.getLocation()), new NameValuePair("website", this.publicInfo.getWebsite()), new NameValuePair("port", Integer.toString(this.connectController.getBindPort())), new NameValuePair("numUsers", Integer.toString(this.kailleraServer.getNumUsers())), new NameValuePair("maxUsers", Integer.toString(this.kailleraServer.getMaxUsers())), new NameValuePair("numGames", Integer.toString(this.kailleraServer.getNumGames())), new NameValuePair("maxGames", Integer.toString(this.kailleraServer.getMaxGames())), new NameValuePair("version", "ESF" + this.releaseInfo.getVersionString())};
            GetMethod meth = new GetMethod(url);
            meth.setQueryString(nameValuePairArray);
            meth.setRequestHeader("Waiting-games", waitingGames.toString());
            meth.setFollowRedirects(true);
            props = new Properties();
            try {
                try {
                    int statusCode = this.httpClient.executeMethod((HttpMethod)meth);
                    if (statusCode != 200) {
                        log.error((Object)("Failed to touch EmuLinker Master: " + meth.getStatusLine()));
                    } else {
                        props.load(meth.getResponseBodyAsStream());
                        log.info((Object)"Touching EmuLinker Master done");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to touch EmuLinker Master: " + e.getMessage()));
                    if (meth != null) {
                        try {
                            meth.releaseConnection();
                        }
                        catch (Exception exception) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (meth != null) {
                    try {
                        meth.releaseConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (meth != null) {
                try {
                    meth.releaseConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((updateAvailable = props.getProperty("updateAvailable")) != null && updateAvailable.equalsIgnoreCase("true")) {
            String latestVersion = props.getProperty("latest");
            String notes = props.getProperty("notes");
            StringBuilder sb = new StringBuilder();
            sb.append("A updated version of EmuLinkerSF is available: ");
            sb.append(latestVersion);
            if (notes != null) {
                sb.append(" (");
                sb.append(notes);
                sb.append(")");
            }
            log.warn((Object)sb.toString());
        }
    }
}

