/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.AllReadyEvent;
import org.emulinker.kaillera.model.event.GameChatEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.GameInfoEvent;
import org.emulinker.kaillera.model.event.GameStartedEvent;
import org.emulinker.kaillera.model.event.GameStatusChangedEvent;
import org.emulinker.kaillera.model.event.GameTimeoutEvent;
import org.emulinker.kaillera.model.event.PlayerDesynchEvent;
import org.emulinker.kaillera.model.event.UserDroppedGameEvent;
import org.emulinker.kaillera.model.event.UserJoinedGameEvent;
import org.emulinker.kaillera.model.event.UserQuitGameEvent;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.exception.GameDataException;
import org.emulinker.kaillera.model.exception.GameKickException;
import org.emulinker.kaillera.model.exception.JoinGameException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.StartGameException;
import org.emulinker.kaillera.model.exception.UserReadyException;
import org.emulinker.kaillera.model.impl.AutoFireDetector;
import org.emulinker.kaillera.model.impl.KailleraServerImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.kaillera.model.impl.PlayerActionQueue;
import org.emulinker.kaillera.model.impl.PlayerTimeoutException;
import org.emulinker.util.EmuLang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KailleraGameImpl
implements KailleraGame {
    private static Log log = LogFactory.getLog(KailleraGameImpl.class);
    private int id;
    private String romName;
    private String toString;
    private Date startDate;
    private String lastAddress = "null";
    private int lastAddressCount = 0;
    private static int chatFloodTime = 3;
    private int maxUsers = 8;
    private int delay;
    private String aEmulator = "any";
    private String aConnection = "any";
    private int maxPing = 1000;
    private int startN = -1;
    private boolean p2P = false;
    private boolean sameDelay = false;
    public boolean swap = false;
    private int highestPing = 0;
    private int bufferSize;
    private boolean startTimeout = false;
    private long startTimeoutTime;
    private int timeoutMillis;
    private int desynchTimeouts;
    private KailleraServerImpl server;
    private KailleraUserImpl owner;
    private List<KailleraUserImpl> players = new CopyOnWriteArrayList<KailleraUserImpl>();
    private StatsCollector statsCollector;
    private List<String> kickedUsers = new ArrayList<String>();
    private List<String> mutedUsers = new ArrayList<String>();
    private int status = 0;
    private boolean synched = false;
    private int actionsPerMessage;
    private PlayerActionQueue[] playerActionQueues;
    private AutoFireDetector autoFireDetector;

    public KailleraGameImpl(int gameID, String romName, KailleraUserImpl owner, KailleraServerImpl server, int bufferSize, int timeoutMillis, int desynchTimeouts) {
        this.id = gameID;
        this.romName = romName;
        this.owner = owner;
        this.server = server;
        this.actionsPerMessage = owner.getConnectionType();
        this.bufferSize = bufferSize;
        this.timeoutMillis = 100;
        this.desynchTimeouts = 120;
        this.toString = "Game" + this.id + "(" + (romName.length() > 15 ? String.valueOf(romName.substring(0, 15)) + "..." : romName) + ")";
        this.startDate = new Date();
        this.statsCollector = server.getStatsCollector();
        this.autoFireDetector = server.getAutoFireDetector(this);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public List<String> getMutedUsers() {
        return this.mutedUsers;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    public String getAEmulator() {
        return this.aEmulator;
    }

    public void setAEmulator(String aEmulator) {
        this.aEmulator = aEmulator;
    }

    public String getAConnection() {
        return this.aConnection;
    }

    public void setAConnection(String aConnection) {
        this.aConnection = aConnection;
    }

    @Override
    public PlayerActionQueue[] getPlayerActionQueue() {
        return this.playerActionQueues;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void setStartTimeout(boolean startTimeout) {
        this.startTimeout = startTimeout;
    }

    @Override
    public boolean getStartTimeout() {
        return this.startTimeout;
    }

    @Override
    public void setSameDelay(boolean sameDelay) {
        this.sameDelay = sameDelay;
    }

    @Override
    public boolean getSameDelay() {
        return this.sameDelay;
    }

    @Override
    public long getStartTimeoutTime() {
        return this.startTimeoutTime;
    }

    @Override
    public int getStartN() {
        return this.startN;
    }

    @Override
    public boolean getP2P() {
        return this.p2P;
    }

    @Override
    public void setP2P(boolean p2P) {
        this.p2P = p2P;
    }

    @Override
    public void setStartN(int startN) {
        this.startN = startN;
    }

    @Override
    public String getRomName() {
        return this.romName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
        this.server.addEvent(new GameStatusChangedEvent(this.server, this));
    }

    @Override
    public int getMaxUsers() {
        return this.maxUsers;
    }

    @Override
    public int getHighestPing() {
        return this.highestPing;
    }

    @Override
    public void setMaxPing(int maxPing) {
        this.maxPing = maxPing;
    }

    @Override
    public int getMaxPing() {
        return this.maxPing;
    }

    @Override
    public KailleraUser getOwner() {
        return this.owner;
    }

    @Override
    public int getPlayerNumber(KailleraUser user) {
        return this.players.indexOf(user) + 1;
    }

    @Override
    public KailleraUser getPlayer(int playerNumber) {
        if (playerNumber > this.players.size()) {
            log.error((Object)(this + ": getPlayer(" + playerNumber + ") failed! (size = " + this.players.size() + ")"));
            return null;
        }
        return this.players.get(playerNumber - 1);
    }

    @Override
    public int getNumPlayers() {
        return this.players.size();
    }

    public List<KailleraUserImpl> getPlayers() {
        return this.players;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean isSynched() {
        return this.synched;
    }

    @Override
    public KailleraServerImpl getServer() {
        return this.server;
    }

    void setStatus(int status) {
        this.status = status;
        this.server.addEvent(new GameStatusChangedEvent(this.server, this));
    }

    @Override
    public String getClientType() {
        return this.getOwner().getClientType();
    }

    public String toString() {
        return this.toString;
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KailleraGame[id=");
        sb.append(this.getID());
        sb.append(" romName=");
        sb.append(this.getRomName());
        sb.append(" owner=");
        sb.append(this.getOwner());
        sb.append(" numPlayers=");
        sb.append(this.getNumPlayers());
        sb.append(" status=");
        sb.append(KailleraGame.STATUS_NAMES[this.getStatus()]);
        sb.append("]");
        return sb.toString();
    }

    int getPlayingCount() {
        int count = 0;
        for (KailleraUserImpl player : this.players) {
            if (player.getStatus() != 0) continue;
            ++count;
        }
        return count;
    }

    int getSynchedCount() {
        if (this.playerActionQueues == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < this.playerActionQueues.length) {
            if (this.playerActionQueues[i].isSynched()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    void addEvent(GameEvent event) {
        for (KailleraUserImpl player : this.players) {
            player.addEvent(event);
        }
    }

    public AutoFireDetector getAutoFireDetector() {
        return this.autoFireDetector;
    }

    @Override
    public synchronized void chat(KailleraUser user, String message) throws GameChatException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " game chat denied: not in " + this));
            throw new GameChatException(EmuLang.getString("KailleraGameImpl.GameChatErrorNotInGame"));
        }
        log.info((Object)(user + ", " + this + " gamechat: " + message));
        this.addEvent(new GameChatEvent(this, user, message));
    }

    public synchronized void announce(String announcement, KailleraUser user) {
        this.addEvent(new GameInfoEvent(this, announcement, user));
    }

    @Override
    public synchronized void kick(KailleraUser user, int userID) throws GameKickException {
        if (user.getAccess() < 4 && !user.equals(this.getOwner())) {
            log.warn((Object)(user + " kick denied: not the owner of " + this));
            throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickDeniedNotGameOwner"));
        }
        if (user.getID() == userID) {
            log.warn((Object)(user + " kick denied: attempt to kick self"));
            throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickDeniedCannotKickSelf"));
        }
        for (KailleraUserImpl player : this.players) {
            if (player.getID() != userID) continue;
            try {
                if (user.getAccess() != 5 && player.getAccess() >= 4) {
                    return;
                }
                log.info((Object)(user + " kicked: " + userID + " from " + this));
                this.kickedUsers.add(player.getConnectSocketAddress().getAddress().getHostAddress());
                player.quitGame();
                return;
            }
            catch (Exception e) {
                log.error((Object)"Caught exception while making user quit game! This shouldn't happen!", (Throwable)e);
            }
        }
        log.warn((Object)(user + " kick failed: user " + userID + " not found in: " + this));
        throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickErrorUserNotFound"));
    }

    @Override
    public synchronized int join(KailleraUser user) throws JoinGameException {
        int access = this.server.getAccessManager().getAccess(user.getSocketAddress().getAddress());
        if (this.lastAddress.equals(user.getConnectSocketAddress().getAddress().getHostAddress())) {
            ++this.lastAddressCount;
            if (this.lastAddressCount >= 4) {
                log.info((Object)(user + " join spam protection: " + user.getID() + " from " + this));
                if (access < 4) {
                    this.kickedUsers.add(user.getConnectSocketAddress().getAddress().getHostAddress());
                    try {
                        user.quitGame();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new JoinGameException("Spam Protection");
                }
            }
        } else {
            this.lastAddressCount = 0;
            this.lastAddress = user.getConnectSocketAddress().getAddress().getHostAddress();
        }
        if (this.players.contains(user)) {
            log.warn((Object)(user + " join game denied: already in " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameErrorAlreadyInGame"));
        }
        if (access < 2 && this.getNumPlayers() >= this.getMaxUsers()) {
            log.warn((Object)(user + " join game denied: max users reached " + this));
            throw new JoinGameException("This room's user capacity has been reached.");
        }
        if (access < 2 && user.getPing() > this.getMaxPing()) {
            log.warn((Object)(user + " join game denied: max ping reached " + this));
            throw new JoinGameException("Your ping is too high for this room.");
        }
        if (access < 2 && !this.aEmulator.equals("any") && !this.aEmulator.equals(user.getClientType())) {
            log.warn((Object)(user + " join game denied: owner doesn't allow that emulator: " + user.getClientType()));
            throw new JoinGameException("Owner only allows emulator version: " + this.aEmulator);
        }
        if (access < 2 && !this.aConnection.equals("any") && user.getConnectionType() != this.getOwner().getConnectionType()) {
            log.warn((Object)(user + "join game denied: owner doesn't allow that connection type: " + KailleraUser.CONNECTION_TYPE_NAMES[user.getConnectionType()]));
            throw new JoinGameException("Owner only allows connection type: " + KailleraUser.CONNECTION_TYPE_NAMES[this.getOwner().getConnectionType()]);
        }
        if (access < 4 && this.kickedUsers.contains(user.getConnectSocketAddress().getAddress().getHostAddress())) {
            log.warn((Object)(user + " join game denied: previously kicked: " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameDeniedPreviouslyKicked"));
        }
        if (access == 1 && this.getStatus() != 0) {
            log.warn((Object)(user + " join game denied: attempt to join game in progress: " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameDeniedGameIsInProgress"));
        }
        if (this.mutedUsers.contains(user.getConnectSocketAddress().getAddress().getHostAddress())) {
            user.setMute(true);
        }
        this.players.add((KailleraUserImpl)user);
        user.setPlayerNumber(this.players.size());
        this.server.addEvent(new GameStatusChangedEvent(this.server, this));
        log.info((Object)(user + " joined: " + this));
        this.addEvent(new UserJoinedGameEvent(this, user));
        if (this.getStartN() != -1 && this.players.size() >= this.getStartN()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.start(this.getOwner());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.announce("Help: " + this.getServer().getReleaseInfo().getProductName() + " v" + this.getServer().getReleaseInfo().getVersionString() + ": " + this.getServer().getReleaseInfo().getReleaseDate() + " - Visit: https://god-weapon.github.io", user);
        this.announce("************************", user);
        this.announce("Type /p2pon to ignore ALL server activity during gameplay.", user);
        this.announce("This will reduce lag that you contribute due to a busy server.", user);
        this.announce("If server is greater than 60 users, option is auto set.", user);
        this.announce("************************", user);
        if (access < 4 && !user.getClientType().equals(this.owner.getClientType()) && !this.owner.getGame().getRomName().startsWith("*")) {
            this.addEvent(new GameInfoEvent(this, String.valueOf(user.getName()) + " using different emulator version: " + user.getClientType(), null));
        }
        return this.players.indexOf(user) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void start(KailleraUser user) throws StartGameException {
        void var3_6;
        int access = this.server.getAccessManager().getAccess(user.getSocketAddress().getAddress());
        if (!user.equals(this.getOwner()) && access < 4) {
            log.warn((Object)(user + " start game denied: not the owner of " + this));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedOnlyOwnerMayStart"));
        }
        if (this.status == 1) {
            log.warn((Object)(user + " start game failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameErrorSynchronizing"));
        }
        if (this.status == 2) {
            log.warn((Object)(user + " start game failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameErrorStatusIsPlaying"));
        }
        if (access == 1 && this.getNumPlayers() < 2 && !this.server.getAllowSinglePlayer()) {
            log.warn((Object)(user + " start game denied: " + this + " needs at least 2 players"));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedSinglePlayerNotAllowed"));
        }
        if (this.owner.getGame().getRomName().startsWith("*")) {
            return;
        }
        for (KailleraUser kailleraUser : this.players) {
            if (kailleraUser.getStealth()) continue;
            if (kailleraUser.getConnectionType() != this.owner.getConnectionType()) {
                log.warn((Object)(user + " start game denied: " + this + ": All players must use the same connection type"));
                this.addEvent(new GameInfoEvent(this, EmuLang.getString("KailleraGameImpl.StartGameConnectionTypeMismatchInfo", KailleraUser.CONNECTION_TYPE_NAMES[this.owner.getConnectionType()]), null));
                throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedConnectionTypeMismatch"));
            }
            if (kailleraUser.getClientType().equals(this.getClientType())) continue;
            log.warn((Object)(user + " start game denied: " + this + ": All players must use the same emulator!"));
            this.addEvent(new GameInfoEvent(this, EmuLang.getString("KailleraGameImpl.StartGameEmulatorMismatchInfo", this.getClientType()), null));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedEmulatorMismatch"));
        }
        log.info((Object)(user + " started: " + this));
        this.setStatus(1);
        if (this.autoFireDetector != null) {
            this.autoFireDetector.start(this.players.size());
        }
        this.playerActionQueues = new PlayerActionQueue[this.players.size()];
        this.startTimeout = false;
        this.delay = 1;
        if (this.server.getUsers().size() > 60) {
            this.p2P = true;
        }
        boolean bl = false;
        while (var3_6 < this.playerActionQueues.length && var3_6 < this.players.size()) {
            KailleraUserImpl player = this.players.get((int)var3_6);
            void playerNumber = var3_6 + true;
            if (!this.swap) {
                player.setPlayerNumber((int)playerNumber);
            }
            player.setTimeouts(0);
            player.setFrameCount(0);
            this.playerActionQueues[var3_6] = new PlayerActionQueue((int)playerNumber, player, this.getNumPlayers(), this.bufferSize, this.timeoutMillis, true);
            double delayVal = (double)(60 / player.getConnectionType()) * ((double)player.getPing() / 1000.0) + 1.0;
            player.setDelay((int)delayVal);
            if ((int)delayVal > this.delay) {
                this.delay = (int)delayVal;
            }
            if (player.getPing() > this.highestPing) {
                this.highestPing = user.getPing();
            }
            if (this.p2P) {
                player.setP2P(true);
                this.announce("This game is ignoring ALL server activity during gameplay!", player);
            }
            log.info((Object)(this + ": " + player + " is player number " + (int)playerNumber));
            if (this.autoFireDetector != null) {
                this.autoFireDetector.addPlayer(player, (int)playerNumber);
            }
            ++var3_6;
        }
        if (this.statsCollector != null) {
            this.statsCollector.gameStarted(this.server, this);
        }
        this.addEvent(new GameStartedEvent(this));
    }

    @Override
    public synchronized void ready(KailleraUser user, int playerNumber) throws UserReadyException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " ready game failed: not in " + this));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorNotInGame"));
        }
        if (this.status != 1) {
            log.warn((Object)(user + " ready failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorIncorrectState"));
        }
        if (this.playerActionQueues == null) {
            log.error((Object)(user + " ready failed: " + this + " playerActionQueues == null!"));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorInternalError"));
        }
        log.info((Object)(user + " (player " + playerNumber + ") is ready to play: " + this));
        this.playerActionQueues[playerNumber - 1].setSynched(true);
        if (this.getSynchedCount() == this.getNumPlayers()) {
            log.info((Object)(this + " all players are ready: starting..."));
            this.setStatus(2);
            this.synched = true;
            this.startTimeoutTime = System.currentTimeMillis();
            this.addEvent(new AllReadyEvent(this));
            int frameDelay = (this.delay + 1) * this.owner.getConnectionType() - 1;
            if (this.sameDelay) {
                this.announce("This game's delay is: " + this.delay + " (" + frameDelay + " frame delay)", null);
            } else {
                int i = 0;
                while (i < this.playerActionQueues.length && i < this.players.size()) {
                    KailleraUserImpl player = this.players.get(i);
                    if (player != null && !player.getStealth()) {
                        frameDelay = (player.getDelay() + 1) * player.getConnectionType() - 1;
                        this.announce("P" + (i + 1) + " Delay = " + player.getDelay() + " (" + frameDelay + " frame delay)", null);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public synchronized void drop(KailleraUser user, int playerNumber) throws DropGameException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " drop game failed: not in " + this));
            throw new DropGameException(EmuLang.getString("KailleraGameImpl.DropGameErrorNotInGame"));
        }
        if (this.playerActionQueues == null) {
            log.error((Object)(user + " drop failed: " + this + " playerActionQueues == null!"));
            throw new DropGameException(EmuLang.getString("KailleraGameImpl.DropGameErrorInternalError"));
        }
        log.info((Object)(user + " dropped: " + this));
        if (playerNumber - 1 < this.playerActionQueues.length) {
            this.playerActionQueues[playerNumber - 1].setSynched(false);
        }
        if (this.getSynchedCount() < 2 && this.synched) {
            this.synched = false;
            PlayerActionQueue[] playerActionQueueArray = this.playerActionQueues;
            int n = this.playerActionQueues.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerActionQueue q = playerActionQueueArray[n2];
                q.setSynched(false);
                ++n2;
            }
            log.info((Object)(this + ": game desynched: less than 2 players playing!"));
        }
        if (this.autoFireDetector != null) {
            this.autoFireDetector.stop(playerNumber);
        }
        if (this.getPlayingCount() == 0) {
            if (this.getStartN() != -1) {
                this.setStartN(-1);
                this.announce("StartN is now off.", null);
            }
            this.setStatus(0);
        }
        this.addEvent(new UserDroppedGameEvent(this, user, playerNumber));
        if (user.getP2P()) {
            this.announce("Rejoin server to update client of ignored server activity!", user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit(KailleraUser user, int playerNumber) throws DropGameException, QuitGameException, CloseGameException {
        KailleraGameImpl kailleraGameImpl = this;
        synchronized (kailleraGameImpl) {
            if (!this.players.remove(user)) {
                log.warn((Object)(user + " quit game failed: not in " + this));
                throw new QuitGameException(EmuLang.getString("KailleraGameImpl.QuitGameErrorNotInGame"));
            }
            log.info((Object)(user + " quit: " + this));
            this.addEvent(new UserQuitGameEvent(this, user));
            user.setP2P(false);
            this.swap = false;
            if (this.status == 0) {
                int i = 0;
                while (i < this.getNumPlayers()) {
                    this.getPlayer(i + 1).setPlayerNumber(i + 1);
                    log.debug((Object)(String.valueOf(this.getPlayer(i + 1).getName()) + ":::" + this.getPlayer(i + 1).getPlayerNumber()));
                    ++i;
                }
            }
        }
        if (user.equals(this.owner)) {
            this.server.closeGame(this, user);
        } else {
            this.server.addEvent(new GameStatusChangedEvent(this.server, this));
        }
    }

    synchronized void close(KailleraUser user) throws CloseGameException {
        if (!user.equals(this.owner)) {
            log.warn((Object)(user + " close game denied: not the owner of " + this));
            throw new CloseGameException(EmuLang.getString("KailleraGameImpl.CloseGameErrorNotGameOwner"));
        }
        if (this.synched) {
            this.synched = false;
            PlayerActionQueue[] playerActionQueueArray = this.playerActionQueues;
            int n = this.playerActionQueues.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerActionQueue q = playerActionQueueArray[n2];
                q.setSynched(false);
                ++n2;
            }
            log.info((Object)(this + ": game desynched: game closed!"));
        }
        for (KailleraUserImpl player : this.players) {
            player.setStatus(1);
            player.setMute(false);
            player.setP2P(false);
            player.setGame(null);
        }
        if (this.autoFireDetector != null) {
            this.autoFireDetector.stop();
        }
        this.players.clear();
    }

    @Override
    public synchronized void droppedPacket(KailleraUser user) {
        if (!this.synched) {
            return;
        }
        int playerNumber = user.getPlayerNumber();
        if (user.getPlayerNumber() > this.playerActionQueues.length) {
            log.info((Object)(this + ": " + user + ": player desynched: dropped a packet! Also left the game already: KailleraGameImpl -> DroppedPacket"));
        }
        if (this.playerActionQueues != null && this.playerActionQueues[playerNumber - 1].isSynched()) {
            this.playerActionQueues[playerNumber - 1].setSynched(false);
            log.info((Object)(this + ": " + user + ": player desynched: dropped a packet!"));
            this.addEvent(new PlayerDesynchEvent(this, user, EmuLang.getString("KailleraGameImpl.DesynchDetectedDroppedPacket", user.getName())));
            if (this.getSynchedCount() < 2 && this.synched) {
                this.synched = false;
                PlayerActionQueue[] playerActionQueueArray = this.playerActionQueues;
                int n = this.playerActionQueues.length;
                int n2 = 0;
                while (n2 < n) {
                    PlayerActionQueue q = playerActionQueueArray[n2];
                    q.setSynched(false);
                    ++n2;
                }
                log.info((Object)(this + ": game desynched: less than 2 players synched!"));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void addData(KailleraUser user, int playerNumber, byte[] data) throws GameDataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CATCHBLOCK]], but top level block is 4[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void handleTimeout(PlayerTimeoutException e) {
        if (!this.synched) {
            return;
        }
        int playerNumber = e.getPlayerNumber();
        int timeoutNumber = e.getTimeoutNumber();
        PlayerActionQueue playerActionQueue = this.playerActionQueues[playerNumber - 1];
        if (!playerActionQueue.isSynched() || e.equals(playerActionQueue.getLastTimeout())) {
            return;
        }
        playerActionQueue.setLastTimeout(e);
        KailleraUserImpl player = e.getPlayer();
        if (timeoutNumber < this.desynchTimeouts) {
            if (this.startTimeout) {
                player.setTimeouts(player.getTimeouts() + 1);
            }
            if (timeoutNumber % 12 == 0) {
                log.info((Object)(this + ": " + player + ": Timeout #" + timeoutNumber / 12));
                this.addEvent(new GameTimeoutEvent(this, player, timeoutNumber / 12));
            }
        } else {
            log.info((Object)(this + ": " + player + ": Timeout #" + timeoutNumber / 12));
            playerActionQueue.setSynched(false);
            log.info((Object)(this + ": " + player + ": player desynched: Lagged!"));
            this.addEvent(new PlayerDesynchEvent(this, player, EmuLang.getString("KailleraGameImpl.DesynchDetectedPlayerLagged", player.getName())));
            if (this.getSynchedCount() < 2) {
                this.synched = false;
                PlayerActionQueue[] playerActionQueueArray = this.playerActionQueues;
                int n = this.playerActionQueues.length;
                int n2 = 0;
                while (n2 < n) {
                    PlayerActionQueue q = playerActionQueueArray[n2];
                    q.setSynched(false);
                    ++n2;
                }
                log.info((Object)(this + ": game desynched: less than 2 players synched!"));
            }
        }
    }
}

