/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.ChatEvent;
import org.emulinker.kaillera.model.event.ConnectedEvent;
import org.emulinker.kaillera.model.event.GameClosedEvent;
import org.emulinker.kaillera.model.event.GameCreatedEvent;
import org.emulinker.kaillera.model.event.InfoMessageEvent;
import org.emulinker.kaillera.model.event.KailleraEventListener;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.event.UserJoinedEvent;
import org.emulinker.kaillera.model.event.UserQuitEvent;
import org.emulinker.kaillera.model.exception.ChatException;
import org.emulinker.kaillera.model.exception.ClientAddressException;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.ConnectionTypeException;
import org.emulinker.kaillera.model.exception.CreateGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.FloodException;
import org.emulinker.kaillera.model.exception.LoginException;
import org.emulinker.kaillera.model.exception.NewConnectionException;
import org.emulinker.kaillera.model.exception.PingTimeException;
import org.emulinker.kaillera.model.exception.QuitException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.ServerFullException;
import org.emulinker.kaillera.model.exception.UserNameException;
import org.emulinker.kaillera.model.impl.AutoFireDetector;
import org.emulinker.kaillera.model.impl.AutoFireDetectorFactory;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.kaillera.model.impl.Trivia;
import org.emulinker.release.ReleaseInfo;
import org.emulinker.util.EmuLang;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.Executable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KailleraServerImpl
implements KailleraServer,
Executable {
    protected static Log log = LogFactory.getLog(KailleraServerImpl.class);
    protected int maxPing;
    protected int maxUsers;
    protected int maxGames;
    protected int idleTimeout;
    protected int keepAliveTimeout;
    protected int chatFloodTime;
    protected int createGameFloodTime;
    protected int maxUserNameLength;
    protected int maxChatLength;
    protected int maxGameNameLength;
    protected int maxQuitMessageLength;
    protected int maxClientNameLength;
    protected int gameBufferSize;
    protected int gameTimeoutMillis;
    protected int gameDesynchTimeouts;
    protected int gameAutoFireSensitivity;
    protected boolean[] allowedConnectionTypes = new boolean[7];
    protected List<String> loginMessages = new ArrayList<String>();
    protected boolean allowSinglePlayer = false;
    protected boolean allowMultipleConnections = false;
    protected boolean stopFlag = false;
    protected boolean isRunning = false;
    protected int connectionCounter = 1;
    protected int gameCounter = 1;
    protected ThreadPoolExecutor threadPool = null;
    protected AccessManager accessManager;
    protected StatsCollector statsCollector;
    protected ReleaseInfo releaseInfo;
    protected AutoFireDetectorFactory autoFireDetectorFactory;
    protected Map<Integer, KailleraUserImpl> users;
    protected Map<Integer, KailleraGameImpl> games;
    private Trivia trivia = null;
    private Thread triviaThread;
    private boolean switchTrivia = false;

    public KailleraServerImpl(ThreadPoolExecutor threadPool, AccessManager accessManager, Configuration config, StatsCollector statsCollector, ReleaseInfo releaseInfo, AutoFireDetectorFactory autoFireDetectorFactory) throws NoSuchElementException, ConfigurationException {
        this.threadPool = threadPool;
        this.accessManager = accessManager;
        this.releaseInfo = releaseInfo;
        this.autoFireDetectorFactory = autoFireDetectorFactory;
        this.maxPing = config.getInt("server.maxPing");
        this.maxUsers = config.getInt("server.maxUsers");
        this.maxGames = config.getInt("server.maxGames");
        this.keepAliveTimeout = config.getInt("server.keepAliveTimeout");
        this.idleTimeout = config.getInt("server.idleTimeout");
        this.chatFloodTime = config.getInt("server.chatFloodTime");
        this.createGameFloodTime = config.getInt("server.createGameFloodTime");
        this.allowSinglePlayer = config.getBoolean("server.allowSinglePlayer");
        this.allowMultipleConnections = config.getBoolean("server.allowMultipleConnections");
        this.maxUserNameLength = config.getInt("server.maxUserNameLength");
        if (this.maxUserNameLength > 31) {
            this.maxUserNameLength = 31;
        }
        this.maxChatLength = config.getInt("server.maxChatLength");
        this.maxGameNameLength = config.getInt("server.maxGameNameLength");
        if (this.maxGameNameLength > 127) {
            this.maxGameNameLength = 127;
        }
        this.maxQuitMessageLength = config.getInt("server.maxQuitMessageLength");
        this.maxClientNameLength = config.getInt("server.maxClientNameLength");
        if (this.maxClientNameLength > 127) {
            this.maxClientNameLength = 127;
        }
        int i = 1;
        while (i <= 999) {
            if (!EmuLang.hasString("KailleraServerImpl.LoginMessage." + i)) break;
            this.loginMessages.add(EmuLang.getString("KailleraServerImpl.LoginMessage." + i));
            ++i;
        }
        this.gameBufferSize = config.getInt("game.bufferSize");
        if (this.gameBufferSize <= 0) {
            throw new ConfigurationException("game.bufferSize can not be <= 0");
        }
        this.gameTimeoutMillis = config.getInt("game.timeoutMillis");
        if (this.gameTimeoutMillis <= 0) {
            throw new ConfigurationException("game.timeoutMillis can not be <= 0");
        }
        this.gameDesynchTimeouts = config.getInt("game.desynchTimeouts");
        this.gameAutoFireSensitivity = config.getInt("game.defaultAutoFireSensitivity");
        if (this.gameAutoFireSensitivity < 0 || this.gameAutoFireSensitivity > 5) {
            throw new ConfigurationException("game.defaultAutoFireSensitivity must be 0-5");
        }
        List connectionTypes = config.getList("server.allowedConnectionTypes");
        for (String s : connectionTypes) {
            try {
                int ct = Integer.parseInt(s);
                if (ct < 1 || ct > 6) {
                    throw new ConfigurationException("Invalid connectionType: " + s);
                }
                this.allowedConnectionTypes[ct] = true;
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid connectionType: " + s);
            }
        }
        if (this.maxPing <= 0) {
            throw new ConfigurationException("server.maxPing can not be <= 0");
        }
        if (this.maxPing > 1000) {
            throw new ConfigurationException("server.maxPing can not be > 1000");
        }
        if (this.keepAliveTimeout <= 0) {
            throw new ConfigurationException("server.keepAliveTimeout must be > 0 (190 is recommended)");
        }
        this.users = new ConcurrentHashMap<Integer, KailleraUserImpl>(this.maxUsers);
        this.games = new ConcurrentHashMap<Integer, KailleraGameImpl>(this.maxGames);
        boolean touchKaillera = config.getBoolean("masterList.touchKaillera", false);
        if (touchKaillera) {
            this.statsCollector = statsCollector;
        }
    }

    @Override
    public void setTrivia(Trivia trivia) {
        this.trivia = trivia;
    }

    public void setTriviaThread(Thread triviaThread) {
        this.triviaThread = triviaThread;
    }

    @Override
    public void setSwitchTrivia(boolean switchTrivia) {
        this.switchTrivia = switchTrivia;
    }

    @Override
    public Trivia getTrivia() {
        return this.trivia;
    }

    public Thread getTriviaThread() {
        return this.triviaThread;
    }

    @Override
    public boolean getSwitchTrivia() {
        return this.switchTrivia;
    }

    @Override
    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    @Override
    public KailleraUser getUser(int userID) {
        return this.users.get(userID);
    }

    @Override
    public KailleraGame getGame(int gameID) {
        return this.games.get(gameID);
    }

    public Collection<KailleraUserImpl> getUsers() {
        return this.users.values();
    }

    public Collection<KailleraGameImpl> getGames() {
        return this.games.values();
    }

    @Override
    public int getNumUsers() {
        return this.users.size();
    }

    @Override
    public int getNumGames() {
        return this.games.size();
    }

    public int getNumGamesPlaying() {
        int count = 0;
        for (KailleraGameImpl game : this.getGames()) {
            if (game.getStatus() == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getMaxPing() {
        return this.maxPing;
    }

    @Override
    public int getMaxUsers() {
        return this.maxUsers;
    }

    @Override
    public int getMaxGames() {
        return this.maxGames;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    protected int getChatFloodTime() {
        return this.chatFloodTime;
    }

    protected int getCreateGameFloodTime() {
        return this.createGameFloodTime;
    }

    protected boolean getAllowSinglePlayer() {
        return this.allowSinglePlayer;
    }

    protected int getMaxUserNameLength() {
        return this.maxUserNameLength;
    }

    protected int getMaxChatLength() {
        return this.maxChatLength;
    }

    protected int getMaxGameNameLength() {
        return this.maxGameNameLength;
    }

    protected int getQuitMessageLength() {
        return this.maxQuitMessageLength;
    }

    protected int getMaxClientNameLength() {
        return this.maxClientNameLength;
    }

    protected boolean getAllowMultipleConnections() {
        return this.allowMultipleConnections;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public String toString() {
        return "KailleraServerImpl[numUsers=" + this.getNumUsers() + " numGames=" + this.getNumGames() + " isRunning=" + this.isRunning() + "]";
    }

    public synchronized void start() {
        log.debug((Object)"KailleraServer thread received start request!");
        log.debug((Object)("KailleraServer thread starting (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        this.stopFlag = false;
        this.threadPool.execute(this);
        Thread.yield();
    }

    @Override
    public synchronized void stop() {
        log.debug((Object)"KailleraServer thread received stop request!");
        if (!this.isRunning()) {
            log.debug((Object)"KailleraServer thread stop request ignored: not running!");
            return;
        }
        this.stopFlag = true;
        for (KailleraUserImpl user : this.users.values()) {
            user.stop();
        }
        this.users.clear();
        this.games.clear();
    }

    protected int getNextUserID() {
        if (this.connectionCounter > 65535) {
            this.connectionCounter = 1;
        }
        return this.connectionCounter++;
    }

    protected int getNextGameID() {
        if (this.gameCounter > 65535) {
            this.gameCounter = 1;
        }
        return this.gameCounter++;
    }

    protected StatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    protected AutoFireDetector getAutoFireDetector(KailleraGame game) {
        return this.autoFireDetectorFactory.getInstance(game, this.gameAutoFireSensitivity);
    }

    @Override
    public ReleaseInfo getReleaseInfo() {
        return this.releaseInfo;
    }

    @Override
    public synchronized KailleraUser newConnection(InetSocketAddress clientSocketAddress, String protocol, KailleraEventListener listener) throws ServerFullException, NewConnectionException {
        log.debug((Object)("Processing connection request from " + EmuUtil.formatSocketAddress(clientSocketAddress)));
        int access = this.accessManager.getAccess(clientSocketAddress.getAddress());
        if (this.getMaxUsers() > 0 && this.users.size() >= this.getMaxUsers() && access <= 1) {
            log.warn((Object)("Connection from " + EmuUtil.formatSocketAddress(clientSocketAddress) + " denied: Server is full!"));
            throw new ServerFullException(EmuLang.getString("KailleraServerImpl.LoginDeniedServerFull"));
        }
        int userID = this.getNextUserID();
        KailleraUserImpl user = new KailleraUserImpl(userID, protocol, clientSocketAddress, listener, this);
        user.setStatus(2);
        log.info((Object)(user + " attempting new connection using protocol " + protocol + " from " + EmuUtil.formatSocketAddress(clientSocketAddress)));
        log.debug((Object)(user + " Thread starting (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        this.threadPool.execute(user);
        Thread.yield();
        log.debug((Object)(user + " Thread started (ThreadPool:" + this.threadPool.getActiveCount() + "/" + this.threadPool.getPoolSize() + ")"));
        this.users.put(userID, user);
        return user;
    }

    @Override
    public synchronized void login(KailleraUser user) throws PingTimeException, ClientAddressException, ConnectionTypeException, UserNameException, LoginException {
        KailleraUserImpl userImpl = (KailleraUserImpl)user;
        long loginDelay = System.currentTimeMillis() - user.getConnectTime();
        log.info((Object)(user + ": login request: delay=" + loginDelay + "ms, clientAddress=" + EmuUtil.formatSocketAddress(user.getSocketAddress()) + ", name=" + user.getName() + ", ping=" + user.getPing() + ", client=" + user.getClientType() + ", connection=" + KailleraUser.CONNECTION_TYPE_NAMES[user.getConnectionType()]));
        if (user.isLoggedIn()) {
            log.warn((Object)(user + " login denied: Already logged in!"));
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginDeniedAlreadyLoggedIn"));
        }
        Integer userListKey = new Integer(user.getID());
        KailleraUser u = this.users.get(userListKey);
        if (u == null) {
            log.warn((Object)(user + " login denied: Connection timed out!"));
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginDeniedConnectionTimedOut"));
        }
        int access = this.accessManager.getAccess(user.getSocketAddress().getAddress());
        if (access < 1) {
            log.info((Object)(user + " login denied: Access denied"));
            this.users.remove(userListKey);
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginDeniedAccessDenied"));
        }
        if (access == 1 && this.getMaxPing() > 0 && user.getPing() > this.getMaxPing()) {
            log.info((Object)(user + " login denied: Ping " + user.getPing() + " > " + this.getMaxPing()));
            this.users.remove(userListKey);
            throw new PingTimeException(EmuLang.getString("KailleraServerImpl.LoginDeniedPingTooHigh", String.valueOf(user.getPing()) + " > " + this.getMaxPing()));
        }
        if (access == 1 && !this.allowedConnectionTypes[user.getConnectionType()]) {
            log.info((Object)(user + " login denied: Connection " + KailleraUser.CONNECTION_TYPE_NAMES[user.getConnectionType()] + " Not Allowed"));
            this.users.remove(userListKey);
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginDeniedConnectionTypeDenied", KailleraUser.CONNECTION_TYPE_NAMES[user.getConnectionType()]));
        }
        if (user.getPing() < 0) {
            log.warn((Object)(user + " login denied: Invalid ping: " + user.getPing()));
            this.users.remove(userListKey);
            throw new PingTimeException(EmuLang.getString("KailleraServerImpl.LoginErrorInvalidPing", user.getPing()));
        }
        if (access == 1 && user.getName().trim().length() == 0) {
            log.info((Object)(user + " login denied: Empty UserName"));
            this.users.remove(userListKey);
            throw new UserNameException(EmuLang.getString("KailleraServerImpl.LoginDeniedUserNameEmpty"));
        }
        if (user.getName().equals("Server") || user.getName().toLowerCase().contains("|") || access == 1 && (user.getName().toLowerCase().contains("www.") || user.getName().toLowerCase().contains("http://") || user.getName().toLowerCase().contains("https://") || user.getName().toLowerCase().contains("\\") || user.getName().toLowerCase().contains("\u00a0") || user.getName().toLowerCase().contains("\u00ad"))) {
            log.info((Object)(user + " login denied: Illegal characters in UserName"));
            this.users.remove(userListKey);
            throw new UserNameException(EmuLang.getString("KailleraServerImpl.LoginDeniedIllegalCharactersInUserName"));
        }
        if (this.maxUserNameLength > 0 && user.getName().length() > this.getMaxUserNameLength()) {
            log.info((Object)(user + " login denied: UserName Length > " + this.getMaxUserNameLength()));
            this.users.remove(userListKey);
            throw new UserNameException(EmuLang.getString("KailleraServerImpl.LoginDeniedUserNameTooLong"));
        }
        if (access == 1 && this.maxClientNameLength > 0 && user.getClientType().length() > this.getMaxClientNameLength()) {
            log.info((Object)(user + " login denied: Client Name Length > " + this.getMaxClientNameLength()));
            this.users.remove(userListKey);
            throw new UserNameException(EmuLang.getString("KailleraServerImpl.LoginDeniedEmulatorNameTooLong"));
        }
        if (user.getClientType().toLowerCase().contains("|")) {
            log.warn((Object)(user + " login denied: Illegal characters in EmulatorName"));
            this.users.remove(userListKey);
            throw new UserNameException("Illegal characters in Emulator Name");
        }
        if (access == 1) {
            char[] chars = user.getName().toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] < ' ') {
                    log.info((Object)(user + " login denied: Illegal characters in UserName"));
                    this.users.remove(userListKey);
                    throw new UserNameException(EmuLang.getString("KailleraServerImpl.LoginDeniedIllegalCharactersInUserName"));
                }
                ++i;
            }
        }
        if (u.getStatus() != 2) {
            this.users.remove(userListKey);
            log.warn((Object)(user + " login denied: Invalid status=" + KailleraUser.STATUS_NAMES[u.getStatus()]));
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginErrorInvalidStatus", u.getStatus()));
        }
        if (!u.getConnectSocketAddress().getAddress().equals(user.getSocketAddress().getAddress())) {
            this.users.remove(userListKey);
            log.warn((Object)(user + " login denied: Connect address does not match login address: " + u.getConnectSocketAddress().getAddress().getHostAddress() + " != " + user.getSocketAddress().getAddress().getHostAddress()));
            throw new ClientAddressException(EmuLang.getString("KailleraServerImpl.LoginDeniedAddressMatchError"));
        }
        if (access == 1 && !this.accessManager.isEmulatorAllowed(user.getClientType())) {
            log.info((Object)(user + " login denied: AccessManager denied emulator: " + user.getClientType()));
            this.users.remove(userListKey);
            throw new LoginException(EmuLang.getString("KailleraServerImpl.LoginDeniedEmulatorRestricted", user.getClientType()));
        }
        for (KailleraUserImpl u2 : this.getUsers()) {
            if (!u2.isLoggedIn()) continue;
            if (!u2.equals(u) && u.getConnectSocketAddress().getAddress().equals(u2.getConnectSocketAddress().getAddress()) && u.getName().equals(u2.getName())) {
                try {
                    this.quit(u2, EmuLang.getString("KailleraServerImpl.ForcedQuitReconnected"));
                }
                catch (Exception e) {
                    log.error((Object)("Error forcing " + u2 + " quit for reconnect!"), (Throwable)e);
                }
            } else if (!u2.equals(u) && u2.getName().toLowerCase().trim().equals(u.getName().toLowerCase().trim())) {
                this.users.remove(userListKey);
                log.warn((Object)(user + " login denied: Duplicating Names is not allowed! " + u2.getName()));
                throw new ClientAddressException("Duplicating names is not allowed: " + u2.getName());
            }
            if (access != 1 || u2.equals(u) || !u.getConnectSocketAddress().getAddress().equals(u2.getConnectSocketAddress().getAddress()) || u.getName().equals(u2.getName()) || this.allowMultipleConnections) continue;
            this.users.remove(userListKey);
            log.warn((Object)(user + " login denied: Address already logged in as " + u2.getName()));
            throw new ClientAddressException(EmuLang.getString("KailleraServerImpl.LoginDeniedAlreadyLoggedInAs", u2.getName()));
        }
        userImpl.setAccess(access);
        userImpl.setStatus(1);
        userImpl.setLoggedIn();
        this.users.put(userListKey, userImpl);
        userImpl.addEvent(new ConnectedEvent(this, user));
        try {
            Thread.sleep(20L);
        }
        catch (Exception u2) {
            // empty catch block
        }
        for (String loginMessage : this.loginMessages) {
            userImpl.addEvent(new InfoMessageEvent(user, loginMessage));
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (access > 1) {
            log.info((Object)(user + " logged in successfully with " + AccessManager.ACCESS_NAMES[access] + " access!"));
        } else {
            log.info((Object)(user + " logged in successfully"));
        }
        if (user.isEmuLinkerClient()) {
            userImpl.addEvent(new InfoMessageEvent(user, ":ACCESS=" + userImpl.getAccessStr()));
            if (access >= 5) {
                StringBuilder sb = new StringBuilder();
                sb.append(":USERINFO=");
                int sbCount = 0;
                for (KailleraUserImpl u3 : this.getUsers()) {
                    if (!u3.isLoggedIn()) continue;
                    sb.append(u3.getID());
                    sb.append('\u0002');
                    sb.append(u3.getConnectSocketAddress().getAddress().getHostAddress());
                    sb.append('\u0002');
                    sb.append(u3.getAccessStr());
                    sb.append('\u0002');
                    sb.append(u3.getName());
                    sb.append('\u0002');
                    sb.append(u3.getPing());
                    sb.append('\u0002');
                    sb.append(u3.getStatus());
                    sb.append('\u0002');
                    sb.append(u3.getConnectionType());
                    sb.append('\u0003');
                    ++sbCount;
                    if (sb.length() <= 300) continue;
                    ((KailleraUserImpl)user).addEvent(new InfoMessageEvent(user, sb.toString()));
                    sb = new StringBuilder();
                    sb.append(":USERINFO=");
                    sbCount = 0;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sbCount > 0) {
                    ((KailleraUserImpl)user).addEvent(new InfoMessageEvent(user, sb.toString()));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception sb) {
            // empty catch block
        }
        if (access >= 4) {
            userImpl.addEvent(new InfoMessageEvent(user, EmuLang.getString("KailleraServerImpl.AdminWelcomeMessage")));
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception sb) {
            // empty catch block
        }
        userImpl.addEvent(new InfoMessageEvent(user, String.valueOf(this.getReleaseInfo().getProductName()) + " v" + this.getReleaseInfo().getVersionString() + ": " + this.getReleaseInfo().getReleaseDate() + " - Visit: https://god-weapon.github.io"));
        try {
            Thread.sleep(20L);
        }
        catch (Exception sb) {
            // empty catch block
        }
        this.addEvent(new UserJoinedEvent(this, user));
        try {
            Thread.sleep(20L);
        }
        catch (Exception sb) {
            // empty catch block
        }
        String announcement = this.accessManager.getAnnouncement(user.getSocketAddress().getAddress());
        if (announcement != null) {
            this.announce(announcement, false, null);
        }
    }

    @Override
    public synchronized void quit(KailleraUser user, String message) throws QuitException, DropGameException, QuitGameException, CloseGameException {
        int access;
        String quitMsg;
        KailleraGameImpl userGame;
        if (!user.isLoggedIn()) {
            this.users.remove(user.getID());
            log.error((Object)(user + " quit failed: Not logged in"));
            throw new QuitException(EmuLang.getString("KailleraServerImpl.NotLoggedIn"));
        }
        if (this.users.remove(user.getID()) == null) {
            log.error((Object)(user + " quit failed: not in user list"));
        }
        if ((userGame = ((KailleraUserImpl)user).getGame()) != null) {
            user.quitGame();
        }
        if ((quitMsg = message.trim()).length() == 0 || this.maxQuitMessageLength > 0 && quitMsg.length() > this.maxQuitMessageLength) {
            quitMsg = EmuLang.getString("KailleraServerImpl.StandardQuitMessage");
        }
        if ((access = user.getServer().getAccessManager().getAccess(user.getSocketAddress().getAddress())) < 5 && user.getServer().getAccessManager().isSilenced(user.getSocketAddress().getAddress())) {
            quitMsg = "https://god-weapon.github.io";
        }
        log.info((Object)(user + " quit: " + quitMsg));
        UserQuitEvent quitEvent = new UserQuitEvent(this, user, quitMsg);
        this.addEvent(quitEvent);
        ((KailleraUserImpl)user).addEvent(quitEvent);
    }

    @Override
    public synchronized void chat(KailleraUser user, String message) throws ChatException, FloodException {
        if (!user.isLoggedIn()) {
            log.error((Object)(user + " chat failed: Not logged in"));
            throw new ChatException(EmuLang.getString("KailleraServerImpl.NotLoggedIn"));
        }
        int access = this.accessManager.getAccess(user.getSocketAddress().getAddress());
        if (access < 5 && this.accessManager.isSilenced(user.getSocketAddress().getAddress())) {
            log.warn((Object)(user + " chat denied: Silenced: " + message));
            throw new ChatException(EmuLang.getString("KailleraServerImpl.ChatDeniedSilenced"));
        }
        if (access == 1 && this.chatFloodTime > 0 && System.currentTimeMillis() - ((KailleraUserImpl)user).getLastChatTime() < (long)(this.chatFloodTime * 1000)) {
            log.warn((Object)(user + " chat denied: Flood: " + message));
            throw new FloodException(EmuLang.getString("KailleraServerImpl.ChatDeniedFloodControl"));
        }
        if (message.equals(":USER_COMMAND")) {
            return;
        }
        if ((message = message.trim()).length() == 0 || message.startsWith("\u00a0") || message.startsWith("\u00ad")) {
            return;
        }
        if (access == 1) {
            char[] chars = message.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] < ' ') {
                    log.warn((Object)(user + " chat denied: Illegal characters in message"));
                    throw new ChatException(EmuLang.getString("KailleraServerImpl.ChatDeniedIllegalCharacters"));
                }
                ++i;
            }
            if (this.maxChatLength > 0 && message.length() > this.maxChatLength) {
                log.warn((Object)(user + " chat denied: Message Length > " + this.maxChatLength));
                throw new ChatException(EmuLang.getString("KailleraServerImpl.ChatDeniedMessageTooLong"));
            }
        }
        log.info((Object)(user + " chat: " + message));
        this.addEvent(new ChatEvent(this, user, message));
        if (this.switchTrivia && !this.trivia.isAnswered() && this.trivia.isCorrect(message)) {
            this.trivia.addScore(user.getName(), user.getSocketAddress().getAddress().getHostAddress(), message);
        }
    }

    @Override
    public synchronized KailleraGame createGame(KailleraUser user, String romName) throws CreateGameException, FloodException {
        if (!user.isLoggedIn()) {
            log.error((Object)(user + " create game failed: Not logged in"));
            throw new CreateGameException(EmuLang.getString("KailleraServerImpl.NotLoggedIn"));
        }
        if (((KailleraUserImpl)user).getGame() != null) {
            log.error((Object)(user + " create game failed: already in game: " + ((KailleraUserImpl)user).getGame()));
            throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameErrorAlreadyInGame"));
        }
        if (this.maxGameNameLength > 0 && romName.trim().length() > this.maxGameNameLength) {
            log.warn((Object)(user + " create game denied: Rom Name Length > " + this.maxGameNameLength));
            throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedNameTooLong"));
        }
        if (romName.toLowerCase().contains("|")) {
            log.warn((Object)(user + " create game denied: Illegal characters in ROM name"));
            throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedIllegalCharacters"));
        }
        int access = this.accessManager.getAccess(user.getSocketAddress().getAddress());
        if (access == 1) {
            if (this.createGameFloodTime > 0 && System.currentTimeMillis() - ((KailleraUserImpl)user).getLastCreateGameTime() < (long)(this.createGameFloodTime * 1000)) {
                log.warn((Object)(user + " create game denied: Flood: " + romName));
                throw new FloodException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedFloodControl"));
            }
            if (this.maxGames > 0 && this.getNumGames() >= this.maxGames) {
                log.warn((Object)(user + " create game denied: Over maximum of " + this.maxGames + " current games!"));
                throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedMaxGames", this.maxGames));
            }
            char[] chars = romName.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] < ' ') {
                    log.warn((Object)(user + " create game denied: Illegal characters in ROM name"));
                    throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedIllegalCharacters"));
                }
                ++i;
            }
            if (romName.trim().length() == 0) {
                log.warn((Object)(user + " create game denied: Rom Name Empty"));
                throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameErrorEmptyName"));
            }
            if (!this.accessManager.isGameAllowed(romName)) {
                log.warn((Object)(user + " create game denied: AccessManager denied game: " + romName));
                throw new CreateGameException(EmuLang.getString("KailleraServerImpl.CreateGameDeniedGameBanned"));
            }
        }
        KailleraGameImpl game = null;
        int gameID = this.getNextGameID();
        game = new KailleraGameImpl(gameID, romName, (KailleraUserImpl)user, this, this.gameBufferSize, this.gameTimeoutMillis, this.gameDesynchTimeouts);
        this.games.put(gameID, game);
        this.addEvent(new GameCreatedEvent(this, game));
        log.info((Object)(user + " created: " + game + ": " + game.getRomName()));
        try {
            user.joinGame(game.getID());
        }
        catch (Exception e) {
            log.error((Object)"Caught exception while making owner join game! This shouldn't happen!", (Throwable)e);
        }
        this.announce(EmuLang.getString("KailleraServerImpl.UserCreatedGameAnnouncement", user.getName(), game.getRomName()), false, null);
        return game;
    }

    synchronized void closeGame(KailleraGame game, KailleraUser user) throws CloseGameException {
        if (!user.isLoggedIn()) {
            log.error((Object)(user + " close " + game + " failed: Not logged in"));
            throw new CloseGameException(EmuLang.getString("KailleraServerImpl.NotLoggedIn"));
        }
        if (!this.games.containsKey(game.getID())) {
            log.error((Object)(user + " close " + game + " failed: not in list: " + game));
            return;
        }
        ((KailleraGameImpl)game).close(user);
        this.games.remove(game.getID());
        log.info((Object)(user + " closed: " + game));
        this.addEvent(new GameClosedEvent(this, game));
    }

    @Override
    public boolean checkMe(KailleraUser user, String message) {
        if (!user.isLoggedIn()) {
            log.error((Object)(user + " chat failed: Not logged in"));
            return false;
        }
        int access = this.accessManager.getAccess(user.getSocketAddress().getAddress());
        if (access < 5 && this.accessManager.isSilenced(user.getSocketAddress().getAddress())) {
            log.warn((Object)(user + " /me: Silenced: " + message));
            return false;
        }
        if (message.equals(":USER_COMMAND")) {
            return false;
        }
        if ((message = message.trim()).length() == 0) {
            return false;
        }
        if (access == 1) {
            char[] chars = message.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] < ' ') {
                    log.warn((Object)(user + " /me: Illegal characters in message"));
                    return false;
                }
                ++i;
            }
            if (this.maxChatLength > 0 && message.length() > this.maxChatLength) {
                log.warn((Object)(user + " /me denied: Message Length > " + this.maxChatLength));
                return false;
            }
        }
        return true;
    }

    @Override
    public void announce(String announcement, boolean gamesAlso, KailleraUserImpl user) {
        if (user != null) {
            if (gamesAlso) {
                for (KailleraUserImpl kailleraUser : this.getUsers()) {
                    if (!kailleraUser.isLoggedIn()) continue;
                    int access = this.accessManager.getAccess(user.getConnectSocketAddress().getAddress());
                    if (access < 4) {
                        if (kailleraUser.searchIgnoredUsers(user.getConnectSocketAddress().getAddress().getHostAddress())) continue;
                        kailleraUser.addEvent(new InfoMessageEvent(kailleraUser, announcement));
                        continue;
                    }
                    kailleraUser.addEvent(new InfoMessageEvent(kailleraUser, announcement));
                }
            } else {
                user.addEvent(new InfoMessageEvent(user, announcement));
            }
            return;
        }
        for (KailleraUserImpl kailleraUser : this.getUsers()) {
            if (!kailleraUser.isLoggedIn()) continue;
            kailleraUser.addEvent(new InfoMessageEvent(kailleraUser, announcement));
            if (!gamesAlso || kailleraUser.getGame() == null) continue;
            kailleraUser.getGame().announce(announcement, kailleraUser);
            Thread.yield();
        }
    }

    protected void addEvent(ServerEvent event) {
        for (KailleraUserImpl user : this.users.values()) {
            if (user.isLoggedIn()) {
                if (user.getStatus() != 1) {
                    if (user.getP2P()) {
                        if (event.toString().equals("GameDataEvent")) {
                            user.addEvent(event);
                            continue;
                        }
                        if (event.toString().equals("ChatEvent") || event.toString().equals("UserJoinedEvent") || event.toString().equals("UserQuitEvent") || event.toString().equals("GameStatusChangedEvent") || event.toString().equals("GameClosedEvent") || event.toString().equals("GameCreatedEvent")) continue;
                        user.addEvent(event);
                        continue;
                    }
                    user.addEvent(event);
                    continue;
                }
                user.addEvent(event);
                continue;
            }
            log.debug((Object)(user + ": not adding event, not logged in: " + event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        log.debug((Object)"KailleraServer thread running...");
        try {
            try {
                while (!this.stopFlag) {
                    try {
                        Thread.sleep(this.maxPing * 3);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Sleep Interrupted!", (Throwable)e);
                    }
                    if (this.stopFlag) {
                        break;
                    }
                    if (this.users.isEmpty()) continue;
                    Iterator<KailleraUserImpl> iterator = this.getUsers().iterator();
                    while (iterator.hasNext()) {
                        KailleraUserImpl user;
                        KailleraUserImpl kailleraUserImpl = user = iterator.next();
                        synchronized (kailleraUserImpl) {
                            int access = this.accessManager.getAccess(user.getConnectSocketAddress().getAddress());
                            user.setAccess(access);
                            if (user.isLoggedIn() && user.getGame() != null && user.getGame().getStatus() == 2 && !user.getGame().getStartTimeout() && System.currentTimeMillis() - user.getGame().getStartTimeoutTime() > 15000L) {
                                user.getGame().setStartTimeout(true);
                            }
                            if (!user.isLoggedIn() && System.currentTimeMillis() - user.getConnectTime() > (long)(this.maxPing * 15)) {
                                log.info((Object)(user + " connection timeout!"));
                                user.stop();
                                this.users.remove(user.getID());
                            } else if (user.isLoggedIn() && System.currentTimeMillis() - user.getLastKeepAlive() > (long)(this.keepAliveTimeout * 1000)) {
                                log.info((Object)(user + " keepalive timeout!"));
                                try {
                                    this.quit(user, EmuLang.getString("KailleraServerImpl.ForcedQuitPingTimeout"));
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error forcing " + user + " quit for keepalive timeout!"), (Throwable)e);
                                }
                            } else if (this.idleTimeout > 0 && access == 1 && user.isLoggedIn() && System.currentTimeMillis() - user.getLastActivity() > (long)(this.idleTimeout * 1000)) {
                                log.info((Object)(user + " inactivity timeout!"));
                                try {
                                    this.quit(user, EmuLang.getString("KailleraServerImpl.ForcedQuitInactivityTimeout"));
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error forcing " + user + " quit for inactivity timeout!"), (Throwable)e);
                                }
                            } else if (user.isLoggedIn() && access < 1) {
                                log.info((Object)(user + " banned!"));
                                try {
                                    this.quit(user, EmuLang.getString("KailleraServerImpl.ForcedQuitBanned"));
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error forcing " + user + " quit because banned!"), (Throwable)e);
                                }
                            } else if (user.isLoggedIn() && access == 1 && !this.accessManager.isEmulatorAllowed(user.getClientType())) {
                                log.info((Object)(user + ": emulator restricted!"));
                                try {
                                    this.quit(user, EmuLang.getString("KailleraServerImpl.ForcedQuitEmulatorRestricted"));
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error forcing " + user + " quit because emulator restricted!"), (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!this.stopFlag) {
                    log.fatal((Object)("KailleraServer thread caught unexpected exception: " + e), e);
                }
                this.isRunning = false;
                log.debug((Object)"KailleraServer thread exiting...");
            }
        }
        finally {
            this.isRunning = false;
            log.debug((Object)"KailleraServer thread exiting...");
        }
    }
}

