/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.reflection;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.NanoPicoContainer;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;

public abstract class AbstractNanoPicoContainer
implements NanoPicoContainer,
Serializable {
    protected MutablePicoContainer delegate;
    protected Map namedChildContainers = new HashMap();
    protected transient NanoContainer container;

    protected AbstractNanoPicoContainer() {
    }

    protected AbstractNanoPicoContainer(MutablePicoContainer delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.container = new DefaultNanoContainer(classLoader, delegate);
    }

    public final Object getComponentInstance(Object componentKey) throws PicoException {
        Object instance = this.delegate.getComponentInstance(componentKey);
        if (instance != null) {
            return instance;
        }
        ComponentAdapter componentAdapter = null;
        if (componentKey.toString().startsWith("*")) {
            String candidateClassName = componentKey.toString().substring(1);
            Collection cas = this.getComponentAdapters();
            Iterator it = cas.iterator();
            while (it.hasNext()) {
                ComponentAdapter ca = (ComponentAdapter)it.next();
                Object key = ca.getComponentKey();
                if (!(key instanceof Class) || !candidateClassName.equals(((Class)key).getName())) continue;
                componentAdapter = ca;
                break;
            }
        }
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance((PicoContainer)this);
        }
        return this.getComponentInstanceFromChildren(componentKey);
    }

    private final Object getComponentInstanceFromChildren(Object componentKey) {
        String componentKeyPath = componentKey.toString();
        int ix = componentKeyPath.indexOf(47);
        if (ix != -1) {
            String firstElement = componentKeyPath.substring(0, ix);
            String remainder = componentKeyPath.substring(ix + 1, componentKeyPath.length());
            Object o = this.getNamedContainers().get(firstElement);
            if (o != null) {
                MutablePicoContainer child = (MutablePicoContainer)o;
                return child.getComponentInstance((Object)remainder);
            }
        }
        return null;
    }

    public final MutablePicoContainer makeChildContainer() {
        return this.makeChildContainer("containers" + this.namedChildContainers.size());
    }

    public void removeChildContainer(PicoContainer child) {
        this.delegate.removeChildContainer(child);
        Iterator children = this.namedChildContainers.entrySet().iterator();
        while (children.hasNext()) {
            Map.Entry e = children.next();
            PicoContainer pc = (PicoContainer)e.getValue();
            if (pc != child) continue;
            children.remove();
        }
    }

    protected final Map getNamedContainers() {
        return this.namedChildContainers;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        return this.delegate.getComponentInstanceOfType(componentType);
    }

    public Object getComponentInstanceOfType(String componentType) {
        return this.container.getComponentInstanceOfType(componentType);
    }

    public List getComponentInstances() {
        return this.delegate.getComponentInstances();
    }

    public synchronized PicoContainer getParent() {
        return this.delegate.getParent();
    }

    public ComponentAdapter getComponentAdapter(Object componentKey) {
        return this.delegate.getComponentAdapter(componentKey);
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return this.delegate.getComponentAdapterOfType(componentType);
    }

    public Collection getComponentAdapters() {
        return this.delegate.getComponentAdapters();
    }

    public List getComponentAdaptersOfType(Class componentType) {
        return this.delegate.getComponentAdaptersOfType(componentType);
    }

    public void verify() throws PicoVerificationException {
        this.delegate.verify();
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.delegate.registerComponentImplementation(componentKey, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        return this.delegate.registerComponentImplementation(componentKey, componentImplementation, parameters);
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.delegate.registerComponentImplementation(componentImplementation);
    }

    public ComponentAdapter registerComponentInstance(Object componentInstance) throws PicoRegistrationException {
        return this.delegate.registerComponentInstance(componentInstance);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        return this.delegate.registerComponentInstance(componentKey, componentInstance);
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws PicoRegistrationException {
        return this.delegate.registerComponent(componentAdapter);
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        return this.delegate.unregisterComponent(componentKey);
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        return this.delegate.unregisterComponentByInstance(componentInstance);
    }

    public void addClassLoaderURL(URL url) {
        this.container.addClassLoaderURL(url);
    }

    public ComponentAdapter registerComponentImplementation(String componentImplementationClassName) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        return this.container.registerComponentImplementation(componentImplementationClassName);
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName) throws ClassNotFoundException {
        return this.container.registerComponentImplementation(key, componentImplementationClassName);
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName, Parameter[] parameters) throws ClassNotFoundException {
        return this.container.registerComponentImplementation(key, componentImplementationClassName, parameters);
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName, String[] parameterTypesAsString, String[] parameterValuesAsString) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        return this.container.registerComponentImplementation(key, componentImplementationClassName, parameterTypesAsString, parameterValuesAsString);
    }

    public ComponentAdapter registerComponentImplementation(String componentImplementationClassName, String[] parameterTypesAsString, String[] parameterValuesAsString) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        return this.container.registerComponentImplementation(componentImplementationClassName, parameterTypesAsString, parameterValuesAsString);
    }

    public MutablePicoContainer getPico() {
        return this;
    }

    public ClassLoader getComponentClassLoader() {
        return this.container.getComponentClassLoader();
    }

    public void accept(PicoVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public List getComponentInstancesOfType(Class type) throws PicoException {
        return this.delegate.getComponentInstancesOfType(type);
    }

    public void addChildContainer(PicoContainer child) {
        this.delegate.addChildContainer(child);
        this.namedChildContainers.put("containers" + this.namedChildContainers.size(), child);
    }

    public void addChildContainer(String name, PicoContainer child) {
        this.delegate.addChildContainer(child);
        this.namedChildContainers.put(name, child);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }
}

