/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.reflection;

import java.util.HashMap;
import java.util.Map;
import org.nanocontainer.reflection.Converter;
import org.nanocontainer.reflection.InvalidConversionException;

public class StringToObjectConverter {
    private final Map converters = new HashMap();

    public StringToObjectConverter() {
        this.register(String.class, new Converter(){

            public Object convert(String in) {
                return in;
            }
        });
        this.register(Integer.class, new Converter(){

            public Object convert(String in) {
                return in == null ? new Integer(0) : Integer.valueOf(in);
            }
        });
        this.register(Long.class, new Converter(){

            public Object convert(String in) {
                return in == null ? new Long(0L) : Long.valueOf(in);
            }
        });
        this.register(Boolean.class, new Converter(){

            public Object convert(String in) {
                if (in == null || in.length() == 0) {
                    return Boolean.FALSE;
                }
                char c = in.toLowerCase().charAt(0);
                return c == '1' || c == 'y' || c == 't' ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public Object convertTo(Class desiredClass, String inputString) {
        Converter converter = (Converter)this.converters.get(desiredClass);
        if (converter == null) {
            throw new InvalidConversionException("Cannot convert to type " + desiredClass.getName());
        }
        return converter.convert(inputString);
    }

    public void register(Class type, Converter converter) {
        this.converters.put(type, converter);
    }
}

