/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy;

import java.util.Collection;
import java.util.Iterator;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class GroovyScriptGenerator {
    public String generateScript(MutablePicoContainer pico) {
        StringBuffer groovy = new StringBuffer();
        groovy.append("pico = new org.nanocontainer.reflection.DefaultNanoPicoContainer()\n");
        Collection componentAdapters = pico.getComponentAdapters();
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            Object componentKey = componentAdapter.getComponentKey();
            String groovyKey = null;
            if (componentKey instanceof Class) {
                groovyKey = ((Class)componentKey).getName();
            } else if (componentKey instanceof String) {
                groovyKey = "\"" + componentKey + "\"";
            }
            Object componentInstance = componentAdapter.getComponentInstance((PicoContainer)pico);
            if (componentInstance instanceof String) {
                groovy.append("pico.registerComponentInstance(" + groovyKey + ", \"" + componentInstance + "\")\n");
                continue;
            }
            groovy.append("pico.registerComponentImplementation(" + groovyKey + ", " + componentInstance.getClass().getName() + ")\n");
        }
        return groovy.toString();
    }
}

