/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.aop.dynaop;

import dynaop.Interceptor;
import dynaop.InterceptorFactory;
import dynaop.Proxy;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.nanocontainer.aop.dynaop.MethodInterceptorAdapter;
import org.picocontainer.PicoContainer;

class ContainerSuppliedInterceptorFactory
implements InterceptorFactory {
    private final PicoContainer pico;
    private final Object interceptorComponentKey;

    ContainerSuppliedInterceptorFactory(PicoContainer pico, Object interceptorComponentKey) {
        this.pico = pico;
        this.interceptorComponentKey = interceptorComponentKey;
    }

    public Interceptor create(Proxy proxy) throws NullPointerException {
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.pico.getComponentInstance(this.interceptorComponentKey);
        if (methodInterceptor == null) {
            throw new NullPointerException("Interceptor with component key " + this.interceptorComponentKey + " + not found in PicoContainer");
        }
        return new MethodInterceptorAdapter(methodInterceptor);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("advice", "method interceptor");
        properties.setProperty("scope", "per-instance");
        return properties;
    }
}

