/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.concurrent;

import com.thoughtworks.proxy.toys.multicast.ClassHierarchyIntrospector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nanocontainer.concurrent.ThreadLocalReference;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ObjectReference;

public class ThreadLocalComponentAdapter
extends DecoratingComponentAdapter {
    private static Map m_proxyMap = Collections.synchronizedMap(new HashMap());

    public ThreadLocalComponentAdapter(ComponentAdapter delegate) {
        super((ComponentAdapter)new CachingComponentAdapter(delegate, (ObjectReference)new ThreadLocalReference()));
    }

    public Object getComponentInstance(final PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentKey = this.getDelegate().getComponentKey();
        String key = String.valueOf(System.identityHashCode(componentKey)) + "." + String.valueOf(System.identityHashCode(pico));
        Object proxy = m_proxyMap.get(key);
        if (proxy == null) {
            Class[] interfaces = componentKey instanceof Class && ((Class)componentKey).isInterface() ? new Class[]{(Class)this.getDelegate().getComponentKey()} : ClassHierarchyIntrospector.getAllInterfaces((Class)this.getDelegate().getComponentImplementation());
            if (interfaces.length == 0) {
                throw new PicoIntrospectionException("Can't proxy implementation for " + this.getDelegate().getComponentImplementation().getName() + ". It doesn't implement any interfaces.");
            }
            InvocationHandler threadLocalInvocationHandler = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object delegatedInstance = ThreadLocalComponentAdapter.this.getDelegate().getComponentInstance(pico);
                    return method.invoke(delegatedInstance, args);
                }
            };
            proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), interfaces, threadLocalInvocationHandler);
            m_proxyMap.put(key, proxy);
        }
        return proxy;
    }
}

