/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.integrationkit.ContainerPopulator;
import org.nanocontainer.integrationkit.PicoCompositionException;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.xml.EmptyCompositionException;
import org.nanocontainer.script.xml.XMLComponentInstanceFactory;
import org.nanocontainer.script.xml.XStreamComponentInstanceFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLContainerBuilder
extends ScriptedContainerBuilder
implements ContainerPopulator {
    private static final String DEFAULT_INSTANCE_FACTORY = XStreamComponentInstanceFactory.class.getName();
    private static final String DEFAULT_COMPONENT_ADAPTER_FACTORY = DefaultComponentAdapterFactory.class.getName();
    private static final String CONTAINER = "container";
    private static final String CLASSPATH = "classpath";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_IMPLEMENTATION = "component-implementation";
    private static final String COMPONENT_INSTANCE = "component-instance";
    private static final String COMPONENT_ADAPTER = "component-adapter";
    private static final String COMPONENT_ADAPTER_FACTORY = "component-adapter-factory";
    private static final String CLASS = "class";
    private static final String FACTORY = "factory";
    private static final String FILE = "file";
    private static final String KEY = "key";
    private static final String PARAMETER = "parameter";
    private static final String URL = "url";
    private static final String EMPTY = "";
    private final Element rootElement;

    public XMLContainerBuilder(Reader script, ClassLoader classLoader) {
        super(script, classLoader);
        InputSource inputSource = new InputSource(script);
        try {
            this.rootElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException("SAXException : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException("IOException : " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new NanoContainerMarkupException("PArserConfigurationException :" + e.getMessage(), e);
        }
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        try {
            String cafName = this.rootElement.getAttribute(COMPONENT_ADAPTER_FACTORY);
            if (EMPTY.equals(cafName) || cafName == null) {
                cafName = DEFAULT_COMPONENT_ADAPTER_FACTORY;
            }
            ComponentAdapterFactory componentAdapterFactory = this.createComponentAdapterFactory(cafName);
            DefaultPicoContainer childContainer = new DefaultPicoContainer(componentAdapterFactory, parentContainer);
            this.populateContainer((MutablePicoContainer)childContainer);
            return childContainer;
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException("Class not found:" + e.getMessage(), e);
        }
    }

    public void populateContainer(MutablePicoContainer container) {
        try {
            DefaultNanoContainer nanoContainer = new DefaultNanoContainer(this.classLoader, container);
            this.registerComponentsAndChildContainers(nanoContainer, this.rootElement);
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException("Class not found:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    private void registerComponentsAndChildContainers(NanoContainer parentContainer, Element containerElement) throws ClassNotFoundException, IOException, SAXException {
        NodeList children = containerElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            String name;
            if (!(children.item(i) instanceof Element) || !CLASSPATH.equals(name = (childElement = (Element)children.item(i)).getNodeName())) continue;
            this.registerClasspath(parentContainer, childElement);
        }
        int count = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String name = childElement.getNodeName();
            if (CONTAINER.equals(name)) {
                MutablePicoContainer childContainer = parentContainer.getPico().makeChildContainer();
                DefaultNanoContainer childNanoContainer = new DefaultNanoContainer(parentContainer.getComponentClassLoader(), childContainer);
                this.registerComponentsAndChildContainers(childNanoContainer, childElement);
                ++count;
                continue;
            }
            if (CLASSPATH.equals(name)) continue;
            if (COMPONENT_IMPLEMENTATION.equals(name) || COMPONENT.equals(name)) {
                this.registerComponentImplementation(parentContainer, childElement);
                ++count;
                continue;
            }
            if (COMPONENT_INSTANCE.equals(name)) {
                this.registerComponentInstance(parentContainer, childElement);
                ++count;
                continue;
            }
            if (COMPONENT_ADAPTER.equals(name)) {
                this.registerComponentAdapter(parentContainer, childElement);
                ++count;
                continue;
            }
            throw new NanoContainerMarkupException("Unsupported element:" + name);
        }
        if (count == 0) {
            throw new EmptyCompositionException();
        }
    }

    private void registerClasspath(NanoContainer container, Element classpathElement) throws IOException {
        NodeList children = classpathElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String fileName = childElement.getAttribute(FILE);
            String urlSpec = childElement.getAttribute(URL);
            URL url = null;
            if (urlSpec != null && !EMPTY.equals(urlSpec)) {
                url = new URL(urlSpec);
            } else {
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException(file.getAbsolutePath() + " doesn't exist");
                }
                url = file.toURL();
            }
            container.addClassLoaderURL(url);
        }
    }

    private PicoContainer registerComponentImplementation(NanoContainer container, Element element) throws ClassNotFoundException {
        String className = element.getAttribute(CLASS);
        if (EMPTY.equals(className)) {
            throw new NanoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Parameter[] parameters = this.createChildParameters(container, element);
        String key = element.getAttribute(KEY);
        Class<?> clazz = this.classLoader.loadClass(className);
        if (key == null || key.equals(EMPTY)) {
            if (parameters == null) {
                container.getPico().registerComponentImplementation(clazz);
            } else {
                container.getPico().registerComponentImplementation(clazz, clazz, parameters);
            }
        } else if (parameters == null) {
            container.getPico().registerComponentImplementation((Object)key, clazz);
        } else {
            container.getPico().registerComponentImplementation((Object)key, clazz, parameters);
        }
        return null;
    }

    private Parameter[] createChildParameters(NanoContainer container, Element element) throws ClassNotFoundException {
        ArrayList<Object> parametersList = new ArrayList<Object>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            if (!(children.item(i) instanceof Element) || !PARAMETER.equals((childElement = (Element)children.item(i)).getNodeName())) continue;
            String key = childElement.getAttribute(KEY);
            if (key != null && !EMPTY.equals(key)) {
                parametersList.add(new ComponentParameter((Object)key));
                continue;
            }
            parametersList.add(this.createConstantParameter((PicoContainer)container.getPico(), childElement));
        }
        Parameter[] parameters = null;
        if (!parametersList.isEmpty()) {
            parameters = parametersList.toArray(new Parameter[parametersList.size()]);
        }
        return parameters;
    }

    private Parameter createConstantParameter(PicoContainer pico, Element element) throws ClassNotFoundException {
        NodeList children = element.getChildNodes();
        Element childElement = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            childElement = (Element)children.item(i);
            break;
        }
        XMLComponentInstanceFactory factory = this.createComponentInstanceFactory(element.getAttribute(FACTORY));
        Object instance = factory.makeInstance(pico, childElement);
        return new ConstantParameter(instance);
    }

    private void registerComponentInstance(NanoContainer container, Element element) throws ClassNotFoundException, PicoCompositionException {
        NodeList children = element.getChildNodes();
        Element childElement = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            childElement = (Element)children.item(i);
            break;
        }
        XMLComponentInstanceFactory factory = this.createComponentInstanceFactory(element.getAttribute(FACTORY));
        Object instance = factory.makeInstance((PicoContainer)container.getPico(), childElement);
        String key = element.getAttribute(KEY);
        if (key == null || key.equals(EMPTY)) {
            container.getPico().registerComponentInstance(instance);
        } else {
            container.getPico().registerComponentInstance((Object)key, instance);
        }
    }

    private XMLComponentInstanceFactory createComponentInstanceFactory(String factoryClass) throws ClassNotFoundException {
        if (factoryClass == null || factoryClass.equals(EMPTY)) {
            factoryClass = DEFAULT_INSTANCE_FACTORY;
        }
        DefaultNanoContainer adapter = new DefaultNanoContainer();
        adapter.registerComponentImplementation(XMLComponentInstanceFactory.class.getName(), factoryClass);
        return (XMLComponentInstanceFactory)adapter.getPico().getComponentInstances().get(0);
    }

    private void registerComponentAdapter(NanoContainer container, Element element) throws ClassNotFoundException, PicoCompositionException {
        String key;
        String factoryName = element.getAttribute(FACTORY);
        if (EMPTY.equals(factoryName)) {
            factoryName = DEFAULT_COMPONENT_ADAPTER_FACTORY;
        }
        if (EMPTY.equals(key = element.getAttribute(KEY))) {
            throw new NanoContainerMarkupException("'key' attribute not specified for " + element.getNodeName());
        }
        String className = element.getAttribute(CLASS);
        if (EMPTY.equals(className)) {
            throw new NanoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Class<?> implementationClass = this.classLoader.loadClass(className);
        Parameter[] parameters = this.createChildParameters(container, element);
        ComponentAdapterFactory componentAdapterFactory = this.createComponentAdapterFactory(factoryName);
        container.getPico().registerComponent(componentAdapterFactory.createComponentAdapter((Object)key, implementationClass, parameters));
    }

    private ComponentAdapterFactory createComponentAdapterFactory(String factoryName) throws ClassNotFoundException, PicoCompositionException {
        Class<?> factoryClass = this.classLoader.loadClass(factoryName);
        try {
            return (ComponentAdapterFactory)factoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IllegalAccessException e) {
            throw new NanoContainerMarkupException(e);
        }
    }
}

