/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.connectcontroller.protocol;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.connectcontroller.protocol.ConnectMessage;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.util.EmuUtil;

public class ConnectMessage_HELLO
extends ConnectMessage {
    public static final String ID = "HELLO";
    public static final String DESC = "Client Connection Request";
    private String protocol;
    private InetSocketAddress clientSocketAddress;

    public ConnectMessage_HELLO(String protocol) {
        this.protocol = protocol;
    }

    public String getID() {
        return ID;
    }

    public String getDescription() {
        return DESC;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setClientSocketAddress(InetSocketAddress clientSocketAddress) {
        this.clientSocketAddress = clientSocketAddress;
    }

    public InetSocketAddress getClientSocketAddress() {
        return this.clientSocketAddress;
    }

    public String toString() {
        return "Client Connection Request: protocol: " + this.protocol;
    }

    public int getLength() {
        return ID.length() + this.protocol.length() + 1;
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.put(charset.encode(ID));
        EmuUtil.writeString(buffer, this.protocol, 0, charset);
    }

    public static ConnectMessage parse(String msg) throws MessageFormatException {
        if (msg.length() < ID.length() + 2) {
            throw new MessageFormatException("Invalid message length!");
        }
        if (!msg.startsWith(ID)) {
            throw new MessageFormatException("Invalid message identifier!");
        }
        if (msg.charAt(msg.length() - 1) != '\u0000') {
            throw new MessageFormatException("Invalid message stop byte!");
        }
        return new ConnectMessage_HELLO(msg.substring(ID.length(), msg.length() - 1));
    }
}

