/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.net.InetAddress;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.protocol.Chat;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraServerImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.kaillera.model.impl.Trivia;
import org.emulinker.release.ReleaseInfo;
import org.emulinker.util.EmuLang;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.WildcardStringPattern;

public class AdminCommandAction
implements V086Action {
    public static final String COMMAND_ANNOUNCE = "/announce";
    public static final String COMMAND_ANNOUNCEALL = "/announceall";
    public static final String COMMAND_ANNOUNCEGAME = "/announcegame";
    public static final String COMMAND_BAN = "/ban";
    public static final String COMMAND_CLEAR = "/clear";
    public static final String COMMAND_CLOSEGAME = "/closegame";
    public static final String COMMAND_FINDGAME = "/findgame";
    public static final String COMMAND_FINDUSER = "/finduser";
    public static final String COMMAND_HELP = "/help";
    public static final String COMMAND_KICK = "/kick";
    public static final String COMMAND_SILENCE = "/silence";
    public static final String COMMAND_TEMPADMIN = "/tempadmin";
    public static final String COMMAND_VERSION = "/version";
    public static final String COMMAND_TRIVIA = "/trivia";
    public static final String COMMAND_STEALTH = "/stealth";
    public static final String COMMAND_TEMPELEVATED = "/tempelevated";
    public static final String COMMAND_TEMPMODERATOR = "/tempmoderator";
    private static Log log = LogFactory.getLog(AdminCommandAction.class);
    private static final String desc = "AdminCommandAction";
    private static AdminCommandAction singleton = new AdminCommandAction();
    private int actionCount = 0;

    public static AdminCommandAction getInstance() {
        return singleton;
    }

    private AdminCommandAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public String toString() {
        return desc;
    }

    public boolean isValidCommand(String chat) {
        if (chat.startsWith(COMMAND_HELP)) {
            return true;
        }
        if (chat.startsWith(COMMAND_FINDUSER)) {
            return true;
        }
        if (chat.startsWith(COMMAND_FINDGAME)) {
            return true;
        }
        if (chat.startsWith(COMMAND_CLOSEGAME)) {
            return true;
        }
        if (chat.startsWith(COMMAND_KICK)) {
            return true;
        }
        if (chat.startsWith(COMMAND_BAN)) {
            return true;
        }
        if (chat.startsWith(COMMAND_TEMPELEVATED)) {
            return true;
        }
        if (chat.startsWith(COMMAND_TEMPMODERATOR)) {
            return true;
        }
        if (chat.startsWith(COMMAND_SILENCE)) {
            return true;
        }
        if (chat.startsWith(COMMAND_ANNOUNCEGAME)) {
            return true;
        }
        if (chat.startsWith(COMMAND_ANNOUNCE)) {
            return true;
        }
        if (chat.startsWith(COMMAND_TEMPADMIN)) {
            return true;
        }
        if (chat.startsWith(COMMAND_VERSION)) {
            return true;
        }
        if (chat.startsWith(COMMAND_CLEAR)) {
            return true;
        }
        if (chat.startsWith(COMMAND_STEALTH)) {
            return true;
        }
        return chat.startsWith(COMMAND_TRIVIA);
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        block24: {
            Chat chatMessage = (Chat)message;
            String chat = chatMessage.getMessage();
            KailleraServerImpl server = (KailleraServerImpl)clientHandler.getController().getServer();
            AccessManager accessManager = server.getAccessManager();
            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
            if (!(accessManager.getAccess(clientHandler.getRemoteInetAddress()) >= 4 || chat.startsWith(COMMAND_SILENCE) || chat.startsWith(COMMAND_KICK) || chat.startsWith(COMMAND_HELP) || chat.startsWith(COMMAND_FINDUSER) || chat.startsWith(COMMAND_VERSION) && accessManager.getAccess(clientHandler.getRemoteInetAddress()) > 2)) {
                try {
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Admin Command Error: You are not an admin!"));
                }
                catch (MessageFormatException messageFormatException) {
                    // empty catch block
                }
                throw new FatalActionException("Admin Command Denied: " + user + " does not have Admin access: " + chat);
            }
            log.info((Object)(user + ": Admin Command: " + chat));
            try {
                if (chat.startsWith(COMMAND_HELP)) {
                    this.processHelp(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_FINDUSER)) {
                    this.processFindUser(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_FINDGAME)) {
                    this.processFindGame(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_CLOSEGAME)) {
                    this.processCloseGame(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_KICK)) {
                    this.processKick(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_BAN)) {
                    this.processBan(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_TEMPELEVATED)) {
                    this.processTempElevated(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_TEMPMODERATOR)) {
                    this.processTempModerator(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_SILENCE)) {
                    this.processSilence(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_ANNOUNCEGAME)) {
                    this.processGameAnnounce(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_ANNOUNCE)) {
                    this.processAnnounce(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_TEMPADMIN)) {
                    this.processTempAdmin(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_VERSION)) {
                    this.processVersion(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_CLEAR)) {
                    this.processClear(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_STEALTH)) {
                    this.processStealth(chat, server, user, clientHandler);
                    break block24;
                }
                if (chat.startsWith(COMMAND_TRIVIA)) {
                    this.processTrivia(chat, server, user, clientHandler);
                    break block24;
                }
                throw new ActionException("Invalid Command: " + chat);
            }
            catch (ActionException e) {
                log.info((Object)("Admin Command Failed: " + user + ": " + chat));
                try {
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.Failed", e.getMessage())));
                }
                catch (MessageFormatException e2) {
                    log.error((Object)("Failed to contruct InformationMessage message: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (MessageFormatException e) {
                log.error((Object)("Failed to contruct message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processHelp(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (admin.getAccess() == 3) {
            return;
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpVersion")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpKick")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpSilence")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpBan")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (admin.getAccess() == 4) {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpClear")));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpCloseGame")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpAnnounce")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpAnnounceAll")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpAnnounceGame")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpFindUser")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpFindGame")));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/triviaon to start the trivia bot- /triviapause to pause the bot- /triviaresume to resume the bot after pause- /triviasave to save the bot's scores- /triviatime <#> to change the question delay"));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/triviaoff to stop the bot- /triviascores to show top 3 scores- /triviawin to show a winner- /triviaupdate <IP Address> <New IP Address> to update ip address"));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/stealthon /stealthoff to join a room invisibly."));
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (admin.getAccess() == 5) {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/tempelevated <UserID> <min> to give a user temporary elevated access."));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/tempmoderator <UserID> <min> to give a user temporary moderator access."));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.HelpTempAdmin")));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/clear <IP Address> to remove any temp ban, silence, elevated, moderator or admin."));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processFindUser(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        int space = message.indexOf(32);
        if (space < 0) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.FindUserError"));
        }
        int foundCount = 0;
        String str = message.substring(space + 1);
        for (KailleraUserImpl user : server.getUsers()) {
            if (!user.isLoggedIn() || !user.getName().toLowerCase().contains(str.toLowerCase())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("UserID: ");
            sb.append(user.getID());
            sb.append(", IP: ");
            sb.append(user.getConnectSocketAddress().getAddress().getHostAddress());
            sb.append(", Nick: <");
            sb.append(user.getName());
            sb.append(">, Access: ");
            sb.append(user.getAccessStr());
            if (user.getGame() != null) {
                sb.append(", GameID: ");
                sb.append(user.getGame().getID());
                sb.append(", Game: ");
                sb.append(user.getGame().getRomName());
            }
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", sb.toString()));
            ++foundCount;
        }
        if (foundCount == 0) {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.NoUsersFound")));
        }
    }

    private void processFindGame(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        int space = message.indexOf(32);
        if (space < 0) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.FindGameError"));
        }
        int foundCount = 0;
        WildcardStringPattern pattern = new WildcardStringPattern(message.substring(space + 1));
        for (KailleraGameImpl game : server.getGames()) {
            if (!pattern.match(game.getRomName())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("GameID: ");
            sb.append(game.getID());
            sb.append(", Owner: <");
            sb.append(game.getOwner().getName());
            sb.append(">, Game: ");
            sb.append(game.getRomName());
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", sb.toString()));
            ++foundCount;
        }
        if (foundCount == 0) {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.NoGamesFound")));
        }
    }

    private void processSilence(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            int minutes = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotSilenceSelf"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotSilenceAdmin"));
            }
            if (access == 3 && admin.getAccess() == 3) {
                throw new ActionException("You cannot silence a moderator if you're not an admin!");
            }
            if (admin.getAccess() == 3) {
                if (server.getAccessManager().isSilenced(user.getSocketAddress().getAddress())) {
                    throw new ActionException("This User has already been Silenced.  Please wait until his time expires.");
                }
                if (minutes > 15) {
                    throw new ActionException("Moderators can only silence up to 15 minutes!");
                }
            }
            server.getAccessManager().addSilenced(user.getConnectSocketAddress().getAddress().getHostAddress(), minutes);
            server.announce(EmuLang.getString("AdminCommandAction.Silenced", minutes, user.getName()), false, null);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.SilenceError"));
        }
    }

    private void processKick(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotKickSelf"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access == 3 && admin.getAccess() == 3) {
                throw new ActionException("You cannot kick a moderator if you're not an admin!");
            }
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotKickAdmin"));
            }
            user.quit(EmuLang.getString("AdminCommandAction.QuitKicked"));
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.KickError"));
        }
    }

    private void processCloseGame(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int gameID = scanner.nextInt();
            KailleraGameImpl game = (KailleraGameImpl)server.getGame(gameID);
            if (game == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.GameNotFound", gameID));
            }
            KailleraUserImpl owner = (KailleraUserImpl)game.getOwner();
            int access = server.getAccessManager().getAccess(owner.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5 && owner.isLoggedIn()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotCloseAdminGame"));
            }
            owner.quitGame();
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.CloseGameError"));
        }
    }

    private void processBan(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            int minutes = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotBanSelf"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.CanNotBanAdmin"));
            }
            server.announce(EmuLang.getString("AdminCommandAction.Banned", minutes, user.getName()), false, null);
            user.quit(EmuLang.getString("AdminCommandAction.QuitBanned"));
            server.getAccessManager().addTempBan(user.getConnectSocketAddress().getAddress().getHostAddress(), minutes);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.BanError"));
        }
    }

    private void processTempElevated(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (admin.getAccess() != 5) {
            throw new ActionException("Only SUPER ADMIN's can give Temp Elevated Status!");
        }
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            int minutes = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.AlreadyAdmin"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserAlreadyAdmin"));
            }
            if (access == 2) {
                throw new ActionException("User is already elevated.");
            }
            server.getAccessManager().addTempElevated(user.getConnectSocketAddress().getAddress().getHostAddress(), minutes);
            server.announce("Temp Elevated Granted: " + user.getName() + " for " + minutes + "min", false, null);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("Temp Elevated Error."));
        }
    }

    private void processTempModerator(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (admin.getAccess() != 5) {
            throw new ActionException("Only SUPER ADMIN's can give Temp Moderator Status!");
        }
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            int minutes = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.AlreadyAdmin"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserAlreadyAdmin"));
            }
            if (access == 3) {
                throw new ActionException("User is already moderator.");
            }
            server.getAccessManager().addTempModerator(user.getConnectSocketAddress().getAddress().getHostAddress(), minutes);
            server.announce("Temp Moderator Granted: " + user.getName() + " for " + minutes + "min.", false, null);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("Temp Moderator Error."));
        }
    }

    private void processTempAdmin(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (admin.getAccess() != 5) {
            throw new ActionException("Only SUPER ADMIN's can give Temp Admin Status!");
        }
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int userID = scanner.nextInt();
            int minutes = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)server.getUser(userID);
            if (user == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserNotFound", userID));
            }
            if (user.getID() == admin.getID()) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.AlreadyAdmin"));
            }
            int access = server.getAccessManager().getAccess(user.getConnectSocketAddress().getAddress());
            if (access >= 4 && admin.getAccess() != 5) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.UserAlreadyAdmin"));
            }
            server.getAccessManager().addTempAdmin(user.getConnectSocketAddress().getAddress().getHostAddress(), minutes);
            server.announce(EmuLang.getString("AdminCommandAction.TempAdminGranted", minutes, user.getName()), false, null);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.TempAdminError"));
        }
    }

    private void processStealth(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (admin.getGame() != null) {
            throw new ActionException("Can't use /stealth while in a gameroom.");
        }
        if (message.equals("/stealthon")) {
            admin.setStealth(true);
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Stealth Mode is on."));
        } else if (message.equals("/stealthoff")) {
            admin.setStealth(false);
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Stealth Mode is off."));
        } else {
            throw new ActionException("Stealth Mode Error: /stealthon /stealthoff");
        }
    }

    private void processTrivia(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (message.equals("/triviareset")) {
            if (server.getSwitchTrivia()) {
                server.getTrivia().saveScores(true);
                server.getTriviaThread().stop();
            }
            server.announce("<Trivia> SupraTrivia has been reset!", false, null);
            Trivia trivia = new Trivia(server);
            Thread triviaThread = new Thread(trivia);
            triviaThread.start();
            server.setTriviaThread(triviaThread);
            server.setTrivia(trivia);
            trivia.setTriviaPaused(false);
        } else if (message.equals("/triviaon")) {
            if (server.getSwitchTrivia()) {
                throw new ActionException("Trivia already started!");
            }
            server.announce("SupraTrivia has been started!", false, null);
            Trivia trivia = new Trivia(server);
            Thread triviaThread = new Thread(trivia);
            triviaThread.start();
            server.setTriviaThread(triviaThread);
            server.setTrivia(trivia);
            trivia.setTriviaPaused(false);
        } else if (message.equals("/triviaoff")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.announce("SupraTrivia has been stopped!", false, null);
            server.getTrivia().saveScores(false);
            server.getTriviaThread().stop();
            server.setSwitchTrivia(false);
            server.setTrivia(null);
        } else if (message.equals("/triviapause")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.getTrivia().setTriviaPaused(true);
            server.announce("<Trivia> SupraTrivia will be paused after this question!", false, null);
        } else if (message.equals("/triviaresume")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.getTrivia().setTriviaPaused(false);
            server.announce("<Trivia> SupraTrivia has been resumed!", false, null);
        } else if (message.equals("/triviasave")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.getTrivia().saveScores(true);
        } else if (message.equals("/triviascores")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.getTrivia().displayHighScores(false);
        } else if (message.equals("/triviawin")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            server.getTrivia().displayHighScores(true);
        } else if (message.startsWith("/triviaupdate")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            Scanner scanner = new Scanner(message).useDelimiter(" ");
            try {
                scanner.next();
                String ip = scanner.next();
                String ip_update = scanner.next();
                if (server.getTrivia().updateIP(ip, ip_update)) {
                    server.announce("<Trivia> " + ip_update.subSequence(0, 4) + ".... Trivia IP was updated!", false, admin);
                }
                server.announce("<Trivia> " + ip.subSequence(0, 4) + " was not found!  Error updating score!", false, admin);
            }
            catch (Exception e) {
                throw new ActionException("Invalid Trivia Score Update!");
            }
        } else if (message.startsWith("/triviatime")) {
            if (server.getTrivia() == null) {
                throw new ActionException("Trivia needs to be started first!");
            }
            Scanner scanner = new Scanner(message).useDelimiter(" ");
            try {
                scanner.next();
                int questionTime = scanner.nextInt();
                server.getTrivia().setQuestionTime(questionTime * 1000);
                server.announce("<Trivia> SupraTrivia's question delay has been changed to " + questionTime + "s!", false, admin);
            }
            catch (Exception e) {
                throw new ActionException("Invalid Trivia Time!");
            }
        }
    }

    private void processAnnounce(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        String announcement;
        int space = message.indexOf(32);
        if (space < 0) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.AnnounceError"));
        }
        boolean all = false;
        if (message.startsWith(COMMAND_ANNOUNCEALL)) {
            all = true;
        }
        if ((announcement = message.substring(space + 1)).startsWith(":")) {
            announcement = announcement.substring(1);
        }
        server.announce(announcement, all, null);
    }

    private void processGameAnnounce(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int gameID = scanner.nextInt();
            StringBuilder sb = new StringBuilder();
            while (scanner.hasNext()) {
                sb.append(scanner.next());
                sb.append(" ");
            }
            KailleraGameImpl game = (KailleraGameImpl)server.getGame(gameID);
            if (game == null) {
                throw new ActionException(EmuLang.getString("AdminCommandAction.GameNotFound", gameID));
            }
            game.announce(sb.toString(), null);
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.AnnounceGameError"));
        }
    }

    private void processClear(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        int space = message.indexOf(32);
        if (space < 0) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.ClearError"));
        }
        String addressStr = message.substring(space + 1);
        InetAddress inetAddr = null;
        try {
            inetAddr = InetAddress.getByName(addressStr);
        }
        catch (Exception e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.ClearAddressFormatError"));
        }
        if (admin.getAccess() == 5 && server.getAccessManager().clearTemp(inetAddr, true) || admin.getAccess() == 4 && server.getAccessManager().clearTemp(inetAddr, false)) {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.ClearSuccess")));
        } else {
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("AdminCommandAction.ClearNotFound")));
        }
    }

    private void processVersion(String message, KailleraServerImpl server, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        try {
            ReleaseInfo releaseInfo = server.getReleaseInfo();
            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "VERSION: " + releaseInfo.getProductName() + ": " + releaseInfo.getVersionString() + ": " + releaseInfo.getReleaseDate()));
            this.sleep(20);
            if (admin.getAccess() >= 4) {
                Properties props = System.getProperties();
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "JAVAVER: " + props.getProperty("java.version")));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "JAVAVEND: " + props.getProperty("java.vendor")));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "OSNAME: " + props.getProperty("os.name")));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "OSARCH: " + props.getProperty("os.arch")));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "OSVER: " + props.getProperty("os.version")));
                this.sleep(20);
                Runtime runtime = Runtime.getRuntime();
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "NUMPROCS: " + runtime.availableProcessors()));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "FREEMEM: " + runtime.freeMemory()));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "MAXMEM: " + runtime.maxMemory()));
                this.sleep(20);
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "TOTMEM: " + runtime.totalMemory()));
                this.sleep(20);
                Map<String, String> env = System.getenv();
                if (EmuUtil.systemIsWindows()) {
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "COMPNAME: " + env.get("COMPUTERNAME")));
                    this.sleep(20);
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "USER: " + env.get("USERNAME")));
                    this.sleep(20);
                } else {
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "COMPNAME: " + env.get("HOSTNAME")));
                    this.sleep(20);
                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "USER: " + env.get("USERNAME")));
                    this.sleep(20);
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new ActionException(EmuLang.getString("AdminCommandAction.VersionError"));
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

