/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.AdminCommandAction;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.Chat;
import org.emulinker.kaillera.controller.v086.protocol.Chat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.Chat_Request;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.event.ChatEvent;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.release.ReleaseInfo;
import org.emulinker.util.EmuLang;

public class ChatAction
implements V086Action,
V086ServerEventHandler {
    public static final String ADMIN_COMMAND_ESCAPE_STRING = "/";
    private static Log log = LogFactory.getLog(ChatAction.class);
    private static final String desc = "ChatAction";
    private static ChatAction singleton = new ChatAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static ChatAction getInstance() {
        return singleton;
    }

    private ChatAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof Chat_Request)) {
            throw new FatalActionException("Received incorrect instance of Chat: " + message);
        }
        if (((Chat)message).getMessage().startsWith(ADMIN_COMMAND_ESCAPE_STRING)) {
            if (clientHandler.getUser().getAccess() > 2) {
                try {
                    if (AdminCommandAction.getInstance().isValidCommand(((Chat)message).getMessage())) {
                        AdminCommandAction.getInstance().performAction(message, clientHandler);
                        if (((Chat)message).getMessage().equals("/help")) {
                            this.checkCommands(message, clientHandler);
                        }
                    } else {
                        this.checkCommands(message, clientHandler);
                    }
                }
                catch (FatalActionException e) {
                    log.warn((Object)("Admin command failed: " + e.getMessage()));
                }
                return;
            }
            this.checkCommands(message, clientHandler);
            return;
        }
        ++this.actionCount;
        try {
            clientHandler.getUser().chat(((Chat)message).getMessage());
        }
        catch (ActionException e) {
            log.info((Object)("Chat Denied: " + clientHandler.getUser() + ": " + ((Chat)message).getMessage()));
            try {
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("ChatAction.ChatDenied", e.getMessage())));
            }
            catch (MessageFormatException e2) {
                log.error((Object)("Failed to contruct InformationMessage message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void checkCommands(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        block171: {
            boolean doCommand = true;
            KailleraUserImpl userN = (KailleraUserImpl)clientHandler.getUser();
            if (userN.getAccess() < 2) {
                try {
                    clientHandler.getUser().chat(":USER_COMMAND");
                }
                catch (ActionException e) {
                    doCommand = false;
                }
            }
            if (doCommand) {
                if (((Chat)message).getMessage().equals("/alivecheck")) {
                    try {
                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", ":ALIVECHECK=EmulinkerSF Alive Check: You are still logged in."));
                    }
                    catch (Exception e) {}
                } else if (((Chat)message).getMessage().equals("/version") && clientHandler.getUser().getAccess() < 4) {
                    ReleaseInfo releaseInfo = clientHandler.getUser().getServer().getReleaseInfo();
                    try {
                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "VERSION: " + releaseInfo.getProductName() + ": " + releaseInfo.getVersionString() + ": " + releaseInfo.getReleaseDate()));
                    }
                    catch (Exception exception) {}
                } else if (((Chat)message).getMessage().equals("/myip")) {
                    try {
                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Your IP Address is: " + clientHandler.getUser().getConnectSocketAddress().getAddress().getHostAddress()));
                    }
                    catch (Exception releaseInfo) {}
                } else if (((Chat)message).getMessage().equals("/msgon")) {
                    clientHandler.getUser().setMsg(true);
                    try {
                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private messages are now on."));
                    }
                    catch (Exception releaseInfo) {}
                } else if (((Chat)message).getMessage().equals("/msgoff")) {
                    clientHandler.getUser().setMsg(false);
                    try {
                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private messages are now off."));
                    }
                    catch (Exception releaseInfo) {}
                } else if (((Chat)message).getMessage().startsWith("/me")) {
                    int access;
                    int space = ((Chat)message).getMessage().indexOf(32);
                    if (space < 0) {
                        try {
                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Invalid # of Fields!"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    String announcement = ((Chat)message).getMessage().substring(space + 1);
                    if (announcement.startsWith(":")) {
                        announcement = announcement.substring(1);
                    }
                    if ((access = clientHandler.getUser().getServer().getAccessManager().getAccess(clientHandler.getUser().getSocketAddress().getAddress())) < 5 && clientHandler.getUser().getServer().getAccessManager().isSilenced(clientHandler.getUser().getSocketAddress().getAddress())) {
                        try {
                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You are silenced!"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    if (clientHandler.getUser().getServer().checkMe(clientHandler.getUser(), announcement)) {
                        String m = announcement;
                        announcement = "*" + clientHandler.getUser().getName() + " " + m;
                        KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
                        clientHandler.getUser().getServer().announce(announcement, true, user1);
                    }
                } else {
                    if (((Chat)message).getMessage().startsWith("/msg")) {
                        block172: {
                            KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
                            Scanner scanner = new Scanner(((Chat)message).getMessage()).useDelimiter(" ");
                            int access = clientHandler.getUser().getServer().getAccessManager().getAccess(clientHandler.getUser().getSocketAddress().getAddress());
                            if (access < 5 && clientHandler.getUser().getServer().getAccessManager().isSilenced(clientHandler.getUser().getSocketAddress().getAddress())) {
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You are silenced!"));
                                }
                                catch (Exception m) {
                                    // empty catch block
                                }
                                return;
                            }
                            try {
                                scanner.next();
                                int userID = scanner.nextInt();
                                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                                StringBuilder sb = new StringBuilder();
                                while (scanner.hasNext()) {
                                    sb.append(scanner.next());
                                    sb.append(" ");
                                }
                                if (user == null) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (user == clientHandler.getUser()) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You can't private message yourself!"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (!user.getMsg() || user.searchIgnoredUsers(clientHandler.getUser().getConnectSocketAddress().getAddress().getHostAddress())) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "<" + user.getName() + "> Is not accepting private messages!"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                String m = sb.toString();
                                if ((m = m.trim()).length() == 0 || m.startsWith("\u00a0") || m.startsWith("\u00ad")) {
                                    return;
                                }
                                if (access == 1) {
                                    char[] chars = m.toCharArray();
                                    int i2 = 0;
                                    while (i2 < chars.length) {
                                        if (chars[i2] < ' ') {
                                            log.warn((Object)(user + " /msg denied: Illegal characters in message"));
                                            try {
                                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Denied: Illegal characters in message"));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            return;
                                        }
                                        ++i2;
                                    }
                                    if (m.length() > 320) {
                                        log.warn((Object)(user + " /msg denied: Message Length > " + 320));
                                        try {
                                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Denied: Message Too Long"));
                                        }
                                        catch (Exception i2) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                                user1.setLastMsgID(user.getID());
                                user.setLastMsgID(user1.getID());
                                user1.getServer().announce("TO: <" + user.getName() + ">(" + user.getID() + ") <" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, false, user1);
                                user.getServer().announce("<" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, false, user);
                                break block171;
                            }
                            catch (NoSuchElementException e) {
                                if (user1.getLastMsgID() == -1) break block172;
                                try {
                                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(user1.getLastMsgID());
                                    StringBuilder sb = new StringBuilder();
                                    while (scanner.hasNext()) {
                                        sb.append(scanner.next());
                                        sb.append(" ");
                                    }
                                    if (user == null) {
                                        try {
                                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                                        }
                                        catch (Exception m) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    if (user == clientHandler.getUser()) {
                                        try {
                                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You can't private message yourself!"));
                                        }
                                        catch (Exception m) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    if (!user.getMsg()) {
                                        try {
                                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "<" + user.getName() + "> Is not accepting private messages!"));
                                        }
                                        catch (Exception m) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    String m = sb.toString();
                                    if ((m = m.trim()).length() == 0 || m.startsWith("\u00a0") || m.startsWith("\u00ad")) {
                                        return;
                                    }
                                    if (access == 1) {
                                        char[] chars = m.toCharArray();
                                        int i = 0;
                                        while (i < chars.length) {
                                            if (chars[i] < ' ') {
                                                log.warn((Object)(user + " /msg denied: Illegal characters in message"));
                                                try {
                                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Denied: Illegal characters in message"));
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                return;
                                            }
                                            ++i;
                                        }
                                        if (m.length() > 320) {
                                            log.warn((Object)(user + " /msg denied: Message Length > " + 320));
                                            try {
                                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Denied: Message Too Long"));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            return;
                                        }
                                    }
                                    user1.getServer().announce("TO: <" + user.getName() + ">(" + user.getID() + ") <" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, false, user1);
                                    user.getServer().announce("<" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, false, user);
                                    break block171;
                                }
                                catch (NoSuchElementException e1) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Error: /msg <UserID> <message>"));
                                    }
                                    catch (Exception sb) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                        }
                        try {
                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Private Message Error: /msg <UserID> <message>"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    if (((Chat)message).getMessage().equals("/ignoreall")) {
                        KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                        try {
                            clientHandler.getUser().setIgnoreAll(true);
                            user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now ignoring everyone!", false, null);
                        }
                        catch (Exception scanner) {}
                    } else if (((Chat)message).getMessage().equals("/unignoreall")) {
                        KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                        try {
                            clientHandler.getUser().setIgnoreAll(false);
                            user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now unignoring everyone!", false, null);
                        }
                        catch (Exception scanner) {}
                    } else {
                        if (((Chat)message).getMessage().startsWith("/ignore")) {
                            Scanner scanner = new Scanner(((Chat)message).getMessage()).useDelimiter(" ");
                            try {
                                scanner.next();
                                int userID = scanner.nextInt();
                                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                                if (user == null) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (user == clientHandler.getUser()) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You can't ignore yourself!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (clientHandler.getUser().findIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress())) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You can't ignore a user that is already ignored!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (user.getAccess() >= 3) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You cannot ignore a moderator or admin!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                clientHandler.getUser().addIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress());
                                user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now ignoring <" + user.getName() + "> ID: " + user.getID(), false, null);
                            }
                            catch (NoSuchElementException e) {
                                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                                user.getServer().announce("Ignore User Error: /ignore <UserID>", false, user);
                                log.info((Object)("IGNORE USER ERROR: " + user.getName() + ": " + clientHandler.getRemoteSocketAddress().getHostName()));
                                return;
                            }
                        }
                        if (((Chat)message).getMessage().startsWith("/unignore")) {
                            Scanner scanner = new Scanner(((Chat)message).getMessage()).useDelimiter(" ");
                            try {
                                scanner.next();
                                int userID = scanner.nextInt();
                                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                                if (user == null) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (!clientHandler.getUser().findIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress())) {
                                    try {
                                        clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "You can't unignore a user that isn't ignored!"));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (clientHandler.getUser().removeIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress(), false)) {
                                    user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now unignoring <" + user.getName() + "> ID: " + user.getID(), false, null);
                                }
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                                }
                                catch (Exception e) {}
                            }
                            catch (NoSuchElementException e) {
                                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                                user.getServer().announce("Unignore User Error: /ignore <UserID>", false, user);
                                log.info((Object)("UNIGNORE USER ERROR: " + user.getName() + ": " + clientHandler.getRemoteSocketAddress().getHostName()));
                                return;
                            }
                        } else if (((Chat)message).getMessage().equals("/help")) {
                            try {
                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/me <message> to make personal message eg. /me is bored ...SupraFast is bored."));
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/ignore <UserID> or /unignore <UserID> or /ignoreall or /unignoreall to ignore users."));
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/msg <UserID> <msg> to PM somebody. /msgoff or /msgon to turn pm off | on."));
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/myip to get your IP Address."));
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(20L);
                            }
                            catch (Exception scanner) {
                                // empty catch block
                            }
                            if (clientHandler.getUser().getAccess() == 3) {
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/silence <UserID> <min> to silence a user. 15min max."));
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/kick <UserID> to kick a user."));
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                            }
                            if (clientHandler.getUser().getAccess() < 4) {
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/version to get server version."));
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "/finduser <Nick> to get a user's info. eg. /finduser sup ...will return SupraFast info."));
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception scanner) {
                                    // empty catch block
                                }
                                return;
                            }
                        } else if (((Chat)message).getMessage().startsWith("/finduser") && clientHandler.getUser().getAccess() < 4) {
                            int space = ((Chat)message).getMessage().indexOf(32);
                            if (space < 0) {
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "Finduser Error: /finduser <nick> eg. /finduser sup ...will return SupraFast info."));
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                            int foundCount = 0;
                            String str = ((Chat)message).getMessage().substring(space + 1);
                            for (KailleraUserImpl user : clientHandler.getUser().getUsers()) {
                                if (!user.isLoggedIn() || !user.getName().toLowerCase().contains(str.toLowerCase())) continue;
                                StringBuilder sb = new StringBuilder();
                                sb.append("UserID: ");
                                sb.append(user.getID());
                                sb.append(", Nick: <");
                                sb.append(user.getName());
                                sb.append(">");
                                sb.append(", Access: ");
                                if (user.getAccessStr().equals("SuperAdmin") || user.getAccessStr().equals("Admin")) {
                                    sb.append("Normal");
                                } else {
                                    sb.append(user.getAccessStr());
                                }
                                if (user.getGame() != null) {
                                    sb.append(", GameID: ");
                                    sb.append(user.getGame().getID());
                                    sb.append(", Game: ");
                                    sb.append(user.getGame().getRomName());
                                }
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", sb.toString()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++foundCount;
                            }
                            if (foundCount == 0) {
                                try {
                                    clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "No Users Found!"));
                                }
                                catch (Exception exception) {}
                            }
                        } else {
                            userN.getServer().announce("Unknown Command: " + ((Chat)message).getMessage(), false, userN);
                        }
                    }
                }
            } else {
                userN.getServer().announce("Denied: Flood Control", false, userN);
            }
        }
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        ChatEvent chatEvent = (ChatEvent)event;
        try {
            if (clientHandler.getUser().searchIgnoredUsers(chatEvent.getUser().getConnectSocketAddress().getAddress().getHostAddress())) {
                return;
            }
            if (clientHandler.getUser().getIgnoreAll() && chatEvent.getUser().getAccess() < 4 && chatEvent.getUser() != clientHandler.getUser()) {
                return;
            }
            String m = chatEvent.getMessage();
            clientHandler.send(new Chat_Notification(clientHandler.getNextMessageNumber(), chatEvent.getUser().getName(), m));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct Chat_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

