/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.protocol.GameChat;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.util.EmuLang;

public class GameOwnerCommandAction
implements V086Action {
    public static final String COMMAND_HELP = "/help";
    public static final String COMMAND_DETECTAUTOFIRE = "/detectautofire";
    public static final String COMMAND_LAGSTAT = "/lag";
    public static final String COMMAND_MAXUSERS = "/maxusers";
    public static final String COMMAND_MAXPING = "/maxping";
    public static final String COMMAND_START = "/start";
    public static final String COMMAND_STARTN = "/startn";
    public static final String COMMAND_MUTE = "/mute";
    public static final String COMMAND_UNMUTE = "/unmute";
    public static final String COMMAND_SWAP = "/swap";
    public static final String COMMAND_KICK = "/kick";
    public static final String COMMAND_EMU = "/setemu";
    public static final String COMMAND_CONN = "/setconn";
    public static final String COMMAND_SAMEDELAY = "/samedelay";
    public static final String COMMAND_NUM = "/num";
    private static long lastMaxUserChange = 0L;
    private static Log log = LogFactory.getLog(GameOwnerCommandAction.class);
    private static final String desc = "GameOwnerCommandAction";
    private static GameOwnerCommandAction singleton = new GameOwnerCommandAction();
    private int actionCount = 0;

    public static GameOwnerCommandAction getInstance() {
        return singleton;
    }

    private GameOwnerCommandAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public String toString() {
        return desc;
    }

    public boolean isValidCommand(String chat) {
        if (chat.startsWith(COMMAND_HELP)) {
            return true;
        }
        if (chat.startsWith(COMMAND_DETECTAUTOFIRE)) {
            return true;
        }
        if (chat.startsWith(COMMAND_MAXUSERS)) {
            return true;
        }
        if (chat.startsWith(COMMAND_MAXPING)) {
            return true;
        }
        if (chat.equals(COMMAND_START)) {
            return true;
        }
        if (chat.startsWith(COMMAND_STARTN)) {
            return true;
        }
        if (chat.startsWith(COMMAND_MUTE)) {
            return true;
        }
        if (chat.startsWith(COMMAND_EMU)) {
            return true;
        }
        if (chat.startsWith(COMMAND_CONN)) {
            return true;
        }
        if (chat.startsWith(COMMAND_UNMUTE)) {
            return true;
        }
        if (chat.startsWith(COMMAND_SWAP)) {
            return true;
        }
        if (chat.startsWith(COMMAND_KICK)) {
            return true;
        }
        if (chat.startsWith(COMMAND_SAMEDELAY)) {
            return true;
        }
        if (chat.startsWith(COMMAND_LAGSTAT)) {
            return true;
        }
        return chat.startsWith(COMMAND_NUM);
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        GameChat chatMessage = (GameChat)message;
        String chat = chatMessage.getMessage();
        KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
        KailleraGameImpl game = user.getGame();
        if (game == null) {
            throw new FatalActionException("GameOwner Command Failed: Not in a game: " + chat);
        }
        if (!user.equals(game.getOwner()) && user.getAccess() < 5 && !chat.startsWith(COMMAND_HELP)) {
            log.warn((Object)("GameOwner Command Denied: Not game owner: " + game + ": " + user + ": " + chat));
            game.announce("GameOwner Command Error: You are not an owner!", user);
            return;
        }
        try {
            if (chat.startsWith(COMMAND_HELP)) {
                this.processHelp(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_DETECTAUTOFIRE)) {
                this.processDetectAutoFire(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_MAXUSERS)) {
                this.processMaxUsers(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_MAXPING)) {
                this.processMaxPing(chat, game, user, clientHandler);
            } else if (chat.equals(COMMAND_START)) {
                this.processStart(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_STARTN)) {
                this.processStartN(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_MUTE)) {
                this.processMute(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_EMU)) {
                this.processEmu(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_CONN)) {
                this.processConn(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_UNMUTE)) {
                this.processUnmute(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_SWAP)) {
                this.processSwap(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_KICK)) {
                this.processKick(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_LAGSTAT)) {
                this.processLagstat(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_SAMEDELAY)) {
                this.processSameDelay(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_NUM)) {
                this.processNum(chat, game, user, clientHandler);
            } else {
                game.announce("Unknown Command: " + chat, user);
                log.info((Object)("Unknown GameOwner Command: " + game + ": " + user + ": " + chat));
            }
        }
        catch (ActionException e) {
            log.info((Object)("GameOwner Command Failed: " + game + ": " + user + ": " + chat));
            game.announce(EmuLang.getString("GameOwnerCommandAction.CommandFailed", e.getMessage()), user);
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct message: " + e.getMessage()), (Throwable)e);
        }
    }

    private void processHelp(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (!admin.equals(game.getOwner()) && admin.getAccess() < 5) {
            return;
        }
        game.announce(EmuLang.getString("GameOwnerCommandAction.SetAutofireDetection"), admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/maxusers <#> to set capacity of room", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/maxping <#> to set maximum ping for room", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/start or /startn <#> start game when n players are joined.", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/mute /unmute  <UserID> or /muteall or /unmuteall to mute player(s).", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/swap <order> eg. 123..n {n = total # of players; Each slot = new player#}", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/kick <Player#> or /kickall to kick a player(s).", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/setemu To restrict the gameroom to this emulator!", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/setconn To restrict the gameroom to this connection type!", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/lagstat To check who has the most lag spikes or /lagreset to reset lagstat!", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce("/samedelay {true | false} to play at the same delay as player with highest ping. Default is false.", admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void autoFireHelp(KailleraGameImpl game, KailleraUserImpl admin) {
        int cur = game.getAutoFireDetector().getSensitivity();
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpSensitivity"), admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpDisable"), admin);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        game.announce(String.valueOf(EmuLang.getString("GameOwnerCommandAction.HelpCurrentSensitivity", cur)) + (cur == 0 ? EmuLang.getString("GameOwnerCommandAction.HelpDisabled") : ""), admin);
    }

    private void processDetectAutoFire(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (game.getStatus() != 0) {
            game.announce(EmuLang.getString("GameOwnerCommandAction.AutoFireChangeDeniedInGame"), admin);
            return;
        }
        StringTokenizer st = new StringTokenizer(message, " ");
        if (st.countTokens() != 2) {
            this.autoFireHelp(game, admin);
            return;
        }
        String command = st.nextToken();
        String sensitivityStr = st.nextToken();
        int sensitivity = -1;
        try {
            sensitivity = Integer.parseInt(sensitivityStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sensitivity > 5 || sensitivity < 0) {
            this.autoFireHelp(game, admin);
            return;
        }
        game.getAutoFireDetector().setSensitivity(sensitivity);
        game.announce(String.valueOf(EmuLang.getString("GameOwnerCommandAction.HelpCurrentSensitivity", sensitivity)) + (sensitivity == 0 ? EmuLang.getString("GameOwnerCommandAction.HelpDisabled") : ""), null);
    }

    private void processEmu(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        String emu = game.getOwner().getClientType();
        if (message.equals("/setemu any")) {
            emu = "any";
        }
        admin.getGame().setAEmulator(emu);
        admin.getGame().announce("Owner has restricted the emulator to: " + emu, null);
    }

    private void processConn(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        String conn = KailleraUser.CONNECTION_TYPE_NAMES[game.getOwner().getConnectionType()];
        if (message.equals("/setconn any")) {
            conn = "any";
        }
        admin.getGame().setAConnection(conn);
        admin.getGame().announce("Owner has restricted the connection type to: " + conn, null);
    }

    private void processNum(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        admin.getGame().announce(String.valueOf(game.getNumPlayers()) + " in the room!", admin);
    }

    private void processLagstat(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (game.getStatus() != 2) {
            game.announce("Lagstat is only available during gameplay!", admin);
        }
        if (message.equals("/lagstat")) {
            String str = "";
            for (KailleraUser player : game.getPlayers()) {
                if (player.getStealth()) continue;
                str = String.valueOf(str) + "P" + player.getPlayerNumber() + ": " + player.getTimeouts() + ", ";
            }
            if (str.length() > 0) {
                str = str.substring(0, str.length() - ", ".length());
                game.announce(String.valueOf(str) + " lag spikes", null);
            }
        } else if (message.equals("/lagreset")) {
            for (KailleraUser player : game.getPlayers()) {
                player.setTimeouts(0);
            }
            game.announce("LagStat has been reset!", null);
        }
    }

    private void processSameDelay(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (message.equals("/samedelay true")) {
            game.setSameDelay(true);
            admin.getGame().announce("Players will have the same delay when game starts (restarts)!", null);
        } else {
            game.setSameDelay(false);
            admin.getGame().announce("Players will have independent delays when game starts (restarts)!", null);
        }
    }

    private void processMute(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            String str = scanner.next();
            if (str.equals("/muteall")) {
                int w = 1;
                while (w <= game.getPlayers().size()) {
                    if (game.getPlayer(w).getAccess() < 4 && !game.getPlayer(w).equals(game.getOwner())) {
                        game.getPlayer(w).setMute(true);
                        game.getMutedUsers().add(game.getPlayer(w).getConnectSocketAddress().getAddress().getHostAddress());
                    }
                    ++w;
                }
                admin.getGame().announce("All players have been muted!", null);
                return;
            }
            int userID = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
            if (user == null) {
                admin.getGame().announce("Player doesn't exist!", admin);
                return;
            }
            if (user == clientHandler.getUser()) {
                user.getGame().announce("You can't mute yourself!", admin);
                return;
            }
            if (user.getAccess() >= 4 && admin.getAccess() != 5) {
                user.getGame().announce("You can't mute an Admin", admin);
                return;
            }
            game.getMutedUsers().add(user.getConnectSocketAddress().getAddress().getHostAddress());
            user.setMute(true);
            KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
            user1.getGame().announce(String.valueOf(user.getName()) + " has been muted!", null);
        }
        catch (NoSuchElementException e) {
            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
            user.getGame().announce("Mute Player Error: /mute <UserID>", admin);
        }
    }

    private void processUnmute(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            String str = scanner.next();
            if (str.equals("/unmuteall")) {
                int w = 1;
                while (w <= game.getPlayers().size()) {
                    game.getPlayer(w).setMute(false);
                    game.getMutedUsers().remove(game.getPlayer(w).getConnectSocketAddress().getAddress().getHostAddress());
                    ++w;
                }
                admin.getGame().announce("All players have been unmuted!", null);
                return;
            }
            int userID = scanner.nextInt();
            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
            if (user == null) {
                admin.getGame().announce("Player doesn't exist!", admin);
                return;
            }
            if (user == clientHandler.getUser()) {
                user.getGame().announce("You can't unmute yourself!", admin);
                return;
            }
            if (user.getAccess() >= 4 && admin.getAccess() != 5) {
                user.getGame().announce("You can't unmute an Admin", admin);
                return;
            }
            game.getMutedUsers().remove(user.getConnectSocketAddress().getAddress().getHostAddress());
            user.setMute(false);
            KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
            user1.getGame().announce(String.valueOf(user.getName()) + " has been unmuted!", null);
        }
        catch (NoSuchElementException e) {
            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
            user.getGame().announce("Unmute Player Error: /unmute <UserID>", admin);
        }
    }

    private void processStartN(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int num = scanner.nextInt();
            if (num > 0 && num < 101) {
                game.setStartN((byte)num);
                game.announce("This game will start when " + num + " players have joined.", null);
            } else {
                game.announce("StartN Error: Enter value between 1 and 100.", admin);
            }
        }
        catch (NoSuchElementException e) {
            game.announce("Failed: /startn <#>", admin);
        }
    }

    private void processSwap(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            int i = 1;
            scanner.next();
            int test = scanner.nextInt();
            String str = Integer.toString(test);
            if (game.getPlayers().size() < str.length()) {
                game.announce("Failed: You can't swap more than the # of players in the room.", admin);
                return;
            }
            if (test > 0) {
                int numCount = 0;
                int[] num = new int[str.length()];
                i = 0;
                while (i < num.length) {
                    num[i] = Integer.parseInt(String.valueOf(str.charAt(i)));
                    numCount = 1;
                    if (num[i] == 0 || num[i] > game.getPlayers().size()) break;
                    int j = 0;
                    while (j < num.length) {
                        if (num[i] != num[j]) {
                            ++numCount;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (numCount == game.getPlayers().size()) {
                    game.swap = true;
                    i = 0;
                    while (i < str.length()) {
                        KailleraUserImpl player = (KailleraUserImpl)game.getPlayers().get(i);
                        player.setPlayerNumber(num[i]);
                        game.announce(String.valueOf(player.getName()) + " is now Player#: " + player.getPlayerNumber(), null);
                        ++i;
                    }
                } else {
                    game.announce("Swap Player Error: /swap <order> eg. 123..n {n = total # of players; Each slot = new player#}", admin);
                }
            }
        }
        catch (NoSuchElementException e) {
            game.announce("Swap Player Error: /swap <order> eg. 123..n {n = total # of players; Each slot = new player#}", admin);
        }
    }

    private void processStart(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        game.start(admin);
    }

    private void processKick(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            String str = scanner.next();
            if (str.equals("/kickall")) {
                int w = game.getPlayers().size();
                while (w >= 1) {
                    if (game.getPlayer(w).getAccess() < 4 && !game.getPlayer(w).equals(game.getOwner())) {
                        game.kick(admin, game.getPlayer(w).getID());
                    }
                    --w;
                }
                admin.getGame().announce("All players have been kicked!", null);
                return;
            }
            int playerNumber = scanner.nextInt();
            if (playerNumber > 0 && playerNumber < 101) {
                if (game.getPlayer(playerNumber) != null) {
                    game.kick(admin, game.getPlayer(playerNumber).getID());
                } else {
                    game.announce("Player doesn't exisit!", admin);
                }
            } else {
                game.announce("Kick Player Error: Enter value between 1 and 100", admin);
            }
        }
        catch (NoSuchElementException e) {
            game.announce("Failed: /kick <Player#> or /kickall to kick all players.", admin);
        }
    }

    private void processMaxUsers(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (System.currentTimeMillis() - lastMaxUserChange <= 3000L) {
            game.announce("Max User Command Spam Detection...Please Wait!", admin);
            lastMaxUserChange = System.currentTimeMillis();
            return;
        }
        lastMaxUserChange = System.currentTimeMillis();
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int num = scanner.nextInt();
            if (num > 0 && num < 101) {
                game.setMaxUsers(num);
                game.announce("Max Users has been set to " + num, null);
            } else {
                game.announce("Max Users Error: Enter value between 1 and 100", admin);
            }
        }
        catch (NoSuchElementException e) {
            game.announce("Failed: /maxusers <#>", admin);
        }
    }

    private void processMaxPing(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        Scanner scanner = new Scanner(message).useDelimiter(" ");
        try {
            scanner.next();
            int num = scanner.nextInt();
            if (num > 0 && num < 1001) {
                game.setMaxPing(num);
                game.announce("Max Ping has been set to " + num, null);
            } else {
                game.announce("Max Ping Error: Enter value between 1 and 1000", admin);
            }
        }
        catch (NoSuchElementException e) {
            game.announce("Failed: /maxping <#>", admin);
        }
    }
}

