/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.StartGame_Notification;
import org.emulinker.kaillera.controller.v086.protocol.StartGame_Request;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.GameStartedEvent;
import org.emulinker.kaillera.model.exception.StartGameException;

public class StartGameAction
implements V086Action,
V086GameEventHandler {
    private static Log log = LogFactory.getLog(StartGameAction.class);
    private static final String desc = "StartGameAction";
    private static StartGameAction singleton = new StartGameAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static StartGameAction getInstance() {
        return singleton;
    }

    private StartGameAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof StartGame_Request)) {
            throw new FatalActionException("Received incorrect instance of StartGame: " + message);
        }
        ++this.actionCount;
        try {
            clientHandler.getUser().startGame();
        }
        catch (StartGameException e) {
            log.debug((Object)("Failed to start game: " + e.getMessage()));
            try {
                clientHandler.send(new GameChat_Notification(clientHandler.getNextMessageNumber(), "Error", e.getMessage()));
            }
            catch (MessageFormatException ex) {
                log.error((Object)("Failed to contruct GameChat_Notification message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameStartedEvent gameStartedEvent = (GameStartedEvent)event;
        try {
            KailleraGame game = gameStartedEvent.getGame();
            clientHandler.getUser().setTempDelay(game.getDelay() - clientHandler.getUser().getDelay());
            int delay = game.getSameDelay() ? game.getDelay() : clientHandler.getUser().getDelay();
            int playerNumber = game.getPlayerNumber(clientHandler.getUser());
            clientHandler.send(new StartGame_Notification(clientHandler.getNextMessageNumber(), (short)delay, (byte)playerNumber, (byte)game.getNumPlayers()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct StartGame_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

