/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.EmuUtil;

public class InformationMessage
extends V086Message {
    public static final byte ID = 23;
    public static final String DESC = "Information Message";
    private String source;
    private String message;

    public InformationMessage(int messageNumber, String source, String message) throws MessageFormatException {
        super(messageNumber);
        if (source.length() == 0) {
            throw new MessageFormatException("Invalid " + this.getDescription() + " format: source.length == 0");
        }
        if (message.length() == 0) {
            throw new MessageFormatException("Invalid " + this.getDescription() + " format: message.length == 0");
        }
        this.source = source;
        this.message = message;
    }

    public byte getID() {
        return 23;
    }

    public String getDescription() {
        return DESC;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf(this.getInfoString()) + "[source: " + this.source + " message: " + this.message + "]";
    }

    public int getBodyLength() {
        return InformationMessage.getNumBytes(this.source) + InformationMessage.getNumBytes(this.message) + 2;
    }

    public void writeBodyTo(ByteBuffer buffer) {
        EmuUtil.writeString(buffer, this.source, 0, charset);
        EmuUtil.writeString(buffer, this.message, 0, charset);
    }

    public static InformationMessage parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 4) {
            throw new ParseException("Failed byte count validation!");
        }
        String source = EmuUtil.readString(buffer, 0, charset);
        if (buffer.remaining() < 2) {
            throw new ParseException("Failed byte count validation!");
        }
        String message = EmuUtil.readString(buffer, 0, charset);
        return new InformationMessage(messageNumber, source, message);
    }
}

