/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.QuitGame_Notification;
import org.emulinker.kaillera.controller.v086.protocol.QuitGame_Request;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.UnsignedUtil;

public abstract class QuitGame
extends V086Message {
    public static final byte ID = 11;
    private String userName;
    private int userID;

    public QuitGame(int messageNumber, String userName, int userID) throws MessageFormatException {
        super(messageNumber);
        if (userID < 0 || userID > 65535) {
            throw new MessageFormatException("Invalid " + this.getDescription() + " format: userID out of acceptable range: " + userID);
        }
        this.userName = userName;
        this.userID = userID;
    }

    public byte getID() {
        return 11;
    }

    public abstract String getDescription();

    public String getUserName() {
        return this.userName;
    }

    public int getUserID() {
        return this.userID;
    }

    public int getBodyLength() {
        return QuitGame.getNumBytes(this.userName) + 3;
    }

    public void writeBodyTo(ByteBuffer buffer) {
        EmuUtil.writeString(buffer, this.userName, 0, charset);
        UnsignedUtil.putUnsignedShort(buffer, this.userID);
    }

    public static QuitGame parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 3) {
            throw new ParseException("Failed byte count validation!");
        }
        String userName = EmuUtil.readString(buffer, 0, charset);
        if (buffer.remaining() < 2) {
            throw new ParseException("Failed byte count validation!");
        }
        int userID = UnsignedUtil.getUnsignedShort(buffer);
        if (userName.length() == 0 && userID == 65535) {
            return new QuitGame_Request(messageNumber);
        }
        return new QuitGame_Notification(messageNumber, userName, userID);
    }
}

