/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.master.client;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.connectcontroller.ConnectController;
import org.emulinker.kaillera.master.PublicServerInformation;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.master.client.MasterListUpdateTask;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.release.ReleaseInfo;

public class KailleraMasterUpdateTask
implements MasterListUpdateTask {
    private static Log log = LogFactory.getLog(KailleraMasterUpdateTask.class);
    private PublicServerInformation publicInfo;
    private ConnectController connectController;
    private KailleraServer kailleraServer;
    private StatsCollector statsCollector;
    private HttpClient httpClient;
    private ReleaseInfo releaseInfo;

    public KailleraMasterUpdateTask(PublicServerInformation publicInfo, ConnectController connectController, KailleraServer kailleraServer, StatsCollector statsCollector, ReleaseInfo releaseInfo) {
        this.publicInfo = publicInfo;
        this.connectController = connectController;
        this.kailleraServer = kailleraServer;
        this.releaseInfo = releaseInfo;
        this.statsCollector = statsCollector;
        this.publicInfo = publicInfo;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectionTimeout(5000);
        this.httpClient.setTimeout(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchMaster() {
        block18: {
            List createdGamesList = this.statsCollector.getStartedGamesList();
            StringBuilder createdGames = new StringBuilder();
            List list = createdGamesList;
            synchronized (list) {
                Iterator iterator = createdGamesList.iterator();
                while (iterator.hasNext()) {
                    createdGames.append(iterator.next());
                    createdGames.append("|");
                }
                createdGamesList.clear();
            }
            StringBuilder waitingGames = new StringBuilder();
            for (KailleraGame kailleraGame : this.kailleraServer.getGames()) {
                if (kailleraGame.getStatus() != 0) continue;
                waitingGames.append(kailleraGame.getID());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getRomName());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getOwner().getName());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getOwner().getClientType());
                waitingGames.append("|");
                waitingGames.append(kailleraGame.getNumPlayers());
                waitingGames.append("|");
            }
            NameValuePair[] nameValuePairArray = new NameValuePair[]{new NameValuePair("servername", this.publicInfo.getServerName()), new NameValuePair("port", Integer.toString(this.connectController.getBindPort())), new NameValuePair("nbusers", Integer.toString(this.kailleraServer.getNumUsers())), new NameValuePair("maxconn", Integer.toString(this.kailleraServer.getMaxUsers())), new NameValuePair("version", "ESF" + this.releaseInfo.getVersionString()), new NameValuePair("nbgames", Integer.toString(this.kailleraServer.getNumGames())), new NameValuePair("location", this.publicInfo.getLocation()), new NameValuePair("ip", this.publicInfo.getConnectAddress()), new NameValuePair("url", this.publicInfo.getWebsite())};
            GetMethod kailleraTouch = new GetMethod("http://www.kaillera.com/touch_server.php");
            kailleraTouch.setQueryString(nameValuePairArray);
            kailleraTouch.setRequestHeader("Kaillera-games", createdGames.toString());
            kailleraTouch.setRequestHeader("Kaillera-wgames", waitingGames.toString());
            try {
                try {
                    int statusCode = this.httpClient.executeMethod((HttpMethod)kailleraTouch);
                    if (statusCode != 200) {
                        log.error((Object)("Failed to touch Kaillera Master: " + kailleraTouch.getStatusLine()));
                        break block18;
                    }
                    log.info((Object)"Touching Kaillera Master done");
                }
                catch (Exception e) {
                    log.error((Object)("Failed to touch Kaillera Master: " + e.getMessage()));
                    if (kailleraTouch == null) break block18;
                    try {
                        kailleraTouch.releaseConnection();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (kailleraTouch != null) {
                    try {
                        kailleraTouch.releaseConnection();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

