/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.impl.AutoFireDetector;

public class AutoFireScanner2
implements AutoFireDetector {
    protected static Log log = LogFactory.getLog(AutoFireScanner2.class);
    private static int[][] SENSITIVITY_TABLE = new int[][]{new int[2], {2, 13}, {3, 11}, {4, 9}, {5, 7}, {6, 5}};
    protected static ExecutorService executor = Executors.newCachedThreadPool();
    protected KailleraGame game;
    protected int sensitivity;
    protected int maxDelay;
    protected int minReps;
    protected ScanningJob[] scanningJobs;

    public AutoFireScanner2(KailleraGame game, int sensitivity) {
        this.game = game;
        this.setSensitivity(sensitivity);
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(int sensitivity) {
        if (sensitivity < 0 || sensitivity > 5) {
            this.sensitivity = 0;
        } else {
            this.sensitivity = sensitivity;
            this.maxDelay = SENSITIVITY_TABLE[sensitivity][0];
            this.minReps = SENSITIVITY_TABLE[sensitivity][1];
        }
    }

    public void start(int numPlayers) {
        if (this.sensitivity <= 0) {
            return;
        }
        this.scanningJobs = new ScanningJob[numPlayers];
    }

    public void addPlayer(KailleraUser player, int playerNumber) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1] = new ScanningJob(player, playerNumber);
    }

    public void stop(int playerNumber) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1].stop();
    }

    public void stop() {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        int i = 0;
        while (i < this.scanningJobs.length) {
            this.scanningJobs[i].stop();
            ++i;
        }
    }

    public void addData(int playerNumber, byte[] data, int bytesPerAction) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1].addData(data, bytesPerAction);
    }

    protected class ScanningJob
    implements Runnable {
        private KailleraUser user;
        private int playerNumber;
        private int bytesPerAction = -1;
        private int sizeLimit;
        private int bufferSize = 5;
        private int size = 0;
        private byte[][] buffer;
        private int head = 0;
        private int tail = 0;
        private int pos = 0;
        private boolean running = false;
        private boolean stopFlag = false;

        protected ScanningJob(KailleraUser user, int playerNumber) {
            this.user = user;
            this.playerNumber = playerNumber;
            this.sizeLimit = (AutoFireScanner2.this.maxDelay + 1) * AutoFireScanner2.this.minReps * 5;
            this.buffer = new byte[this.bufferSize][this.sizeLimit];
        }

        protected synchronized void addData(byte[] data, int bytesPerAction) {
            if (this.pos + data.length >= this.sizeLimit) {
                int firstSize = this.sizeLimit - this.pos;
                System.arraycopy(data, 0, this.buffer[this.tail], this.pos, firstSize);
                ++this.tail;
                if (this.tail == this.bufferSize) {
                    this.tail = 0;
                }
                System.arraycopy(data, firstSize, this.buffer[this.tail], 0, data.length - firstSize);
                this.pos = data.length - firstSize;
                ++this.size;
                if (this.bytesPerAction <= 0) {
                    this.bytesPerAction = bytesPerAction;
                }
                if (!this.running) {
                    executor.submit(this);
                }
            } else {
                System.arraycopy(data, 0, this.buffer[this.tail], this.pos, data.length);
                this.pos += data.length;
            }
        }

        protected void stop() {
            this.stopFlag = true;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

