/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.kaillera.model.impl.PlayerTimeoutException;

public class PlayerActionQueue {
    private int gameBufferSize;
    private int gameTimeoutMillis;
    private boolean capture;
    private int thisPlayerNumber;
    private KailleraUserImpl thisPlayer;
    private boolean synched = false;
    private PlayerTimeoutException lastTimeout;
    private byte[] array;
    private int[] heads;
    private int tail = 0;

    public PlayerActionQueue(int playerNumber, KailleraUserImpl player, int numPlayers, int gameBufferSize, int gameTimeoutMillis, boolean capture) {
        this.thisPlayerNumber = playerNumber;
        this.thisPlayer = player;
        this.gameBufferSize = gameBufferSize;
        this.gameTimeoutMillis = gameTimeoutMillis;
        this.capture = capture;
        this.array = new byte[gameBufferSize];
        this.heads = new int[numPlayers];
    }

    public int getPlayerNumber() {
        return this.thisPlayerNumber;
    }

    public KailleraUserImpl getPlayer() {
        return this.thisPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynched(boolean synched) {
        this.synched = synched;
        if (!synched) {
            PlayerActionQueue playerActionQueue = this;
            synchronized (playerActionQueue) {
                this.notifyAll();
            }
        }
    }

    public boolean isSynched() {
        return this.synched;
    }

    public void setLastTimeout(PlayerTimeoutException e) {
        this.lastTimeout = e;
    }

    public PlayerTimeoutException getLastTimeout() {
        return this.lastTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActions(byte[] actions) {
        if (!this.synched) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            this.array[this.tail] = actions[i];
            ++this.tail;
            if (this.tail == this.gameBufferSize) {
                this.tail = 0;
            }
            ++i;
        }
        PlayerActionQueue playerActionQueue = this;
        synchronized (playerActionQueue) {
            this.notifyAll();
        }
        this.lastTimeout = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAction(int playerNumber, byte[] actions, int location, int actionLength) throws PlayerTimeoutException {
        PlayerActionQueue playerActionQueue = this;
        synchronized (playerActionQueue) {
            if (this.getSize(playerNumber) < actionLength && this.synched) {
                try {
                    this.wait(this.gameTimeoutMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.getSize(playerNumber) >= actionLength) {
            int i = 0;
            while (i < actionLength) {
                actions[location + i] = this.array[this.heads[playerNumber - 1]];
                int n = playerNumber - 1;
                this.heads[n] = this.heads[n] + 1;
                if (this.heads[playerNumber - 1] == this.gameBufferSize) {
                    this.heads[playerNumber - 1] = 0;
                }
                ++i;
            }
            return;
        }
        if (!this.synched) {
            return;
        }
        throw new PlayerTimeoutException(this.thisPlayerNumber, this.thisPlayer);
    }

    private int getSize(int playerNumber) {
        return (this.tail + this.gameBufferSize - this.heads[playerNumber - 1]) % this.gameBufferSize;
    }
}

