/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.util;

import java.lang.reflect.Array;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CircularBlockingByteQueue {
    private static Log log = LogFactory.getLog(CircularBlockingByteQueue.class);
    private byte[] array;
    private int head = 0;
    private int tail = 0;
    private int size = 0;
    private Semaphore semaphore = new Semaphore(0);
    private Object lock = new Object();

    public CircularBlockingByteQueue(int maxSize) {
        this.array = new byte[maxSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return "CircularBlockingIntArray[size=" + this.size + " head=" + this.head + " tail=" + this.tail + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.head == this.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            if (!this.semaphore.tryAcquire(timeout, unit)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            return -1;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte data) {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == this.array.length) {
                this.grow();
            }
            this.array[this.tail] = data;
            this.tail = (this.tail + 1) % this.array.length;
            ++this.size;
        }
        this.semaphore.release();
    }

    public byte remove(int index) {
        int pos = this.convert(index);
        try {
            byte by = this.array[pos];
            return by;
        }
        finally {
            this.array[pos] = -1;
            if (pos == this.head) {
                ++this.head;
                if (this.head == this.array.length) {
                    this.head = 0;
                }
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.array, this.head, this.array, this.head + 1, pos - this.head);
                ++this.head;
                if (this.head == this.array.length) {
                    this.head = 0;
                }
            } else {
                System.arraycopy(this.array, pos + 1, this.array, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            }
            --this.size;
        }
    }

    public void grow() {
        int oldCapacity = this.array.length;
        int newCapacity = oldCapacity * 3 / 2 + 1;
        log.debug((Object)("CircularBlockingByteQueue growing from " + oldCapacity + " to " + newCapacity));
        byte[] newData = new byte[newCapacity];
        this.toArray(newData);
        this.tail = this.size;
        this.head = 0;
        this.array = newData;
    }

    public byte[] toArray() {
        return this.toArray(new byte[this.size]);
    }

    public byte[] toArray(byte[] a) {
        if (this.size == 0) {
            return a;
        }
        if (a.length < this.size) {
            a = (byte[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.head < this.tail) {
            System.arraycopy(this.array, this.head, a, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.array, this.head, a, 0, this.array.length - this.head);
            System.arraycopy(this.array, 0, a, this.array.length - this.head, this.tail);
        }
        if (a.length > this.size) {
            a[this.size] = 0;
        }
        return a;
    }

    protected int convert(int index) {
        return (index + this.head) % this.array.length;
    }
}

