/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.CloseGame;
import org.emulinker.kaillera.model.event.GameClosedEvent;
import org.emulinker.kaillera.model.event.ServerEvent;

public class CloseGameAction
implements V086ServerEventHandler {
    private static Log log = LogFactory.getLog(CloseGameAction.class);
    private static final String desc = "CloseGameAction";
    private static CloseGameAction singleton = new CloseGameAction();
    private int handledCount;

    public static CloseGameAction getInstance() {
        return singleton;
    }

    private CloseGameAction() {
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameClosedEvent gameClosedEvent = (GameClosedEvent)event;
        try {
            clientHandler.send(new CloseGame(clientHandler.getNextMessageNumber(), gameClosedEvent.getGame().getID(), 0));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct CloseGame_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

