/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.GameOwnerCommandAction;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.GameChat;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Request;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.event.GameChatEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;

public class GameChatAction
implements V086Action,
V086GameEventHandler {
    public static final String ADMIN_COMMAND_ESCAPE_STRING = "/";
    private static Log log = LogFactory.getLog(GameChatAction.class);
    private static final String desc = "GameChatAction";
    public static final byte STATUS_IDLE = 1;
    private static GameChatAction singleton = new GameChatAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static GameChatAction getInstance() {
        return singleton;
    }

    private GameChatAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof GameChat_Request)) {
            throw new FatalActionException("Received incorrect instance of GameChat: " + message);
        }
        if (clientHandler.getUser() == null) {
            throw new FatalActionException("User does not exist: GameChatAction " + message);
        }
        if (clientHandler.getUser().getGame() == null) {
            return;
        }
        if (((GameChat)message).getMessage().startsWith(ADMIN_COMMAND_ESCAPE_STRING)) {
            try {
                if (GameOwnerCommandAction.getInstance().isValidCommand(((GameChat)message).getMessage())) {
                    GameOwnerCommandAction.getInstance().performAction(message, clientHandler);
                    if (((GameChat)message).getMessage().equals("/help")) {
                        this.checkCommands(message, clientHandler);
                    }
                } else {
                    this.checkCommands(message, clientHandler);
                }
                return;
            }
            catch (FatalActionException e) {
                log.warn((Object)("GameOwner command failed: " + e.getMessage()));
            }
        }
        ++this.actionCount;
        GameChat_Request gameChatMessage = (GameChat_Request)message;
        try {
            clientHandler.getUser().gameChat(gameChatMessage.getMessage(), gameChatMessage.getNumber());
        }
        catch (GameChatException e) {
            log.debug((Object)("Failed to send game chat message: " + e.getMessage()));
        }
    }

    private void checkCommands(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        boolean doCommand = true;
        if (clientHandler.getUser().getAccess() < 2) {
            try {
                clientHandler.getUser().chat(":USER_COMMAND");
            }
            catch (ActionException e) {
                doCommand = false;
            }
        }
        if (doCommand) {
            if (((GameChat)message).getMessage().equals("/msgon")) {
                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                try {
                    clientHandler.getUser().setMsg(true);
                    user.getGame().announce("Private messages are now on.", user);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (((GameChat)message).getMessage().equals("/msgoff")) {
                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                try {
                    clientHandler.getUser().setMsg(false);
                    user.getGame().announce("Private messages are now off.", user);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (((GameChat)message).getMessage().startsWith("/p2p")) {
                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                if (((GameChat)message).getMessage().equals("/p2pon")) {
                    if (clientHandler.getUser().getGame().getOwner().equals(clientHandler.getUser())) {
                        clientHandler.getUser().getGame().setP2P(true);
                        for (KailleraUserImpl u : clientHandler.getUser().getGame().getPlayers()) {
                            u.setP2P(true);
                            if (!u.isLoggedIn()) continue;
                            u.getGame().announce("This game will NOT receive any server activity during gameplay!", u);
                        }
                    } else {
                        clientHandler.getUser().setP2P(true);
                        for (KailleraUserImpl u : clientHandler.getUser().getGame().getPlayers()) {
                            if (!u.isLoggedIn()) continue;
                            u.getGame().announce(String.valueOf(clientHandler.getUser().getName()) + " will NOT receive any server activity during gameplay!", u);
                        }
                    }
                } else if (((GameChat)message).getMessage().equals("/p2poff")) {
                    if (clientHandler.getUser().getGame().getOwner().equals(clientHandler.getUser())) {
                        clientHandler.getUser().getGame().setP2P(false);
                        for (KailleraUserImpl u : clientHandler.getUser().getGame().getPlayers()) {
                            u.setP2P(false);
                            if (!u.isLoggedIn()) continue;
                            u.getGame().announce("This game will NOW receive ALL server activity during gameplay!", u);
                        }
                    } else {
                        clientHandler.getUser().setP2P(false);
                        for (KailleraUserImpl u : clientHandler.getUser().getGame().getPlayers()) {
                            if (!u.isLoggedIn()) continue;
                            u.getGame().announce(String.valueOf(clientHandler.getUser().getName()) + " will NOW receive ALL server activity during gameplay!", u);
                        }
                    }
                } else {
                    user.getGame().announce("Failed P2P: /p2pon or /p2poff", user);
                }
                return;
            }
            if (((GameChat)message).getMessage().startsWith("/msg")) {
                KailleraUserImpl user1;
                block92: {
                    user1 = (KailleraUserImpl)clientHandler.getUser();
                    Scanner scanner = new Scanner(((GameChat)message).getMessage()).useDelimiter(" ");
                    int access = clientHandler.getUser().getServer().getAccessManager().getAccess(clientHandler.getUser().getSocketAddress().getAddress());
                    if (access < 5 && clientHandler.getUser().getServer().getAccessManager().isSilenced(clientHandler.getUser().getSocketAddress().getAddress())) {
                        user1.getGame().announce("You are silenced!", user1);
                        return;
                    }
                    try {
                        scanner.next();
                        int userID = scanner.nextInt();
                        KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                        StringBuilder sb = new StringBuilder();
                        while (scanner.hasNext()) {
                            sb.append(scanner.next());
                            sb.append(" ");
                        }
                        if (user == null) {
                            user1.getGame().announce("User not found!", user1);
                            return;
                        }
                        if (user.getGame() != user1.getGame()) {
                            user1.getGame().announce("User not in this game!", user1);
                            return;
                        }
                        if (user == clientHandler.getUser()) {
                            user1.getGame().announce("You can't private message yourself!", user1);
                            return;
                        }
                        if (!user.getMsg() || user.searchIgnoredUsers(clientHandler.getUser().getConnectSocketAddress().getAddress().getHostAddress())) {
                            user1.getGame().announce("<" + user.getName() + "> Is not accepting private messages!", user1);
                            return;
                        }
                        String m = sb.toString();
                        if ((m = m.trim()).length() == 0 || m.startsWith("\u00a0") || m.startsWith("\u00ad")) {
                            return;
                        }
                        if (access == 1) {
                            char[] chars = m.toCharArray();
                            int i = 0;
                            while (i < chars.length) {
                                if (chars[i] < ' ') {
                                    log.warn((Object)(user + " /msg denied: Illegal characters in message"));
                                    user1.getGame().announce("Private Message Denied: Illegal characters in message", user1);
                                    return;
                                }
                                ++i;
                            }
                            if (m.length() > 320) {
                                log.warn((Object)(user + " /msg denied: Message Length > " + 320));
                                user1.getGame().announce("Private Message Denied: Message Too Long", user1);
                                return;
                            }
                        }
                        user1.setLastMsgID(user.getID());
                        user.setLastMsgID(user1.getID());
                        if (user1.getGame() != null) {
                            user1.getGame().announce("TO: <" + user.getName() + ">(" + user.getID() + ") <" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, user1);
                        }
                        if (user.getGame() != null) {
                            user.getGame().announce("<" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, user);
                        }
                        return;
                    }
                    catch (NoSuchElementException e) {
                        if (user1.getLastMsgID() == -1) break block92;
                        try {
                            KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(user1.getLastMsgID());
                            StringBuilder sb = new StringBuilder();
                            while (scanner.hasNext()) {
                                sb.append(scanner.next());
                                sb.append(" ");
                            }
                            if (user == null) {
                                user1.getGame().announce("User not found!", user1);
                                return;
                            }
                            if (user.getGame() != user1.getGame()) {
                                user1.getGame().announce("User not in this game!", user1);
                                return;
                            }
                            if (user == clientHandler.getUser()) {
                                user1.getGame().announce("You can't private message yourself!", user1);
                                return;
                            }
                            if (!user.getMsg()) {
                                user1.getGame().announce("<" + user.getName() + "> Is not accepting private messages!", user1);
                                return;
                            }
                            String m = sb.toString();
                            if ((m = m.trim()).length() == 0 || m.startsWith("\u00a0") || m.startsWith("\u00ad")) {
                                return;
                            }
                            if (access == 1) {
                                char[] chars = m.toCharArray();
                                int i = 0;
                                while (i < chars.length) {
                                    if (chars[i] < ' ') {
                                        log.warn((Object)(user + " /msg denied: Illegal characters in message"));
                                        user1.getGame().announce("Private Message Denied: Illegal characters in message", user1);
                                        return;
                                    }
                                    ++i;
                                }
                                if (m.length() > 320) {
                                    log.warn((Object)(user + " /msg denied: Message Length > " + 320));
                                    user1.getGame().announce("Private Message Denied: Message Too Long", user1);
                                    return;
                                }
                            }
                            if (user1.getGame() != null) {
                                user1.getGame().announce("TO: <" + user.getName() + ">(" + user.getID() + ") <" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, user1);
                            }
                            if (user.getGame() != null) {
                                user.getGame().announce("<" + clientHandler.getUser().getName() + "> (" + clientHandler.getUser().getID() + "): " + m, user);
                            }
                            return;
                        }
                        catch (Exception e1) {
                            user1.getGame().announce("Private Message Error: /msg <UserID> <message>", user1);
                            return;
                        }
                    }
                }
                user1.getGame().announce("Private Message Error: /msg <UserID> <message>", user1);
                return;
            }
            if (((GameChat)message).getMessage().equals("/ignoreall")) {
                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                try {
                    clientHandler.getUser().setIgnoreAll(true);
                    user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now ignoring everyone!", false, null);
                }
                catch (Exception scanner) {
                    // empty catch block
                }
                return;
            }
            if (((GameChat)message).getMessage().equals("/unignoreall")) {
                KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                try {
                    clientHandler.getUser().setIgnoreAll(false);
                    user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now unignoring everyone!", false, null);
                }
                catch (Exception scanner) {
                    // empty catch block
                }
                return;
            }
            if (((GameChat)message).getMessage().startsWith("/ignore")) {
                KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
                Scanner scanner = new Scanner(((GameChat)message).getMessage()).useDelimiter(" ");
                try {
                    scanner.next();
                    int userID = scanner.nextInt();
                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                    if (user == null) {
                        user1.getGame().announce("User not found!", user1);
                        return;
                    }
                    if (user == clientHandler.getUser()) {
                        user1.getGame().announce("You can't ignore yourself!", user1);
                        return;
                    }
                    if (clientHandler.getUser().findIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress())) {
                        user1.getGame().announce("You can't ignore a user that is already ignored!", user1);
                        return;
                    }
                    if (user.getAccess() >= 3) {
                        user1.getGame().announce("You cannot ignore a moderator or admin!", user1);
                        return;
                    }
                    clientHandler.getUser().addIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress());
                    user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now ignoring <" + user.getName() + "> ID: " + user.getID(), false, null);
                    return;
                }
                catch (NoSuchElementException e) {
                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                    user.getGame().announce("Ignore User Error: /ignore <UserID>", user);
                    log.info((Object)("IGNORE USER ERROR: " + user.getName() + ": " + clientHandler.getRemoteSocketAddress().getHostName()));
                    return;
                }
            }
            if (((GameChat)message).getMessage().startsWith("/unignore")) {
                KailleraUserImpl user1 = (KailleraUserImpl)clientHandler.getUser();
                Scanner scanner = new Scanner(((GameChat)message).getMessage()).useDelimiter(" ");
                try {
                    scanner.next();
                    int userID = scanner.nextInt();
                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser().getServer().getUser(userID);
                    if (user == null) {
                        user1.getGame().announce("User Not Found!", user1);
                        return;
                    }
                    if (!clientHandler.getUser().findIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress())) {
                        user1.getGame().announce("You can't unignore a user that isn't ignored", user1);
                        return;
                    }
                    if (clientHandler.getUser().removeIgnoredUser(user.getConnectSocketAddress().getAddress().getHostAddress(), false)) {
                        user.getServer().announce(String.valueOf(clientHandler.getUser().getName()) + " is now unignoring <" + user.getName() + "> ID: " + user.getID(), false, null);
                    } else {
                        try {
                            clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", "User Not Found!"));
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (NoSuchElementException e) {
                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                    user.getGame().announce("Unignore User Error: /ignore <UserID>", user);
                    log.info((Object)("UNIGNORE USER ERROR: " + user.getName() + ": " + clientHandler.getRemoteSocketAddress().getHostName()));
                    return;
                }
            }
            if (((GameChat)message).getMessage().startsWith("/me")) {
                int access;
                int space = ((GameChat)message).getMessage().indexOf(32);
                if (space < 0) {
                    clientHandler.getUser().getGame().announce("Invalid # of Fields!", clientHandler.getUser());
                    return;
                }
                String announcement = ((GameChat)message).getMessage().substring(space + 1);
                if (announcement.startsWith(":")) {
                    announcement = announcement.substring(1);
                }
                if ((access = clientHandler.getUser().getServer().getAccessManager().getAccess(clientHandler.getUser().getSocketAddress().getAddress())) < 5 && clientHandler.getUser().getServer().getAccessManager().isSilenced(clientHandler.getUser().getSocketAddress().getAddress())) {
                    clientHandler.getUser().getGame().announce("You are silenced!", clientHandler.getUser());
                    return;
                }
                if (clientHandler.getUser().getServer().checkMe(clientHandler.getUser(), announcement)) {
                    String m = announcement;
                    announcement = "*" + clientHandler.getUser().getName() + " " + m;
                    for (KailleraUserImpl user : clientHandler.getUser().getGame().getPlayers()) {
                        user.getGame().announce(announcement, user);
                    }
                    return;
                }
            } else {
                if (((GameChat)message).getMessage().equals("/help")) {
                    KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
                    user.getGame().announce("/me <message> to make personal message eg. /me is bored ...SupraFast is bored.", user);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    user.getGame().announce("/msg <UserID> <msg> to PM somebody. /msgoff or /msgon to turn pm off | on.", user);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    user.getGame().announce("/ignore <UserID> or /unignore <UserID> or /ignoreall or /unignoreall to ignore users.", user);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    user.getGame().announce("/p2pon or /p2poff this option ignores all server activity during gameplay.", user);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                clientHandler.getUser().getGame().announce("Unknown Command: " + ((GameChat)message).getMessage(), clientHandler.getUser());
            }
        } else {
            clientHandler.getUser().getGame().announce("Denied: Flood Control", clientHandler.getUser());
        }
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameChatEvent gameChatEvent = (GameChatEvent)event;
        try {
            if (clientHandler.getUser().searchIgnoredUsers(gameChatEvent.getUser().getConnectSocketAddress().getAddress().getHostAddress())) {
                return;
            }
            if (clientHandler.getUser().getIgnoreAll() && gameChatEvent.getUser().getAccess() < 4 && gameChatEvent.getUser() != clientHandler.getUser()) {
                return;
            }
            String m = gameChatEvent.getMessage();
            clientHandler.send(new GameChat_Notification(clientHandler.getNextMessageNumber(), gameChatEvent.getUser().getName(), m));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct GameChat_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

