/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.kaillera.model.event.KailleraEventListener;
import org.emulinker.kaillera.model.exception.ChatException;
import org.emulinker.kaillera.model.exception.ClientAddressException;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.ConnectionTypeException;
import org.emulinker.kaillera.model.exception.CreateGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.FloodException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.exception.GameDataException;
import org.emulinker.kaillera.model.exception.GameKickException;
import org.emulinker.kaillera.model.exception.JoinGameException;
import org.emulinker.kaillera.model.exception.LoginException;
import org.emulinker.kaillera.model.exception.PingTimeException;
import org.emulinker.kaillera.model.exception.QuitException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.StartGameException;
import org.emulinker.kaillera.model.exception.UserNameException;
import org.emulinker.kaillera.model.exception.UserReadyException;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface KailleraUser {
    public static final byte CONNECTION_TYPE_LAN = 1;
    public static final byte CONNECTION_TYPE_EXCELLENT = 2;
    public static final byte CONNECTION_TYPE_GOOD = 3;
    public static final byte CONNECTION_TYPE_AVERAGE = 4;
    public static final byte CONNECTION_TYPE_LOW = 5;
    public static final byte CONNECTION_TYPE_BAD = 6;
    public static final String[] CONNECTION_TYPE_NAMES = new String[]{"DISABLED", "LAN", "Excellent", "Good", "Average", "Low", "Bad"};
    public static final byte STATUS_PLAYING = 0;
    public static final byte STATUS_IDLE = 1;
    public static final byte STATUS_CONNECTING = 2;
    public static final String[] STATUS_NAMES = new String[]{"Playing", "Idle", "Connecting"};

    public int getID();

    public InetSocketAddress getConnectSocketAddress();

    public String getProtocol();

    public long getConnectTime();

    public int getFrameCount();

    public byte[] getLostInput();

    public int getArraySize();

    public int getBytesPerAction();

    public void setTempDelay(int var1);

    public void setFrameCount(int var1);

    public boolean getMsg();

    public void setMsg(boolean var1);

    public int getStatus();

    public void setLastMsgID(int var1);

    public int getDelay();

    public int getLastMsgID();

    public boolean getP2P();

    public int getTimeouts();

    public void setTimeouts(int var1);

    public boolean findIgnoredUser(String var1);

    public void setP2P(boolean var1);

    public void setPlayerNumber(int var1);

    public boolean getMute();

    public void setMute(boolean var1);

    public KailleraGameImpl getGame();

    public int getAccess();

    public boolean removeIgnoredUser(String var1, boolean var2);

    public boolean searchIgnoredUsers(String var1);

    public void setIgnoreAll(boolean var1);

    public boolean getIgnoreAll();

    public void addIgnoredUser(String var1);

    public Collection<KailleraUserImpl> getUsers();

    public String getName();

    public void setName(String var1);

    public boolean getStealth();

    public void setStealth(boolean var1);

    public String getClientType();

    public boolean isEmuLinkerClient();

    public void setClientType(String var1);

    public byte getConnectionType();

    public void setConnectionType(byte var1);

    public InetSocketAddress getSocketAddress();

    public void setSocketAddress(InetSocketAddress var1);

    public int getPing();

    public void setPing(int var1);

    public void login() throws PingTimeException, ClientAddressException, ConnectionTypeException, UserNameException, LoginException;

    public long getLastActivity();

    public void updateLastActivity();

    public void updateLastKeepAlive();

    public long getLastKeepAlive();

    public boolean isLoggedIn();

    public KailleraServer getServer();

    public KailleraEventListener getListener();

    public void chat(String var1) throws ChatException, FloodException;

    public KailleraGame createGame(String var1) throws CreateGameException, FloodException;

    public void quit(String var1) throws QuitException, DropGameException, QuitGameException, CloseGameException;

    public KailleraGame joinGame(int var1) throws JoinGameException;

    public int getPlayerNumber();

    public void startGame() throws StartGameException;

    public void gameChat(String var1, int var2) throws GameChatException;

    public void gameKick(int var1) throws GameKickException;

    public void playerReady() throws UserReadyException;

    public void addGameData(byte[] var1) throws GameDataException;

    public void dropGame() throws DropGameException;

    public void quitGame() throws DropGameException, QuitGameException, CloseGameException;

    public void droppedPacket();

    public void stop();
}

