/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.emulinker.kaillera.model.impl.KailleraServerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trivia
implements Runnable {
    private boolean exitThread = false;
    private boolean triviaPaused = false;
    private KailleraServerImpl server;
    private boolean newQuestion = true;
    private String answer;
    private char[] hint;
    private boolean hint1 = false;
    private boolean hint2 = false;
    private boolean answered = false;
    private int questions_count = 0;
    private String ip_streak = "";
    private int score_streak = 0;
    private int questionTime = 30000;
    private List<Questions> questions = new ArrayList<Questions>();
    private List<Integer> questions_num = new ArrayList<Integer>();
    private List<Scores> scores = new ArrayList<Scores>();

    public boolean isAnswered() {
        return this.answered;
    }

    public void setQuestionTime(int questionTime) {
        this.questionTime = questionTime;
    }

    public List<Scores> getScores() {
        return this.scores;
    }

    public void setTriviaPaused(boolean triviaPaused) {
        this.triviaPaused = triviaPaused;
    }

    public Trivia(KailleraServerImpl server) {
        this.server = server;
        try {
            server.announce("<Trivia> Loading SupraTrivia Questions...", false, null);
            FileInputStream ist = new FileInputStream("questions.txt");
            BufferedReader istream = new BufferedReader(new InputStreamReader(ist));
            int count = 0;
            String str = istream.readLine();
            while (str != null) {
                if (str.startsWith("q:") || str.startsWith("Q:")) {
                    String q = str.substring("q:".length()).trim();
                    str = istream.readLine();
                    String a = str.substring("a:".length()).trim();
                    this.questions.add(new Questions(q, a));
                    this.questions_num.add(count);
                    ++count;
                }
                str = istream.readLine();
            }
            ((InputStream)ist).close();
            server.announce("<Trivia> " + this.questions.size() + " questions have been loaded!", false, null);
            server.announce("<Trivia> Loading Previous Scores...", false, null);
            ist = new FileInputStream("scores.txt");
            istream = new BufferedReader(new InputStreamReader(ist));
            str = istream.readLine();
            while (str != null) {
                if (str.startsWith("ip:") || str.startsWith("IP:") || str.startsWith("Ip:") || str.startsWith("iP:")) {
                    String ip = str.substring("ip:".length()).trim();
                    str = istream.readLine();
                    String s = str.substring("s:".length()).trim();
                    str = istream.readLine();
                    String n = str.substring("n:".length()).trim();
                    this.scores.add(new Scores(n, ip, Integer.parseInt(s)));
                }
                str = istream.readLine();
            }
            ((InputStream)ist).close();
            server.announce("<Trivia> " + this.scores.size() + " scores have been loaded!", false, null);
            if (this.questions.size() == 0) {
                this.exitThread = true;
            } else {
                server.setSwitchTrivia(true);
                server.announce("<Trivia> SupraTrivia will begin in 10s!", false, null);
            }
        }
        catch (Exception e) {
            this.exitThread = true;
            server.announce("<Trivia> Error loading SupraTrivia Questions/Scores!", false, null);
        }
    }

    @Override
    public void run() {
        int temp;
        int count = 0;
        Random generator = new Random();
        if (this.questions.size() > 1) {
            temp = generator.nextInt(this.questions_num.size() - 1);
            this.questions_count = this.questions_num.get(temp);
            this.questions_num.remove(temp);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {}
        while (!this.exitThread) {
            if (!this.triviaPaused) {
                if (this.newQuestion) {
                    if (++count % 15 == 0) {
                        this.saveScores(false);
                        this.displayHighScores(false);
                    }
                    this.newQuestion = false;
                    this.hint1 = true;
                    this.hint2 = false;
                    this.server.announce("<Trivia> " + this.questions.get(this.questions_count).getQuestion(), false, null);
                    if (!this.answered) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.answered) {
                        this.server.announce("<Trivia> 35 seconds left...", false, null);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.hint1 && !this.answered) {
                    this.newQuestion = false;
                    this.hint1 = false;
                    this.hint2 = true;
                    this.answer = this.questions.get(this.questions_count).getAnswer().toLowerCase();
                    this.answer = this.answer.replace(" ", "    ");
                    this.hint = this.answer.toCharArray();
                    int w2 = 0;
                    while (w2 < this.hint.length) {
                        if ((w2 + 1) % 2 == 0 && this.hint[w2] != ' ') {
                            this.hint[w2] = 95;
                        }
                        ++w2;
                    }
                    this.answer = String.valueOf(this.hint);
                    this.answer = this.answer.replace("_", " _ ");
                    this.server.announce("<Trivia> Hint1: " + this.answer, false, null);
                    if (!this.answered) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception w2) {
                            // empty catch block
                        }
                    }
                    if (!this.answered) {
                        this.server.announce("<Trivia> 20 seconds left...", false, null);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception w2) {
                            // empty catch block
                        }
                    }
                }
                if (this.hint2 && !this.answered) {
                    this.newQuestion = false;
                    this.hint1 = false;
                    this.hint2 = false;
                    this.answer = this.questions.get(this.questions_count).getAnswer().toLowerCase();
                    this.answer = this.answer.replace(" ", "    ");
                    this.hint = this.answer.toCharArray();
                    int w3 = 0;
                    while (w3 < this.hint.length) {
                        if ((w3 + 1) % 4 == 0 && this.hint[w3] != ' ') {
                            this.hint[w3] = 95;
                        }
                        ++w3;
                    }
                    this.answer = String.valueOf(this.hint);
                    this.answer = this.answer.replace("_", " _ ");
                    this.server.announce("<Trivia> Hint2: " + this.answer, false, null);
                    if (!this.answered) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception w3) {
                            // empty catch block
                        }
                    }
                    if (!this.answered) {
                        this.server.announce("<Trivia> 5 seconds left...", false, null);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception w3) {
                            // empty catch block
                        }
                    }
                }
                if (!this.answered) {
                    this.server.announce("<Trivia> Time's up! The answer is: " + this.questions.get(this.questions_count).getAnswer(), false, null);
                }
                if (count == this.questions.size()) {
                    count = 0;
                    this.server.announce("<Trivia> ***All questions have been exhaused! Restarting list...***", false, null);
                }
                if (this.questions_num.size() == 1) {
                    this.questions_count = this.questions_num.get(0);
                    this.questions_num.clear();
                    int w = 0;
                    while (w < this.questions.size()) {
                        this.questions_num.add(w);
                        ++w;
                    }
                } else {
                    temp = generator.nextInt(this.questions_num.size() - 1);
                    this.questions_count = this.questions_num.get(temp);
                    this.questions_num.remove(temp);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.server.announce("<Trivia> " + this.questionTime / 1000 + " seconds until the next question. Get ready for question " + (count + 1) + " of " + this.questions.size(), false, null);
                try {
                    Thread.sleep(this.questionTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.newQuestion = true;
                this.hint1 = false;
                this.hint2 = false;
                this.answered = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isCorrect(String message) {
        String[] numbers0 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
        String[] numbers1 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        String[] placement0 = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "nineth", "tenth"};
        String[] placement1 = new String[]{"1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th"};
        if (message.toLowerCase().equals(this.questions.get(this.questions_count).getAnswer().toLowerCase())) {
            this.answered = true;
            return true;
        }
        int i = 0;
        while (i < numbers0.length) {
            if (this.questions.get(this.questions_count).getAnswer().toLowerCase().contains(numbers0[i])) {
                message = message.replace(numbers1[i], numbers0[i]);
            } else if (this.questions.get(this.questions_count).getAnswer().toLowerCase().contains(numbers1[i])) {
                message = message.replace(numbers0[i], numbers1[i]);
            }
            ++i;
        }
        if (message.toLowerCase().equals(this.questions.get(this.questions_count).getAnswer().toLowerCase())) {
            this.answered = true;
            return true;
        }
        i = 0;
        while (i < placement0.length) {
            if (this.questions.get(this.questions_count).getAnswer().toLowerCase().contains(placement0[i])) {
                message = message.replace(placement1[i], placement0[i]);
            } else if (this.questions.get(this.questions_count).getAnswer().toLowerCase().contains(placement1[i])) {
                message = message.replace(placement0[i], placement1[i]);
            }
            ++i;
        }
        if (message.toLowerCase().equals(this.questions.get(this.questions_count).getAnswer().toLowerCase())) {
            this.answered = true;
            return true;
        }
        return false;
    }

    public boolean updateIP(String ip, String ip_update) {
        int i = 0;
        while (i < this.scores.size()) {
            if (this.scores.get(i).getIP().equals(ip)) {
                this.scores.get(i).setIP(ip_update);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addScore(String nick, String ip, String answer) {
        this.answered = true;
        int i = 0;
        while (i < this.scores.size()) {
            if (this.scores.get(i).getIP().equals(ip)) {
                this.scores.get(i).setNick(nick);
                int s = this.scores.get(i).getScore();
                this.scores.get(i).setScore(++s);
                this.server.announce("<Trivia> " + nick + " is the winner of this round (" + this.questions.get(this.questions_count).getAnswer() + ")! Your score is: " + s, false, null);
                if (this.ip_streak.equals(ip)) {
                    ++this.score_streak;
                    if (this.score_streak > 1) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.server.announce("<Trivia> ***" + nick + " has won " + this.score_streak + " in a row!***", false, null);
                    }
                } else {
                    this.score_streak = 1;
                    this.ip_streak = ip;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s == 25) {
                    this.server.announce("<Trivia> " + nick + ", you're doing great. Keep it up tiger!", false, null);
                } else if (s == 50) {
                    this.server.announce("<Trivia> " + nick + ", you're so smart you're going to break the Trivia Bot!", false, null);
                } else if (s == 100) {
                    this.server.announce("<Trivia> " + nick + ", you're in a league of your own. Nobody can compete!", false, null);
                } else if (s % 100 == 0) {
                    this.server.announce("<Trivia> " + nick + ", you're a God at SupraTrivia!", false, null);
                }
                return;
            }
            ++i;
        }
        this.scores.add(new Scores(nick, ip, 1));
        this.score_streak = 1;
        this.ip_streak = ip;
        this.server.announce("<Trivia> " + nick + " is the winner of this round (" + answer + ")! His score is: 1", false, null);
    }

    public void displayHighScores(boolean winner) {
        String first_nick = "";
        String second_nick = "";
        String third_nick = "";
        int first_score = 0;
        int second_score = 0;
        int third_score = 0;
        int temp_score = 0;
        int i = 0;
        while (i < this.scores.size()) {
            String temp_nick;
            if (this.scores.get(i).getScore() > first_score) {
                temp_nick = first_nick;
                temp_score = first_score;
                first_score = this.scores.get(i).getScore();
                first_nick = this.scores.get(i).getNick();
                second_score = temp_score;
                second_nick = temp_nick;
            } else if (this.scores.get(i).getScore() > second_score) {
                temp_nick = second_nick;
                temp_score = second_score;
                second_score = this.scores.get(i).getScore();
                second_nick = this.scores.get(i).getNick();
                third_score = temp_score;
                third_nick = temp_nick;
            } else if (this.scores.get(i).getScore() > third_score) {
                third_score = this.scores.get(i).getScore();
                third_nick = this.scores.get(i).getNick();
            }
            ++i;
        }
        if (!winner) {
            String str = String.valueOf(first_nick) + " = " + first_score + ", ";
            str = String.valueOf(str) + second_nick + " = " + second_score + ", ";
            str = String.valueOf(str) + third_nick + " = " + third_score;
            this.server.announce("<Trivia> (Top 3 Scores of " + this.scores.size() + ") " + str, false, null);
        } else {
            this.server.announce("<Trivia> The Winner is: " + first_nick + " with " + first_score + " points!", false, null);
        }
    }

    public void saveScores(boolean display) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("scores.txt", false));
            int i = 0;
            while (i < this.scores.size()) {
                out.write("ip:" + this.scores.get(i).getIP());
                out.newLine();
                out.write("s:" + this.scores.get(i).getScore());
                out.newLine();
                out.write("n:" + this.scores.get(i).getNick());
                out.newLine();
                out.newLine();
                ++i;
            }
            out.close();
            if (display) {
                this.server.announce("<Trivia> SupraTrivia Scores were Saved Successfully!", false, null);
            }
        }
        catch (Exception e) {
            this.server.announce("<Trivia> Error Saving SupraTrivia Scores!", false, null);
        }
    }

    private class Questions {
        String question;
        String answer;

        public Questions(String question, String answer) {
            this.question = question;
            this.answer = answer;
        }

        public void setQuestion(String question) {
            this.question = question;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public String getQuestion() {
            return this.question;
        }

        public String getAnswer() {
            return this.answer;
        }
    }

    private class Scores {
        private String ip;
        private int score;
        private String nick;

        public Scores(String nick, String ip, int score) {
            this.nick = nick;
            this.ip = ip;
            this.score = score;
        }

        public void setScore(int score) {
            this.score = score;
        }

        public void setIP(String ip) {
            this.ip = ip;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }

        public int getScore() {
            return this.score;
        }

        public String getIP() {
            return this.ip;
        }

        public String getNick() {
            return this.nick;
        }
    }
}

